/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.k2.codeinsight.fixes;

import com.intellij.modcommand.ActionContext;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.Presentation;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analysis.api.KaSession;
import org.jetbrains.kotlin.analysis.api.fir.diagnostics.KaFirDiagnostic;
import org.jetbrains.kotlin.analysis.api.renderer.types.impl.KaTypeRendererForSource;
import org.jetbrains.kotlin.analysis.api.types.KaClassType;
import org.jetbrains.kotlin.analysis.api.types.KaType;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.codeinsight.api.applicable.intentions.KotlinPsiUpdateModCommandAction;
import org.jetbrains.kotlin.idea.codeinsight.api.applicators.fixes.KotlinQuickFixFactory;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.psi.KtCollectionLiteralExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.types.Variance;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c0\u0002\u0018\u00002\u00020\u0001:\u0001\u0013B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0019\u0010\b\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\fH\u0002R\u00020\n\u00a2\u0006\u0002\u0010\rJ#\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002R\u00020\n\u00a2\u0006\u0002\u0010\u0012R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/idea/k2/codeinsight/fixes/AddTypeAnnotationToValueParameterFixFactory;", "", "()V", "addTypeAnnotationToValueParameterFixFactory", "Lorg/jetbrains/kotlin/idea/codeinsight/api/applicators/fixes/KotlinQuickFixFactory$ModCommandBased;", "Lorg/jetbrains/kotlin/analysis/api/fir/diagnostics/KaFirDiagnostic$ValueParameterWithoutExplicitType;", "getAddTypeAnnotationToValueParameterFixFactory", "()Lorg/jetbrains/kotlin/idea/codeinsight/api/applicators/fixes/KotlinQuickFixFactory$ModCommandBased;", "getTypeName", "", "Lorg/jetbrains/kotlin/analysis/api/KaSession;", "type", "Lorg/jetbrains/kotlin/analysis/api/types/KaType;", "(Lorg/jetbrains/kotlin/analysis/api/KaSession;Lorg/jetbrains/kotlin/analysis/api/types/KaType;)Ljava/lang/String;", "element", "Lorg/jetbrains/kotlin/psi/KtParameter;", "defaultValue", "Lorg/jetbrains/kotlin/psi/KtExpression;", "(Lorg/jetbrains/kotlin/analysis/api/KaSession;Lorg/jetbrains/kotlin/psi/KtParameter;Lorg/jetbrains/kotlin/psi/KtExpression;)Ljava/lang/String;", "AddTypeAnnotationToValueParameterFix", "kotlin.code-insight.fixes.k2"})
public final class AddTypeAnnotationToValueParameterFixFactory {
    @NotNull
    public static final AddTypeAnnotationToValueParameterFixFactory INSTANCE = new AddTypeAnnotationToValueParameterFixFactory();
    @NotNull
    private static final KotlinQuickFixFactory.ModCommandBased<KaFirDiagnostic.ValueParameterWithoutExplicitType> addTypeAnnotationToValueParameterFixFactory = AddTypeAnnotationToValueParameterFixFactory::addTypeAnnotationToValueParameterFixFactory$lambda$0;

    private AddTypeAnnotationToValueParameterFixFactory() {
    }

    @NotNull
    public final KotlinQuickFixFactory.ModCommandBased<KaFirDiagnostic.ValueParameterWithoutExplicitType> getAddTypeAnnotationToValueParameterFixFactory() {
        return addTypeAnnotationToValueParameterFixFactory;
    }

    private final String getTypeName(KaSession $context_receiver_0, KtParameter element3, KtExpression defaultValue2) {
        KaType kaType = $context_receiver_0.getExpressionType(defaultValue2);
        if (kaType == null) {
            return null;
        }
        KaType type2 = kaType;
        if ($context_receiver_0.isArrayOrPrimitiveArray(type2)) {
            if (element3.hasModifier(KtTokens.VARARG_KEYWORD)) {
                KaType kaType2 = $context_receiver_0.getArrayElementType(type2);
                if (kaType2 == null) {
                    return null;
                }
                KaType elementType = kaType2;
                return this.getTypeName($context_receiver_0, elementType);
            }
            if (defaultValue2 instanceof KtCollectionLiteralExpression) {
                KaType elementType;
                KaType kaType3 = elementType = $context_receiver_0.getArrayElementType(type2);
                boolean bl = kaType3 != null ? $context_receiver_0.isPrimitive(kaType3) : false;
                if (bl) {
                    Intrinsics.checkNotNull((Object)elementType, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.analysis.api.types.KaClassType");
                    ClassId classId = ((KaClassType)elementType).getClassId();
                    String arrayTypeName = classId.getShortClassName() + "Array";
                    return arrayTypeName;
                }
            }
        }
        return this.getTypeName($context_receiver_0, type2);
    }

    private final String getTypeName(KaSession $context_receiver_0, KaType type2) {
        String typeName = $context_receiver_0.render(type2, KaTypeRendererForSource.INSTANCE.getWITH_SHORT_NAMES(), Variance.INVARIANT);
        return typeName;
    }

    private static final List addTypeAnnotationToValueParameterFixFactory$lambda$0(KaSession $context_receiver_0, KaFirDiagnostic.ValueParameterWithoutExplicitType diagnostic) {
        Intrinsics.checkNotNullParameter((Object)$context_receiver_0, (String)"$context_receiver_0");
        Intrinsics.checkNotNullParameter((Object)diagnostic, (String)"diagnostic");
        KtParameter element3 = (KtParameter)diagnostic.getPsi();
        KtExpression ktExpression = element3.getDefaultValue();
        if (ktExpression == null) {
            return CollectionsKt.emptyList();
        }
        KtExpression defaultValue2 = ktExpression;
        String string = INSTANCE.getTypeName($context_receiver_0, element3, defaultValue2);
        if (string == null) {
            return CollectionsKt.emptyList();
        }
        String elementContext2 = string;
        return CollectionsKt.listOf((Object)((Object)new AddTypeAnnotationToValueParameterFix(element3, elementContext2)));
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0015\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\b\u0010\b\u001a\u00020\u0006H\u0016J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0004\u001a\u00020\u0002H\u0014J-\u0010\r\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\f2\u0006\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u0011H\u0014\u00a2\u0006\u0002\u0010\u0012R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/idea/k2/codeinsight/fixes/AddTypeAnnotationToValueParameterFixFactory$AddTypeAnnotationToValueParameterFix;", "Lorg/jetbrains/kotlin/idea/codeinsight/api/applicable/intentions/KotlinPsiUpdateModCommandAction$ElementBased;", "Lorg/jetbrains/kotlin/psi/KtParameter;", "", "element", "typeName", "", "(Lorg/jetbrains/kotlin/psi/KtParameter;Ljava/lang/String;)V", "getFamilyName", "getPresentation", "Lcom/intellij/modcommand/Presentation;", "context", "Lcom/intellij/modcommand/ActionContext;", "invoke", "actionContext", "elementContext", "updater", "Lcom/intellij/modcommand/ModPsiUpdater;", "(Lcom/intellij/modcommand/ActionContext;Lorg/jetbrains/kotlin/psi/KtParameter;Lkotlin/Unit;Lcom/intellij/modcommand/ModPsiUpdater;)V", "kotlin.code-insight.fixes.k2"})
    private static final class AddTypeAnnotationToValueParameterFix
    extends KotlinPsiUpdateModCommandAction.ElementBased<KtParameter, Unit> {
        @NotNull
        private final String typeName;

        public AddTypeAnnotationToValueParameterFix(@NotNull KtParameter element3, @NotNull String typeName) {
            Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
            Intrinsics.checkNotNullParameter((Object)typeName, (String)"typeName");
            super((PsiElement)element3, Unit.INSTANCE);
            this.typeName = typeName;
        }

        @Override
        protected void invoke(@NotNull ActionContext actionContext, @NotNull KtParameter element3, @NotNull Unit elementContext2, @NotNull ModPsiUpdater updater2) {
            Intrinsics.checkNotNullParameter((Object)actionContext, (String)"actionContext");
            Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
            Intrinsics.checkNotNullParameter((Object)elementContext2, (String)"elementContext");
            Intrinsics.checkNotNullParameter((Object)updater2, (String)"updater");
            Project project2 = actionContext.project();
            Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"project(...)");
            element3.setTypeReference(new KtPsiFactory(project2, false, 2, null).createType(this.typeName));
        }

        @NotNull
        public String getFamilyName() {
            return KotlinBundle.message((String)"fix.add.type.annotation.family", (Object[])new Object[0]);
        }

        @NotNull
        protected Presentation getPresentation(@NotNull ActionContext context2, @NotNull KtParameter element3) {
            Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
            Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
            Object[] objectArray = new Object[]{this.typeName, String.valueOf(element3.getName())};
            String actionName = KotlinBundle.message((String)"fix.add.type.annotation.text", (Object[])objectArray);
            Presentation presentation2 = Presentation.of((String)actionName);
            Intrinsics.checkNotNullExpressionValue((Object)presentation2, (String)"of(...)");
            return presentation2;
        }
    }
}

