/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.inspections.collections;

import com.intellij.codeInsight.actions.OptimizeImportsProcessor;
import com.intellij.codeInsight.intention.FileModifier;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.base.util.GenericPsiUtils;
import org.jetbrains.kotlin.idea.codeinsight.utils.DocumentUtilsKt;
import org.jetbrains.kotlin.idea.core.ShortenReferences;
import org.jetbrains.kotlin.idea.inspections.collections.AbstractCallChainChecker;
import org.jetbrains.kotlin.idea.inspections.collections.SimplifyCallChainFix;
import org.jetbrains.kotlin.idea.intentions.UtilsKt;
import org.jetbrains.kotlin.idea.refactoring.KotlinCommonRefactoringUtilKt;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.CreateByPatternKt;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtLambdaArgument;
import org.jetbrains.kotlin.psi.KtLambdaExpression;
import org.jetbrains.kotlin.psi.KtParenthesizedExpression;
import org.jetbrains.kotlin.psi.KtPostfixExpression;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtQualifiedExpression;
import org.jetbrains.kotlin.psi.KtSafeQualifiedExpression;
import org.jetbrains.kotlin.psi.KtValueArgument;
import org.jetbrains.kotlin.psi.KtValueArgumentList;
import org.jetbrains.kotlin.psi.psiUtil.PsiChildRange;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001BB\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0005\u0012\u001f\b\u0002\u0010\u0007\u001a\u0019\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\b\u00a2\u0006\u0002\b\f\u00a2\u0006\u0002\u0010\rJ\u000e\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u0012J\u0018\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\b\u0010\u0018\u001a\u00020\u000fH\u0016J\b\u0010\u0019\u001a\u00020\u000fH\u0016R\u0010\u0010\u0002\u001a\u00020\u00038\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000R'\u0010\u0007\u001a\u0019\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\b\u00a2\u0006\u0002\b\f8\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/collections/SimplifyCallChainFix;", "Lcom/intellij/codeInspection/LocalQuickFix;", "conversion", "Lorg/jetbrains/kotlin/idea/inspections/collections/AbstractCallChainChecker$Conversion;", "removeReceiverOfFirstCall", "", "runOptimizeImports", "modifyArguments", "Lkotlin/Function2;", "Lorg/jetbrains/kotlin/psi/KtPsiFactory;", "Lorg/jetbrains/kotlin/psi/KtCallExpression;", "", "Lkotlin/ExtensionFunctionType;", "(Lorg/jetbrains/kotlin/idea/inspections/collections/AbstractCallChainChecker$Conversion;ZZLkotlin/jvm/functions/Function2;)V", "shortenedText", "", "apply", "qualifiedExpression", "Lorg/jetbrains/kotlin/psi/KtQualifiedExpression;", "applyFix", "project", "Lcom/intellij/openapi/project/Project;", "descriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "getFamilyName", "getName", "kotlin.idea"})
@SourceDebugExtension(value={"SMAP\nSimplifyCallChainFix.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SimplifyCallChainFix.kt\norg/jetbrains/kotlin/idea/inspections/collections/SimplifyCallChainFix\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 KotlinPsiModificationUtils.kt\norg/jetbrains/kotlin/idea/base/psi/KotlinPsiModificationUtils\n+ 4 addToStdlib.kt\norg/jetbrains/kotlin/utils/addToStdlib/AddToStdlibKt\n*L\n1#1,113:1\n1#2:114\n26#3,7:115\n26#3,7:123\n26#3,7:130\n118#4:122\n*S KotlinDebug\n*F\n+ 1 SimplifyCallChainFix.kt\norg/jetbrains/kotlin/idea/inspections/collections/SimplifyCallChainFix\n*L\n79#1:115,7\n94#1:123,7\n99#1:130,7\n90#1:122\n*E\n"})
public final class SimplifyCallChainFix
implements LocalQuickFix {
    @FileModifier.SafeFieldForPreview
    @NotNull
    private final AbstractCallChainChecker.Conversion conversion;
    private final boolean removeReceiverOfFirstCall;
    private final boolean runOptimizeImports;
    @FileModifier.SafeFieldForPreview
    @NotNull
    private final Function2<KtPsiFactory, KtCallExpression, Unit> modifyArguments;
    @NotNull
    private final String shortenedText;

    public SimplifyCallChainFix(@NotNull AbstractCallChainChecker.Conversion conversion2, boolean removeReceiverOfFirstCall, boolean runOptimizeImports, @NotNull Function2<? super KtPsiFactory, ? super KtCallExpression, Unit> modifyArguments) {
        Intrinsics.checkNotNullParameter((Object)conversion2, (String)"conversion");
        Intrinsics.checkNotNullParameter(modifyArguments, (String)"modifyArguments");
        this.conversion = conversion2;
        this.removeReceiverOfFirstCall = removeReceiverOfFirstCall;
        this.runOptimizeImports = runOptimizeImports;
        this.modifyArguments = modifyArguments;
        this.shortenedText = StringsKt.substringAfterLast$default((String)this.conversion.getReplacement(), (String)".", null, (int)2, null);
    }

    public /* synthetic */ SimplifyCallChainFix(AbstractCallChainChecker.Conversion conversion2, boolean bl, boolean bl2, Function2 function2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            bl = false;
        }
        if ((n & 4) != 0) {
            bl2 = false;
        }
        if ((n & 8) != 0) {
            function2 = 1.INSTANCE;
        }
        this(conversion2, bl, bl2, (Function2<? super KtPsiFactory, ? super KtCallExpression, Unit>)function2);
    }

    @NotNull
    public String getName() {
        Object[] objectArray = new Object[]{this.shortenedText};
        return KotlinBundle.message((String)"simplify.call.chain.fix.text", (Object[])objectArray);
    }

    @NotNull
    public String getFamilyName() {
        return this.getName();
    }

    public final void apply(@NotNull KtQualifiedExpression qualifiedExpression) {
        PsiElement parent2;
        PsiElement call2;
        PsiElement psiElement2;
        Object object;
        boolean secondCallHasArguments;
        PsiElement secondCallTrailingComma;
        KtValueArgumentList secondCallArgumentList;
        KtExpression ktExpression;
        Intrinsics.checkNotNullParameter((Object)qualifiedExpression, (String)"qualifiedExpression");
        Project project2 = qualifiedExpression.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
        KtPsiFactory psiFactory = new KtPsiFactory(project2, false, 2, null);
        KtExpression firstExpression = qualifiedExpression.getReceiverExpression();
        String operationSign = this.removeReceiverOfFirstCall ? "" : ((ktExpression = firstExpression) instanceof KtSafeQualifiedExpression ? "?." : (ktExpression instanceof KtQualifiedExpression ? "." : ""));
        String receiverExpressionOrEmptyString = !this.removeReceiverOfFirstCall && firstExpression instanceof KtQualifiedExpression ? ((KtQualifiedExpression)firstExpression).getReceiverExpression().getText() : "";
        KtCallExpression ktCallExpression = AbstractCallChainChecker.Companion.getCallExpression(firstExpression);
        if (ktCallExpression == null) {
            return;
        }
        KtCallExpression firstCallExpression = ktCallExpression;
        this.modifyArguments.invoke((Object)psiFactory, (Object)firstCallExpression);
        KtValueArgumentList firstCallArgumentList = firstCallExpression.getValueArgumentList();
        KtExpression ktExpression2 = qualifiedExpression.getSelectorExpression();
        KtCallExpression ktCallExpression2 = ktExpression2 instanceof KtCallExpression ? (KtCallExpression)ktExpression2 : null;
        if (ktCallExpression2 == null) {
            return;
        }
        KtCallExpression secondCallExpression = ktCallExpression2;
        KtValueArgumentList ktValueArgumentList = secondCallArgumentList = secondCallExpression.getValueArgumentList();
        PsiElement psiElement3 = secondCallTrailingComma = ktValueArgumentList != null ? ktValueArgumentList.getTrailingComma() : null;
        if (psiElement3 != null) {
            psiElement3.delete();
        }
        List list2 = firstCallExpression.getLambdaArguments();
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getLambdaArguments(...)");
        KtLambdaArgument ktLambdaArgument = (KtLambdaArgument)CollectionsKt.singleOrNull((List)list2);
        KtLambdaExpression lambdaExpression2 = ktLambdaArgument != null ? ktLambdaArgument.getLambdaExpression() : null;
        String additionalArgument = this.conversion.getAdditionalArgument();
        Object object2 = secondCallArgumentList;
        boolean bl = object2 != null && (object2 = object2.getArguments()) != null ? !((Collection)object2).isEmpty() : (secondCallHasArguments = false);
        Object object3 = firstCallArgumentList;
        boolean firstCallHasArguments = object3 != null && (object3 = object3.getArguments()) != null ? !((Collection)object3).isEmpty() : false;
        Object[] objectArray = new String[4];
        KtValueArgumentList ktValueArgumentList2 = object = secondCallArgumentList;
        int n = 0;
        Object[] objectArray2 = objectArray;
        boolean bl2 = false;
        boolean bl3 = secondCallHasArguments;
        Object object4 = bl3 ? object : null;
        objectArray2[n] = object4 != null ? SimplifyCallChainFix.apply$getTextInsideParentheses(object4) : null;
        KtValueArgumentList it = object = firstCallArgumentList;
        n = 1;
        objectArray2 = objectArray;
        boolean bl4 = false;
        bl3 = firstCallHasArguments;
        Object object5 = bl3 ? object : null;
        objectArray2[n] = object5 != null ? SimplifyCallChainFix.apply$getTextInsideParentheses(object5) : null;
        String string = additionalArgument;
        object = string;
        n = 2;
        objectArray2 = objectArray;
        boolean bl5 = false;
        bl3 = !firstCallHasArguments && !secondCallHasArguments;
        objectArray2[n] = bl3 ? string : null;
        KtLambdaExpression ktLambdaExpression2 = lambdaExpression2;
        objectArray[3] = ktLambdaExpression2 != null ? ktLambdaExpression2.getText() : null;
        String argumentsText2 = CollectionsKt.joinToString$default((Iterable)CollectionsKt.listOfNotNull((Object[])objectArray), (CharSequence)",", null, null, (int)0, null, null, (int)62, null);
        String newCallText = this.conversion.getReplacement();
        KtExpression newQualifiedOrCallExpression = psiFactory.createExpression(receiverExpressionOrEmptyString + operationSign + newCallText + "(" + argumentsText2 + ")");
        Project project3 = qualifiedExpression.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project3, (String)"getProject(...)");
        Project project4 = project3;
        KtFile ktFile2 = qualifiedExpression.getContainingKtFile();
        Intrinsics.checkNotNullExpressionValue((Object)ktFile2, (String)"getContainingKtFile(...)");
        KtFile file2 = ktFile2;
        PsiElement $this$replaced$iv = (PsiElement)qualifiedExpression;
        boolean $i$f$replaced2 = false;
        if (Intrinsics.areEqual((Object)$this$replaced$iv, (Object)((PsiElement)newQualifiedOrCallExpression))) {
            psiElement2 = (PsiElement)newQualifiedOrCallExpression;
        } else {
            PsiElement result$iv = $this$replaced$iv.replace((PsiElement)newQualifiedOrCallExpression);
            if (result$iv instanceof KtExpression) {
                psiElement2 = result$iv;
            } else {
                Intrinsics.checkNotNull((Object)result$iv, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtParenthesizedExpression");
                KtExpression ktExpression3 = ((KtParenthesizedExpression)result$iv).getExpression();
                if (ktExpression3 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtExpression");
                }
                psiElement2 = (PsiElement)ktExpression3;
            }
        }
        KtExpression result2 = (KtExpression)psiElement2;
        if (lambdaExpression2 != null || additionalArgument != null) {
            KtCallExpression callExpression2;
            KtExpression $i$f$replaced2 = result2;
            KtCallExpression ktCallExpression3 = callExpression2 = $i$f$replaced2 instanceof KtQualifiedExpression ? UtilsKt.getCallExpression((KtQualifiedExpression)result2) : ($i$f$replaced2 instanceof KtCallExpression ? (KtCallExpression)result2 : null);
            if (ktCallExpression3 != null) {
                KotlinCommonRefactoringUtilKt.moveFunctionLiteralOutsideParentheses$default(ktCallExpression3, null, 1, null);
            }
        }
        if (secondCallTrailingComma != null && !firstCallHasArguments) {
            Object object6;
            KtQualifiedExpression ktQualifiedExpression;
            KtExpression $this$safeAs$iv = result2;
            boolean $i$f$safeAs = false;
            KtExpression ktExpression4 = $this$safeAs$iv;
            if (!(ktExpression4 instanceof KtQualifiedExpression)) {
                ktExpression4 = null;
            }
            if ((ktQualifiedExpression = (KtQualifiedExpression)ktExpression4) == null || (ktQualifiedExpression = UtilsKt.getCallExpression(ktQualifiedExpression)) == null) {
                KtExpression $this$safeAs$iv2 = result2;
                boolean $i$f$safeAs2 = false;
                KtExpression ktExpression5 = $this$safeAs$iv2;
                if (!(ktExpression5 instanceof KtCallExpression)) {
                    ktExpression5 = null;
                }
                ktQualifiedExpression = (KtCallExpression)ktExpression5;
            }
            if ((object6 = (call2 = ktQualifiedExpression)) != null && (object6 = object6.getValueArgumentList()) != null && (object6 = object6.getArguments()) != null && (object6 = (KtValueArgument)CollectionsKt.lastOrNull((List)object6)) != null) {
                object6.add(psiFactory.createComma());
            }
        }
        if (this.conversion.getAddNotNullAssertion()) {
            PsiElement psiElement4;
            call2 = (PsiElement)result2;
            Object[] $i$f$replaced2 = new Object[]{result2};
            PsiElement newElement$iv = (PsiElement)CreateByPatternKt.createExpressionByPattern$default((KtPsiFactory)psiFactory, (String)"$0!!", (Object[])$i$f$replaced2, (boolean)false, (int)4, null);
            boolean $i$f$replaced3 = false;
            if (Intrinsics.areEqual((Object)$this$replaced$iv, (Object)newElement$iv)) {
                psiElement4 = newElement$iv;
            } else {
                PsiElement result$iv = $this$replaced$iv.replace(newElement$iv);
                if (result$iv instanceof KtExpression) {
                    psiElement4 = result$iv;
                } else {
                    Intrinsics.checkNotNull((Object)result$iv, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtParenthesizedExpression");
                    KtExpression ktExpression6 = ((KtParenthesizedExpression)result$iv).getExpression();
                    if (ktExpression6 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtExpression");
                    }
                    psiElement4 = (PsiElement)ktExpression6;
                }
            }
            result2 = (KtExpression)psiElement4;
        }
        if (this.conversion.getRemoveNotNullAssertion() && (parent2 = result2.getParent()) instanceof KtPostfixExpression && Intrinsics.areEqual((Object)((KtPostfixExpression)parent2).getOperationToken(), (Object)KtTokens.EXCLEXCL)) {
            PsiElement psiElement5;
            PsiElement $this$replaced$iv2 = parent2;
            boolean $i$f$replaced4 = false;
            if (Intrinsics.areEqual((Object)$this$replaced$iv2, (Object)((PsiElement)result2))) {
                psiElement5 = (PsiElement)result2;
            } else {
                PsiElement result$iv = $this$replaced$iv2.replace((PsiElement)result2);
                if (result$iv instanceof KtExpression) {
                    psiElement5 = result$iv;
                } else {
                    Intrinsics.checkNotNull((Object)result$iv, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtParenthesizedExpression");
                    KtExpression ktExpression7 = ((KtParenthesizedExpression)result$iv).getExpression();
                    if (ktExpression7 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtExpression");
                    }
                    psiElement5 = (PsiElement)ktExpression7;
                }
            }
            result2 = (KtExpression)psiElement5;
        }
        KtFile ktFile3 = result2.getContainingKtFile();
        Intrinsics.checkNotNullExpressionValue((Object)ktFile3, (String)"getContainingKtFile(...)");
        DocumentUtilsKt.commitAndUnblockDocument((PsiFile)ktFile3);
        if (result2.isValid()) {
            PsiElement psiElement6 = GenericPsiUtils.reformatted$default((PsiElement)result2, false, 1, null);
            Intrinsics.checkNotNull((Object)psiElement6, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtElement");
            ShortenReferences.process$default(ShortenReferences.DEFAULT, (KtElement)psiElement6, null, 2, null);
        }
        if (this.runOptimizeImports) {
            new OptimizeImportsProcessor(project4, (PsiFile)file2).run();
        }
    }

    public void applyFix(@NotNull Project project2, @NotNull ProblemDescriptor descriptor2) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
            PsiElement psiElement2 = descriptor2.getPsiElement();
            KtQualifiedExpression ktQualifiedExpression = psiElement2 instanceof KtQualifiedExpression ? (KtQualifiedExpression)psiElement2 : null;
            if (ktQualifiedExpression == null) break block0;
            KtQualifiedExpression p0 = ktQualifiedExpression;
            boolean bl = false;
            this.apply(p0);
        }
    }

    private static final String apply$getTextInsideParentheses(KtValueArgumentList $this$apply_u24getTextInsideParentheses) {
        PsiElement psiElement2;
        PsiElement psiElement3 = $this$apply_u24getTextInsideParentheses.getLeftParenthesis();
        if (psiElement3 == null || (psiElement3 = psiElement3.getNextSibling()) == null) {
            psiElement3 = $this$apply_u24getTextInsideParentheses.getFirstChild();
        }
        if ((psiElement2 = $this$apply_u24getTextInsideParentheses.getRightParenthesis()) == null || (psiElement2 = psiElement2.getPrevSibling()) == null) {
            psiElement2 = $this$apply_u24getTextInsideParentheses.getLastChild();
        }
        PsiChildRange range2 = new PsiChildRange(psiElement3, psiElement2);
        return SequencesKt.joinToString$default((Sequence)((Sequence)range2), (CharSequence)"", null, null, (int)0, null, (Function1)apply.getTextInsideParentheses.1.INSTANCE, (int)30, null);
    }
}

