/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.inspections;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.base.psi.KotlinPsiModificationUtils;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.codeinsight.api.classic.inspections.AbstractApplicabilityBasedInspection;
import org.jetbrains.kotlin.idea.intentions.UtilsKt;
import org.jetbrains.kotlin.psi.KtBlockStringTemplateEntry;
import org.jetbrains.kotlin.psi.KtDotQualifiedExpression;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtReferenceExpression;
import org.jetbrains.kotlin.psi.KtStringTemplateEntry;
import org.jetbrains.kotlin.psi.KtStringTemplateExpression;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\"\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u0002H\u0016J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\n\u001a\u00020\u0002H\u0016R\u0014\u0010\u0004\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/ReplaceToStringWithStringTemplateInspection;", "Lorg/jetbrains/kotlin/idea/codeinsight/api/classic/inspections/AbstractApplicabilityBasedInspection;", "Lorg/jetbrains/kotlin/psi/KtDotQualifiedExpression;", "()V", "defaultFixText", "", "getDefaultFixText", "()Ljava/lang/String;", "applyTo", "", "element", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "inspectionText", "isApplicable", "", "kotlin.idea"})
public final class ReplaceToStringWithStringTemplateInspection
extends AbstractApplicabilityBasedInspection<KtDotQualifiedExpression> {
    public ReplaceToStringWithStringTemplateInspection() {
        super(KtDotQualifiedExpression.class);
    }

    @Override
    public boolean isApplicable(@NotNull KtDotQualifiedExpression element3) {
        Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
        if (!(element3.getReceiverExpression() instanceof KtReferenceExpression)) {
            return false;
        }
        if (element3.getParent() instanceof KtBlockStringTemplateEntry) {
            return false;
        }
        return UtilsKt.isToString(element3);
    }

    @Override
    public void applyTo(@NotNull KtDotQualifiedExpression element3, @NotNull Project project2, @Nullable Editor editor2) {
        block0: {
            KtBlockStringTemplateEntry blockStringTemplateEntry;
            Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            String variable2 = element3.getReceiverExpression().getText();
            PsiElement psiElement2 = element3.replace((PsiElement)new KtPsiFactory(project2, false, 2, null).createExpression("\"${" + variable2 + "}\""));
            Intrinsics.checkNotNullExpressionValue((Object)psiElement2, (String)"replace(...)");
            PsiElement replaced2 = psiElement2;
            Object[] objectArray = replaced2 instanceof KtStringTemplateExpression ? (Object[])replaced2 : null;
            KtStringTemplateEntry ktStringTemplateEntry = objectArray != null && (objectArray = objectArray.getEntries()) != null ? (KtStringTemplateEntry)ArraysKt.firstOrNull((Object[])objectArray) : null;
            KtBlockStringTemplateEntry ktBlockStringTemplateEntry = blockStringTemplateEntry = ktStringTemplateEntry instanceof KtBlockStringTemplateEntry ? (KtBlockStringTemplateEntry)ktStringTemplateEntry : null;
            if (ktBlockStringTemplateEntry == null) break block0;
            KotlinPsiModificationUtils.dropCurlyBracketsIfPossible(ktBlockStringTemplateEntry);
        }
    }

    @Override
    @NotNull
    public String inspectionText(@NotNull KtDotQualifiedExpression element3) {
        Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
        return KotlinBundle.message((String)"inspection.replace.to.string.with.string.template.display.name", (Object[])new Object[0]);
    }

    @Override
    @NotNull
    public String getDefaultFixText() {
        return KotlinBundle.message((String)"replace.tostring.with.string.template", (Object[])new Object[0]);
    }
}

