/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.codeinsight.api.classic.inspections.AbstractKotlinInspection;
import org.jetbrains.kotlin.idea.codeinsight.utils.EditorUtilsKt;
import org.jetbrains.kotlin.idea.refactoring.inline.KotlinInlineAnonymousFunctionProcessor;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtFunctionLiteral;
import org.jetbrains.kotlin.psi.KtLambdaExpression;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtVisitorVoid;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0002\t\nB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/RedundantLambdaOrAnonymousFunctionInspection;", "Lorg/jetbrains/kotlin/idea/codeinsight/api/classic/inspections/AbstractKotlinInspection;", "()V", "buildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "RedundantLambdaOrAnonymousFunctionFix", "Util", "kotlin.idea"})
public final class RedundantLambdaOrAnonymousFunctionInspection
extends AbstractKotlinInspection {
    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        return (PsiElementVisitor)new KtVisitorVoid(holder){
            final /* synthetic */ ProblemsHolder $holder;
            {
                this.$holder = $holder;
            }

            public void visitNamedFunction(@NotNull KtNamedFunction function2) {
                Intrinsics.checkNotNullParameter((Object)function2, (String)"function");
                this.processExpression((KtFunction)function2);
            }

            public void visitLambdaExpression(@NotNull KtLambdaExpression lambdaExpression2) {
                Intrinsics.checkNotNullParameter((Object)lambdaExpression2, (String)"lambdaExpression");
                KtFunctionLiteral ktFunctionLiteral = lambdaExpression2.getFunctionLiteral();
                Intrinsics.checkNotNullExpressionValue((Object)ktFunctionLiteral, (String)"getFunctionLiteral(...)");
                this.processExpression((KtFunction)ktFunctionLiteral);
            }

            private final void processExpression(KtFunction function2) {
                if (Util.INSTANCE.findCallIfApplicableTo(function2) == null) {
                    return;
                }
                String message2 = function2 instanceof KtNamedFunction ? KotlinBundle.message((String)"inspection.redundant.anonymous.function.description", (Object[])new Object[0]) : KotlinBundle.message((String)"inspection.redundant.lambda.description", (Object[])new Object[0]);
                LocalQuickFix[] localQuickFixArray = new LocalQuickFix[]{new RedundantLambdaOrAnonymousFunctionFix()};
                this.$holder.registerProblem((PsiElement)function2, message2, localQuickFixArray);
            }
        };
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\fH\u0016\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/RedundantLambdaOrAnonymousFunctionInspection$RedundantLambdaOrAnonymousFunctionFix;", "Lcom/intellij/codeInspection/LocalQuickFix;", "()V", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "descriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "getFamilyName", "", "startInWriteAction", "", "kotlin.idea"})
    private static final class RedundantLambdaOrAnonymousFunctionFix
    implements LocalQuickFix {
        public boolean startInWriteAction() {
            return false;
        }

        @NotNull
        public String getFamilyName() {
            return KotlinBundle.message((String)"inspection.redundant.lambda.or.anonymous.function.fix", (Object[])new Object[0]);
        }

        public void applyFix(@NotNull Project project2, @NotNull ProblemDescriptor descriptor2) {
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
            PsiElement psiElement2 = descriptor2.getPsiElement();
            KtFunction ktFunction = psiElement2 instanceof KtFunction ? (KtFunction)psiElement2 : null;
            if (ktFunction == null) {
                return;
            }
            KtFunction function2 = ktFunction;
            KtExpression ktExpression = KotlinInlineAnonymousFunctionProcessor.Companion.findCallExpression(function2);
            if (ktExpression == null) {
                return;
            }
            KtExpression call2 = ktExpression;
            new KotlinInlineAnonymousFunctionProcessor(function2, call2, EditorUtilsKt.findExistingEditor((PsiElement)function2), project2).run();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/RedundantLambdaOrAnonymousFunctionInspection$Util;", "", "()V", "findCallIfApplicableTo", "Lorg/jetbrains/kotlin/psi/KtExpression;", "function", "Lorg/jetbrains/kotlin/psi/KtFunction;", "kotlin.idea"})
    public static final class Util {
        @NotNull
        public static final Util INSTANCE = new Util();

        private Util() {
        }

        @Nullable
        public final KtExpression findCallIfApplicableTo(@NotNull KtFunction function2) {
            Intrinsics.checkNotNullParameter((Object)function2, (String)"function");
            return function2.hasBody() ? KotlinInlineAnonymousFunctionProcessor.Companion.findCallExpression(function2) : null;
        }
    }
}

