/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.inspections;

import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.options.OptPane;
import com.intellij.codeInspection.options.OptRegularComponent;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiRecursiveElementWalkingVisitor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.base.psi.PsiLinesUtilsKt;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.codeinsight.api.classic.inspections.AbstractKotlinInspection;
import org.jetbrains.kotlin.idea.codeinsight.utils.EditorUtilsKt;
import org.jetbrains.kotlin.idea.inspections.LiftReturnOrAssignmentInspection;
import org.jetbrains.kotlin.idea.intentions.branchedTransformations.BranchedFoldingUtils;
import org.jetbrains.kotlin.idea.intentions.branchedTransformations.IfThenUtilsKt;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtIfExpression;
import org.jetbrains.kotlin.psi.KtReturnExpression;
import org.jetbrains.kotlin.psi.KtTryExpression;
import org.jetbrains.kotlin.psi.KtVisitorVoid;
import org.jetbrains.kotlin.psi.KtWhenExpression;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.bindingContextUtil.BindingContextUtilsKt;
import org.jetbrains.kotlin.resolve.lazy.BodyResolveMode;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0003\u000f\u0010\u0011B\u0011\b\u0007\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\r\u001a\u00020\u000eH\u0016R\u0012\u0010\u0005\u001a\u00020\u00038\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/LiftReturnOrAssignmentInspection;", "Lorg/jetbrains/kotlin/idea/codeinsight/api/classic/inspections/AbstractKotlinInspection;", "skipLongExpressions", "", "(Z)V", "reportOnlyIfSingleStatement", "buildVisitor", "Lorg/jetbrains/kotlin/psi/KtVisitorVoid;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "session", "Lcom/intellij/codeInspection/LocalInspectionToolSession;", "getOptionsPane", "Lcom/intellij/codeInspection/options/OptPane;", "LiftAssignmentOutFix", "LiftReturnOutFix", "Util", "kotlin.idea"})
public final class LiftReturnOrAssignmentInspection
extends AbstractKotlinInspection {
    private final boolean skipLongExpressions;
    @JvmField
    public boolean reportOnlyIfSingleStatement;

    @JvmOverloads
    public LiftReturnOrAssignmentInspection(boolean skipLongExpressions) {
        this.skipLongExpressions = skipLongExpressions;
        this.reportOnlyIfSingleStatement = true;
    }

    public /* synthetic */ LiftReturnOrAssignmentInspection(boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            bl = true;
        }
        this(bl);
    }

    @NotNull
    public OptPane getOptionsPane() {
        OptRegularComponent[] optRegularComponentArray = new OptRegularComponent[]{OptPane.checkbox((String)"reportOnlyIfSingleStatement", (String)KotlinBundle.message((String)"inspection.lift.return.or.assignment.option.only.single.statement", (Object[])new Object[0]), (OptRegularComponent[])new OptRegularComponent[0])};
        OptPane optPane = OptPane.pane((OptRegularComponent[])optRegularComponentArray);
        Intrinsics.checkNotNullExpressionValue((Object)optPane, (String)"pane(...)");
        return optPane;
    }

    @NotNull
    public KtVisitorVoid buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        return new KtVisitorVoid(this, holder, isOnTheFly){
            final /* synthetic */ LiftReturnOrAssignmentInspection this$0;
            final /* synthetic */ ProblemsHolder $holder;
            final /* synthetic */ boolean $isOnTheFly;
            {
                this.this$0 = $receiver;
                this.$holder = $holder;
                this.$isOnTheFly = $isOnTheFly;
            }

            public void visitExpression(@NotNull KtExpression expression2) {
                Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
                List<Util.LiftState> list2 = Util.INSTANCE.getState(expression2, LiftReturnOrAssignmentInspection.access$getSkipLongExpressions$p(this.this$0), this.this$0.reportOnlyIfSingleStatement);
                if (list2 == null) {
                    return;
                }
                List<Util.LiftState> states = list2;
                if (BindingContextUtilsKt.isUsedAsExpression((KtElement)((KtElement)expression2), (BindingContext)ResolutionUtils.analyze((KtElement)expression2, BodyResolveMode.PARTIAL_WITH_CFA))) {
                    return;
                }
                Iterable $this$forEach$iv = states;
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    Util.LiftState state = (Util.LiftState)element$iv;
                    boolean bl = false;
                    PsiElement psiElement2 = state.getKeyword();
                    boolean bl2 = state.isSerious();
                    this.registerProblem(expression2, psiElement2, bl2, switch (buildVisitor.WhenMappings.$EnumSwitchMapping$0[state.getLiftType().ordinal()]) {
                        case 1 -> {
                            String v3 = state.getKeyword().getText();
                            Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"getText(...)");
                            yield new LiftReturnOutFix(v3);
                        }
                        case 2 -> {
                            String v5 = state.getKeyword().getText();
                            Intrinsics.checkNotNullExpressionValue((Object)v5, (String)"getText(...)");
                            yield new LiftAssignmentOutFix(v5);
                        }
                        default -> throw new NoWhenBranchMatchedException();
                    }, state.getHighlightElement(), state.getHighlightType());
                }
            }

            private final void registerProblem(KtExpression expression2, PsiElement keyword, boolean isSerious, LocalQuickFix fix3, PsiElement highlightElement, ProblemHighlightType highlightType) {
                String subject = fix3 instanceof LiftReturnOutFix ? KotlinBundle.message((String)"text.Return", (Object[])new Object[0]) : KotlinBundle.message((String)"text.Assignment", (Object[])new Object[0]);
                PsiElement psiElement2 = (PsiElement)expression2;
                Object[] objectArray = new Object[2];
                objectArray[0] = subject;
                Intrinsics.checkNotNullExpressionValue((Object)keyword.getText(), (String)"getText(...)");
                String string = KotlinBundle.message((String)"0.1.be.lifted.out.of.2", (Object[])objectArray);
                TextRange textRange = highlightElement.getTextRange();
                objectArray = new LocalQuickFix[]{fix3};
                this.this$0.registerProblemWithoutOfflineInformation(this.$holder, psiElement2, string, this.$isOnTheFly, highlightType, textRange != null ? textRange.shiftRight(-PsiUtilsKt.getStartOffset((PsiElement)((PsiElement)expression2))) : null, (LocalQuickFix[])objectArray);
            }

            static /* synthetic */ void registerProblem$default(buildVisitor.1 var0, KtExpression ktExpression, PsiElement psiElement2, boolean bl, LocalQuickFix localQuickFix, PsiElement psiElement3, ProblemHighlightType problemHighlightType2, int n, Object object) {
                if ((n & 0x10) != 0) {
                    psiElement3 = psiElement2;
                }
                if ((n & 0x20) != 0) {
                    problemHighlightType2 = bl ? ProblemHighlightType.GENERIC_ERROR_OR_WARNING : ProblemHighlightType.INFORMATION;
                }
                var0.registerProblem(ktExpression, psiElement2, bl, localQuickFix, psiElement3, problemHighlightType2);
            }
        };
    }

    @JvmOverloads
    public LiftReturnOrAssignmentInspection() {
        this(false, 1, null);
    }

    public static final /* synthetic */ boolean access$getSkipLongExpressions$p(LiftReturnOrAssignmentInspection $this) {
        return $this.skipLongExpressions;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\u0003H\u0016J\b\u0010\f\u001a\u00020\u0003H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/LiftReturnOrAssignmentInspection$LiftAssignmentOutFix;", "Lcom/intellij/codeInspection/LocalQuickFix;", "keyword", "", "(Ljava/lang/String;)V", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "descriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "getFamilyName", "getName", "kotlin.idea"})
    private static final class LiftAssignmentOutFix
    implements LocalQuickFix {
        @NotNull
        private final String keyword;

        public LiftAssignmentOutFix(@NotNull String keyword) {
            Intrinsics.checkNotNullParameter((Object)keyword, (String)"keyword");
            this.keyword = keyword;
        }

        @NotNull
        public String getName() {
            Object[] objectArray = new Object[]{this.keyword};
            return KotlinBundle.message((String)"lift.assignment.out.fix.text.0", (Object[])objectArray);
        }

        @NotNull
        public String getFamilyName() {
            return this.getName();
        }

        public void applyFix(@NotNull Project project2, @NotNull ProblemDescriptor descriptor2) {
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
            PsiElement psiElement2 = descriptor2.getPsiElement();
            Intrinsics.checkNotNull((Object)psiElement2, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtExpression");
            BranchedFoldingUtils.INSTANCE.tryFoldToAssignment((KtExpression)psiElement2);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\u0003H\u0016J\b\u0010\f\u001a\u00020\u0003H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/LiftReturnOrAssignmentInspection$LiftReturnOutFix;", "Lcom/intellij/codeInspection/LocalQuickFix;", "keyword", "", "(Ljava/lang/String;)V", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "descriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "getFamilyName", "getName", "kotlin.idea"})
    private static final class LiftReturnOutFix
    implements LocalQuickFix {
        @NotNull
        private final String keyword;

        public LiftReturnOutFix(@NotNull String keyword) {
            Intrinsics.checkNotNullParameter((Object)keyword, (String)"keyword");
            this.keyword = keyword;
        }

        @NotNull
        public String getName() {
            Object[] objectArray = new Object[]{this.keyword};
            return KotlinBundle.message((String)"lift.return.out.fix.text.0", (Object[])objectArray);
        }

        @NotNull
        public String getFamilyName() {
            return this.getName();
        }

        public void applyFix(@NotNull Project project2, @NotNull ProblemDescriptor descriptor2) {
            block0: {
                Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
                Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
                PsiElement psiElement2 = descriptor2.getPsiElement();
                Intrinsics.checkNotNull((Object)psiElement2, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtExpression");
                KtExpression replaced2 = BranchedFoldingUtils.INSTANCE.foldToReturn((KtExpression)psiElement2);
                Editor editor2 = EditorUtilsKt.findExistingEditor((PsiElement)replaced2);
                if (editor2 == null || (editor2 = editor2.getCaretModel()) == null) break block0;
                editor2.moveToOffset(PsiUtilsKt.getStartOffset((PsiElement)((PsiElement)replaced2)));
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0002\u0011\u0012B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J(\u0010\u0005\u001a\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u00062\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\b\b\u0002\u0010\f\u001a\u00020\u000bJ0\u0010\r\u001a\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u00062\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000bH\u0002J\f\u0010\u0010\u001a\u00020\u000b*\u00020\tH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/LiftReturnOrAssignmentInspection$Util;", "", "()V", "LINES_LIMIT", "", "getState", "", "Lorg/jetbrains/kotlin/idea/inspections/LiftReturnOrAssignmentInspection$Util$LiftState;", "expression", "Lorg/jetbrains/kotlin/psi/KtExpression;", "skipLongExpressions", "", "reportOnlyIfSingleStatement", "getStateForWhenOrTry", "keyword", "Lcom/intellij/psi/PsiElement;", "hasSiblings", "LiftState", "LiftType", "kotlin.idea"})
    @SourceDebugExtension(value={"SMAP\nLiftReturnOrAssignmentInspection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LiftReturnOrAssignmentInspection.kt\norg/jetbrains/kotlin/idea/inspections/LiftReturnOrAssignmentInspection$Util\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 psiUtils.kt\norg/jetbrains/kotlin/psi/psiUtil/PsiUtilsKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,165:1\n1#2:166\n266#3:167\n277#3,10:168\n299#3:178\n2624#4,3:179\n1549#4:182\n1620#4,3:183\n2624#4,3:186\n*S KotlinDebug\n*F\n+ 1 LiftReturnOrAssignmentInspection.kt\norg/jetbrains/kotlin/idea/inspections/LiftReturnOrAssignmentInspection$Util\n*L\n131#1:167\n131#1:168,10\n131#1:178\n132#1:179,3\n136#1:182\n136#1:183,3\n142#1:186,3\n*E\n"})
    public static final class Util {
        @NotNull
        public static final Util INSTANCE = new Util();
        private static final int LINES_LIMIT = 15;

        private Util() {
        }

        @Nullable
        public final List<LiftState> getState(@NotNull KtExpression expression2, boolean skipLongExpressions, boolean reportOnlyIfSingleStatement) {
            List<LiftState> list2;
            Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
            KtExpression ktExpression = expression2;
            if (ktExpression instanceof KtWhenExpression) {
                PsiElement psiElement2 = ((KtWhenExpression)expression2).getWhenKeyword();
                Intrinsics.checkNotNullExpressionValue((Object)psiElement2, (String)"getWhenKeyword(...)");
                list2 = this.getStateForWhenOrTry(expression2, psiElement2, skipLongExpressions, reportOnlyIfSingleStatement);
            } else if (ktExpression instanceof KtIfExpression) {
                PsiElement psiElement3 = ((KtIfExpression)expression2).getIfKeyword();
                Intrinsics.checkNotNullExpressionValue((Object)psiElement3, (String)"getIfKeyword(...)");
                list2 = this.getStateForWhenOrTry(expression2, psiElement3, skipLongExpressions, reportOnlyIfSingleStatement);
            } else if (ktExpression instanceof KtTryExpression) {
                PsiElement psiElement4 = ((KtTryExpression)expression2).getTryKeyword();
                if (psiElement4 != null) {
                    PsiElement it = psiElement4;
                    boolean bl = false;
                    list2 = INSTANCE.getStateForWhenOrTry(expression2, it, skipLongExpressions, reportOnlyIfSingleStatement);
                } else {
                    list2 = null;
                }
            } else {
                list2 = null;
            }
            return list2;
        }

        public static /* synthetic */ List getState$default(Util util, KtExpression ktExpression, boolean bl, boolean bl2, int n, Object object) {
            if ((n & 4) != 0) {
                bl2 = true;
            }
            return util.getState(ktExpression, bl, bl2);
        }

        /*
         * WARNING - void declaration
         */
        private final List<LiftState> getStateForWhenOrTry(KtExpression expression2, PsiElement keyword, boolean skipLongExpressions, boolean reportOnlyIfSingleStatement) {
            List<KtReturnExpression> foldableReturns;
            if (skipLongExpressions && PsiLinesUtilsKt.getLineCount((PsiElement)expression2) > 15) {
                return null;
            }
            if (IfThenUtilsKt.isElseIf(expression2)) {
                return null;
            }
            List<KtReturnExpression> list2 = foldableReturns = BranchedFoldingUtils.INSTANCE.getFoldableReturns$kotlin_idea(expression2);
            boolean bl = list2 != null ? !((Collection)list2).isEmpty() : false;
            if (bl) {
                void $this$mapTo$iv$iv;
                boolean bl2;
                boolean hasOtherReturns2;
                block11: {
                    void $this$anyDescendantOfType$iv;
                    PsiElement psiElement2 = (PsiElement)expression2;
                    Function1 predicate$iv = (Function1)new Function1<KtReturnExpression, Boolean>(foldableReturns){
                        final /* synthetic */ List<KtReturnExpression> $foldableReturns;
                        {
                            this.$foldableReturns = $foldableReturns;
                            super(1);
                        }

                        @NotNull
                        public final Boolean invoke(@NotNull KtReturnExpression it) {
                            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                            return !this.$foldableReturns.contains(it);
                        }
                    };
                    boolean $i$f$anyDescendantOfType = false;
                    Iterator $this$findDescendantOfType$iv$iv = $this$anyDescendantOfType$iv;
                    boolean $i$f$findDescendantOfType = false;
                    void $this$findDescendantOfType$iv$iv$iv = $this$findDescendantOfType$iv$iv;
                    boolean $i$f$findDescendantOfType2 = false;
                    PsiUtilsKt.checkDecompiledText((PsiElement)$this$findDescendantOfType$iv$iv$iv);
                    Ref.ObjectRef result$iv$iv$iv = new Ref.ObjectRef();
                    $this$findDescendantOfType$iv$iv$iv.accept((PsiElementVisitor)new PsiRecursiveElementWalkingVisitor(predicate$iv, result$iv$iv$iv){
                        final /* synthetic */ Function1 $predicate;
                        final /* synthetic */ Ref.ObjectRef $result;
                        {
                            this.$predicate = $predicate;
                            this.$result = $result;
                        }

                        public void visitElement(PsiElement element3) {
                            Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
                            if (element3 instanceof KtReturnExpression && ((Boolean)this.$predicate.invoke((Object)element3)).booleanValue()) {
                                this.$result.element = element3;
                                this.stopWalking();
                                return;
                            }
                            PsiElement it = element3;
                            boolean bl = false;
                            super.visitElement(element3);
                        }
                    });
                    hasOtherReturns2 = (PsiElement)result$iv$iv$iv.element != null;
                    Iterable $this$none$iv = foldableReturns;
                    boolean $i$f$none = false;
                    if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                        bl2 = true;
                    } else {
                        for (Object element$iv : $this$none$iv) {
                            KtReturnExpression it = (KtReturnExpression)element$iv;
                            boolean bl3 = false;
                            if (!INSTANCE.hasSiblings((KtExpression)it)) continue;
                            bl2 = false;
                            break block11;
                        }
                        bl2 = true;
                    }
                }
                boolean allBranchesAreSingleStatement = bl2;
                boolean isSerious = !hasOtherReturns2 && foldableReturns.size() > 1 && (allBranchesAreSingleStatement || !reportOnlyIfSingleStatement);
                Iterable $this$map$iv = foldableReturns;
                boolean $i$f$map = false;
                Iterable element$iv = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    KtReturnExpression ktReturnExpression = (KtReturnExpression)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl4 = false;
                    collection.add(new LiftState(keyword, isSerious, LiftType.LIFT_RETURN_OUT, (PsiElement)it, ProblemHighlightType.INFORMATION));
                }
                return CollectionsKt.plus((Collection)((List)destination$iv$iv), (Object)new LiftState(keyword, isSerious, LiftType.LIFT_RETURN_OUT, null, null, 24, null));
            }
            Set<KtBinaryExpression> assignments = BranchedFoldingUtils.INSTANCE.getFoldableAssignments$kotlin_idea(expression2);
            if (!((Collection)assignments).isEmpty()) {
                boolean bl5;
                block12: {
                    Iterable $this$none$iv = assignments;
                    boolean $i$f$none = false;
                    if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                        bl5 = true;
                    } else {
                        for (Object element$iv : $this$none$iv) {
                            KtBinaryExpression it = (KtBinaryExpression)element$iv;
                            boolean bl6 = false;
                            if (!INSTANCE.hasSiblings((KtExpression)it)) continue;
                            bl5 = false;
                            break block12;
                        }
                        bl5 = true;
                    }
                }
                boolean allBranchesAreSingleStatement = bl5;
                boolean isSerious = assignments.size() > 1 && (allBranchesAreSingleStatement || !reportOnlyIfSingleStatement);
                return CollectionsKt.listOf((Object)new LiftState(keyword, isSerious, LiftType.LIFT_ASSIGNMENT_OUT, null, null, 24, null));
            }
            return null;
        }

        private final boolean hasSiblings(KtExpression $this$hasSiblings) {
            PsiElement psiElement2 = $this$hasSiblings.getParent();
            KtBlockExpression ktBlockExpression = psiElement2 instanceof KtBlockExpression ? (KtBlockExpression)psiElement2 : null;
            List list2 = ktBlockExpression != null ? ktBlockExpression.getStatements() : null;
            if (list2 == null) {
                list2 = CollectionsKt.emptyList();
            }
            return list2.size() > 1;
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0012\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B1\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\u0003\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\t\u0010\u0014\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\u0007H\u00c6\u0003J\t\u0010\u0017\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0018\u001a\u00020\nH\u00c6\u0003J;\u0010\u0019\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\u00032\b\b\u0002\u0010\t\u001a\u00020\nH\u00c6\u0001J\u0013\u0010\u001a\u001a\u00020\u00052\b\u0010\u001b\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001c\u001a\u00020\u001dH\u00d6\u0001J\t\u0010\u001e\u001a\u00020\u001fH\u00d6\u0001R\u0011\u0010\b\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\u0010R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006 "}, d2={"Lorg/jetbrains/kotlin/idea/inspections/LiftReturnOrAssignmentInspection$Util$LiftState;", "", "keyword", "Lcom/intellij/psi/PsiElement;", "isSerious", "", "liftType", "Lorg/jetbrains/kotlin/idea/inspections/LiftReturnOrAssignmentInspection$Util$LiftType;", "highlightElement", "highlightType", "Lcom/intellij/codeInspection/ProblemHighlightType;", "(Lcom/intellij/psi/PsiElement;ZLorg/jetbrains/kotlin/idea/inspections/LiftReturnOrAssignmentInspection$Util$LiftType;Lcom/intellij/psi/PsiElement;Lcom/intellij/codeInspection/ProblemHighlightType;)V", "getHighlightElement", "()Lcom/intellij/psi/PsiElement;", "getHighlightType", "()Lcom/intellij/codeInspection/ProblemHighlightType;", "()Z", "getKeyword", "getLiftType", "()Lorg/jetbrains/kotlin/idea/inspections/LiftReturnOrAssignmentInspection$Util$LiftType;", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "other", "hashCode", "", "toString", "", "kotlin.idea"})
        public static final class LiftState {
            @NotNull
            private final PsiElement keyword;
            private final boolean isSerious;
            @NotNull
            private final LiftType liftType;
            @NotNull
            private final PsiElement highlightElement;
            @NotNull
            private final ProblemHighlightType highlightType;

            public LiftState(@NotNull PsiElement keyword, boolean isSerious, @NotNull LiftType liftType, @NotNull PsiElement highlightElement, @NotNull ProblemHighlightType highlightType) {
                Intrinsics.checkNotNullParameter((Object)keyword, (String)"keyword");
                Intrinsics.checkNotNullParameter((Object)((Object)liftType), (String)"liftType");
                Intrinsics.checkNotNullParameter((Object)highlightElement, (String)"highlightElement");
                Intrinsics.checkNotNullParameter((Object)highlightType, (String)"highlightType");
                this.keyword = keyword;
                this.isSerious = isSerious;
                this.liftType = liftType;
                this.highlightElement = highlightElement;
                this.highlightType = highlightType;
            }

            public /* synthetic */ LiftState(PsiElement psiElement2, boolean bl, LiftType liftType, PsiElement psiElement3, ProblemHighlightType problemHighlightType2, int n, DefaultConstructorMarker defaultConstructorMarker) {
                if ((n & 8) != 0) {
                    psiElement3 = psiElement2;
                }
                if ((n & 0x10) != 0) {
                    problemHighlightType2 = bl ? ProblemHighlightType.GENERIC_ERROR_OR_WARNING : ProblemHighlightType.INFORMATION;
                }
                this(psiElement2, bl, liftType, psiElement3, problemHighlightType2);
            }

            @NotNull
            public final PsiElement getKeyword() {
                return this.keyword;
            }

            public final boolean isSerious() {
                return this.isSerious;
            }

            @NotNull
            public final LiftType getLiftType() {
                return this.liftType;
            }

            @NotNull
            public final PsiElement getHighlightElement() {
                return this.highlightElement;
            }

            @NotNull
            public final ProblemHighlightType getHighlightType() {
                return this.highlightType;
            }

            @NotNull
            public final PsiElement component1() {
                return this.keyword;
            }

            public final boolean component2() {
                return this.isSerious;
            }

            @NotNull
            public final LiftType component3() {
                return this.liftType;
            }

            @NotNull
            public final PsiElement component4() {
                return this.highlightElement;
            }

            @NotNull
            public final ProblemHighlightType component5() {
                return this.highlightType;
            }

            @NotNull
            public final LiftState copy(@NotNull PsiElement keyword, boolean isSerious, @NotNull LiftType liftType, @NotNull PsiElement highlightElement, @NotNull ProblemHighlightType highlightType) {
                Intrinsics.checkNotNullParameter((Object)keyword, (String)"keyword");
                Intrinsics.checkNotNullParameter((Object)((Object)liftType), (String)"liftType");
                Intrinsics.checkNotNullParameter((Object)highlightElement, (String)"highlightElement");
                Intrinsics.checkNotNullParameter((Object)highlightType, (String)"highlightType");
                return new LiftState(keyword, isSerious, liftType, highlightElement, highlightType);
            }

            public static /* synthetic */ LiftState copy$default(LiftState liftState, PsiElement psiElement2, boolean bl, LiftType liftType, PsiElement psiElement3, ProblemHighlightType problemHighlightType2, int n, Object object) {
                if ((n & 1) != 0) {
                    psiElement2 = liftState.keyword;
                }
                if ((n & 2) != 0) {
                    bl = liftState.isSerious;
                }
                if ((n & 4) != 0) {
                    liftType = liftState.liftType;
                }
                if ((n & 8) != 0) {
                    psiElement3 = liftState.highlightElement;
                }
                if ((n & 0x10) != 0) {
                    problemHighlightType2 = liftState.highlightType;
                }
                return liftState.copy(psiElement2, bl, liftType, psiElement3, problemHighlightType2);
            }

            @NotNull
            public String toString() {
                return "LiftState(keyword=" + this.keyword + ", isSerious=" + this.isSerious + ", liftType=" + this.liftType + ", highlightElement=" + this.highlightElement + ", highlightType=" + this.highlightType + ")";
            }

            public int hashCode() {
                int result2 = this.keyword.hashCode();
                result2 = result2 * 31 + Boolean.hashCode(this.isSerious);
                result2 = result2 * 31 + this.liftType.hashCode();
                result2 = result2 * 31 + this.highlightElement.hashCode();
                result2 = result2 * 31 + this.highlightType.hashCode();
                return result2;
            }

            public boolean equals(@Nullable Object other2) {
                if (this == other2) {
                    return true;
                }
                if (!(other2 instanceof LiftState)) {
                    return false;
                }
                LiftState liftState = (LiftState)other2;
                if (!Intrinsics.areEqual((Object)this.keyword, (Object)liftState.keyword)) {
                    return false;
                }
                if (this.isSerious != liftState.isSerious) {
                    return false;
                }
                if (this.liftType != liftState.liftType) {
                    return false;
                }
                if (!Intrinsics.areEqual((Object)this.highlightElement, (Object)liftState.highlightElement)) {
                    return false;
                }
                return this.highlightType == liftState.highlightType;
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0004\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/LiftReturnOrAssignmentInspection$Util$LiftType;", "", "(Ljava/lang/String;I)V", "LIFT_RETURN_OUT", "LIFT_ASSIGNMENT_OUT", "kotlin.idea"})
        public static final class LiftType
        extends Enum<LiftType> {
            public static final /* enum */ LiftType LIFT_RETURN_OUT = new LiftType();
            public static final /* enum */ LiftType LIFT_ASSIGNMENT_OUT = new LiftType();
            private static final /* synthetic */ LiftType[] $VALUES;
            private static final /* synthetic */ EnumEntries $ENTRIES;

            public static LiftType[] values() {
                return (LiftType[])$VALUES.clone();
            }

            public static LiftType valueOf(String value2) {
                return Enum.valueOf(LiftType.class, value2);
            }

            @NotNull
            public static EnumEntries<LiftType> getEntries() {
                return $ENTRIES;
            }

            static {
                $VALUES = liftTypeArray = new LiftType[]{LiftType.LIFT_RETURN_OUT, LiftType.LIFT_ASSIGNMENT_OUT};
                $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
            }
        }
    }
}

