/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.highlighter;

import com.intellij.codeInsight.daemon.impl.analysis.DefaultHighlightingSettingProvider;
import com.intellij.codeInsight.daemon.impl.analysis.FileHighlightingSetting;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.base.projectStructure.RootKindFilter;
import org.jetbrains.kotlin.idea.base.projectStructure.SourceKindFilterUtils;
import org.jetbrains.kotlin.idea.codeinsight.utils.KotlinSupportAvailability;
import org.jetbrains.kotlin.idea.core.util.PhysicalFileSystemUtilsKt;
import org.jetbrains.kotlin.idea.highlighter.KotlinDefaultHighlightingSettingsProviderKt;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.scripting.definitions.ScriptDependenciesProvider;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\u001a\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/idea/highlighter/KotlinDefaultHighlightingSettingsProvider;", "Lcom/intellij/codeInsight/daemon/impl/analysis/DefaultHighlightingSettingProvider;", "Lcom/intellij/openapi/project/DumbAware;", "()V", "getDefaultSetting", "Lcom/intellij/codeInsight/daemon/impl/analysis/FileHighlightingSetting;", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "kotlin.highlighting.shared"})
public final class KotlinDefaultHighlightingSettingsProvider
extends DefaultHighlightingSettingProvider
implements DumbAware {
    /*
     * Enabled aggressive block sorting
     */
    @Nullable
    public FileHighlightingSetting getDefaultSetting(@NotNull Project project2, @NotNull VirtualFile file2) {
        FileHighlightingSetting fileHighlightingSetting;
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        if (!file2.isValid()) {
            return null;
        }
        PsiFile psiFile2 = PhysicalFileSystemUtilsKt.toPsiFile(file2, project2);
        if (psiFile2 == null) {
            return null;
        }
        PsiFile psiFile3 = psiFile2;
        if (psiFile3 instanceof KtFile) {
            if (((KtFile)psiFile3).isScript()) {
                ScriptDependenciesProvider scriptDependenciesProvider = ScriptDependenciesProvider.Companion.getInstance(project2);
                if ((scriptDependenciesProvider != null ? scriptDependenciesProvider.getScriptConfiguration((KtFile)psiFile3) : null) == null) {
                    fileHighlightingSetting = FileHighlightingSetting.SKIP_HIGHLIGHTING;
                    return fileHighlightingSetting;
                }
            }
            if (((KtFile)psiFile3).isCompiled()) {
                fileHighlightingSetting = FileHighlightingSetting.SKIP_INSPECTION;
                return fileHighlightingSetting;
            }
            if (!KotlinSupportAvailability.Companion.isSupported((KtElement)psiFile3)) {
                fileHighlightingSetting = FileHighlightingSetting.SKIP_HIGHLIGHTING;
                return fileHighlightingSetting;
            }
            if (!SourceKindFilterUtils.matches(RootKindFilter.libraryFiles, project2, file2)) return null;
            fileHighlightingSetting = FileHighlightingSetting.SKIP_INSPECTION;
            return fileHighlightingSetting;
        }
        if (!KotlinDefaultHighlightingSettingsProviderKt.isKotlinDecompiledFile(file2)) return null;
        fileHighlightingSetting = FileHighlightingSetting.SKIP_HIGHLIGHTING;
        return fileHighlightingSetting;
    }
}

