/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.framework;

import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryKind;
import com.intellij.openapi.roots.ui.configuration.libraries.LibraryPresentationManager;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.NlsContexts;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.KotlinJvmBundle;

public final class FrameworksCompatibilityUtils {
    private FrameworksCompatibilityUtils() {
    }

    public static void suggestRemoveIncompatibleFramework(@NotNull ModifiableRootModel rootModel, @NotNull Set<? extends LibraryKind> frameworkLibraryKinds, @NotNull String presentableName) {
        if (rootModel == null) {
            FrameworksCompatibilityUtils.$$$reportNull$$$0(0);
        }
        if (frameworkLibraryKinds == null) {
            FrameworksCompatibilityUtils.$$$reportNull$$$0(1);
        }
        if (presentableName == null) {
            FrameworksCompatibilityUtils.$$$reportNull$$$0(2);
        }
        ArrayList<OrderEntry> existingEntries = new ArrayList<OrderEntry>();
        for (OrderEntry entry : rootModel.getOrderEntries()) {
            Library library2;
            if (!(entry instanceof LibraryOrderEntry) || (library2 = ((LibraryOrderEntry)entry).getLibrary()) == null) continue;
            for (LibraryKind libraryKind : frameworkLibraryKinds) {
                if (!LibraryPresentationManager.getInstance().isLibraryOfKind(Arrays.asList(library2.getFiles(OrderRootType.CLASSES)), libraryKind)) continue;
                existingEntries.add(entry);
            }
        }
        FrameworksCompatibilityUtils.removeWithConfirm(rootModel, existingEntries, KotlinJvmBundle.message("frameworks.remove.conflict.question", presentableName), KotlinJvmBundle.message("frameworks.remove.conflict.title", new Object[0]));
    }

    private static void removeWithConfirm(ModifiableRootModel rootModel, List<OrderEntry> orderEntries2, @NlsContexts.DialogMessage String message2, @NlsContexts.DialogTitle String title) {
        int result2;
        if (!orderEntries2.isEmpty() && (result2 = Messages.showYesNoDialog((String)message2, (String)title, (Icon)Messages.getWarningIcon())) == 0) {
            for (OrderEntry entry : orderEntries2) {
                rootModel.removeOrderEntry(entry);
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "rootModel";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "frameworkLibraryKinds";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "presentableName";
                break;
            }
        }
        objectArray[1] = "org/jetbrains/kotlin/idea/framework/FrameworksCompatibilityUtils";
        objectArray[2] = "suggestRemoveIncompatibleFramework";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

