/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.editor;

import com.intellij.codeInsight.editorActions.CopyPastePreProcessor;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RawText;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.CharsKt;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.base.codeInsight.handlers.fixers.FixersUtilKt;
import org.jetbrains.kotlin.idea.editor.EntryChunk;
import org.jetbrains.kotlin.idea.editor.KotlinLiteralCopyPasteProcessor;
import org.jetbrains.kotlin.idea.editor.KotlinLiteralCopyPasteProcessorKt;
import org.jetbrains.kotlin.idea.editor.LiteralChunk;
import org.jetbrains.kotlin.idea.editor.NewLineChunk;
import org.jetbrains.kotlin.idea.editor.TemplateChunk;
import org.jetbrains.kotlin.idea.editor.TemplateTokenSequence;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtEscapeStringTemplateEntry;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtQualifiedExpression;
import org.jetbrains.kotlin.psi.KtStringTemplateExpression;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0015\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J*\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u0004H\u0016J2\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\n\u001a\u00020\u00042\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0016\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/idea/editor/KotlinLiteralCopyPasteProcessor;", "Lcom/intellij/codeInsight/editorActions/CopyPastePreProcessor;", "()V", "preprocessOnCopy", "", "file", "Lcom/intellij/psi/PsiFile;", "startOffsets", "", "endOffsets", "text", "preprocessOnPaste", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "rawText", "Lcom/intellij/openapi/editor/RawText;", "kotlin.ide"})
@SourceDebugExtension(value={"SMAP\nKotlinLiteralCopyPasteProcessor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinLiteralCopyPasteProcessor.kt\norg/jetbrains/kotlin/idea/editor/KotlinLiteralCopyPasteProcessor\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n*L\n1#1,293:1\n1313#2,2:294\n1#3:296\n1064#4,2:297\n643#4,5:299\n*S KotlinDebug\n*F\n+ 1 KotlinLiteralCopyPasteProcessor.kt\norg/jetbrains/kotlin/idea/editor/KotlinLiteralCopyPasteProcessor\n*L\n127#1:294,2\n152#1:297,2\n145#1:299,5\n*E\n"})
public final class KotlinLiteralCopyPasteProcessor
implements CopyPastePreProcessor {
    @Nullable
    public String preprocessOnCopy(@NotNull PsiFile file2, @NotNull int[] startOffsets, @NotNull int[] endOffsets, @NotNull String text2) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Intrinsics.checkNotNullParameter((Object)startOffsets, (String)"startOffsets");
        Intrinsics.checkNotNullParameter((Object)endOffsets, (String)"endOffsets");
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        if (!(file2 instanceof KtFile)) {
            return null;
        }
        StringBuilder buffer = new StringBuilder();
        boolean changed2 = false;
        String fileText2 = ((KtFile)file2).getText();
        int deducedBlockSelectionWidth = KotlinLiteralCopyPasteProcessorKt.access$deduceBlockSelectionWidth(startOffsets, endOffsets, text2);
        int n = startOffsets.length;
        for (int i2 = 0; i2 < n; ++i2) {
            if (i2 > 0) {
                buffer.append('\n');
            }
            TextRange fileRange = new TextRange(startOffsets[i2], endOffsets[i2]);
            int givenTextOffset = fileRange.getStartOffset();
            while (givenTextOffset < fileRange.getEndOffset()) {
                TextRange inter;
                PsiElement tpEntry;
                IElementType elTp;
                PsiElement element3 = file2.findElementAt(givenTextOffset);
                if (element3 == null) {
                    Intrinsics.checkNotNull((Object)fileText2);
                    String string = fileText2.substring(givenTextOffset, fileRange.getEndOffset() - 1);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                    buffer.append(string);
                    break;
                }
                Intrinsics.checkNotNullExpressionValue((Object)element3.getNode().getElementType(), (String)"getElementType(...)");
                if (Intrinsics.areEqual((Object)elTp, (Object)KtTokens.ESCAPE_SEQUENCE) && fileRange.contains(FixersUtilKt.getRange((PsiElement)element3))) {
                    TextRange textRange = KotlinLiteralCopyPasteProcessorKt.access$getTemplateContentRange(element3);
                    boolean bl = textRange != null ? textRange.contains(fileRange) : false;
                    if (bl) {
                        PsiElement psiElement2 = element3.getParent();
                        Intrinsics.checkNotNull((Object)psiElement2, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtEscapeStringTemplateEntry");
                        tpEntry = (KtEscapeStringTemplateEntry)psiElement2;
                        changed2 = true;
                        buffer.append(tpEntry.getUnescapedValue());
                        givenTextOffset = PsiUtilsKt.getEndOffset((PsiElement)element3);
                        continue;
                    }
                }
                if (Intrinsics.areEqual((Object)elTp, (Object)KtTokens.SHORT_TEMPLATE_ENTRY_START) || Intrinsics.areEqual((Object)elTp, (Object)KtTokens.LONG_TEMPLATE_ENTRY_START)) {
                    TextRange inter2;
                    tpEntry = element3.getParent();
                    Intrinsics.checkNotNull((Object)tpEntry);
                    Intrinsics.checkNotNull((Object)fileRange.intersection(FixersUtilKt.getRange((PsiElement)tpEntry)));
                    Intrinsics.checkNotNull((Object)fileText2);
                    String string = fileText2.substring(inter2.getStartOffset(), inter2.getEndOffset());
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                    buffer.append(string);
                    givenTextOffset = inter2.getEndOffset();
                    continue;
                }
                Intrinsics.checkNotNull((Object)fileRange.intersection(FixersUtilKt.getRange((PsiElement)element3)));
                Intrinsics.checkNotNull((Object)fileText2);
                String string = fileText2.substring(inter.getStartOffset(), inter.getEndOffset());
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                buffer.append(string);
                givenTextOffset = inter.getEndOffset();
            }
            int blockSelectionPadding = deducedBlockSelectionWidth - fileRange.getLength();
            for (int j = 0; j < blockSelectionPadding; ++j) {
                buffer.append(' ');
            }
        }
        return changed2 ? buffer.toString() : null;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    @NotNull
    public String preprocessOnPaste(@NotNull Project project2, @NotNull PsiFile file2, @NotNull Editor editor2, @NotNull String text2, @Nullable RawText rawText) {
        StringBuilder stringBuilder;
        String string;
        String string2;
        TemplateTokenSequence templateTokenSequence;
        block24: {
            boolean bl;
            Object object;
            block18: {
                CharSequence $this$all$iv;
                block23: {
                    Object object2;
                    Iterator iterator2;
                    boolean endsInLineBreak;
                    String lineBreak;
                    StringBuilder res;
                    block20: {
                        block21: {
                            block22: {
                                KtStringTemplateExpression beginTp;
                                PsiElement begin;
                                block19: {
                                    Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
                                    Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
                                    Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
                                    Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
                                    if (!(file2 instanceof KtFile)) {
                                        return text2;
                                    }
                                    PsiDocumentManager.getInstance((Project)project2).commitDocument(editor2.getDocument());
                                    SelectionModel selectionModel = editor2.getSelectionModel();
                                    Intrinsics.checkNotNullExpressionValue((Object)selectionModel, (String)"getSelectionModel(...)");
                                    SelectionModel selectionModel2 = selectionModel;
                                    PsiElement psiElement2 = file2.findElementAt(selectionModel2.getSelectionStart());
                                    if (psiElement2 == null) {
                                        return text2;
                                    }
                                    begin = psiElement2;
                                    KtStringTemplateExpression ktStringTemplateExpression = KotlinLiteralCopyPasteProcessorKt.access$getTemplateIfAtLiteral(file2, selectionModel2.getSelectionStart(), begin);
                                    if (ktStringTemplateExpression == null) {
                                        return text2;
                                    }
                                    beginTp = ktStringTemplateExpression;
                                    KtStringTemplateExpression ktStringTemplateExpression2 = KotlinLiteralCopyPasteProcessorKt.getTemplateIfAtLiteral$default(file2, selectionModel2.getSelectionEnd(), null, 2, null);
                                    if (ktStringTemplateExpression2 == null) {
                                        return text2;
                                    }
                                    KtStringTemplateExpression endTp = ktStringTemplateExpression2;
                                    if (KtPsiUtilKt.isSingleQuoted((KtStringTemplateExpression)beginTp) != KtPsiUtilKt.isSingleQuoted((KtStringTemplateExpression)endTp)) {
                                        return text2;
                                    }
                                    templateTokenSequence = new TemplateTokenSequence(text2);
                                    if (!KtPsiUtilKt.isSingleQuoted((KtStringTemplateExpression)beginTp)) break block19;
                                    res = new StringBuilder();
                                    lineBreak = "\\n\"+\n \"";
                                    endsInLineBreak = false;
                                    Sequence sequence2 = templateTokenSequence;
                                    boolean $i$f$forEach = false;
                                    iterator2 = sequence2.iterator();
                                    break block20;
                                }
                                PsiElement psiElement3 = beginTp.getFirstChild();
                                if (!Intrinsics.areEqual((Object)(psiElement3 != null ? psiElement3.getText() : null), (Object)"\"\"\"")) break block21;
                                KtQualifiedExpression ktQualifiedExpression = KtPsiUtilKt.getQualifiedExpressionForReceiver((KtExpression)((KtExpression)beginTp));
                                Object object3 = ktQualifiedExpression != null ? ktQualifiedExpression.getSelectorExpression() : null;
                                KtCallExpression ktCallExpression = object3 instanceof KtCallExpression ? (KtCallExpression)object3 : null;
                                if (!Intrinsics.areEqual((Object)(ktCallExpression != null && (ktCallExpression = ktCallExpression.getCalleeExpression()) != null ? ktCallExpression.getText() : null), (Object)"trimIndent")) break block21;
                                TemplateChunk templateChunk2 = (TemplateChunk)SequencesKt.firstOrNull((Sequence)templateTokenSequence);
                                templateChunk2 = (TemplateChunk)SequencesKt.lastOrNull((Sequence)templateTokenSequence);
                                if (!Intrinsics.areEqual((Object)(templateChunk != null ? KotlinLiteralCopyPasteProcessor.preprocessOnPaste$indent(templateChunk) : null), (Object)(templateChunk2 != null ? KotlinLiteralCopyPasteProcessor.preprocessOnPaste$indent(templateChunk2) : null))) break block21;
                                Object object4 = begin.getParent();
                                if (object4 == null || (object4 = object4.getPrevSibling()) == null || (object4 = object4.getText()) == null) break block22;
                                Object object5 = object = object4;
                                boolean bl2 = false;
                                $this$all$iv = (CharSequence)object5;
                                boolean $i$f$all = false;
                                break block23;
                            }
                            string2 = null;
                            break block24;
                        }
                        string2 = null;
                        break block24;
                    }
                    while (iterator2.hasNext()) {
                        Object e = iterator2.next();
                        TemplateChunk it = (TemplateChunk)e;
                        boolean bl3 = false;
                        TemplateChunk templateChunk = it;
                        if (templateChunk instanceof LiteralChunk) {
                            StringUtil.escapeStringCharacters((int)((LiteralChunk)it).getText().length(), (String)((LiteralChunk)it).getText(), (String)"$\"", (StringBuilder)res);
                        } else if (templateChunk instanceof EntryChunk) {
                            res.append(((EntryChunk)it).getText());
                        } else if (templateChunk instanceof NewLineChunk) {
                            res.append(lineBreak);
                        }
                        endsInLineBreak = it instanceof NewLineChunk;
                    }
                    if (endsInLineBreak) {
                        object2 = StringsKt.removeSuffix((CharSequence)res, (CharSequence)lineBreak) + "\\n";
                        return object2;
                    }
                    String string3 = res.toString();
                    Intrinsics.checkNotNull((Object)string3);
                    object2 = string3;
                    return object2;
                }
                for (int j = 0; j < $this$all$iv.length(); ++j) {
                    char element$iv;
                    char c = element$iv = $this$all$iv.charAt(j);
                    boolean bl4 = false;
                    if (c == ' ' || c == '\t') continue;
                    bl = false;
                    break block18;
                }
                bl = true;
            }
            string2 = string = bl ? object : null;
        }
        if (string2 == null) {
            string = "";
        }
        String indent = string;
        StringBuilder $this$preprocessOnPaste_u24lambda_u245 = stringBuilder = new StringBuilder();
        boolean bl = false;
        Regex tripleQuoteRe = new Regex("[\"]{3,}");
        String string4 = "";
        Iterator<TemplateChunk> iterator3 = templateTokenSequence.iterator();
        while (true) {
            void var16_26;
            if (!iterator3.hasNext()) {
                String string5 = stringBuilder.toString();
                Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"toString(...)");
                return string5;
            }
            TemplateChunk chunk = iterator3.next();
            TemplateChunk templateChunk = chunk;
            if (templateChunk instanceof LiteralChunk) {
                String escapedDollar = StringsKt.replace$default((String)((LiteralChunk)chunk).getText(), (String)"$", (String)"${'$'}", (boolean)false, (int)4, null);
                boolean bl5 = false;
                String replaced2 = tripleQuoteRe.replace((CharSequence)escapedDollar, (Function1)preprocessOnPaste.2.replaced.1.1.INSTANCE);
                $this$preprocessOnPaste_u24lambda_u245.append((String)var16_26 + replaced2);
                String string6 = "";
                continue;
            }
            if (templateChunk instanceof EntryChunk) {
                $this$preprocessOnPaste_u24lambda_u245.append((String)var16_26 + ((EntryChunk)chunk).getText());
                String string7 = "";
                continue;
            }
            if (!(templateChunk instanceof NewLineChunk)) continue;
            Intrinsics.checkNotNullExpressionValue((Object)$this$preprocessOnPaste_u24lambda_u245.append('\n'), (String)"append(...)");
            String string8 = indent;
        }
    }

    private static final String preprocessOnPaste$indent(TemplateChunk $this$preprocessOnPaste_u24indent) {
        Object object;
        block1: {
            TemplateChunk templateChunk = $this$preprocessOnPaste_u24indent;
            String $this$takeWhile$iv = templateChunk instanceof LiteralChunk ? ((LiteralChunk)$this$preprocessOnPaste_u24indent).getText() : (templateChunk instanceof EntryChunk ? ((EntryChunk)$this$preprocessOnPaste_u24indent).getText() : "");
            boolean $i$f$takeWhile = false;
            int n = $this$takeWhile$iv.length();
            for (int index$iv = 0; index$iv < n; ++index$iv) {
                char it = $this$takeWhile$iv.charAt(index$iv);
                boolean bl = false;
                if (CharsKt.isWhitespace((char)it)) continue;
                String string = $this$takeWhile$iv;
                int n2 = 0;
                String string2 = string.substring(n2, index$iv);
                object = string2;
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
                break block1;
            }
            object = templateChunk;
        }
        return object;
    }
}

