/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.decompiler.navigation;

import com.intellij.openapi.project.Project;
import com.intellij.psi.search.GlobalSearchScope;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analysis.decompiler.psi.file.KtDecompiledFile;
import org.jetbrains.kotlin.analysis.decompiler.psi.text.ByDescriptorIndexer;
import org.jetbrains.kotlin.analyzer.ModuleInfo;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.PackageFragmentDescriptor;
import org.jetbrains.kotlin.descriptors.PackageViewDescriptor;
import org.jetbrains.kotlin.descriptors.ParameterDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.TypeAliasDescriptor;
import org.jetbrains.kotlin.descriptors.impl.TypeAliasConstructorDescriptor;
import org.jetbrains.kotlin.idea.base.projectStructure.moduleInfo.BinaryModuleInfo;
import org.jetbrains.kotlin.idea.base.projectStructure.scope.KotlinSourceFilterScope;
import org.jetbrains.kotlin.idea.caches.project.IdeaModuleInfoUtils;
import org.jetbrains.kotlin.idea.stubindex.KotlinFullClassNameIndex;
import org.jetbrains.kotlin.idea.stubindex.KotlinTopLevelFunctionFqnNameIndex;
import org.jetbrains.kotlin.idea.stubindex.KotlinTopLevelPropertyFqnNameIndex;
import org.jetbrains.kotlin.idea.stubindex.KotlinTopLevelTypeAliasFqNameIndex;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.types.error.ErrorUtils;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000(\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\u001a(\u0010\u0000\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002\u001a\"\u0010\t\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0003\u001a\u00020\u00042\b\u0010\n\u001a\u0004\u0018\u00010\u0006\u001a\u001a\u0010\u000b\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u001a\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0004H\u0002\u00a8\u0006\u000f"}, d2={"findCandidateDeclarationsInIndex", "", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "referencedDescriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "scope", "Lcom/intellij/psi/search/GlobalSearchScope;", "project", "Lcom/intellij/openapi/project/Project;", "findDecompiledDeclaration", "builtInsSearchScope", "findInScope", "isLocal", "", "descriptor", "kotlin.base.fe10.analysis"})
@SourceDebugExtension(value={"SMAP\nfindDecompiledDeclaration.kt\nKotlin\n*S Kotlin\n*F\n+ 1 findDecompiledDeclaration.kt\norg/jetbrains/kotlin/idea/decompiler/navigation/FindDecompiledDeclarationKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,102:1\n1#2:103\n1#2:106\n1611#3:104\n1855#3:105\n1856#3:107\n1612#3:108\n*S KotlinDebug\n*F\n+ 1 findDecompiledDeclaration.kt\norg/jetbrains/kotlin/idea/decompiler/navigation/FindDecompiledDeclarationKt\n*L\n55#1:106\n55#1:104\n55#1:105\n55#1:107\n55#1:108\n*E\n"})
public final class FindDecompiledDeclarationKt {
    @Nullable
    public static final KtDeclaration findDecompiledDeclaration(@NotNull Project project2, @NotNull DeclarationDescriptor referencedDescriptor, @Nullable GlobalSearchScope builtInsSearchScope) {
        block8: {
            GlobalSearchScope globalSearchScope;
            block10: {
                block9: {
                    BinaryModuleInfo binaryInfo;
                    Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
                    Intrinsics.checkNotNullParameter((Object)referencedDescriptor, (String)"referencedDescriptor");
                    if (ErrorUtils.isError((DeclarationDescriptor)referencedDescriptor)) {
                        return null;
                    }
                    if (FindDecompiledDeclarationKt.isLocal(referencedDescriptor)) {
                        return null;
                    }
                    if (referencedDescriptor instanceof PackageFragmentDescriptor || referencedDescriptor instanceof PackageViewDescriptor) {
                        return null;
                    }
                    Object object = DescriptorUtilsKt.getModule((DeclarationDescriptor)referencedDescriptor).getCapability(ModuleInfo.Companion.getCapability());
                    BinaryModuleInfo binaryModuleInfo = binaryInfo = object instanceof BinaryModuleInfo ? (BinaryModuleInfo)object : null;
                    if (binaryInfo != null && (object = IdeaModuleInfoUtils.getBinariesScope(binaryInfo)) != null) {
                        Object it = object;
                        boolean bl = false;
                        return FindDecompiledDeclarationKt.findInScope(referencedDescriptor, (GlobalSearchScope)it);
                    }
                    if (!KotlinBuiltIns.isBuiltIn((DeclarationDescriptor)referencedDescriptor)) break block8;
                    globalSearchScope = builtInsSearchScope;
                    if (globalSearchScope == null) break block9;
                    GlobalSearchScope it = globalSearchScope;
                    boolean bl = false;
                    KtDeclaration ktDeclaration = FindDecompiledDeclarationKt.findInScope(referencedDescriptor, it);
                    globalSearchScope = ktDeclaration;
                    if (ktDeclaration != null) break block10;
                }
                GlobalSearchScope globalSearchScope2 = GlobalSearchScope.allScope((Project)project2);
                Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope2, (String)"allScope(...)");
                globalSearchScope = FindDecompiledDeclarationKt.findInScope(referencedDescriptor, globalSearchScope2);
                if (globalSearchScope == null) {
                    GlobalSearchScope globalSearchScope3 = GlobalSearchScope.everythingScope((Project)project2);
                    Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope3, (String)"everythingScope(...)");
                    globalSearchScope = FindDecompiledDeclarationKt.findInScope(referencedDescriptor, globalSearchScope3);
                }
            }
            return globalSearchScope;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private static final KtDeclaration findInScope(DeclarationDescriptor referencedDescriptor, GlobalSearchScope scope2) {
        void $this$mapNotNullTo$iv;
        Project project2 = scope2.getProject();
        if (project2 == null) {
            return null;
        }
        Project project3 = project2;
        DeclarationDescriptor declarationDescriptor = referencedDescriptor.getOriginal();
        Intrinsics.checkNotNullExpressionValue((Object)declarationDescriptor, (String)"getOriginal(...)");
        Iterable iterable = FindDecompiledDeclarationKt.findCandidateDeclarationsInIndex(declarationDescriptor, KotlinSourceFilterScope.Companion.libraryClasses(scope2, project3), project3);
        Collection destination$iv = new LinkedHashSet();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv = $this$mapNotNullTo$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv.iterator();
        while (iterator2.hasNext()) {
            KtDecompiledFile it$iv;
            Object element$iv$iv;
            Object element$iv = element$iv$iv = iterator2.next();
            boolean bl = false;
            KtDeclaration it = (KtDeclaration)element$iv;
            boolean bl2 = false;
            KtDeclaration ktDeclaration = it;
            Object object = ktDeclaration != null ? ktDeclaration.getContainingFile() : null;
            if ((object instanceof KtDecompiledFile ? (KtDecompiledFile)object : null) == null) continue;
            it$iv = it$iv;
            boolean bl3 = false;
            destination$iv.add(it$iv);
        }
        LinkedHashSet decompiledFiles = (LinkedHashSet)destination$iv;
        return (KtDeclaration)SequencesKt.firstOrNull((Sequence)SequencesKt.mapNotNull((Sequence)CollectionsKt.asSequence((Iterable)decompiledFiles), (Function1)((Function1)new Function1<KtDecompiledFile, KtDeclaration>(referencedDescriptor){
            final /* synthetic */ DeclarationDescriptor $referencedDescriptor;
            {
                this.$referencedDescriptor = $referencedDescriptor;
                super(1);
            }

            @Nullable
            public final KtDeclaration invoke(@NotNull KtDecompiledFile file2) {
                Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
                return ByDescriptorIndexer.INSTANCE.getDeclarationForDescriptor(this.$referencedDescriptor, file2);
            }
        })));
    }

    private static final boolean isLocal(DeclarationDescriptor descriptor2) {
        boolean bl;
        if (descriptor2 instanceof ParameterDescriptor) {
            DeclarationDescriptor declarationDescriptor = ((ParameterDescriptor)descriptor2).getContainingDeclaration();
            Intrinsics.checkNotNullExpressionValue((Object)declarationDescriptor, (String)"getContainingDeclaration(...)");
            bl = FindDecompiledDeclarationKt.isLocal(declarationDescriptor);
        } else {
            bl = DescriptorUtils.isLocal((DeclarationDescriptor)descriptor2);
        }
        return bl;
    }

    private static final Collection<KtDeclaration> findCandidateDeclarationsInIndex(DeclarationDescriptor referencedDescriptor, GlobalSearchScope scope2, Project project2) {
        Collection<Object> collection;
        DeclarationDescriptor topLevelDeclaration;
        ClassDescriptor containingClass = (ClassDescriptor)DescriptorUtils.getParentOfType((DeclarationDescriptor)referencedDescriptor, ClassDescriptor.class, (boolean)false);
        if (containingClass != null) {
            String string = DescriptorUtilsKt.getFqNameSafe((DeclarationDescriptor)((DeclarationDescriptor)containingClass)).asString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"asString(...)");
            return KotlinFullClassNameIndex.Helper.get(string, project2, scope2);
        }
        DeclarationDescriptor declarationDescriptor = DescriptorUtils.getParentOfType((DeclarationDescriptor)referencedDescriptor, PropertyDescriptor.class, (boolean)false);
        if (declarationDescriptor == null) {
            TypeAliasConstructorDescriptor typeAliasConstructorDescriptor = (TypeAliasConstructorDescriptor)DescriptorUtils.getParentOfType((DeclarationDescriptor)referencedDescriptor, TypeAliasConstructorDescriptor.class, (boolean)false);
            Object object = typeAliasConstructorDescriptor != null ? typeAliasConstructorDescriptor.getTypeAliasDescriptor() : null;
            if (object != null) {
                declarationDescriptor = (DeclarationDescriptor)object;
            } else {
                FunctionDescriptor functionDescriptor2 = (FunctionDescriptor)DescriptorUtils.getParentOfType((DeclarationDescriptor)referencedDescriptor, FunctionDescriptor.class, (boolean)false);
                if (functionDescriptor2 != null) {
                    declarationDescriptor = (DeclarationDescriptor)functionDescriptor2;
                } else {
                    TypeAliasDescriptor typeAliasDescriptor = (TypeAliasDescriptor)DescriptorUtils.getParentOfType((DeclarationDescriptor)referencedDescriptor, TypeAliasDescriptor.class, (boolean)false);
                    if (typeAliasDescriptor != null) {
                        declarationDescriptor = (DeclarationDescriptor)typeAliasDescriptor;
                    } else {
                        return CollectionsKt.emptyList();
                    }
                }
            }
        }
        if (!DescriptorUtils.isTopLevelDeclaration((DeclarationDescriptor)(topLevelDeclaration = declarationDescriptor))) {
            return CollectionsKt.emptyList();
        }
        String string = DescriptorUtilsKt.getFqNameSafe((DeclarationDescriptor)topLevelDeclaration).asString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"asString(...)");
        String fqName2 = string;
        DeclarationDescriptor declarationDescriptor2 = topLevelDeclaration;
        if (declarationDescriptor2 instanceof FunctionDescriptor) {
            collection = KotlinTopLevelFunctionFqnNameIndex.Helper.get(fqName2, project2, scope2);
        } else if (declarationDescriptor2 instanceof PropertyDescriptor) {
            collection = KotlinTopLevelPropertyFqnNameIndex.Helper.get(fqName2, project2, scope2);
        } else if (declarationDescriptor2 instanceof TypeAliasDescriptor) {
            collection = KotlinTopLevelTypeAliasFqNameIndex.Helper.get(fqName2, project2, scope2);
        } else {
            throw new IllegalStateException(("Referenced non local declaration that is not inside top level function, property, class or typealias:\n " + referencedDescriptor).toString());
        }
        return collection;
    }
}

