/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.stepping.smartStepInto;

import com.intellij.debugger.SourcePosition;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.base.psi.PsiLinesUtilsKt;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtDeclarationWithBody;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtNamedFunction;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000\u001e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0018\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0002H\u0002\u001a\u001e\u0010\u0004\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b\u00a8\u0006\t"}, d2={"findExecutableStatements", "", "Lorg/jetbrains/kotlin/psi/KtExpression;", "body", "findFirstAndLastStatementPositions", "Lkotlin/Pair;", "Lcom/intellij/debugger/SourcePosition;", "declaration", "Lorg/jetbrains/kotlin/psi/KtDeclarationWithBody;", "kotlin.jvm-debugger.core-fe10"})
@SourceDebugExtension(value={"SMAP\nKotlinLambdaMethodFilter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinLambdaMethodFilter.kt\norg/jetbrains/kotlin/idea/debugger/stepping/smartStepInto/KotlinLambdaMethodFilterKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,98:1\n766#2:99\n857#2,2:100\n*S KotlinDebug\n*F\n+ 1 KotlinLambdaMethodFilter.kt\norg/jetbrains/kotlin/idea/debugger/stepping/smartStepInto/KotlinLambdaMethodFilterKt\n*L\n96#1:99\n96#1:100,2\n*E\n"})
public final class KotlinLambdaMethodFilterKt {
    @NotNull
    public static final Pair<SourcePosition, SourcePosition> findFirstAndLastStatementPositions(@NotNull KtDeclarationWithBody declaration2) {
        Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
        KtExpression body2 = declaration2.getBodyExpression();
        if (body2 != null && PsiLinesUtilsKt.isMultiLine((PsiElement)declaration2)) {
            PsiElement[] psiElementArray = body2.getChildren();
            Intrinsics.checkNotNullExpressionValue((Object)psiElementArray, (String)"getChildren(...)");
            if (!(((Object[])psiElementArray).length == 0)) {
                SourcePosition firstStatementPosition = null;
                SourcePosition lastStatementPosition = null;
                List<KtExpression> statements2 = KotlinLambdaMethodFilterKt.findExecutableStatements(body2);
                if (!((Collection)statements2).isEmpty() && (firstStatementPosition = SourcePosition.createFromElement((PsiElement)((PsiElement)CollectionsKt.first(statements2)))) != null) {
                    KtExpression lastStatement = (KtExpression)CollectionsKt.last(statements2);
                    lastStatementPosition = SourcePosition.createFromOffset((PsiFile)firstStatementPosition.getFile(), (int)lastStatement.getTextRange().getEndOffset());
                }
                return new Pair((Object)firstStatementPosition, lastStatementPosition);
            }
        }
        SourcePosition position = SourcePosition.createFromElement((PsiElement)((PsiElement)declaration2));
        return new Pair((Object)position, (Object)position);
    }

    /*
     * WARNING - void declaration
     */
    private static final List<KtExpression> findExecutableStatements(KtExpression body2) {
        void $this$filterTo$iv$iv;
        KtBlockExpression ktBlockExpression = body2 instanceof KtBlockExpression ? (KtBlockExpression)body2 : null;
        List list2 = ktBlockExpression != null ? ktBlockExpression.getStatements() : null;
        if (list2 == null) {
            list2 = CollectionsKt.listOf((Object)body2);
        }
        List statements2 = list2;
        Iterable $this$filter$iv = statements2;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            KtExpression it = (KtExpression)element$iv$iv;
            boolean bl = false;
            if (!(!(it instanceof KtNamedFunction))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }
}

