/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.evaluate.compilation;

import com.intellij.debugger.engine.DebugProcess;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.impl.DebuggerUtilsImpl;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.impl.XDebugSessionImpl;
import com.intellij.xdebugger.impl.frame.XValueMarkers;
import com.intellij.xdebugger.impl.ui.tree.ValueMarkup;
import com.sun.jdi.ArrayType;
import com.sun.jdi.BooleanType;
import com.sun.jdi.ByteType;
import com.sun.jdi.CharType;
import com.sun.jdi.ClassType;
import com.sun.jdi.DoubleType;
import com.sun.jdi.FloatType;
import com.sun.jdi.IntegerType;
import com.sun.jdi.InterfaceType;
import com.sun.jdi.LongType;
import com.sun.jdi.Mirror;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.ShortType;
import com.sun.jdi.Value;
import com.sun.jdi.VoidType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.SimpleMemberScope;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.builtins.PrimitiveType;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.DescriptorVisibilities;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.descriptors.PackageFragmentDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.SourceElement;
import org.jetbrains.kotlin.descriptors.annotations.Annotations;
import org.jetbrains.kotlin.descriptors.impl.PackageFragmentDescriptorImpl;
import org.jetbrains.kotlin.descriptors.impl.PropertyGetterDescriptorImpl;
import org.jetbrains.kotlin.idea.core.util.CodeFragmentUtilsKt;
import org.jetbrains.kotlin.idea.debugger.evaluate.EvaluatorResolutionUtilsKt;
import org.jetbrains.kotlin.idea.debugger.evaluate.compilation.DebugLabelModuleDescriptor;
import org.jetbrains.kotlin.idea.debugger.evaluate.compilation.DebugLabelPropertyDescriptor;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtCodeFragment;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.SimpleType;
import org.jetbrains.kotlin.types.Variance;
import org.jetbrains.org.objectweb.asm.Type;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u0000 \u001c2\u00020\u0001:\u0001\u001cB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0010\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J \u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0016\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00130\u00192\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0006\u0010\u001a\u001a\u00020\u001bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/evaluate/compilation/DebugLabelPropertyDescriptorProvider;", "", "codeFragment", "Lorg/jetbrains/kotlin/psi/KtCodeFragment;", "debugProcess", "Lcom/intellij/debugger/engine/DebugProcessImpl;", "(Lorg/jetbrains/kotlin/psi/KtCodeFragment;Lcom/intellij/debugger/engine/DebugProcessImpl;)V", "getCodeFragment", "()Lorg/jetbrains/kotlin/psi/KtCodeFragment;", "getDebugProcess", "()Lcom/intellij/debugger/engine/DebugProcessImpl;", "moduleDescriptor", "Lorg/jetbrains/kotlin/idea/debugger/evaluate/compilation/DebugLabelModuleDescriptor;", "convertReferenceType", "Lorg/jetbrains/kotlin/types/KotlinType;", "type", "Lcom/sun/jdi/Type;", "convertType", "createDebugLabelDescriptor", "Lorg/jetbrains/kotlin/descriptors/PropertyDescriptor;", "labelName", "", "containingDeclaration", "Lorg/jetbrains/kotlin/descriptors/PackageFragmentDescriptor;", "createDebugLabelDescriptors", "", "supplyDebugLabels", "", "Companion", "kotlin.jvm-debugger.evaluation"})
@SourceDebugExtension(value={"SMAP\nDebugLabelPropertyDescriptorProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DebugLabelPropertyDescriptorProvider.kt\norg/jetbrains/kotlin/idea/debugger/evaluate/compilation/DebugLabelPropertyDescriptorProvider\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,220:1\n1#2:221\n*E\n"})
public final class DebugLabelPropertyDescriptorProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final KtCodeFragment codeFragment;
    @NotNull
    private final DebugProcessImpl debugProcess;
    @NotNull
    private final DebugLabelModuleDescriptor moduleDescriptor;

    public DebugLabelPropertyDescriptorProvider(@NotNull KtCodeFragment codeFragment, @NotNull DebugProcessImpl debugProcess) {
        Intrinsics.checkNotNullParameter((Object)codeFragment, (String)"codeFragment");
        Intrinsics.checkNotNullParameter((Object)debugProcess, (String)"debugProcess");
        this.codeFragment = codeFragment;
        this.debugProcess = debugProcess;
        this.moduleDescriptor = DebugLabelModuleDescriptor.INSTANCE;
    }

    @NotNull
    public final KtCodeFragment getCodeFragment() {
        return this.codeFragment;
    }

    @NotNull
    public final DebugProcessImpl getDebugProcess() {
        return this.debugProcess;
    }

    public final void supplyDebugLabels() {
        DebugLabelModuleDescriptor debugLabelModuleDescriptor = this.moduleDescriptor;
        FqName fqName2 = FqName.ROOT;
        var packageFragment2 = new PackageFragmentDescriptorImpl(this, debugLabelModuleDescriptor, fqName2){
            @NotNull
            private final List<PropertyDescriptor> properties;
            {
                ModuleDescriptor moduleDescriptor = $super_call_param$1;
                Intrinsics.checkNotNull((Object)$super_call_param$2);
                super(moduleDescriptor, $super_call_param$2);
                this.properties = DebugLabelPropertyDescriptorProvider.access$createDebugLabelDescriptors($receiver, (PackageFragmentDescriptor)this);
            }

            @NotNull
            public final List<PropertyDescriptor> getProperties() {
                return this.properties;
            }

            @NotNull
            public SimpleMemberScope getMemberScope() {
                return new SimpleMemberScope(this.properties);
            }
        };
        CodeFragmentUtilsKt.setExternalDescriptors(this.codeFragment, packageFragment2.getProperties());
    }

    private final List<PropertyDescriptor> createDebugLabelDescriptors(PackageFragmentDescriptor containingDeclaration2) {
        Map<? extends Value, ValueMarkup> markupMap = Companion.getMarkupMap(this.debugProcess);
        ArrayList result2 = new ArrayList(markupMap.size());
        for (Map.Entry<? extends Value, ValueMarkup> entry : markupMap.entrySet()) {
            String labelName2;
            Mirror mirror;
            block4: {
                block3: {
                    Value value2 = entry.getKey();
                    ValueMarkup markup = entry.getValue();
                    Intrinsics.checkNotNullExpressionValue((Object)markup.getText(), (String)"getText(...)");
                    mirror = value2;
                    if (mirror == null || (mirror = mirror.type()) == null) break block3;
                    Mirror it = mirror;
                    boolean bl = false;
                    KotlinType kotlinType = this.convertType((com.sun.jdi.Type)it);
                    mirror = kotlinType;
                    if (kotlinType != null) break block4;
                }
                SimpleType simpleType = this.moduleDescriptor.getBuiltIns().getNullableAnyType();
                Intrinsics.checkNotNullExpressionValue((Object)simpleType, (String)"getNullableAnyType(...)");
                mirror = (KotlinType)simpleType;
            }
            Mirror kotlinType = mirror;
            ((Collection)result2).add(this.createDebugLabelDescriptor(labelName2, (KotlinType)kotlinType, containingDeclaration2));
        }
        return result2;
    }

    private final PropertyDescriptor createDebugLabelDescriptor(String labelName2, KotlinType type2, PackageFragmentDescriptor containingDeclaration2) {
        PropertyGetterDescriptorImpl propertyGetterDescriptorImpl;
        DebugLabelPropertyDescriptor propertyDescriptor = new DebugLabelPropertyDescriptor((DeclarationDescriptor)containingDeclaration2, labelName2);
        propertyDescriptor.setType(type2, CollectionsKt.emptyList(), null, null, CollectionsKt.emptyList());
        PropertyGetterDescriptorImpl $this$createDebugLabelDescriptor_u24lambda_u241 = propertyGetterDescriptorImpl = new PropertyGetterDescriptorImpl((PropertyDescriptor)propertyDescriptor, Annotations.Companion.getEMPTY(), Modality.FINAL, DescriptorVisibilities.PUBLIC, false, false, false, CallableMemberDescriptor.Kind.SYNTHESIZED, null, SourceElement.NO_SOURCE);
        boolean bl = false;
        $this$createDebugLabelDescriptor_u24lambda_u241.initialize(type2);
        PropertyGetterDescriptorImpl getterDescriptor = propertyGetterDescriptorImpl;
        propertyDescriptor.initialize(getterDescriptor, null);
        return (PropertyDescriptor)propertyDescriptor;
    }

    private final KotlinType convertType(com.sun.jdi.Type type2) {
        KotlinType kotlinType;
        KotlinBuiltIns builtIns = this.moduleDescriptor.getBuiltIns();
        com.sun.jdi.Type type3 = type2;
        if (type3 instanceof VoidType) {
            SimpleType simpleType = builtIns.getUnitType();
            Intrinsics.checkNotNullExpressionValue((Object)simpleType, (String)"getUnitType(...)");
            kotlinType = (KotlinType)simpleType;
        } else if (type3 instanceof LongType) {
            SimpleType simpleType = builtIns.getLongType();
            Intrinsics.checkNotNullExpressionValue((Object)simpleType, (String)"getLongType(...)");
            kotlinType = (KotlinType)simpleType;
        } else if (type3 instanceof DoubleType) {
            SimpleType simpleType = builtIns.getDoubleType();
            Intrinsics.checkNotNullExpressionValue((Object)simpleType, (String)"getDoubleType(...)");
            kotlinType = (KotlinType)simpleType;
        } else if (type3 instanceof CharType) {
            SimpleType simpleType = builtIns.getCharType();
            Intrinsics.checkNotNullExpressionValue((Object)simpleType, (String)"getCharType(...)");
            kotlinType = (KotlinType)simpleType;
        } else if (type3 instanceof FloatType) {
            SimpleType simpleType = builtIns.getFloatType();
            Intrinsics.checkNotNullExpressionValue((Object)simpleType, (String)"getFloatType(...)");
            kotlinType = (KotlinType)simpleType;
        } else if (type3 instanceof ByteType) {
            SimpleType simpleType = builtIns.getByteType();
            Intrinsics.checkNotNullExpressionValue((Object)simpleType, (String)"getByteType(...)");
            kotlinType = (KotlinType)simpleType;
        } else if (type3 instanceof IntegerType) {
            SimpleType simpleType = builtIns.getIntType();
            Intrinsics.checkNotNullExpressionValue((Object)simpleType, (String)"getIntType(...)");
            kotlinType = (KotlinType)simpleType;
        } else if (type3 instanceof BooleanType) {
            SimpleType simpleType = builtIns.getBooleanType();
            Intrinsics.checkNotNullExpressionValue((Object)simpleType, (String)"getBooleanType(...)");
            kotlinType = (KotlinType)simpleType;
        } else if (type3 instanceof ShortType) {
            SimpleType simpleType = builtIns.getShortType();
            Intrinsics.checkNotNullExpressionValue((Object)simpleType, (String)"getShortType(...)");
            kotlinType = (KotlinType)simpleType;
        } else if (type3 instanceof ArrayType) {
            SimpleType simpleType;
            com.sun.jdi.Type componentType = ((ArrayType)type2).componentType();
            if (componentType instanceof VoidType) {
                simpleType = builtIns.getArrayType(Variance.INVARIANT, (KotlinType)builtIns.getUnitType());
            } else if (componentType instanceof LongType) {
                simpleType = builtIns.getPrimitiveArrayKotlinType(PrimitiveType.LONG);
            } else if (componentType instanceof DoubleType) {
                simpleType = builtIns.getPrimitiveArrayKotlinType(PrimitiveType.DOUBLE);
            } else if (componentType instanceof CharType) {
                simpleType = builtIns.getPrimitiveArrayKotlinType(PrimitiveType.CHAR);
            } else if (componentType instanceof FloatType) {
                simpleType = builtIns.getPrimitiveArrayKotlinType(PrimitiveType.FLOAT);
            } else if (componentType instanceof ByteType) {
                simpleType = builtIns.getPrimitiveArrayKotlinType(PrimitiveType.BYTE);
            } else if (componentType instanceof IntegerType) {
                simpleType = builtIns.getPrimitiveArrayKotlinType(PrimitiveType.INT);
            } else if (componentType instanceof BooleanType) {
                simpleType = builtIns.getPrimitiveArrayKotlinType(PrimitiveType.BOOLEAN);
            } else if (componentType instanceof ShortType) {
                simpleType = builtIns.getPrimitiveArrayKotlinType(PrimitiveType.SHORT);
            } else {
                Intrinsics.checkNotNull((Object)componentType);
                simpleType = builtIns.getArrayType(Variance.INVARIANT, this.convertReferenceType(componentType));
            }
            SimpleType simpleType2 = simpleType;
            Intrinsics.checkNotNull((Object)simpleType2);
            kotlinType = (KotlinType)simpleType2;
        } else if (type3 instanceof ReferenceType) {
            kotlinType = this.convertReferenceType(type2);
        } else {
            SimpleType simpleType = builtIns.getAnyType();
            Intrinsics.checkNotNullExpressionValue((Object)simpleType, (String)"getAnyType(...)");
            kotlinType = (KotlinType)simpleType;
        }
        return kotlinType;
    }

    private final KotlinType convertReferenceType(com.sun.jdi.Type type2) {
        if (!(type2 instanceof ClassType || type2 instanceof InterfaceType)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        Type asmType = Type.getType((String)type2.signature());
        Project project2 = this.codeFragment.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
        Project project3 = project2;
        Intrinsics.checkNotNull((Object)asmType);
        GlobalSearchScope globalSearchScope = GlobalSearchScope.allScope((Project)project3);
        Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope, (String)"allScope(...)");
        ClassDescriptor classDescriptor = EvaluatorResolutionUtilsKt.getClassDescriptor$default(asmType, globalSearchScope, false, null, 4, null);
        if (classDescriptor == null) {
            SimpleType simpleType = this.moduleDescriptor.getBuiltIns().getNullableAnyType();
            Intrinsics.checkNotNullExpressionValue((Object)simpleType, (String)"getNullableAnyType(...)");
            return (KotlinType)simpleType;
        }
        ClassDescriptor classDescriptor2 = classDescriptor;
        SimpleType simpleType = classDescriptor2.getDefaultType();
        Intrinsics.checkNotNullExpressionValue((Object)simpleType, (String)"getDefaultType(...)");
        return (KotlinType)simpleType;
    }

    public static final /* synthetic */ List access$createDebugLabelDescriptors(DebugLabelPropertyDescriptorProvider $this, PackageFragmentDescriptor containingDeclaration2) {
        return $this.createDebugLabelDescriptors(containingDeclaration2);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\"\u0010\u0003\u001a\u0014\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u0005\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u00042\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u001e\u0010\t\u001a\u0012\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u0005\u0012\u0004\u0012\u00020\u00060\u00042\u0006\u0010\u0007\u001a\u00020\b\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/evaluate/compilation/DebugLabelPropertyDescriptorProvider$Companion;", "", "()V", "doGetMarkupMap", "", "Lcom/sun/jdi/Value;", "Lcom/intellij/xdebugger/impl/ui/tree/ValueMarkup;", "debugProcess", "Lcom/intellij/debugger/engine/DebugProcessImpl;", "getMarkupMap", "kotlin.jvm-debugger.evaluation"})
    @SourceDebugExtension(value={"SMAP\nDebugLabelPropertyDescriptorProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DebugLabelPropertyDescriptorProvider.kt\norg/jetbrains/kotlin/idea/debugger/evaluate/compilation/DebugLabelPropertyDescriptorProvider$Companion\n+ 2 ApplicationUtils.kt\norg/jetbrains/kotlin/idea/util/application/ApplicationUtilsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,220:1\n73#2:221\n478#3,7:222\n*S KotlinDebug\n*F\n+ 1 DebugLabelPropertyDescriptorProvider.kt\norg/jetbrains/kotlin/idea/debugger/evaluate/compilation/DebugLabelPropertyDescriptorProvider$Companion\n*L\n40#1:221\n47#1:222,7\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Map<? extends Value, ValueMarkup> getMarkupMap(@NotNull DebugProcessImpl debugProcess) {
            Intrinsics.checkNotNullParameter((Object)debugProcess, (String)"debugProcess");
            Map map2 = this.doGetMarkupMap(debugProcess);
            if (map2 == null) {
                map2 = MapsKt.emptyMap();
            }
            return map2;
        }

        private final Map<? extends Value, ValueMarkup> doGetMarkupMap(DebugProcessImpl debugProcess) {
            Map map2;
            boolean $i$f$isUnitTestMode = false;
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                XValueMarkers xValueMarkers = DebuggerUtilsImpl.getValueMarkers((DebugProcess)((DebugProcess)debugProcess));
                return xValueMarkers != null ? xValueMarkers.getAllMarkers() : null;
            }
            XDebugSession xDebugSession = debugProcess.getSession().getXDebugSession();
            XDebugSessionImpl debugSession = xDebugSession instanceof XDebugSessionImpl ? (XDebugSessionImpl)xDebugSession : null;
            Object object = debugSession;
            if (object != null && (object = object.getValueMarkers()) != null && (object = object.getAllMarkers()) != null) {
                Object $this$filterKeys$iv = object;
                boolean $i$f$filterKeys = false;
                LinkedHashMap result$iv = new LinkedHashMap();
                for (Map.Entry entry$iv : $this$filterKeys$iv.entrySet()) {
                    Object it = entry$iv.getKey();
                    boolean bl = false;
                    Object k = it;
                    if (!(k == null ? true : k instanceof Value)) continue;
                    result$iv.put(entry$iv.getKey(), entry$iv.getValue());
                }
                map2 = result$iv;
            } else {
                map2 = null;
            }
            return map2;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

