/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.core.breakpoints;

import com.intellij.debugger.ui.breakpoints.JavaMethodBreakpointType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.xdebugger.breakpoints.XBreakpoint;
import com.intellij.xdebugger.breakpoints.XLineBreakpoint;
import com.intellij.xdebugger.breakpoints.XLineBreakpointType;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.java.debugger.breakpoints.properties.JavaMethodBreakpointProperties;
import org.jetbrains.kotlin.idea.base.facet.platform.TargetPlatformDetectorUtils;
import org.jetbrains.kotlin.idea.base.psi.KotlinPsiHeuristics;
import org.jetbrains.kotlin.idea.debugger.breakpoints.KotlinBreakpointType;
import org.jetbrains.kotlin.idea.debugger.core.KotlinDebuggerCoreBundle;
import org.jetbrains.kotlin.idea.debugger.core.breakpoints.ApplicabilityResult;
import org.jetbrains.kotlin.idea.debugger.core.breakpoints.BreakpointTypeUtilsKt;
import org.jetbrains.kotlin.idea.debugger.core.breakpoints.KotlinFunctionBreakpoint;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.platform.TargetPlatform;
import org.jetbrains.kotlin.platform.TargetPlatformKt;
import org.jetbrains.kotlin.platform.jvm.JvmPlatformKt;
import org.jetbrains.kotlin.psi.KtAnnotated;
import org.jetbrains.kotlin.psi.KtCallableDeclaration;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtConstructor;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtEnumEntry;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtPropertyAccessor;
import org.jetbrains.kotlin.psi.KtPsiUtil;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\b\u0016\u00a2\u0006\u0002\u0010\u0003B\u001b\b\u0004\u0012\b\b\u0001\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0001\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007J \u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u001e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0010\u001a\u00020\u00112\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015H\u0016J\u0016\u0010\u0017\u001a\u00020\u00052\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0018H\u0016J\"\u0010\u0017\u001a\u00020\u00052\u0018\u0010\u0019\u001a\u00140\u001aR\u0010\u0012\f\u0012\n \u001c*\u0004\u0018\u00010\u00160\u00160\u001bH\u0014J\b\u0010\u001d\u001a\u00020\u000fH\u0016J \u0010\u001e\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0018\u0010\u001f\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\f\u0010 \u001a\u00020\u000b*\u00020!H\u0004R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lorg/jetbrains/kotlin/idea/debugger/core/breakpoints/KotlinFunctionBreakpointType;", "Lcom/intellij/debugger/ui/breakpoints/JavaMethodBreakpointType;", "Lorg/jetbrains/kotlin/idea/debugger/breakpoints/KotlinBreakpointType;", "()V", "id", "", "message", "(Ljava/lang/String;Ljava/lang/String;)V", "COMPOSABLE_FQ_NAME", "Lorg/jetbrains/kotlin/name/FqName;", "canPutAt", "", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "line", "", "project", "Lcom/intellij/openapi/project/Project;", "createJavaBreakpoint", "Lorg/jetbrains/kotlin/idea/debugger/core/breakpoints/KotlinFunctionBreakpoint;", "breakpoint", "Lcom/intellij/xdebugger/breakpoints/XBreakpoint;", "Lorg/jetbrains/java/debugger/breakpoints/properties/JavaMethodBreakpointProperties;", "getGeneralDescription", "Lcom/intellij/xdebugger/breakpoints/XLineBreakpoint;", "variant", "Lcom/intellij/xdebugger/breakpoints/XLineBreakpointType$XLineBreakpointVariant;", "Lcom/intellij/xdebugger/breakpoints/XLineBreakpointType;", "kotlin.jvm.PlatformType", "getPriority", "isFunctionBreakpointApplicable", "isKtFileWithCommonOrJvmPlatform", "isComposable", "Lorg/jetbrains/kotlin/psi/KtFunction;", "kotlin.jvm-debugger.core"})
public class KotlinFunctionBreakpointType
extends JavaMethodBreakpointType
implements KotlinBreakpointType {
    @NotNull
    private final FqName COMPOSABLE_FQ_NAME;

    protected KotlinFunctionBreakpointType(@NotNull String id, @Nls @NotNull String message2) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
        super(id, message2);
        this.COMPOSABLE_FQ_NAME = new FqName("androidx.compose.runtime.Composable");
    }

    public KotlinFunctionBreakpointType() {
        this("kotlin-function", KotlinDebuggerCoreBundle.message("function.breakpoint.tab.title", new Object[0]));
    }

    @NotNull
    protected String getGeneralDescription(@NotNull XLineBreakpointType.XLineBreakpointVariant variant) {
        Intrinsics.checkNotNullParameter((Object)variant, (String)"variant");
        return KotlinDebuggerCoreBundle.message("function.breakpoint.description", new Object[0]);
    }

    @NotNull
    public String getGeneralDescription(@NotNull XLineBreakpoint<JavaMethodBreakpointProperties> breakpoint2) {
        Intrinsics.checkNotNullParameter(breakpoint2, (String)"breakpoint");
        return KotlinDebuggerCoreBundle.message("function.breakpoint.description", new Object[0]);
    }

    public int getPriority() {
        return 120;
    }

    @NotNull
    public KotlinFunctionBreakpoint createJavaBreakpoint(@NotNull Project project2, @NotNull XBreakpoint<JavaMethodBreakpointProperties> breakpoint2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter(breakpoint2, (String)"breakpoint");
        return new KotlinFunctionBreakpoint(project2, breakpoint2);
    }

    public boolean canPutAt(@NotNull VirtualFile file2, int line, @NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        return this.isKtFileWithCommonOrJvmPlatform(file2, project2) && this.isFunctionBreakpointApplicable(file2, line, project2);
    }

    private final boolean isKtFileWithCommonOrJvmPlatform(VirtualFile file2, Project project2) {
        PsiFile psiFile2 = PsiManager.getInstance((Project)project2).findFile(file2);
        KtFile ktFile2 = psiFile2 instanceof KtFile ? (KtFile)psiFile2 : null;
        if (ktFile2 == null) {
            return false;
        }
        KtFile psiFile3 = ktFile2;
        TargetPlatform platform2 = TargetPlatformDetectorUtils.getPlatform((KtElement)psiFile3);
        return TargetPlatformKt.isCommon((TargetPlatform)platform2) || JvmPlatformKt.isJvm((TargetPlatform)platform2);
    }

    public boolean isFunctionBreakpointApplicable(@NotNull VirtualFile file2, int line, @NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        return BreakpointTypeUtilsKt.isBreakpointApplicable(file2, line, project2, (Function1<? super PsiElement, ApplicabilityResult>)((Function1)new Function1<PsiElement, ApplicabilityResult>(this){
            final /* synthetic */ KotlinFunctionBreakpointType this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final ApplicabilityResult invoke(@NotNull PsiElement element3) {
                Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
                PsiElement psiElement2 = element3;
                return psiElement2 instanceof KtConstructor ? ApplicabilityResult.DEFINITELY_YES : (psiElement2 instanceof KtFunction ? ApplicabilityResult.Companion.maybe(!KtPsiUtil.isLocal((KtDeclaration)((KtDeclaration)element3)) && !BreakpointTypeUtilsKt.isInlineOnly((KtCallableDeclaration)element3) && !this.this$0.isComposable((KtFunction)element3)) : (psiElement2 instanceof KtPropertyAccessor ? ApplicabilityResult.Companion.maybe(((KtPropertyAccessor)element3).hasBody() && !KtPsiUtil.isLocal((KtDeclaration)((KtDeclaration)((KtPropertyAccessor)element3).getProperty()))) : (psiElement2 instanceof KtClass ? ApplicabilityResult.Companion.maybe(!(element3 instanceof KtEnumEntry) && !((KtClass)element3).isAnnotation() && !((KtClass)element3).isInterface() && ((KtClass)element3).hasPrimaryConstructor()) : ApplicabilityResult.UNKNOWN)));
            }
        }));
    }

    protected final boolean isComposable(@NotNull KtFunction $this$isComposable) {
        Intrinsics.checkNotNullParameter((Object)$this$isComposable, (String)"<this>");
        return KotlinPsiHeuristics.hasAnnotation$default((KtAnnotated)$this$isComposable, this.COMPOSABLE_FQ_NAME, null, 4, null);
    }
}

