/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.core;

import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.engine.SourcePositionHighlighter;
import com.intellij.debugger.ui.breakpoints.JavaLineBreakpointType;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.base.psi.PsiLinesUtilsKt;
import org.jetbrains.kotlin.idea.debugger.KotlinReentrantSourcePosition;
import org.jetbrains.kotlin.idea.debugger.KotlinSourcePositionWithEntireLineHighlighted;
import org.jetbrains.kotlin.idea.debugger.base.util.JvmDebuggerBasePsiUtils;
import org.jetbrains.kotlin.idea.debugger.core.stepping.KotlinSteppingCommandProviderKt;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtFunctionLiteral;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\u0003\u001a\u0004\u0018\u00010\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/core/KotlinSourcePositionHighlighter;", "Lcom/intellij/debugger/engine/SourcePositionHighlighter;", "()V", "getHighlightRange", "Lcom/intellij/openapi/util/TextRange;", "sourcePosition", "Lcom/intellij/debugger/SourcePosition;", "kotlin.jvm-debugger.core"})
@SourceDebugExtension(value={"SMAP\nKotlinSourcePositionHighlighter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinSourcePositionHighlighter.kt\norg/jetbrains/kotlin/idea/debugger/core/KotlinSourcePositionHighlighter\n+ 2 psiTreeUtil.kt\ncom/intellij/psi/util/PsiTreeUtilKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,62:1\n66#2,2:63\n1#3:65\n*S KotlinDebug\n*F\n+ 1 KotlinSourcePositionHighlighter.kt\norg/jetbrains/kotlin/idea/debugger/core/KotlinSourcePositionHighlighter\n*L\n35#1:63,2\n*E\n"})
public final class KotlinSourcePositionHighlighter
extends SourcePositionHighlighter {
    @Nullable
    public TextRange getHighlightRange(@Nullable SourcePosition sourcePosition2) {
        Object object;
        block12: {
            block11: {
                if (sourcePosition2 == null || sourcePosition2 instanceof KotlinSourcePositionWithEntireLineHighlighted || sourcePosition2 instanceof KotlinReentrantSourcePosition) {
                    return null;
                }
                PsiElement psiElement2 = sourcePosition2.getElementAt();
                if (psiElement2 == null) {
                    return null;
                }
                PsiElement element3 = psiElement2;
                if (JavaLineBreakpointType.isReturnKeyword((PsiElement)element3) && element3 == JavaLineBreakpointType.findSingleConditionalReturn((SourcePosition)sourcePosition2)) {
                    return element3.getTextRange();
                }
                PsiElement $this$parentOfType_u24default$iv = element3;
                boolean withSelf$iv = false;
                boolean $i$f$parentOfType = false;
                object = (KtFunction)PsiTreeUtil.getParentOfType((PsiElement)$this$parentOfType_u24default$iv, KtFunction.class, (boolean)true);
                if (object == null) break block11;
                KtFunction it = withSelf$iv = object;
                boolean bl = false;
                object = it instanceof KtFunctionLiteral || it.getName() == null ? withSelf$iv : null;
                if (object != null) break block12;
            }
            return null;
        }
        KtFunction lambda2 = object;
        TextRange lambdaRange = JavaLineBreakpointType.getTextRangeWithoutTrailingComments((PsiElement)((PsiElement)lambda2));
        if (PsiLinesUtilsKt.isOneLiner((PsiElement)lambda2)) {
            return lambdaRange;
        }
        IntRange intRange = KotlinSteppingCommandProviderKt.getLineRange((PsiElement)lambda2);
        if (intRange == null) {
            return null;
        }
        IntRange lambdaLineRange = intRange;
        PsiFile psiFile2 = sourcePosition2.getFile();
        Intrinsics.checkNotNullExpressionValue((Object)psiFile2, (String)"getFile(...)");
        TextRange textRange = JvmDebuggerBasePsiUtils.getRangeOfLine(psiFile2, sourcePosition2.getLine(), false);
        if (textRange == null) {
            return null;
        }
        TextRange lineRange = textRange;
        TextRange intersection = lineRange.intersection(lambdaRange);
        if (sourcePosition2.getLine() == lambdaLineRange.getFirst()) {
            TextRange textRange2 = intersection;
            return textRange2 != null ? textRange2.grown(1) : null;
        }
        if (sourcePosition2.getLine() == lambdaLineRange.getLast() && !Intrinsics.areEqual((Object)intersection, (Object)lineRange) && intersection.getLength() > 1) {
            return intersection;
        }
        return null;
    }
}

