/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.core;

import com.intellij.debugger.jdi.MethodBytecodeUtil;
import com.sun.jdi.Location;
import com.sun.jdi.Method;
import kotlin.Metadata;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.debugger.core.DebuggerUtil;
import org.jetbrains.org.objectweb.asm.Label;
import org.jetbrains.org.objectweb.asm.Type;
import org.jetbrains.org.objectweb.asm.tree.MethodNode;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u000e\n\u0002\u0010\u0000\n\u0002\b\b\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002:\u000278B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u001c\u0010\u0019\u001a\u00020\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001cH\u0002J\u001c\u0010\u001e\u001a\u00020\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\b\u0010\u001f\u001a\u0004\u0018\u00010\u001cH\u0002J\b\u0010 \u001a\u00020\u001aH\u0002J\u0010\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\tH\u0016J.\u0010$\u001a\u00020\"2\u0006\u0010%\u001a\u00020\t2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001c2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\b\u0010\u001f\u001a\u0004\u0018\u00010\u001cH\u0016J\u0018\u0010&\u001a\u00020\"2\u0006\u0010'\u001a\u00020\t2\u0006\u0010(\u001a\u00020\tH\u0016J\u0010\u0010)\u001a\u00020\"2\u0006\u0010%\u001a\u00020\tH\u0016J\u0018\u0010*\u001a\u00020\"2\u0006\u0010%\u001a\u00020\t2\u0006\u0010+\u001a\u00020\tH\u0016J\u001a\u0010,\u001a\u00020\"2\u0006\u0010%\u001a\u00020\t2\b\u0010-\u001a\u0004\u0018\u00010\u0015H\u0016J\u0012\u0010.\u001a\u00020\"2\b\u0010-\u001a\u0004\u0018\u00010\u0015H\u0016J\u0012\u0010/\u001a\u00020\"2\b\u00100\u001a\u0004\u0018\u000101H\u0016J6\u00102\u001a\u00020\"2\u0006\u00103\u001a\u00020\t2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001c2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\b\u0010\u001f\u001a\u0004\u0018\u00010\u001c2\u0006\u00104\u001a\u00020\u001aH\u0016J\u0018\u00105\u001a\u00020\"2\u0006\u0010%\u001a\u00020\t2\u0006\u00106\u001a\u00020\tH\u0016R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\r\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0016\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u000f\"\u0004\b\u0018\u0010\u0011R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00069"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/core/CoroutineStateMachineVisitor;", "Lorg/jetbrains/org/objectweb/asm/tree/MethodNode;", "Lcom/intellij/debugger/jdi/MethodBytecodeUtil$InstructionOffsetReader;", "method", "Lcom/sun/jdi/Method;", "resumeLocation", "Lcom/sun/jdi/Location;", "(Lcom/sun/jdi/Method;Lcom/sun/jdi/Location;)V", "coroutineSuspendedLocalVarIndex", "", "coroutineSuspendedState", "Lorg/jetbrains/kotlin/idea/debugger/core/CoroutineStateMachineVisitor$CoroutineSuspendedState;", "currentByteCodeOffSet", "firstReturnAfterSuspensionOffset", "getFirstReturnAfterSuspensionOffset", "()I", "setFirstReturnAfterSuspensionOffset", "(I)V", "myState", "Lorg/jetbrains/kotlin/idea/debugger/core/CoroutineStateMachineVisitor$CurrentInsn;", "nextCallLabel", "Lorg/jetbrains/org/objectweb/asm/Label;", "nextCallOffset", "getNextCallOffset", "setNextCallOffset", "isGetCoroutineSuspended", "", "name", "", "owner", "isSuspendFunction", "descriptor", "reachedResumedLocation", "readBytecodeInstructionOffset", "", "offset", "visitFieldInsn", "opcode", "visitIincInsn", "varIndex", "increment", "visitInsn", "visitIntInsn", "operand", "visitJumpInsn", "label", "visitLabel", "visitLdcInsn", "value", "", "visitMethodInsn", "opcodeAndSource", "isInterface", "visitVarInsn", "var", "CoroutineSuspendedState", "CurrentInsn", "kotlin.jvm-debugger.core"})
@SourceDebugExtension(value={"SMAP\ndebuggerUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 debuggerUtil.kt\norg/jetbrains/kotlin/idea/debugger/core/CoroutineStateMachineVisitor\n+ 2 ArrayIntrinsics.kt\nkotlin/ArrayIntrinsicsKt\n*L\n1#1,565:1\n26#2:566\n*S KotlinDebug\n*F\n+ 1 debuggerUtil.kt\norg/jetbrains/kotlin/idea/debugger/core/CoroutineStateMachineVisitor\n*L\n275#1:566\n*E\n"})
final class CoroutineStateMachineVisitor
extends MethodNode
implements MethodBytecodeUtil.InstructionOffsetReader {
    @NotNull
    private final Location resumeLocation;
    @NotNull
    private CurrentInsn myState;
    @NotNull
    private CoroutineSuspendedState coroutineSuspendedState;
    private int coroutineSuspendedLocalVarIndex;
    private int currentByteCodeOffSet;
    @Nullable
    private Label nextCallLabel;
    private int firstReturnAfterSuspensionOffset;
    private int nextCallOffset;

    public CoroutineStateMachineVisitor(@NotNull Method method, @NotNull Location resumeLocation) {
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        Intrinsics.checkNotNullParameter((Object)resumeLocation, (String)"resumeLocation");
        boolean $i$f$emptyArray = false;
        super(589824, 1, method.name(), "", "(Ljava/lang/Object;)Ljava/lang/Object;", new String[0]);
        this.resumeLocation = resumeLocation;
        this.myState = CurrentInsn.NONE;
        this.coroutineSuspendedState = CoroutineSuspendedState.NONE;
        this.coroutineSuspendedLocalVarIndex = -1;
        this.currentByteCodeOffSet = -1;
        this.firstReturnAfterSuspensionOffset = -1;
        this.nextCallOffset = -1;
    }

    public final int getFirstReturnAfterSuspensionOffset() {
        return this.firstReturnAfterSuspensionOffset;
    }

    public final void setFirstReturnAfterSuspensionOffset(int n) {
        this.firstReturnAfterSuspensionOffset = n;
    }

    public final int getNextCallOffset() {
        return this.nextCallOffset;
    }

    public final void setNextCallOffset(int n) {
        this.nextCallOffset = n;
    }

    public void readBytecodeInstructionOffset(int offset2) {
        this.currentByteCodeOffSet = offset2;
    }

    public void visitMethodInsn(int opcodeAndSource, @Nullable String owner, @Nullable String name2, @Nullable String descriptor2, boolean isInterface) {
        super.visitMethodInsn(opcodeAndSource, owner, name2, descriptor2, isInterface);
        if (this.coroutineSuspendedState == CoroutineSuspendedState.NONE && this.isGetCoroutineSuspended(name2, owner)) {
            this.coroutineSuspendedState = CoroutineSuspendedState.INVOKE_GET_COROUTINE_SUSPENDED;
        } else if (this.myState == CurrentInsn.NONE && this.reachedResumedLocation()) {
            this.myState = CurrentInsn.SUSPEND_METHOD_ARGS;
        } else if (this.myState != CurrentInsn.SUSPEND_METHOD_ARGS || this.isSuspendFunction(name2, descriptor2)) {
            if (this.myState == CurrentInsn.PUTFIELD_CONTINUATION_LABEL && this.isSuspendFunction(name2, descriptor2)) {
                this.myState = CurrentInsn.INVOKE_SUSPEND_METHOD;
            } else {
                this.myState = CurrentInsn.NONE;
                this.coroutineSuspendedState = CoroutineSuspendedState.NONE;
            }
        }
    }

    public void visitInsn(int opcode) {
        super.visitInsn(opcode);
        if (this.myState == CurrentInsn.NONE && this.reachedResumedLocation()) {
            this.myState = CurrentInsn.SUSPEND_METHOD_ARGS;
        } else if (this.myState != CurrentInsn.SUSPEND_METHOD_ARGS) {
            if (this.myState == CurrentInsn.INVOKE_SUSPEND_METHOD && opcode == 89) {
                this.myState = CurrentInsn.DUP;
            } else if (this.myState == CurrentInsn.ALOAD_SUSPEND_RESULT_FOR_SUSPEND_RETURN && opcode == 176) {
                this.firstReturnAfterSuspensionOffset = this.currentByteCodeOffSet;
            } else {
                this.myState = CurrentInsn.NONE;
                this.coroutineSuspendedState = CoroutineSuspendedState.NONE;
            }
        }
    }

    public void visitLdcInsn(@Nullable Object value2) {
        super.visitLdcInsn(value2);
        if (this.myState == CurrentInsn.NONE && this.reachedResumedLocation()) {
            this.myState = CurrentInsn.SUSPEND_METHOD_ARGS;
        } else if (this.myState != CurrentInsn.SUSPEND_METHOD_ARGS) {
            this.myState = CurrentInsn.NONE;
            this.coroutineSuspendedState = CoroutineSuspendedState.NONE;
        }
    }

    public void visitJumpInsn(int opcode, @Nullable Label label2) {
        super.visitJumpInsn(opcode, label2);
        if (this.myState == CurrentInsn.ALOAD_SUSPEND_RESULT_BEFORE_COMPARE && opcode == 166) {
            this.myState = CurrentInsn.IF_ACMPNE;
            this.nextCallLabel = label2;
        } else {
            this.myState = CurrentInsn.NONE;
            this.coroutineSuspendedState = CoroutineSuspendedState.NONE;
        }
    }

    public void visitIntInsn(int opcode, int operand) {
        super.visitIntInsn(opcode, operand);
        if (this.myState == CurrentInsn.NONE && this.reachedResumedLocation()) {
            this.myState = CurrentInsn.SUSPEND_METHOD_ARGS;
        } else if (this.myState != CurrentInsn.SUSPEND_METHOD_ARGS) {
            this.myState = CurrentInsn.NONE;
            this.coroutineSuspendedState = CoroutineSuspendedState.NONE;
        }
    }

    public void visitIincInsn(int varIndex, int increment) {
        super.visitIincInsn(varIndex, increment);
        if (this.myState == CurrentInsn.NONE && this.reachedResumedLocation()) {
            this.myState = CurrentInsn.SUSPEND_METHOD_ARGS;
        } else if (this.myState != CurrentInsn.SUSPEND_METHOD_ARGS) {
            this.myState = CurrentInsn.NONE;
            this.coroutineSuspendedState = CoroutineSuspendedState.NONE;
        }
    }

    public void visitVarInsn(int opcode, int var) {
        super.visitVarInsn(opcode, var);
        if (this.coroutineSuspendedState == CoroutineSuspendedState.INVOKE_GET_COROUTINE_SUSPENDED && opcode == 58) {
            this.coroutineSuspendedLocalVarIndex = var;
        } else if (this.myState == CurrentInsn.NONE && this.reachedResumedLocation()) {
            this.myState = CurrentInsn.SUSPEND_METHOD_ARGS;
        } else if (this.myState != CurrentInsn.SUSPEND_METHOD_ARGS) {
            if (this.myState == CurrentInsn.DUP && opcode == 25 && var == this.coroutineSuspendedLocalVarIndex) {
                this.myState = CurrentInsn.ALOAD_SUSPEND_RESULT_BEFORE_COMPARE;
            } else if (this.myState == CurrentInsn.IF_ACMPNE && opcode == 25 && var == this.coroutineSuspendedLocalVarIndex) {
                this.myState = CurrentInsn.ALOAD_SUSPEND_RESULT_FOR_SUSPEND_RETURN;
            } else {
                this.myState = CurrentInsn.NONE;
                this.coroutineSuspendedState = CoroutineSuspendedState.NONE;
            }
        }
    }

    public void visitFieldInsn(int opcode, @Nullable String owner, @Nullable String name2, @Nullable String descriptor2) {
        super.visitFieldInsn(opcode, owner, name2, descriptor2);
        if (this.myState == CurrentInsn.NONE && this.reachedResumedLocation()) {
            this.myState = CurrentInsn.SUSPEND_METHOD_ARGS;
        } else if (this.myState == CurrentInsn.SUSPEND_METHOD_ARGS && opcode == 181 && DebuggerUtil.access$checkContinuationLabelField(this.resumeLocation, name2, descriptor2, owner)) {
            this.myState = CurrentInsn.PUTFIELD_CONTINUATION_LABEL;
        } else if (this.myState != CurrentInsn.SUSPEND_METHOD_ARGS) {
            this.myState = CurrentInsn.NONE;
            this.coroutineSuspendedState = CoroutineSuspendedState.NONE;
        }
    }

    public void visitLabel(@Nullable Label label2) {
        super.visitLabel(label2);
        if (this.myState == CurrentInsn.NONE && this.reachedResumedLocation()) {
            this.myState = CurrentInsn.SUSPEND_METHOD_ARGS;
        }
        if (Intrinsics.areEqual((Object)label2, (Object)this.nextCallLabel)) {
            this.nextCallOffset = this.currentByteCodeOffSet;
        }
    }

    private final boolean reachedResumedLocation() {
        return (long)this.currentByteCodeOffSet == this.resumeLocation.codeIndex();
    }

    private final boolean isGetCoroutineSuspended(String name2, String owner) {
        if (name2 == null || owner == null) {
            return false;
        }
        return Intrinsics.areEqual((Object)name2, (Object)"getCOROUTINE_SUSPENDED") && Intrinsics.areEqual((Object)owner, (Object)"kotlin/coroutines/intrinsics/IntrinsicsKt");
    }

    private final boolean isSuspendFunction(String name2, String descriptor2) {
        if (name2 == null || descriptor2 == null) {
            return false;
        }
        Type continuationAsmType = DebuggerUtil.access$continuationAsmType();
        CharSequence charSequence = descriptor2;
        String string = continuationAsmType.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return StringsKt.contains$default((CharSequence)charSequence, (CharSequence)string, (boolean)false, (int)2, null) && !Intrinsics.areEqual((Object)name2, (Object)"<init>");
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0004\b\u0082\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/core/CoroutineStateMachineVisitor$CoroutineSuspendedState;", "", "(Ljava/lang/String;I)V", "NONE", "INVOKE_GET_COROUTINE_SUSPENDED", "kotlin.jvm-debugger.core"})
    private static final class CoroutineSuspendedState
    extends Enum<CoroutineSuspendedState> {
        public static final /* enum */ CoroutineSuspendedState NONE = new CoroutineSuspendedState();
        public static final /* enum */ CoroutineSuspendedState INVOKE_GET_COROUTINE_SUSPENDED = new CoroutineSuspendedState();
        private static final /* synthetic */ CoroutineSuspendedState[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static CoroutineSuspendedState[] values() {
            return (CoroutineSuspendedState[])$VALUES.clone();
        }

        public static CoroutineSuspendedState valueOf(String value2) {
            return Enum.valueOf(CoroutineSuspendedState.class, value2);
        }

        @NotNull
        public static EnumEntries<CoroutineSuspendedState> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = coroutineSuspendedStateArray = new CoroutineSuspendedState[]{CoroutineSuspendedState.NONE, CoroutineSuspendedState.INVOKE_GET_COROUTINE_SUSPENDED};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\n\b\u0082\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\n\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/core/CoroutineStateMachineVisitor$CurrentInsn;", "", "(Ljava/lang/String;I)V", "NONE", "SUSPEND_METHOD_ARGS", "PUTFIELD_CONTINUATION_LABEL", "INVOKE_SUSPEND_METHOD", "DUP", "ALOAD_SUSPEND_RESULT_BEFORE_COMPARE", "IF_ACMPNE", "ALOAD_SUSPEND_RESULT_FOR_SUSPEND_RETURN", "kotlin.jvm-debugger.core"})
    private static final class CurrentInsn
    extends Enum<CurrentInsn> {
        public static final /* enum */ CurrentInsn NONE = new CurrentInsn();
        public static final /* enum */ CurrentInsn SUSPEND_METHOD_ARGS = new CurrentInsn();
        public static final /* enum */ CurrentInsn PUTFIELD_CONTINUATION_LABEL = new CurrentInsn();
        public static final /* enum */ CurrentInsn INVOKE_SUSPEND_METHOD = new CurrentInsn();
        public static final /* enum */ CurrentInsn DUP = new CurrentInsn();
        public static final /* enum */ CurrentInsn ALOAD_SUSPEND_RESULT_BEFORE_COMPARE = new CurrentInsn();
        public static final /* enum */ CurrentInsn IF_ACMPNE = new CurrentInsn();
        public static final /* enum */ CurrentInsn ALOAD_SUSPEND_RESULT_FOR_SUSPEND_RETURN = new CurrentInsn();
        private static final /* synthetic */ CurrentInsn[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static CurrentInsn[] values() {
            return (CurrentInsn[])$VALUES.clone();
        }

        public static CurrentInsn valueOf(String value2) {
            return Enum.valueOf(CurrentInsn.class, value2);
        }

        @NotNull
        public static EnumEntries<CurrentInsn> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = currentInsnArray = new CurrentInsn[]{CurrentInsn.NONE, CurrentInsn.SUSPEND_METHOD_ARGS, CurrentInsn.PUTFIELD_CONTINUATION_LABEL, CurrentInsn.INVOKE_SUSPEND_METHOD, CurrentInsn.DUP, CurrentInsn.ALOAD_SUSPEND_RESULT_BEFORE_COMPARE, CurrentInsn.IF_ACMPNE, CurrentInsn.ALOAD_SUSPEND_RESULT_FOR_SUSPEND_RETURN};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

