/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.core;

import com.intellij.debugger.SourcePosition;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.util.concurrency.annotations.RequiresReadLock;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.base.util.caching.ConcurrentFactoryCache;
import org.jetbrains.kotlin.idea.debugger.base.util.ClassNameCalculator;
import org.jetbrains.kotlin.idea.debugger.core.breakpoints.BreakpointTypeUtilsKt;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtAnonymousInitializer;
import org.jetbrains.kotlin.psi.KtCallableReferenceExpression;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtLambdaExpression;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtObjectDeclaration;
import org.jetbrains.kotlin.psi.KtObjectLiteralExpression;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPropertyAccessor;
import org.jetbrains.kotlin.psi.KtScript;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0002\u001d\u001eB\u001f\b\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bB\u000f\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\tJ\u0016\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0014\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00150\u00102\u0006\u0010\u0016\u001a\u00020\u0017J\u0014\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00150\u00102\u0006\u0010\u0012\u001a\u00020\u0013J\u0016\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0016\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010\u0016\u001a\u00020\u0017H\u0007J\f\u0010\u001b\u001a\u00020\u000b*\u00020\u001cH\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\n\u001a\u00020\u000b*\u00020\f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u001f"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/core/ClassNameProvider;", "", "project", "Lcom/intellij/openapi/project/Project;", "searchScope", "Lcom/intellij/psi/search/GlobalSearchScope;", "configuration", "Lorg/jetbrains/kotlin/idea/debugger/core/ClassNameProvider$Configuration;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/psi/search/GlobalSearchScope;Lorg/jetbrains/kotlin/idea/debugger/core/ClassNameProvider$Configuration;)V", "(Lorg/jetbrains/kotlin/idea/debugger/core/ClassNameProvider$Configuration;)V", "hasInlineAccessors", "", "Lorg/jetbrains/kotlin/psi/KtProperty;", "getHasInlineAccessors", "(Lorg/jetbrains/kotlin/psi/KtProperty;)Z", "computeCandidatesForElement", "", "Lorg/jetbrains/kotlin/idea/debugger/core/ClassNameProvider$ClassNameCandidateInfo;", "element", "Lcom/intellij/psi/PsiElement;", "getCandidates", "", "position", "Lcom/intellij/debugger/SourcePosition;", "getCandidatesForElement", "getCandidatesForElementInternal", "getCandidatesInfo", "isInterfaceClass", "Lcom/intellij/psi/PsiNamedElement;", "ClassNameCandidateInfo", "Configuration", "kotlin.jvm-debugger.core"})
@SourceDebugExtension(value={"SMAP\nClassNameProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ClassNameProvider.kt\norg/jetbrains/kotlin/idea/debugger/core/ClassNameProvider\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,161:1\n1549#2:162\n1620#2,3:163\n1360#2:167\n1446#2,5:168\n1549#2:173\n1620#2,3:174\n1747#2,3:177\n1#3:166\n*S KotlinDebug\n*F\n+ 1 ClassNameProvider.kt\norg/jetbrains/kotlin/idea/debugger/core/ClassNameProvider\n*L\n38#1:162\n38#1:163,3\n44#1:167\n44#1:168,5\n48#1:173\n48#1:174,3\n151#1:177,3\n*E\n"})
public final class ClassNameProvider {
    @NotNull
    private final Configuration configuration;

    public ClassNameProvider(@NotNull Configuration configuration2) {
        Intrinsics.checkNotNullParameter((Object)configuration2, (String)"configuration");
        this.configuration = configuration2;
    }

    public /* synthetic */ ClassNameProvider(Configuration configuration2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            configuration2 = Configuration.Companion.getDEFAULT();
        }
        this(configuration2);
    }

    @Deprecated(message="Use primary constructor}", replaceWith=@ReplaceWith(expression="ClassNameProvider(configuration)", imports={}))
    public ClassNameProvider(@NotNull Project project2, @NotNull GlobalSearchScope searchScope2, @NotNull Configuration configuration2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)searchScope2, (String)"searchScope");
        Intrinsics.checkNotNullParameter((Object)configuration2, (String)"configuration");
        this(configuration2);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<String> getCandidates(@NotNull SourcePosition position) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)position, (String)"position");
        Iterable $this$map$iv = this.getCandidatesInfo(position);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            ClassNameCandidateInfo classNameCandidateInfo = (ClassNameCandidateInfo)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getName());
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @ApiStatus.Internal
    @RequiresReadLock
    @NotNull
    public final List<ClassNameCandidateInfo> getCandidatesInfo(@NotNull SourcePosition position) {
        void $this$flatMapTo$iv$iv;
        Object p0;
        Object object;
        block4: {
            block3: {
                Intrinsics.checkNotNullParameter((Object)position, (String)"position");
                object = position.getElementAt();
                if (object == null) break block3;
                p0 = object;
                boolean bl = false;
                List<ClassNameCandidateInfo> list2 = this.getCandidatesForElementInternal((PsiElement)p0);
                object = list2;
                if (list2 != null) break block4;
            }
            object = CollectionsKt.emptyList();
        }
        Object regularClassNames = object;
        Iterable $this$flatMap$iv = BreakpointTypeUtilsKt.getLambdasAtLineIfAny(position);
        boolean $i$f$flatMap = false;
        p0 = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            KtFunction it = (KtFunction)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = this.getCandidatesForElementInternal((PsiElement)it);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        List lambdaClassNames = (List)destination$iv$iv;
        return CollectionsKt.distinct((Iterable)CollectionsKt.plus((Collection)((Collection)regularClassNames), (Iterable)lambdaClassNames));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<String> getCandidatesForElement(@NotNull PsiElement element3) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
        Iterable $this$map$iv = this.getCandidatesForElementInternal(element3);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            ClassNameCandidateInfo classNameCandidateInfo = (ClassNameCandidateInfo)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getName());
        }
        return (List)destination$iv$iv;
    }

    private final List<ClassNameCandidateInfo> getCandidatesForElementInternal(PsiElement element3) {
        ConcurrentFactoryCache cache2 = (ConcurrentFactoryCache)CachedValuesManager.getCachedValue((PsiElement)element3, ClassNameProvider::getCandidatesForElementInternal$lambda$3);
        Object Value2 = cache2.get(this.configuration, (Function1)new Function1<Configuration, List<? extends ClassNameCandidateInfo>>(this, element3){
            final /* synthetic */ ClassNameProvider this$0;
            final /* synthetic */ PsiElement $element;
            {
                this.this$0 = $receiver;
                this.$element = $element;
                super(1);
            }

            public final List<ClassNameCandidateInfo> invoke(Configuration it) {
                return ClassNameProvider.access$computeCandidatesForElement(this.this$0, this.$element);
            }
        });
        Intrinsics.checkNotNullExpressionValue(Value2, (String)"get(...)");
        return (List)Value2;
    }

    private final List<ClassNameCandidateInfo> computeCandidatesForElement(PsiElement element3) {
        ArrayList<ClassNameCandidateInfo> result2 = new ArrayList<ClassNameCandidateInfo>();
        Ref.BooleanRef hasInlineElements = new Ref.BooleanRef();
        PsiElement current = element3;
        while (true) {
            PsiElement psiElement2;
            if ((psiElement2 = current) instanceof KtScript ? true : psiElement2 instanceof KtFile) {
                PsiElement psiElement3 = current;
                Intrinsics.checkNotNull((Object)psiElement3, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtElement");
                ClassNameProvider.computeCandidatesForElement$registerClassName$5(result2, hasInlineElements, (KtElement)psiElement3);
                break;
            }
            if (psiElement2 instanceof KtClassOrObject) {
                className = ClassNameProvider.computeCandidatesForElement$registerClassName$5(result2, hasInlineElements, (KtElement)current);
                if (className != null) {
                    if (!this.isInterfaceClass((PsiNamedElement)current)) break;
                    ClassNameProvider.computeCandidatesForElement$registerClassName(result2, hasInlineElements, className + "$DefaultImpls");
                    break;
                }
            } else if (psiElement2 instanceof KtProperty) {
                KtClassOrObject propertyOwner;
                if (this.getHasInlineAccessors((KtProperty)current)) {
                    hasInlineElements.element = true;
                }
                if ((propertyOwner = KtPsiUtilKt.getContainingClassOrObject((KtDeclaration)((KtDeclaration)current))) instanceof KtObjectDeclaration && ((KtObjectDeclaration)propertyOwner).isCompanion()) {
                    KtClassOrObject ktClassOrObject = KtPsiUtilKt.getContainingClassOrObject((KtDeclaration)((KtDeclaration)propertyOwner));
                    if (ktClassOrObject == null) {
                        break;
                    }
                    current = (PsiElement)ktClassOrObject;
                    continue;
                }
            } else if (psiElement2 instanceof KtNamedFunction) {
                if (((KtNamedFunction)current).hasModifier(KtTokens.INLINE_KEYWORD)) {
                    hasInlineElements.element = true;
                }
                if (((KtNamedFunction)current).isLocal()) {
                    ClassNameProvider.computeCandidatesForElement$registerClassName$5(result2, hasInlineElements, (KtElement)current);
                }
            } else if (psiElement2 instanceof KtAnonymousInitializer) {
                KtDeclaration initializerOwner = ((KtAnonymousInitializer)current).getContainingDeclaration();
                if (initializerOwner instanceof KtObjectDeclaration && ((KtObjectDeclaration)initializerOwner).isCompanion()) {
                    KtClassOrObject ktClassOrObject = KtPsiUtilKt.getContainingClassOrObject((KtDeclaration)initializerOwner);
                    if (ktClassOrObject == null) {
                        break;
                    }
                    current = (PsiElement)ktClassOrObject;
                    continue;
                }
            } else if (psiElement2 instanceof KtCallableReferenceExpression ? true : psiElement2 instanceof KtLambdaExpression) {
                PsiElement psiElement4 = current;
                Intrinsics.checkNotNull((Object)psiElement4, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtElement");
                className = ClassNameProvider.computeCandidatesForElement$registerClassName$5(result2, hasInlineElements, (KtElement)psiElement4);
                if (className != null && !this.configuration.getAlwaysReturnLambdaParentClass()) {
                    break;
                }
            } else if (psiElement2 instanceof KtObjectLiteralExpression) {
                ClassNameProvider.computeCandidatesForElement$registerClassName$5(result2, hasInlineElements, (KtElement)current);
            }
            if (current.getParent() == null) break;
        }
        return result2;
    }

    private final boolean isInterfaceClass(PsiNamedElement $this$isInterfaceClass) {
        PsiNamedElement psiNamedElement = $this$isInterfaceClass;
        return psiNamedElement instanceof KtClass ? ((KtClass)$this$isInterfaceClass).isInterface() : (psiNamedElement instanceof PsiClass ? ((PsiClass)$this$isInterfaceClass).isInterface() : false);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean getHasInlineAccessors(KtProperty $this$hasInlineAccessors) {
        KtPropertyAccessor it;
        if ($this$hasInlineAccessors.hasModifier(KtTokens.INLINE_KEYWORD)) return true;
        List list2 = $this$hasInlineAccessors.getAccessors();
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getAccessors(...)");
        Iterable $this$any$iv = list2;
        boolean $i$f$any = false;
        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
            return false;
        }
        Iterator iterator2 = $this$any$iv.iterator();
        do {
            if (!iterator2.hasNext()) return false;
            Object element$iv = iterator2.next();
            it = (KtPropertyAccessor)element$iv;
            boolean bl = false;
        } while (!it.hasModifier(KtTokens.INLINE_KEYWORD));
        return true;
    }

    private static final CachedValueProvider.Result getCandidatesForElementInternal$lambda$3() {
        ConcurrentHashMap storage = new ConcurrentHashMap();
        Object[] objectArray = new Object[]{PsiModificationTracker.MODIFICATION_COUNT};
        return new CachedValueProvider.Result(new ConcurrentFactoryCache(storage), objectArray);
    }

    private static final void computeCandidatesForElement$registerClassName(ArrayList<ClassNameCandidateInfo> result2, Ref.BooleanRef hasInlineElements, String name2) {
        result2.add(new ClassNameCandidateInfo(name2, hasInlineElements.element));
    }

    private static final String computeCandidatesForElement$registerClassName$5(ArrayList<ClassNameCandidateInfo> result2, Ref.BooleanRef hasInlineElements, KtElement element3) {
        String string;
        String string2 = ClassNameCalculator.INSTANCE.getClassName(element3);
        if (string2 != null) {
            String string3;
            String it = string3 = string2;
            boolean bl = false;
            ClassNameProvider.computeCandidatesForElement$registerClassName(result2, hasInlineElements, it);
            string = string3;
        } else {
            string = null;
        }
        return string;
    }

    public ClassNameProvider() {
        this(null, 1, null);
    }

    public static final /* synthetic */ List access$computeCandidatesForElement(ClassNameProvider $this, PsiElement element3) {
        return $this.computeCandidatesForElement(element3);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u000b\n\u0002\u0010\b\n\u0002\b\u0002\b\u0087\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u00052\b\u0010\u000f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001J\t\u0010\u0012\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/core/ClassNameProvider$ClassNameCandidateInfo;", "", "name", "", "hasInlineElements", "", "(Ljava/lang/String;Z)V", "getHasInlineElements", "()Z", "getName", "()Ljava/lang/String;", "component1", "component2", "copy", "equals", "other", "hashCode", "", "toString", "kotlin.jvm-debugger.core"})
    @ApiStatus.Internal
    public static final class ClassNameCandidateInfo {
        @NotNull
        private final String name;
        private final boolean hasInlineElements;

        public ClassNameCandidateInfo(@NotNull String name2, boolean hasInlineElements) {
            Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
            this.name = name2;
            this.hasInlineElements = hasInlineElements;
        }

        @NotNull
        public final String getName() {
            return this.name;
        }

        public final boolean getHasInlineElements() {
            return this.hasInlineElements;
        }

        @NotNull
        public final String component1() {
            return this.name;
        }

        public final boolean component2() {
            return this.hasInlineElements;
        }

        @NotNull
        public final ClassNameCandidateInfo copy(@NotNull String name2, boolean hasInlineElements) {
            Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
            return new ClassNameCandidateInfo(name2, hasInlineElements);
        }

        public static /* synthetic */ ClassNameCandidateInfo copy$default(ClassNameCandidateInfo classNameCandidateInfo, String string, boolean bl, int n, Object object) {
            if ((n & 1) != 0) {
                string = classNameCandidateInfo.name;
            }
            if ((n & 2) != 0) {
                bl = classNameCandidateInfo.hasInlineElements;
            }
            return classNameCandidateInfo.copy(string, bl);
        }

        @NotNull
        public String toString() {
            return "ClassNameCandidateInfo(name=" + this.name + ", hasInlineElements=" + this.hasInlineElements + ")";
        }

        public int hashCode() {
            int result2 = this.name.hashCode();
            result2 = result2 * 31 + Boolean.hashCode(this.hasInlineElements);
            return result2;
        }

        public boolean equals(@Nullable Object other2) {
            if (this == other2) {
                return true;
            }
            if (!(other2 instanceof ClassNameCandidateInfo)) {
                return false;
            }
            ClassNameCandidateInfo classNameCandidateInfo = (ClassNameCandidateInfo)other2;
            if (!Intrinsics.areEqual((Object)this.name, (Object)classNameCandidateInfo.name)) {
                return false;
            }
            return this.hasInlineElements == classNameCandidateInfo.hasInlineElements;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u000b\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\b\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B\u0019\b\u0000\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\t\u0010\t\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\u000b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\f\u001a\u00020\u00032\b\u0010\r\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/core/ClassNameProvider$Configuration;", "", "findInlineUseSites", "", "alwaysReturnLambdaParentClass", "(ZZ)V", "getAlwaysReturnLambdaParentClass", "()Z", "getFindInlineUseSites", "component1", "component2", "copy", "equals", "other", "hashCode", "", "toString", "", "Companion", "kotlin.jvm-debugger.core"})
    public static final class Configuration {
        @NotNull
        public static final Companion Companion = new Companion(null);
        private final boolean findInlineUseSites;
        private final boolean alwaysReturnLambdaParentClass;
        @NotNull
        private static final Configuration DEFAULT = new Configuration(false, true, 1, null);
        @NotNull
        private static final Configuration STOP_AT_LAMBDA = new Configuration(false, false, 1, null);

        public Configuration(boolean findInlineUseSites, boolean alwaysReturnLambdaParentClass) {
            this.findInlineUseSites = findInlineUseSites;
            this.alwaysReturnLambdaParentClass = alwaysReturnLambdaParentClass;
        }

        public /* synthetic */ Configuration(boolean bl, boolean bl2, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                bl = false;
            }
            this(bl, bl2);
        }

        public final boolean getFindInlineUseSites() {
            return this.findInlineUseSites;
        }

        public final boolean getAlwaysReturnLambdaParentClass() {
            return this.alwaysReturnLambdaParentClass;
        }

        public final boolean component1() {
            return this.findInlineUseSites;
        }

        public final boolean component2() {
            return this.alwaysReturnLambdaParentClass;
        }

        @NotNull
        public final Configuration copy(boolean findInlineUseSites, boolean alwaysReturnLambdaParentClass) {
            return new Configuration(findInlineUseSites, alwaysReturnLambdaParentClass);
        }

        public static /* synthetic */ Configuration copy$default(Configuration configuration2, boolean bl, boolean bl2, int n, Object object) {
            if ((n & 1) != 0) {
                bl = configuration2.findInlineUseSites;
            }
            if ((n & 2) != 0) {
                bl2 = configuration2.alwaysReturnLambdaParentClass;
            }
            return configuration2.copy(bl, bl2);
        }

        @NotNull
        public String toString() {
            return "Configuration(findInlineUseSites=" + this.findInlineUseSites + ", alwaysReturnLambdaParentClass=" + this.alwaysReturnLambdaParentClass + ")";
        }

        public int hashCode() {
            int result2 = Boolean.hashCode(this.findInlineUseSites);
            result2 = result2 * 31 + Boolean.hashCode(this.alwaysReturnLambdaParentClass);
            return result2;
        }

        public boolean equals(@Nullable Object other2) {
            if (this == other2) {
                return true;
            }
            if (!(other2 instanceof Configuration)) {
                return false;
            }
            Configuration configuration2 = (Configuration)other2;
            if (this.findInlineUseSites != configuration2.findInlineUseSites) {
                return false;
            }
            return this.alwaysReturnLambdaParentClass == configuration2.alwaysReturnLambdaParentClass;
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/core/ClassNameProvider$Configuration$Companion;", "", "()V", "DEFAULT", "Lorg/jetbrains/kotlin/idea/debugger/core/ClassNameProvider$Configuration;", "getDEFAULT", "()Lorg/jetbrains/kotlin/idea/debugger/core/ClassNameProvider$Configuration;", "STOP_AT_LAMBDA", "getSTOP_AT_LAMBDA", "kotlin.jvm-debugger.core"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final Configuration getDEFAULT() {
                return DEFAULT;
            }

            @NotNull
            public final Configuration getSTOP_AT_LAMBDA() {
                return STOP_AT_LAMBDA;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

