/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.core.script;

import com.intellij.ide.scratch.ScratchFileService;
import com.intellij.ide.scratch.ScratchRootType;
import com.intellij.injected.editor.VirtualFileWindow;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.diagnostic.ControlFlowException;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import kotlin.Deprecated;
import kotlin.DeprecationLevel;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.script.experimental.api.SourceCode;
import kotlin.script.experimental.host.ScriptHostUtilKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.KotlinFileType;
import org.jetbrains.kotlin.idea.core.script.BundledScriptDefinitionContributor;
import org.jetbrains.kotlin.idea.core.script.ScriptConfigurationManager;
import org.jetbrains.kotlin.idea.core.script.ScriptDefinitionContributor;
import org.jetbrains.kotlin.idea.core.script.ScriptDefinitionContributorKt;
import org.jetbrains.kotlin.idea.core.script.ScriptTemplatesProviderAdapter;
import org.jetbrains.kotlin.idea.core.script.ScriptUtilsKt;
import org.jetbrains.kotlin.idea.core.script.settings.KotlinScriptingSettings;
import org.jetbrains.kotlin.script.ScriptTemplatesProvider;
import org.jetbrains.kotlin.scripting.definitions.KotlinScriptDefinition;
import org.jetbrains.kotlin.scripting.definitions.LazyScriptDefinitionProvider;
import org.jetbrains.kotlin.scripting.definitions.ScriptDefinition;
import org.jetbrains.kotlin.scripting.definitions.ScriptDefinitionProvider;
import org.jetbrains.kotlin.scripting.definitions.ScriptDefinitionsSource;
import org.jetbrains.kotlin.scripting.resolve.VirtualFileScriptSource;
import org.jetbrains.kotlin.utils.addToStdlib.AddToStdlibKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0082\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010%\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0011\b\u0016\u0018\u0000 >2\u00020\u00012\u00020\u0002:\u0001>B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010\u0019\u001a\u00020\u001aH\u0002J\b\u0010\u001b\u001a\u00020\u001cH\u0014J\b\u0010\u001d\u001a\u00020\u001cH\u0002J\b\u0010\u001e\u001a\u00020\u001cH\u0016J\u0016\u0010\u001f\u001a\u00020\u001c2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u001c0!H\u0014J\u0012\u0010\"\u001a\u0004\u0018\u00010\u000b2\u0006\u0010#\u001a\u00020$H\u0016J\u0012\u0010%\u001a\u0004\u0018\u00010&2\u0006\u0010'\u001a\u00020(H\u0017J\u000f\u0010)\u001a\t\u0018\u00010*\u00a2\u0006\u0002\b+H\u0014J\b\u0010,\u001a\u00020\u000bH\u0016J\b\u0010-\u001a\u00020.H\u0014J\u000e\u0010/\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0002J\u000e\u00100\u001a\b\u0012\u0004\u0012\u00020\b0\nH\u0014J\u0010\u00101\u001a\u00020\u001a2\u0006\u00102\u001a\u00020$H\u0002J\u0010\u00103\u001a\u00020\u001a2\u0006\u0010#\u001a\u00020$H\u0014J\f\u00104\u001a\b\u0012\u0004\u0012\u00020\u000b0\nJ\u0014\u00105\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u00106\u001a\u00020\bJ\u001c\u00107\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\f\u00108\u001a\b\u0012\u0004\u0012\u00020\b0\nH\u0002J\f\u00109\u001a\b\u0012\u0004\u0012\u00020\u000b0\nJ\u0012\u0010:\u001a\u0004\u0018\u00010\u000b2\u0006\u0010;\u001a\u00020(H\u0014J\u0016\u0010<\u001a\u00020\u001c2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u001c0!H\u0002J\u0012\u0010=\u001a\b\u0012\u0004\u0012\u00020\u000b0\n*\u00020\bH\u0002R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n8F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u001a\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000b0\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0016\u0010\u0012\u001a\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R \u0010\u0013\u001a\u0014\u0012\u0004\u0012\u00020\b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\n0\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00180\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006?"}, d2={"Lorg/jetbrains/kotlin/idea/core/script/ScriptDefinitionsManager;", "Lorg/jetbrains/kotlin/scripting/definitions/LazyScriptDefinitionProvider;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "activatedDefinitionSources", "", "Lorg/jetbrains/kotlin/scripting/definitions/ScriptDefinitionsSource;", "allDefinitions", "", "Lorg/jetbrains/kotlin/scripting/definitions/ScriptDefinition;", "getAllDefinitions", "()Ljava/util/List;", "currentDefinitions", "Lkotlin/sequences/Sequence;", "getCurrentDefinitions", "()Lkotlin/sequences/Sequence;", "definitions", "definitionsBySource", "", "definitionsLock", "Ljava/util/concurrent/locks/ReentrantLock;", "failedContributorsHashes", "", "allDefinitionSourcesContributedToCache", "", "applyDefinitionsUpdate", "", "associateFileExtensionsIfNeeded", "dispose", "executeUnderReadLock", "block", "Lkotlin/Function0;", "findDefinition", "script", "Lkotlin/script/experimental/api/SourceCode;", "findScriptDefinition", "Lorg/jetbrains/kotlin/scripting/definitions/KotlinScriptDefinition;", "fileName", "", "getBundledScriptDefinitionContributor", "Lorg/jetbrains/kotlin/idea/core/script/BundledScriptDefinitionContributor;", "Lkotlin/internal/NoInfer;", "getDefaultDefinition", "getKotlinScriptingSettings", "Lorg/jetbrains/kotlin/idea/core/script/settings/KotlinScriptingSettings;", "getOrLoadDefinitions", "getSources", "isEmbeddedScript", "code", "isScratchFile", "reloadDefinitions", "reloadDefinitionsBy", "source", "reloadDefinitionsInternal", "sources", "reorderDefinitions", "tryGetScriptDefinitionFast", "locationId", "withLocks", "safeGetDefinitions", "Companion", "kotlin.base.scripting"})
@SourceDebugExtension(value={"SMAP\nScriptDefinitionsManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ScriptDefinitionsManager.kt\norg/jetbrains/kotlin/idea/core/script/ScriptDefinitionsManager\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 addToStdlib.kt\norg/jetbrains/kotlin/utils/addToStdlib/AddToStdlibKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 ScriptDefinitionContributor.kt\norg/jetbrains/kotlin/idea/core/script/ScriptDefinitionContributor$Companion\n*L\n1#1,323:1\n1#2:324\n193#3,2:325\n193#3,3:331\n195#3:335\n1271#4,2:327\n1285#4,2:329\n1288#4:334\n766#4:336\n857#4,2:337\n1549#4:339\n1620#4,3:340\n1549#4:343\n1620#4,3:344\n800#4,11:348\n28#5:347\n*S KotlinDebug\n*F\n+ 1 ScriptDefinitionsManager.kt\norg/jetbrains/kotlin/idea/core/script/ScriptDefinitionsManager\n*L\n196#1:325,2\n198#1:331,3\n196#1:335\n197#1:327,2\n197#1:329,2\n197#1:334\n254#1:336\n254#1:337,2\n292#1:339\n292#1:340,3\n294#1:343\n294#1:344,3\n318#1:348,11\n318#1:347\n*E\n"})
public class ScriptDefinitionsManager
extends LazyScriptDefinitionProvider
implements Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final Map<ScriptDefinitionsSource, List<ScriptDefinition>> definitionsBySource;
    @NotNull
    private final Set<ScriptDefinitionsSource> activatedDefinitionSources;
    @NotNull
    private final Set<Integer> failedContributorsHashes;
    @NotNull
    private final ReentrantLock definitionsLock;
    @Nullable
    private volatile List<? extends ScriptDefinition> definitions;

    public ScriptDefinitionsManager(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        this.project = project2;
        this.definitionsBySource = new LinkedHashMap();
        ConcurrentHashMap.KeySetView keySetView = ConcurrentHashMap.newKeySet();
        Intrinsics.checkNotNullExpressionValue(keySetView, (String)"newKeySet(...)");
        this.activatedDefinitionSources = keySetView;
        ConcurrentHashMap.KeySetView keySetView2 = ConcurrentHashMap.newKeySet();
        Intrinsics.checkNotNullExpressionValue(keySetView2, (String)"newKeySet(...)");
        this.failedContributorsHashes = keySetView2;
        this.definitionsLock = new ReentrantLock();
    }

    @Override
    @NotNull
    public Sequence<ScriptDefinition> getCurrentDefinitions() {
        KotlinScriptingSettings scriptingSettings = this.getKotlinScriptingSettings();
        return SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)this.getOrLoadDefinitions()), (Function1)((Function1)new Function1<ScriptDefinition, Boolean>(scriptingSettings){
            final /* synthetic */ KotlinScriptingSettings $scriptingSettings;
            {
                this.$scriptingSettings = $scriptingSettings;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull ScriptDefinition it) {
                Intrinsics.checkNotNullParameter((Object)((Object)it), (String)"it");
                return this.$scriptingSettings.isScriptDefinitionEnabled(it);
            }
        }));
    }

    @NotNull
    public final List<ScriptDefinition> getAllDefinitions() {
        return this.getOrLoadDefinitions();
    }

    @Override
    @Nullable
    public ScriptDefinition findDefinition(@NotNull SourceCode script) {
        ScriptDefinition scriptDefinition;
        Intrinsics.checkNotNullParameter((Object)script, (String)"script");
        String string = script.getLocationId();
        if (string == null) {
            return null;
        }
        String locationId = string;
        ScriptDefinition scriptDefinition2 = this.tryGetScriptDefinitionFast(locationId);
        if (scriptDefinition2 != null) {
            ScriptDefinition fastPath = scriptDefinition2;
            boolean bl = false;
            return fastPath;
        }
        this.getOrLoadDefinitions();
        if (this.isScratchFile(script)) {
            scriptDefinition = this.getDefaultDefinition();
        } else {
            scriptDefinition = super.findDefinition(script);
            if (scriptDefinition == null) {
                scriptDefinition = this.isEmbeddedScript(script) ? this.getDefaultDefinition() : null;
            }
        }
        ScriptDefinition definition2 = scriptDefinition;
        return definition2;
    }

    @Override
    @Deprecated(message="Migrating to configuration refinement", level=DeprecationLevel.ERROR)
    @Nullable
    public KotlinScriptDefinition findScriptDefinition(@NotNull String fileName) {
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        ScriptDefinition scriptDefinition = this.findDefinition(ScriptHostUtilKt.toScriptSource(new File(fileName)));
        return scriptDefinition != null ? scriptDefinition.getLegacyDefinition() : null;
    }

    @NotNull
    public final List<ScriptDefinition> reloadDefinitions() {
        return this.reloadDefinitionsInternal(this.getSources());
    }

    @NotNull
    public final List<ScriptDefinition> reloadDefinitionsBy(@NotNull ScriptDefinitionsSource source) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        return this.reloadDefinitionsInternal(CollectionsKt.listOf((Object)source));
    }

    @NotNull
    public final List<ScriptDefinition> reorderDefinitions() {
        if (this.definitions == null) {
            return CollectionsKt.emptyList();
        }
        KotlinScriptingSettings scriptingSettings = this.getKotlinScriptingSettings();
        this.withLocks((Function0<Unit>)((Function0)new Function0<Unit>(this, scriptingSettings){
            final /* synthetic */ ScriptDefinitionsManager this$0;
            final /* synthetic */ KotlinScriptingSettings $scriptingSettings;
            {
                this.this$0 = $receiver;
                this.$scriptingSettings = $scriptingSettings;
                super(0);
            }

            public final void invoke() {
                List list2 = ScriptDefinitionsManager.access$getDefinitions$p(this.this$0);
                if (list2 != null) {
                    List list3 = list2;
                    ScriptDefinitionsManager scriptDefinitionsManager = this.this$0;
                    KotlinScriptingSettings kotlinScriptingSettings = this.$scriptingSettings;
                    List list4 = list3;
                    boolean bl = false;
                    Iterable $this$forEach$iv = list4;
                    boolean $i$f$forEach = false;
                    for (T element$iv : $this$forEach$iv) {
                        ScriptDefinition it = (ScriptDefinition)((Object)element$iv);
                        boolean bl2 = false;
                        it.setOrder(kotlinScriptingSettings.getScriptDefinitionOrder(it));
                    }
                    Iterable $this$sortedBy$iv = list4;
                    boolean $i$f$sortedBy = false;
                    ScriptDefinitionsManager.access$setDefinitions$p(scriptDefinitionsManager, CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

                        public final int compare(T a, T b2) {
                            ScriptDefinition p0 = (ScriptDefinition)((Object)a);
                            boolean bl = false;
                            Comparable comparable = Integer.valueOf(p0.getOrder());
                            p0 = (ScriptDefinition)((Object)b2);
                            Comparable comparable2 = comparable;
                            bl = false;
                            return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(p0.getOrder()));
                        }
                    }));
                }
                ScriptDefinitionsManager.access$clearCache(this.this$0);
            }
        }));
        this.applyDefinitionsUpdate();
        List list2 = this.definitions;
        if (list2 == null) {
            list2 = CollectionsKt.emptyList();
        }
        return list2;
    }

    @Override
    @NotNull
    public ScriptDefinition getDefaultDefinition() {
        BundledScriptDefinitionContributor bundledScriptDefinitionContributor = this.getBundledScriptDefinitionContributor();
        if (bundledScriptDefinitionContributor == null) {
            throw new IllegalStateException("BundledScriptDefinitionContributor must be registered in plugin.xml".toString());
        }
        BundledScriptDefinitionContributor bundledScriptDefinitionContributor2 = bundledScriptDefinitionContributor;
        return new ScriptDefinition.FromLegacy(this.getScriptingHostConfiguration(), (KotlinScriptDefinition)((Object)CollectionsKt.last(bundledScriptDefinitionContributor2.getDefinitions())), null, 4, null);
    }

    private final void withLocks(Function0<Unit> block2) {
        this.executeUnderReadLock((Function0<Unit>)((Function0)new Function0<Unit>(this, block2){
            final /* synthetic */ ScriptDefinitionsManager this$0;
            final /* synthetic */ Function0<Unit> $block;
            {
                this.this$0 = $receiver;
                this.$block = $block;
                super(0);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public final void invoke() {
                Lock lock = ScriptDefinitionsManager.access$getDefinitionsLock$p(this.this$0);
                Function0<Unit> function0 = this.$block;
                lock.lock();
                try {
                    boolean bl = false;
                    function0.invoke();
                    Unit unit = Unit.INSTANCE;
                }
                finally {
                    lock.unlock();
                }
            }
        }));
    }

    private final List<ScriptDefinition> getOrLoadDefinitions() {
        List<ScriptDefinition> list2;
        if (this.definitions == null || !this.allDefinitionSourcesContributedToCache()) {
            list2 = this.reloadDefinitionsInternal(this.getSources());
        } else {
            list2 = this.definitions;
            if (list2 == null) {
                throw new IllegalStateException("'definitions' became null after they weren't".toString());
            }
        }
        return list2;
    }

    private final boolean allDefinitionSourcesContributedToCache() {
        return this.activatedDefinitionSources.containsAll((Collection)this.getSources());
    }

    /*
     * WARNING - void declaration
     */
    private final List<ScriptDefinition> reloadDefinitionsInternal(List<? extends ScriptDefinitionsSource> sources) {
        Ref.ObjectRef loadedDefinitions2 = new Ref.ObjectRef();
        boolean $i$f$measureTimeMillisWithResult = false;
        long start$iv = System.currentTimeMillis();
        boolean bl = false;
        Iterable $this$associateWith$iv = sources;
        boolean $i$f$associateWith = false;
        LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
        Iterable $this$associateWithTo$iv$iv = $this$associateWith$iv;
        boolean $i$f$associateWithTo = false;
        for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
            void it;
            ScriptDefinitionsSource scriptDefinitionsSource = (ScriptDefinitionsSource)element$iv$iv;
            Object t = element$iv$iv;
            Map map2 = result$iv;
            boolean bl2 = false;
            boolean $i$f$measureTimeMillisWithResult2 = false;
            long start$iv2 = System.currentTimeMillis();
            boolean bl3 = false;
            List<ScriptDefinition> result$iv2 = this.safeGetDefinitions((ScriptDefinitionsSource)it);
            Pair pair = new Pair((Object)(System.currentTimeMillis() - start$iv2), result$iv2);
            long ms = ((Number)pair.component1()).longValue();
            List definitions2 = (List)pair.component2();
            ScriptUtilsKt.scriptingDebugLog$default(null, (Function0)new Function0<String>(ms, (ScriptDefinitionsSource)it, (List<? extends ScriptDefinition>)definitions2){
                final /* synthetic */ long $ms;
                final /* synthetic */ ScriptDefinitionsSource $it;
                final /* synthetic */ List<ScriptDefinition> $definitions;
                {
                    this.$ms = $ms;
                    this.$it = $it;
                    this.$definitions = $definitions;
                    super(0);
                }

                /*
                 * WARNING - void declaration
                 */
                @NotNull
                public final String invoke() {
                    Collection<String> collection;
                    void $this$mapTo$iv$iv;
                    void $this$map$iv;
                    Iterable iterable = this.$definitions;
                    String string = this.$it.getClass().getName();
                    long l = this.$ms;
                    boolean $i$f$map = false;
                    void var3_5 = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (T item$iv$iv : $this$mapTo$iv$iv) {
                        void it;
                        ScriptDefinition scriptDefinition = (ScriptDefinition)((Object)item$iv$iv);
                        collection = destination$iv$iv;
                        boolean bl = false;
                        collection.add(it.getName());
                    }
                    collection = (List)destination$iv$iv;
                    return "Loaded definitions: time = " + l + " ms, source = " + string + ", definitions = " + (List)collection;
                }
            }, 1, null);
            List list2 = definitions2;
            map2.put(t, list2);
        }
        Map result$iv3 = result$iv;
        Pair pair = new Pair((Object)(System.currentTimeMillis() - start$iv), (Object)result$iv3);
        long ms = ((Number)pair.component1()).longValue();
        Map newDefinitionsBySource = (Map)pair.component2();
        ScriptUtilsKt.scriptingDebugLog$default(null, (Function0)new Function0<String>(ms){
            final /* synthetic */ long $ms;
            {
                this.$ms = $ms;
                super(0);
            }

            @NotNull
            public final String invoke() {
                return "Definitions loading total time: " + this.$ms + " ms";
            }
        }, 1, null);
        KotlinScriptingSettings scriptingSettings = this.getKotlinScriptingSettings();
        this.withLocks((Function0<Unit>)((Function0)new Function0<Unit>(this, (Map<ScriptDefinitionsSource, ? extends List<? extends ScriptDefinition>>)newDefinitionsBySource, (Ref.ObjectRef<List<ScriptDefinition>>)loadedDefinitions2, scriptingSettings){
            final /* synthetic */ ScriptDefinitionsManager this$0;
            final /* synthetic */ Map<ScriptDefinitionsSource, List<ScriptDefinition>> $newDefinitionsBySource;
            final /* synthetic */ Ref.ObjectRef<List<ScriptDefinition>> $loadedDefinitions;
            final /* synthetic */ KotlinScriptingSettings $scriptingSettings;
            {
                this.this$0 = $receiver;
                this.$newDefinitionsBySource = $newDefinitionsBySource;
                this.$loadedDefinitions = $loadedDefinitions;
                this.$scriptingSettings = $scriptingSettings;
                super(0);
            }

            /*
             * WARNING - void declaration
             */
            public final void invoke() {
                void it;
                void $this$onEach$iv;
                Iterator<T> iterator2;
                Iterable $this$forEach$iv;
                Object object;
                Iterable<T> iterable;
                if (ScriptDefinitionsManager.access$getDefinitionsBySource$p(this.this$0).isEmpty()) {
                    iterable = (Iterable<T>)this.this$0.getSources();
                    object = this.this$0;
                    boolean $i$f$forEach = false;
                    iterator2 = $this$forEach$iv.iterator();
                    while (iterator2.hasNext()) {
                        T element$iv = iterator2.next();
                        ScriptDefinitionsSource it2 = (ScriptDefinitionsSource)element$iv;
                        boolean bl = false;
                        ScriptDefinitionsManager.access$getDefinitionsBySource$p((ScriptDefinitionsManager)object).put(it2, CollectionsKt.emptyList());
                    }
                }
                ScriptDefinitionsManager.access$getDefinitionsBySource$p(this.this$0).putAll(this.$newDefinitionsBySource);
                $this$forEach$iv = AddToStdlibKt.flattenTo((Iterable)ScriptDefinitionsManager.access$getDefinitionsBySource$p(this.this$0).values(), (Collection)new ArrayList<E>());
                object = this.$scriptingSettings;
                Ref.ObjectRef<List<ScriptDefinition>> objectRef = this.$loadedDefinitions;
                boolean $i$f$onEach = false;
                Iterator<T> $this$onEach_u24lambda_u2416$iv = iterator2 = $this$onEach$iv;
                boolean bl = false;
                Iterator<T> iterator3 = $this$onEach_u24lambda_u2416$iv.iterator();
                while (iterator3.hasNext()) {
                    T element$iv = iterator3.next();
                    ScriptDefinition it3 = (ScriptDefinition)((Object)element$iv);
                    boolean bl2 = false;
                    it3.setOrder(((KotlinScriptingSettings)object).getScriptDefinitionOrder(it3));
                }
                Iterator<T> $this$sortedBy$iv = iterator2;
                boolean $i$f$sortedBy22 = false;
                Iterable<T> $i$f$sortedBy22 = iterable = CollectionsKt.sortedWith($this$sortedBy$iv, (Comparator)new Comparator(){

                    public final int compare(T a, T b2) {
                        ScriptDefinition p0 = (ScriptDefinition)((Object)a);
                        boolean bl = false;
                        Comparable comparable = Integer.valueOf(p0.getOrder());
                        p0 = (ScriptDefinition)((Object)b2);
                        Comparable comparable2 = comparable;
                        bl = false;
                        return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(p0.getOrder()));
                    }
                });
                boolean bl3 = false;
                boolean bl4 = !((Collection)it).isEmpty();
                objectRef.element = bl4 ? iterable : null;
                ScriptDefinitionsManager.access$setDefinitions$p(this.this$0, (List)this.$loadedDefinitions.element);
                ScriptDefinitionsManager.access$clearCache(this.this$0);
            }
        }));
        this.activatedDefinitionSources.addAll((Collection<ScriptDefinitionsSource>)sources);
        this.applyDefinitionsUpdate();
        List list3 = (List)loadedDefinitions2.element;
        if (list3 == null) {
            list3 = CollectionsKt.emptyList();
        }
        return list3;
    }

    private final List<ScriptDefinition> safeGetDefinitions(ScriptDefinitionsSource $this$safeGetDefinitions) {
        if (!this.failedContributorsHashes.contains($this$safeGetDefinitions.hashCode())) {
            try {
                return SequencesKt.toList($this$safeGetDefinitions.getDefinitions());
            }
            catch (Throwable t) {
                if (t instanceof ControlFlowException) {
                    throw t;
                }
                this.failedContributorsHashes.add($this$safeGetDefinitions.hashCode());
                Object object = t.getCause();
                if (object == null || (object = ((Throwable)object).getMessage()) == null) {
                    object = t.getMessage();
                }
                ScriptUtilsKt.scriptingErrorLog("Cannot load script definitions from " + $this$safeGetDefinitions + ": " + (String)object, t);
            }
        }
        return CollectionsKt.emptyList();
    }

    private final boolean isEmbeddedScript(SourceCode code) {
        VirtualFileScriptSource virtualFileScriptSource = code instanceof VirtualFileScriptSource ? (VirtualFileScriptSource)code : null;
        if (virtualFileScriptSource == null) {
            return false;
        }
        VirtualFileScriptSource scriptSource = virtualFileScriptSource;
        VirtualFile virtualFile2 = scriptSource.getVirtualFile();
        return virtualFile2 instanceof VirtualFileWindow && Intrinsics.areEqual((Object)virtualFile2.getFileType(), (Object)KotlinFileType.INSTANCE);
    }

    /*
     * WARNING - void declaration
     */
    private final void associateFileExtensionsIfNeeded() {
        void $this$filterTo$iv$iv;
        FileTypeManager fileTypeManager = FileTypeManager.getInstance();
        Iterable $this$filter$iv = SequencesKt.toSet(this.getKnownFilenameExtensions());
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            FileType fileTypeByExtension;
            boolean notKnown;
            String it = (String)element$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)fileTypeManager.getFileTypeByFileName("xxx." + it), (String)"getFileTypeByFileName(...)");
            boolean bl2 = notKnown = !Intrinsics.areEqual((Object)fileTypeByExtension, (Object)KotlinFileType.INSTANCE);
            if (notKnown) {
                ScriptUtilsKt.scriptingWarnLog("extension " + it + " file type [" + fileTypeByExtension.getName() + "] is not registered as " + KotlinFileType.INSTANCE.getName());
            }
            if (!notKnown) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Set newExtensions = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        if (!((Collection)newExtensions).isEmpty()) {
            ScriptUtilsKt.scriptingWarnLog("extensions " + newExtensions + " is about to be registered as " + KotlinFileType.INSTANCE.getName());
            ApplicationManager.getApplication().invokeLater(() -> ScriptDefinitionsManager.associateFileExtensionsIfNeeded$lambda$5(newExtensions, fileTypeManager));
        }
    }

    @Override
    public void dispose() {
        super.dispose();
        this.clearCache();
        this.definitionsBySource.clear();
        this.definitions = null;
        this.activatedDefinitionSources.clear();
        this.failedContributorsHashes.clear();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    protected List<ScriptDefinitionsSource> getSources() {
        void $this$mapTo$iv$iv;
        Collection collection;
        void $this$mapTo$iv$iv2;
        List list2 = this.project.getExtensionArea().getExtensionPoint(ScriptTemplatesProvider.Companion.getEP_NAME()).getExtensionList();
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getExtensionList(...)");
        Iterable $this$map$iv = list2;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            void it;
            ScriptTemplatesProvider scriptTemplatesProvider = (ScriptTemplatesProvider)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it);
            collection.add(ScriptDefinitionContributorKt.asSource(new ScriptTemplatesProviderAdapter((ScriptTemplatesProvider)it)));
        }
        List fromDeprecatedEP = (List)destination$iv$iv;
        List list3 = ScriptDefinitionContributor.Companion.getEP_NAME().getPoint((AreaInstance)this.project).getExtensionList();
        Intrinsics.checkNotNullExpressionValue((Object)list3, (String)"getExtensionList(...)");
        Iterable $this$map$iv2 = list3;
        boolean $i$f$map2 = false;
        destination$iv$iv = $this$map$iv2;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            ScriptDefinitionContributor bl = (ScriptDefinitionContributor)item$iv$iv;
            collection = destination$iv$iv2;
            boolean bl2 = false;
            Intrinsics.checkNotNull((Object)it);
            collection.add(ScriptDefinitionContributorKt.asSource((ScriptDefinitionContributor)it));
        }
        List fromNewEp = (List)destination$iv$iv2;
        return CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)CollectionsKt.dropLast((List)fromNewEp, (int)1), (Iterable)fromDeprecatedEP), (Object)CollectionsKt.last((List)fromNewEp));
    }

    @NotNull
    protected KotlinScriptingSettings getKotlinScriptingSettings() {
        return KotlinScriptingSettings.Companion.getInstance(this.project);
    }

    @Nullable
    protected ScriptDefinition tryGetScriptDefinitionFast(@NotNull String locationId) {
        Intrinsics.checkNotNullParameter((Object)locationId, (String)"locationId");
        return ScriptConfigurationManager.Companion.compositeScriptConfigurationManager(this.project).tryGetScriptDefinitionFast(locationId);
    }

    protected void applyDefinitionsUpdate() {
        this.associateFileExtensionsIfNeeded();
        ScriptConfigurationManager.Companion.getInstance(this.project).updateScriptDefinitionReferences();
    }

    protected boolean isScratchFile(@NotNull SourceCode script) {
        VirtualFile virtualFile2;
        Intrinsics.checkNotNullParameter((Object)script, (String)"script");
        if (script instanceof VirtualFileScriptSource) {
            virtualFile2 = ((VirtualFileScriptSource)script).getVirtualFile();
        } else {
            String string = script.getLocationId();
            if (string != null) {
                String it = string;
                boolean bl = false;
                virtualFile2 = VirtualFileManager.getInstance().findFileByUrl(it);
            } else {
                virtualFile2 = null;
            }
        }
        VirtualFile virtualFile3 = virtualFile2;
        return virtualFile3 != null && ScratchFileService.getInstance().getRootType(virtualFile3) instanceof ScratchRootType;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    protected BundledScriptDefinitionContributor getBundledScriptDefinitionContributor() {
        void $this$filterIsInstanceTo$iv$iv$iv;
        void this_$iv;
        ScriptDefinitionContributor.Companion companion = ScriptDefinitionContributor.Companion;
        Project project$iv = this.project;
        boolean $i$f$find = false;
        List list2 = this_$iv.getEP_NAME().getPoint((AreaInstance)project$iv).getExtensionList();
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getExtensionList(...)");
        Iterable $this$filterIsInstance$iv$iv = list2;
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv$iv;
        Collection destination$iv$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv$iv : $this$filterIsInstanceTo$iv$iv$iv) {
            if (!(element$iv$iv$iv instanceof BundledScriptDefinitionContributor)) continue;
            destination$iv$iv$iv.add(element$iv$iv$iv);
        }
        return (BundledScriptDefinitionContributor)CollectionsKt.firstOrNull((List)((List)destination$iv$iv$iv));
    }

    protected void executeUnderReadLock(@NotNull Function0<Unit> block2) {
        Intrinsics.checkNotNullParameter(block2, (String)"block");
        ActionsKt.runReadAction((Function0)((Function0)new Function0<Unit>(block2){
            final /* synthetic */ Function0<Unit> $block;
            {
                this.$block = $block;
                super(0);
            }

            public final void invoke() {
                this.$block.invoke();
            }
        }));
    }

    private static final void associateFileExtensionsIfNeeded$lambda$5(Set $newExtensions, FileTypeManager $fileTypeManager) {
        Intrinsics.checkNotNullParameter((Object)$newExtensions, (String)"$newExtensions");
        ActionsKt.runWriteAction((Function0)((Function0)new Function0<Unit>((Set<String>)$newExtensions, $fileTypeManager){
            final /* synthetic */ Set<String> $newExtensions;
            final /* synthetic */ FileTypeManager $fileTypeManager;
            {
                this.$newExtensions = $newExtensions;
                this.$fileTypeManager = $fileTypeManager;
                super(0);
            }

            /*
             * WARNING - void declaration
             */
            public final void invoke() {
                void $this$forEach$iv;
                Iterable iterable = this.$newExtensions;
                FileTypeManager fileTypeManager = this.$fileTypeManager;
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    String it = (String)element$iv;
                    boolean bl = false;
                    fileTypeManager.associateExtension((FileType)KotlinFileType.INSTANCE, it);
                }
            }
        }));
    }

    public static final /* synthetic */ List access$getDefinitions$p(ScriptDefinitionsManager $this) {
        return $this.definitions;
    }

    public static final /* synthetic */ void access$clearCache(ScriptDefinitionsManager $this) {
        $this.clearCache();
    }

    public static final /* synthetic */ void access$setDefinitions$p(ScriptDefinitionsManager $this, List list2) {
        $this.definitions = list2;
    }

    public static final /* synthetic */ ReentrantLock access$getDefinitionsLock$p(ScriptDefinitionsManager $this) {
        return $this.definitionsLock;
    }

    public static final /* synthetic */ Map access$getDefinitionsBySource$p(ScriptDefinitionsManager $this) {
        return $this.definitionsBySource;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/idea/core/script/ScriptDefinitionsManager$Companion;", "", "()V", "getInstance", "Lorg/jetbrains/kotlin/idea/core/script/ScriptDefinitionsManager;", "project", "Lcom/intellij/openapi/project/Project;", "kotlin.base.scripting"})
    @SourceDebugExtension(value={"SMAP\nScriptDefinitionsManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ScriptDefinitionsManager.kt\norg/jetbrains/kotlin/idea/core/script/ScriptDefinitionsManager$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,323:1\n31#2,2:324\n*S KotlinDebug\n*F\n+ 1 ScriptDefinitionsManager.kt\norg/jetbrains/kotlin/idea/core/script/ScriptDefinitionsManager$Companion\n*L\n56#1:324,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ScriptDefinitionsManager getInstance(@NotNull Project project2) {
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            ComponentManager $this$service$iv = (ComponentManager)project2;
            boolean $i$f$service = false;
            Class<ScriptDefinitionProvider> serviceClass$iv = ScriptDefinitionProvider.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.idea.core.script.ScriptDefinitionsManager");
            return (ScriptDefinitionsManager)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

