/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.core.script;

import com.intellij.openapi.vfs.StandardFileSystems;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileSystem;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u0011B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\r\u001a\u0004\u0018\u00010\b2\u0006\u0010\u000e\u001a\u00020\nJ\u0006\u0010\u000f\u001a\u00020\u0010R(\u0010\u0003\u001a\u001c\u0012\u0004\u0012\u00020\u0005\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\u0007\u0012\u0006\u0012\u0004\u0018\u00010\b0\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\t\u001a\u00020\u0007*\u00020\n8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/idea/core/script/ClasspathToVfsConverter;", "", "()V", "cache", "Ljava/util/concurrent/ConcurrentHashMap;", "", "Lkotlin/Pair;", "Lorg/jetbrains/kotlin/idea/core/script/ClasspathToVfsConverter$FileType;", "Lcom/intellij/openapi/vfs/VirtualFile;", "fileType", "Ljava/nio/file/Path;", "getFileType", "(Ljava/nio/file/Path;)Lorg/jetbrains/kotlin/idea/core/script/ClasspathToVfsConverter$FileType;", "classpathEntryToVfs", "path", "clearCaches", "", "FileType", "kotlin.base.scripting"})
public final class ClasspathToVfsConverter {
    @NotNull
    public static final ClasspathToVfsConverter INSTANCE = new ClasspathToVfsConverter();
    @NotNull
    private static final ConcurrentHashMap<String, Pair<FileType, VirtualFile>> cache = new ConcurrentHashMap();

    private ClasspathToVfsConverter() {
    }

    private final FileType getFileType(Path $this$fileType) {
        FileType fileType;
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (Files.notExists($this$fileType, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            fileType = FileType.NOT_EXISTS;
        } else {
            LinkOption[] linkOptionArray2 = new LinkOption[]{};
            if (Files.isDirectory($this$fileType, Arrays.copyOf(linkOptionArray2, linkOptionArray2.length))) {
                fileType = FileType.DIRECTORY;
            } else {
                LinkOption[] linkOptionArray3 = new LinkOption[]{};
                fileType = Files.isRegularFile($this$fileType, Arrays.copyOf(linkOptionArray3, linkOptionArray3.length)) ? FileType.REGULAR_FILE : FileType.UNKNOWN;
            }
        }
        return fileType;
    }

    public final void clearCaches() {
        cache.clear();
    }

    @Nullable
    public final VirtualFile classpathEntryToVfs(@NotNull Path path2) {
        VirtualFile oldVFile;
        block4: {
            FileType newType;
            String key;
            block3: {
                Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
                key = ((Object)path2).toString();
                newType = this.getFileType(path2);
                Pair pair = cache.computeIfAbsent(key, arg_0 -> ClasspathToVfsConverter.classpathEntryToVfs$lambda$0((Function1)new Function1<String, Pair<? extends FileType, ? extends VirtualFile>>(newType){
                    final /* synthetic */ FileType $newType;
                    {
                        this.$newType = $newType;
                        super(1, Intrinsics.Kotlin.class, "compute", "classpathEntryToVfs$compute(Lorg/jetbrains/kotlin/idea/core/script/ClasspathToVfsConverter$FileType;Ljava/lang/String;)Lkotlin/Pair;", 0);
                    }

                    @NotNull
                    public final Pair<FileType, VirtualFile> invoke(@NotNull String p0) {
                        Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                        return ClasspathToVfsConverter.access$classpathEntryToVfs$compute(this.$newType, p0);
                    }
                }, arg_0));
                FileType oldType = (FileType)((Object)pair.component1());
                oldVFile = (VirtualFile)pair.component2();
                if (oldType != newType) break block3;
                VirtualFile virtualFile2 = oldVFile;
                boolean bl = virtualFile2 != null ? !virtualFile2.isValid() : false;
                if (!bl && (oldVFile != null || oldType != FileType.DIRECTORY && oldType != FileType.REGULAR_FILE)) break block4;
            }
            Pair pair = cache.compute(key, (arg_0, arg_1) -> ClasspathToVfsConverter.classpathEntryToVfs$lambda$1((Function2)new Function2<String, Pair<? extends FileType, ? extends VirtualFile>, Pair<? extends FileType, ? extends VirtualFile>>(newType){
                final /* synthetic */ FileType $newType;
                {
                    this.$newType = $newType;
                    super(2);
                }

                @Nullable
                public final Pair<FileType, VirtualFile> invoke(@NotNull String k, @Nullable Pair<? extends FileType, ? extends VirtualFile> pair) {
                    Intrinsics.checkNotNullParameter((Object)k, (String)"k");
                    return ClasspathToVfsConverter.access$classpathEntryToVfs$compute(this.$newType, k);
                }
            }, arg_0, arg_1));
            return pair != null ? (VirtualFile)pair.getSecond() : null;
        }
        return oldVFile;
    }

    private static final Pair<FileType, VirtualFile> classpathEntryToVfs$compute(FileType newType, String filePath2) {
        return TuplesKt.to((Object)((Object)newType), switch (WhenMappings.$EnumSwitchMapping$0[newType.ordinal()]) {
            case 1 -> null;
            case 2 -> {
                VirtualFileSystem v1 = StandardFileSystems.local();
                if (v1 != null) {
                    yield v1.refreshAndFindFileByPath(filePath2);
                }
                yield null;
            }
            case 3 -> {
                VirtualFileSystem v2 = StandardFileSystems.jar();
                if (v2 != null) {
                    yield v2.refreshAndFindFileByPath(filePath2 + "!/");
                }
                yield null;
            }
            case 4 -> null;
            default -> throw new NoWhenBranchMatchedException();
        });
    }

    private static final Pair classpathEntryToVfs$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Pair)$tmp0.invoke(p0);
    }

    private static final Pair classpathEntryToVfs$lambda$1(Function2 $tmp0, Object p0, Object p1) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Pair)$tmp0.invoke(p0, p1);
    }

    public static final /* synthetic */ Pair access$classpathEntryToVfs$compute(FileType newType, String filePath2) {
        return ClasspathToVfsConverter.classpathEntryToVfs$compute(newType, filePath2);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0082\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/idea/core/script/ClasspathToVfsConverter$FileType;", "", "(Ljava/lang/String;I)V", "NOT_EXISTS", "DIRECTORY", "REGULAR_FILE", "UNKNOWN", "kotlin.base.scripting"})
    private static final class FileType
    extends Enum<FileType> {
        public static final /* enum */ FileType NOT_EXISTS = new FileType();
        public static final /* enum */ FileType DIRECTORY = new FileType();
        public static final /* enum */ FileType REGULAR_FILE = new FileType();
        public static final /* enum */ FileType UNKNOWN = new FileType();
        private static final /* synthetic */ FileType[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static FileType[] values() {
            return (FileType[])$VALUES.clone();
        }

        public static FileType valueOf(String value2) {
            return Enum.valueOf(FileType.class, value2);
        }

        @NotNull
        public static EnumEntries<FileType> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = fileTypeArray = new FileType[]{FileType.NOT_EXISTS, FileType.DIRECTORY, FileType.REGULAR_FILE, FileType.UNKNOWN};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[FileType.values().length];
            try {
                nArray[FileType.NOT_EXISTS.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[FileType.DIRECTORY.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[FileType.REGULAR_FILE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[FileType.UNKNOWN.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

