/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.completion.lookups.factories;

import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.psi.PsiFile;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.completion.lookups.ImportStrategy;
import org.jetbrains.kotlin.idea.completion.lookups.ImportStrategyKt;
import org.jetbrains.kotlin.idea.completion.lookups.QuotedNamesAwareInsertionHandler;
import org.jetbrains.kotlin.idea.completion.lookups.factories.ClassifierLookupObject;
import org.jetbrains.kotlin.idea.completion.lookups.factories.InsertionUtilsKt;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.renderer.RenderingUtilsKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c2\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/idea/completion/lookups/factories/ClassifierInsertionHandler;", "Lorg/jetbrains/kotlin/idea/completion/lookups/QuotedNamesAwareInsertionHandler;", "()V", "handleInsert", "", "context", "Lcom/intellij/codeInsight/completion/InsertionContext;", "item", "Lcom/intellij/codeInsight/lookup/LookupElement;", "kotlin.completion.impl.k2"})
final class ClassifierInsertionHandler
extends QuotedNamesAwareInsertionHandler {
    @NotNull
    public static final ClassifierInsertionHandler INSTANCE = new ClassifierInsertionHandler();

    private ClassifierInsertionHandler() {
    }

    @Override
    public void handleInsert(@NotNull InsertionContext context2, @NotNull LookupElement item) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        PsiFile psiFile2 = context2.getFile();
        KtFile ktFile2 = psiFile2 instanceof KtFile ? (KtFile)psiFile2 : null;
        if (ktFile2 == null) {
            return;
        }
        KtFile targetFile2 = ktFile2;
        Object object = item.getObject();
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.idea.completion.lookups.factories.ClassifierLookupObject");
        ClassifierLookupObject lookupObject = (ClassifierLookupObject)object;
        ImportStrategy importingStrategy = lookupObject.getImportingStrategy();
        super.handleInsert(context2, item);
        if (importingStrategy instanceof ImportStrategy.InsertFqNameAndShorten) {
            String fqNameRendered = RenderingUtilsKt.render((FqName)((ImportStrategy.InsertFqNameAndShorten)importingStrategy).getFqName());
            InsertionUtilsKt.insertAndShortenReferencesInStringUsingTemporarySuffix(context2, fqNameRendered);
        } else if (importingStrategy instanceof ImportStrategy.AddImport) {
            ImportStrategyKt.addImportIfRequired(targetFile2, ((ImportStrategy.AddImport)importingStrategy).getNameToImport());
        }
    }
}

