/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.completion.handlers;

import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.completion.handlers.HandlerUtilsKt;
import org.jetbrains.kotlin.idea.completion.handlers.KotlinCallableInsertHandler;
import org.jetbrains.kotlin.idea.util.CallType;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0011\u0012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0018\u0010\t\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/idea/completion/handlers/KotlinPropertyInsertHandler;", "Lorg/jetbrains/kotlin/idea/completion/handlers/KotlinCallableInsertHandler;", "callType", "Lorg/jetbrains/kotlin/idea/util/CallType;", "(Lorg/jetbrains/kotlin/idea/util/CallType;)V", "deleteEmptyParenthesis", "", "context", "Lcom/intellij/codeInsight/completion/InsertionContext;", "handleInsert", "item", "Lcom/intellij/codeInsight/lookup/LookupElement;", "kotlin.completion.impl.k1"})
public final class KotlinPropertyInsertHandler
extends KotlinCallableInsertHandler {
    public KotlinPropertyInsertHandler(@NotNull CallType<?> callType) {
        Intrinsics.checkNotNullParameter(callType, (String)"callType");
        super(callType);
    }

    @Override
    public void handleInsert(@NotNull InsertionContext context2, @NotNull LookupElement item) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        boolean surroundedWithBraces = HandlerUtilsKt.surroundWithBracesIfInStringTemplate(context2);
        super.handleInsert(context2, item);
        if (context2.getCompletionChar() == '\t') {
            this.deleteEmptyParenthesis(context2);
        }
        if (surroundedWithBraces) {
            HandlerUtilsKt.removeRedundantBracesInStringTemplate(context2);
        }
    }

    private final void deleteEmptyParenthesis(InsertionContext context2) {
        PsiDocumentManager psiDocumentManager = PsiDocumentManager.getInstance((Project)context2.getProject());
        psiDocumentManager.commitDocument(context2.getDocument());
        psiDocumentManager.doPostponedOperationsAndUnblockDocument(context2.getDocument());
        int offset2 = context2.getTailOffset();
        Document document = context2.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
        Document document2 = document;
        CharSequence charSequence = document2.getCharsSequence();
        Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"getCharsSequence(...)");
        CharSequence chars = charSequence;
        Integer n = HandlerUtilsKt.indexOfSkippingSpace(chars, '(', offset2);
        if (n == null) {
            return;
        }
        int lParenOffset = n;
        Integer n2 = HandlerUtilsKt.indexOfSkippingSpace(chars, ')', lParenOffset + 1);
        if (n2 == null) {
            return;
        }
        int rParenOffset = n2;
        document2.deleteString(offset2, rParenOffset + 1);
    }
}

