/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.codeinsight.api.classic.inspections;

import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.base.projectStructure.LanguageVersionSettingsProviderUtils;
import org.jetbrains.kotlin.idea.codeinsight.api.classic.inspections.AbstractKotlinInspection;
import org.jetbrains.kotlin.idea.statistics.InspectionData;
import org.jetbrains.kotlin.idea.statistics.LanguageFeatureDeprecationCollector;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b&\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003B#\u0012\u0010\b\u0002\u0010\u0004\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00018\u0000\u00a2\u0006\u0002\u0010\u0007J\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0018\u0010\u0016\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u001d\u0010\u0019\u001a\u00020\u00122\u0006\u0010\u001a\u001a\u00028\u00002\u0006\u0010\u001b\u001a\u00020\u001cH\u0016\u00a2\u0006\u0002\u0010\u001dJ\f\u0010\u001e\u001a\u00020\u0018*\u00020\u000eH\u0002J \u0010\u001f\u001a\u00020\u0012*\u00020\u000e2\u0012\u0010 \u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00000!H\u0004R\u0016\u0010\u0004\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0006\u001a\u0004\u0018\u00018\u0000X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\bR!\u0010\t\u001a\u0015\u0012\f\u0012\n \u000b*\u0004\u0018\u00018\u00008\u00000\n\u00a2\u0006\u0002\b\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\r\u001a\u0004\u0018\u00018\u0000*\u00020\u000e8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\""}, d2={"Lorg/jetbrains/kotlin/idea/codeinsight/api/classic/inspections/DeprecationCollectingInspection;", "T", "Lorg/jetbrains/kotlin/idea/statistics/InspectionData;", "Lorg/jetbrains/kotlin/idea/codeinsight/api/classic/inspections/AbstractKotlinInspection;", "collector", "Lorg/jetbrains/kotlin/idea/statistics/LanguageFeatureDeprecationCollector;", "defaultDeprecationData", "(Lorg/jetbrains/kotlin/idea/statistics/LanguageFeatureDeprecationCollector;Lorg/jetbrains/kotlin/idea/statistics/InspectionData;)V", "Lorg/jetbrains/kotlin/idea/statistics/InspectionData;", "deprecationDataKey", "Lcom/intellij/openapi/util/Key;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "deprecationData", "Lcom/intellij/codeInspection/LocalInspectionToolSession;", "getDeprecationData", "(Lcom/intellij/codeInspection/LocalInspectionToolSession;)Lorg/jetbrains/kotlin/idea/statistics/InspectionData;", "inspectionFinished", "", "session", "problemsHolder", "Lcom/intellij/codeInspection/ProblemsHolder;", "inspectionStarted", "isOnTheFly", "", "reportDeprecationData", "inspectionData", "file", "Lcom/intellij/psi/PsiFile;", "(Lorg/jetbrains/kotlin/idea/statistics/InspectionData;Lcom/intellij/psi/PsiFile;)V", "isFullInspection", "updateDeprecationData", "f", "Lkotlin/Function1;", "kotlin.code-insight.api"})
public abstract class DeprecationCollectingInspection<T extends InspectionData>
extends AbstractKotlinInspection {
    @Nullable
    private final LanguageFeatureDeprecationCollector<T> collector;
    @Nullable
    private final T defaultDeprecationData;
    @NotNull
    private final Key<T> deprecationDataKey;

    public DeprecationCollectingInspection(@Nullable LanguageFeatureDeprecationCollector<T> collector2, @Nullable T defaultDeprecationData) {
        this.collector = collector2;
        this.defaultDeprecationData = defaultDeprecationData;
        Key key = Key.create((String)"deprecation_data");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"create(...)");
        this.deprecationDataKey = key;
    }

    public /* synthetic */ DeprecationCollectingInspection(LanguageFeatureDeprecationCollector languageFeatureDeprecationCollector, InspectionData inspectionData, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            languageFeatureDeprecationCollector = null;
        }
        if ((n & 2) != 0) {
            inspectionData = null;
        }
        this(languageFeatureDeprecationCollector, inspectionData);
    }

    private final T getDeprecationData(LocalInspectionToolSession $this$deprecationData) {
        return (T)((InspectionData)$this$deprecationData.getUserData(this.deprecationDataKey));
    }

    private final boolean isFullInspection(LocalInspectionToolSession $this$isFullInspection) {
        return Intrinsics.areEqual((Object)$this$isFullInspection.getPriorityRange(), (Object)$this$isFullInspection.getFile().getTextRange()) && Intrinsics.areEqual((Object)$this$isFullInspection.getRestrictRange(), (Object)$this$isFullInspection.getFile().getTextRange());
    }

    protected final void updateDeprecationData(@NotNull LocalInspectionToolSession $this$updateDeprecationData, @NotNull Function1<? super T, ? extends T> f2) {
        Intrinsics.checkNotNullParameter((Object)$this$updateDeprecationData, (String)"<this>");
        Intrinsics.checkNotNullParameter(f2, (String)"f");
        T t = this.getDeprecationData($this$updateDeprecationData);
        if (t == null) {
            return;
        }
        T existingData = t;
        $this$updateDeprecationData.putUserData(this.deprecationDataKey, f2.invoke(existingData));
    }

    public void inspectionStarted(@NotNull LocalInspectionToolSession session, boolean isOnTheFly) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)session, (String)"session");
            if (!this.isFullInspection(session)) {
                return;
            }
            T t = this.defaultDeprecationData;
            if (t == null) break block1;
            T it = t;
            boolean bl = false;
            session.putUserData(this.deprecationDataKey, it);
        }
    }

    public void inspectionFinished(@NotNull LocalInspectionToolSession session, @NotNull ProblemsHolder problemsHolder) {
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter((Object)problemsHolder, (String)"problemsHolder");
        if (!this.isFullInspection(session)) {
            return;
        }
        T t = this.getDeprecationData(session);
        if (t == null && (t = this.defaultDeprecationData) == null) {
            return;
        }
        T data = t;
        PsiFile psiFile2 = problemsHolder.getFile();
        Intrinsics.checkNotNullExpressionValue((Object)psiFile2, (String)"getFile(...)");
        this.reportDeprecationData(data, psiFile2);
    }

    public void reportDeprecationData(@NotNull T inspectionData, @NotNull PsiFile file2) {
        block0: {
            Intrinsics.checkNotNullParameter(inspectionData, (String)"inspectionData");
            Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
            LanguageFeatureDeprecationCollector<T> languageFeatureDeprecationCollector = this.collector;
            if (languageFeatureDeprecationCollector == null) break block0;
            languageFeatureDeprecationCollector.logInspectionUpdated(file2, inspectionData, LanguageVersionSettingsProviderUtils.getLanguageVersionSettings((PsiElement)file2).getLanguageVersion());
        }
    }

    public DeprecationCollectingInspection() {
        this(null, null, 3, null);
    }
}

