/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.codeInsight.inspections.shared.runBlocking.rbgraph;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.codeInsight.inspections.shared.runBlocking.rbgraph.CallEdge;
import org.jetbrains.kotlin.idea.codeInsight.inspections.shared.runBlocking.rbgraph.FunctionNode;
import org.jetbrains.kotlin.idea.codeInsight.inspections.shared.runBlocking.rbgraph.RBGraphKt;
import org.jetbrains.kotlin.idea.codeInsight.inspections.shared.runBlocking.utils.MyPsiUtils;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtNameReferenceExpression;
import org.jetbrains.kotlin.psi.KtNamedFunction;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\r\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000fJ\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\nH\u0002J\u0006\u0010\u0014\u001a\u00020\u0011J&\u0010\u0015\u001a\u00020\u00112\u0006\u0010\u0016\u001a\u00020\n2\u0006\u0010\u0017\u001a\u00020\n2\u0006\u0010\u0018\u001a\u00020\n2\u0006\u0010\u0019\u001a\u00020\nJ&\u0010\u0015\u001a\u00020\u00112\u0006\u0010\u001a\u001a\u00020\u000b2\u0006\u0010\u001b\u001a\u00020\u000b2\u0006\u0010\u0018\u001a\u00020\n2\u0006\u0010\u0019\u001a\u00020\nJ\u000e\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\nJ\u0014\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00050 2\u0006\u0010!\u001a\u00020\u000bJ\u000e\u0010\"\u001a\u00020\u000b2\u0006\u0010\u001e\u001a\u00020\nJ(\u0010#\u001a\u00020\u000b2\u0006\u0010\u001e\u001a\u00020\n2\u0006\u0010$\u001a\u00020\n2\u0006\u0010%\u001a\u00020\n2\u0006\u0010&\u001a\u00020\nH\u0002J\u000e\u0010'\u001a\u00020\u000b2\u0006\u0010(\u001a\u00020)J\u0016\u0010*\u001a\u00020\u001d2\u0006\u0010\u0016\u001a\u00020\n2\u0006\u0010\u0017\u001a\u00020\nR\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R \u0010\b\u001a\u0014\u0012\u0004\u0012\u00020\n\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\u00040\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Lorg/jetbrains/kotlin/idea/codeInsight/inspections/shared/runBlocking/rbgraph/RBGraph;", "", "()V", "edges", "", "Lorg/jetbrains/kotlin/idea/codeInsight/inspections/shared/runBlocking/rbgraph/CallEdge;", "getEdges", "()Ljava/util/Set;", "fileMap", "", "", "Lorg/jetbrains/kotlin/idea/codeInsight/inspections/shared/runBlocking/rbgraph/FunctionNode;", "functionMap", "addBuilder", "psiElement", "Lcom/intellij/psi/PsiElement;", "addToFileMap", "", "fn", "filePath", "clear", "connect", "parentId", "childId", "callSite", "lineAndFile", "parent", "child", "containsFun", "", "id", "findBuilderBFS", "", "start", "getFunction", "getOrAddBuilderToFM", "declerationSite", "fqName", "fileAndLine", "getOrCreateFunction", "func", "Lorg/jetbrains/kotlin/psi/KtNamedFunction;", "isConnected", "kotlin.code-insight.inspections.shared"})
@SourceDebugExtension(value={"SMAP\nRBGraph.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RBGraph.kt\norg/jetbrains/kotlin/idea/codeInsight/inspections/shared/runBlocking/rbgraph/RBGraph\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,148:1\n372#2,7:149\n372#2,7:170\n372#2,7:177\n1747#3,3:156\n1855#3,2:159\n766#3:161\n857#3,2:162\n1549#3:164\n1620#3,3:165\n1855#3,2:168\n*S KotlinDebug\n*F\n+ 1 RBGraph.kt\norg/jetbrains/kotlin/idea/codeInsight/inspections/shared/runBlocking/rbgraph/RBGraph\n*L\n45#1:149,7\n141#1:170,7\n145#1:177,7\n95#1:156,3\n108#1:159,2\n122#1:161\n122#1:162,2\n123#1:164\n123#1:165,3\n124#1:168,2\n*E\n"})
public final class RBGraph {
    @NotNull
    private Map<String, FunctionNode> functionMap = new LinkedHashMap();
    @NotNull
    private final Map<String, Set<FunctionNode>> fileMap = new LinkedHashMap();
    @NotNull
    private final Set<CallEdge> edges = new LinkedHashSet();

    @NotNull
    public final Set<CallEdge> getEdges() {
        return this.edges;
    }

    public final void clear() {
        this.functionMap.clear();
        this.fileMap.clear();
        this.edges.clear();
    }

    @NotNull
    public final FunctionNode addBuilder(@NotNull PsiElement psiElement2) {
        Intrinsics.checkNotNullParameter((Object)psiElement2, (String)"psiElement");
        if (!(psiElement2 instanceof KtCallExpression)) {
            RBGraphKt.getLOG().error((Throwable)new IllegalArgumentException("Builder must be KtCallExpression"));
            return new FunctionNode("", "", "", "", false);
        }
        String string = ((KtCallExpression)psiElement2).getContainingFile().getVirtualFile().getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
        String filePath2 = string;
        KtExpression ktExpression = ((KtCallExpression)psiElement2).getCalleeExpression();
        Intrinsics.checkNotNull((Object)ktExpression, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtNameReferenceExpression");
        KtNameReferenceExpression callee = (KtNameReferenceExpression)ktExpression;
        PsiReference psiReference = callee.getReference();
        Object object = psiReference != null ? psiReference.resolve() : null;
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtNamedFunction");
        KtNamedFunction ktFun = (KtNamedFunction)object;
        String fqName2 = String.valueOf(ktFun.getFqName());
        String fileAndLine = MyPsiUtils.Companion.getFileAndLine(psiElement2);
        String string2 = MyPsiUtils.Companion.getUrl(psiElement2);
        if (string2 == null) {
            string2 = "";
        }
        String url = string2;
        FunctionNode functionNode = this.getOrAddBuilderToFM(fqName2 + "_" + url, url, fqName2, fileAndLine);
        this.addToFileMap(functionNode, filePath2);
        functionNode.setBuilder(true);
        return functionNode;
    }

    @NotNull
    public final FunctionNode getOrCreateFunction(@NotNull KtNamedFunction func) {
        FunctionNode functionNode;
        Intrinsics.checkNotNullParameter((Object)func, (String)"func");
        String id = FunctionNode.Companion.generateId(func);
        String string = func.getContainingFile().getVirtualFile().getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
        String filePath2 = string;
        Map<String, FunctionNode> $this$getOrPut$iv = this.functionMap;
        boolean $i$f$getOrPut = false;
        FunctionNode value$iv = $this$getOrPut$iv.get(id);
        if (value$iv == null) {
            boolean bl = false;
            FunctionNode node2 = new FunctionNode(func);
            this.addToFileMap(node2, filePath2);
            FunctionNode answer$iv = node2;
            $this$getOrPut$iv.put(id, answer$iv);
            functionNode = answer$iv;
        } else {
            functionNode = value$iv;
        }
        return functionNode;
    }

    public final boolean containsFun(@NotNull String id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        return this.functionMap.containsKey(id);
    }

    @NotNull
    public final FunctionNode getFunction(@NotNull String id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        FunctionNode functionNode = this.functionMap.get(id);
        Intrinsics.checkNotNull((Object)functionNode);
        return functionNode;
    }

    public final void connect(@NotNull FunctionNode parent2, @NotNull FunctionNode child2, @NotNull String callSite, @NotNull String lineAndFile) {
        Intrinsics.checkNotNullParameter((Object)parent2, (String)"parent");
        Intrinsics.checkNotNullParameter((Object)child2, (String)"child");
        Intrinsics.checkNotNullParameter((Object)callSite, (String)"callSite");
        Intrinsics.checkNotNullParameter((Object)lineAndFile, (String)"lineAndFile");
        this.connect(parent2.getId(), child2.getId(), callSite, lineAndFile);
    }

    public final void connect(@NotNull String parentId, @NotNull String childId, @NotNull String callSite, @NotNull String lineAndFile) {
        Intrinsics.checkNotNullParameter((Object)parentId, (String)"parentId");
        Intrinsics.checkNotNullParameter((Object)childId, (String)"childId");
        Intrinsics.checkNotNullParameter((Object)callSite, (String)"callSite");
        Intrinsics.checkNotNullParameter((Object)lineAndFile, (String)"lineAndFile");
        if (this.isConnected(parentId, childId)) {
            return;
        }
        FunctionNode functionNode = this.functionMap.get(parentId);
        Intrinsics.checkNotNull((Object)functionNode);
        FunctionNode parent2 = functionNode;
        FunctionNode functionNode2 = this.functionMap.get(childId);
        Intrinsics.checkNotNull((Object)functionNode2);
        FunctionNode child2 = functionNode2;
        CallEdge newCallEdge = new CallEdge(parent2, child2, callSite, lineAndFile);
        this.edges.add(newCallEdge);
        parent2.addChild(newCallEdge);
        child2.addParent(newCallEdge);
    }

    public final boolean isConnected(@NotNull String parentId, @NotNull String childId) {
        boolean bl;
        block4: {
            Intrinsics.checkNotNullParameter((Object)parentId, (String)"parentId");
            Intrinsics.checkNotNullParameter((Object)childId, (String)"childId");
            FunctionNode parent2 = this.functionMap.get(parentId);
            FunctionNode child2 = this.functionMap.get(childId);
            if (parent2 == null || child2 == null) {
                return false;
            }
            Iterable $this$any$iv = parent2.getChildEdges();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    CallEdge it = (CallEdge)element$iv;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual((Object)it.getChild(), (Object)child2)) continue;
                    bl = true;
                    break block4;
                }
                bl = false;
            }
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<CallEdge> findBuilderBFS(@NotNull FunctionNode start2) {
        Intrinsics.checkNotNullParameter((Object)start2, (String)"start");
        Map cameFrom = new LinkedHashMap();
        Iterable $this$forEach$iv = this.functionMap.values();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            FunctionNode it = (FunctionNode)element$iv;
            boolean bl = false;
            it.setVisited(false);
        }
        Queue queue = new LinkedList();
        queue.add(start2);
        FunctionNode builderNode = start2;
        while (!queue.isEmpty()) {
            void $this$forEach$iv2;
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv;
            CallEdge it;
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv;
            Object element$iv;
            FunctionNode currentNode = (FunctionNode)queue.poll();
            if (currentNode.isBuilder() || currentNode.isSuspend()) {
                Intrinsics.checkNotNull((Object)currentNode);
                builderNode = currentNode;
                break;
            }
            currentNode.setVisited(true);
            element$iv = currentNode.getParentEdges();
            boolean $i$f$filter = false;
            void bl = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (CallEdge)element$iv$iv;
                boolean bl2 = false;
                if (!(!it.getParent().getVisited())) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            boolean $i$f$map = false;
            $this$filterTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                it = (CallEdge)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl3 = false;
                collection.add(it);
            }
            $this$map$iv = (List)destination$iv$iv;
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                CallEdge it2 = (CallEdge)element$iv2;
                boolean bl4 = false;
                queue.add(it2.getParent());
                cameFrom.put(it2.getParent(), it2);
            }
        }
        CallEdge callEdge = (CallEdge)cameFrom.get(builderNode);
        if (callEdge == null) {
            return CollectionsKt.emptyList();
        }
        CallEdge backTrackEdge = callEdge;
        Object[] objectArray = new CallEdge[]{backTrackEdge};
        List traceAccumulator = CollectionsKt.mutableListOf((Object[])objectArray);
        while (!Intrinsics.areEqual((Object)backTrackEdge.getChild(), (Object)start2)) {
            Object v = cameFrom.get(backTrackEdge.getChild());
            Intrinsics.checkNotNull(v);
            backTrackEdge = (CallEdge)v;
            traceAccumulator.add(backTrackEdge);
        }
        return traceAccumulator;
    }

    private final FunctionNode getOrAddBuilderToFM(String id, String declerationSite, String fqName2, String fileAndLine) {
        FunctionNode functionNode;
        Map<String, FunctionNode> $this$getOrPut$iv = this.functionMap;
        boolean $i$f$getOrPut = false;
        FunctionNode value$iv = $this$getOrPut$iv.get(id);
        if (value$iv == null) {
            boolean bl = false;
            FunctionNode answer$iv = new FunctionNode(id, declerationSite, fqName2, fileAndLine, false);
            $this$getOrPut$iv.put(id, answer$iv);
            functionNode = answer$iv;
        } else {
            functionNode = value$iv;
        }
        return functionNode;
    }

    private final void addToFileMap(FunctionNode fn, String filePath2) {
        Set set;
        Map<String, Set<FunctionNode>> $this$getOrPut$iv = this.fileMap;
        boolean $i$f$getOrPut = false;
        Set value$iv = $this$getOrPut$iv.get(filePath2);
        if (value$iv == null) {
            boolean bl = false;
            Set answer$iv = new LinkedHashSet();
            $this$getOrPut$iv.put(filePath2, answer$iv);
            set = answer$iv;
        } else {
            set = value$iv;
        }
        Set set2 = set;
        set2.add((FunctionNode)fn);
    }
}

