/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.caches.resolve;

import com.intellij.java.library.JavaLibraryModificationTracker;
import com.intellij.openapi.diagnostic.ControlFlowException;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ProjectRootModificationTracker;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiCodeFragment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.uast.UastModificationTracker;
import com.intellij.util.containers.SLRUCache;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KFunction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analyzer.ModuleInfo;
import org.jetbrains.kotlin.caches.resolve.KotlinCacheService;
import org.jetbrains.kotlin.caches.resolve.PlatformAnalysisSettings;
import org.jetbrains.kotlin.context.ContextKt;
import org.jetbrains.kotlin.context.GlobalContextImpl;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.kotlin.idea.base.facet.platform.TargetPlatformDetectorUtils;
import org.jetbrains.kotlin.idea.base.projectStructure.ModuleInfoProviderUtils;
import org.jetbrains.kotlin.idea.base.projectStructure.RootKindFilter;
import org.jetbrains.kotlin.idea.base.projectStructure.SourceKindFilterUtils;
import org.jetbrains.kotlin.idea.base.projectStructure.moduleInfo.IdeaModuleInfo;
import org.jetbrains.kotlin.idea.base.projectStructure.moduleInfo.LibrarySourceInfo;
import org.jetbrains.kotlin.idea.base.projectStructure.moduleInfo.ModuleSourceInfo;
import org.jetbrains.kotlin.idea.base.projectStructure.moduleInfo.NotUnderContentRootModuleInfo;
import org.jetbrains.kotlin.idea.base.psi.KotlinPsiHeuristics;
import org.jetbrains.kotlin.idea.base.scripting.projectStructure.ScriptDependenciesInfo;
import org.jetbrains.kotlin.idea.base.scripting.projectStructure.ScriptDependenciesSourceInfo;
import org.jetbrains.kotlin.idea.base.scripting.projectStructure.ScriptModuleInfo;
import org.jetbrains.kotlin.idea.caches.project.IdeaModuleInfoUtils;
import org.jetbrains.kotlin.idea.caches.project.ModuleIndexCacheKt;
import org.jetbrains.kotlin.idea.caches.resolve.KotlinCacheServiceImpl;
import org.jetbrains.kotlin.idea.caches.resolve.KotlinCacheServiceImplKt;
import org.jetbrains.kotlin.idea.caches.resolve.ModuleResolutionFacadeImpl;
import org.jetbrains.kotlin.idea.caches.resolve.PlatformAnalysisSettingsImpl;
import org.jetbrains.kotlin.idea.caches.resolve.ProjectResolutionFacade;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionFacadeWithDebugInfoKt;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.caches.resolve.util.GlobalContextUtilsKt;
import org.jetbrains.kotlin.idea.caches.resolve.util.GlobalFacadeModuleFilters;
import org.jetbrains.kotlin.idea.caches.trackers.PureKotlinCodeBlockModificationListenerKt;
import org.jetbrains.kotlin.idea.core.script.ScriptDependenciesModificationTracker;
import org.jetbrains.kotlin.idea.core.script.dependencies.ScriptAdditionalIdeaDependenciesProvider;
import org.jetbrains.kotlin.idea.resolve.ResolutionFacade;
import org.jetbrains.kotlin.platform.TargetPlatform;
import org.jetbrains.kotlin.platform.jvm.JvmPlatforms;
import org.jetbrains.kotlin.psi.KtAnnotated;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtCodeFragment;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtFileAnnotationList;
import org.jetbrains.kotlin.psi.KtModifierList;
import org.jetbrains.kotlin.psi.KtModifierListOwner;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.diagnostics.KotlinSuppressCache;
import org.jetbrains.kotlin.resolve.lazy.BodyResolveMode;
import org.jetbrains.kotlin.util.slicedMap.ReadOnlySlice;
import org.jetbrains.kotlin.utils.KotlinExceptionWithAttachments;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u009c\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\n\u0018\u00002\u00020\u0001:\u0001KB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J4\u0010\u0019\u001a\u00020\u001a2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001c2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00140\u001c2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"H\u0002J\"\u0010#\u001a\u00020\u00072\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\n\b\u0002\u0010$\u001a\u0004\u0018\u00010\nH\u0002J\u0010\u0010%\u001a\u00020\u00072\u0006\u0010&\u001a\u00020'H\u0002J\u0010\u0010(\u001a\u00020\u00072\u0006\u0010)\u001a\u00020\nH\u0002J\u001a\u0010*\u001a\u0004\u0018\u00010\u00142\u0006\u0010+\u001a\u00020\u00142\u0006\u0010\u001f\u001a\u00020 H\u0002J\u0016\u0010,\u001a\u00020\u00072\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013H\u0002J\u001e\u0010-\u001a\u00020\u00072\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\u0006\u0010)\u001a\u00020\nH\u0002J\u0018\u0010.\u001a\u00020/2\u0006\u0010+\u001a\u00020\u00142\u0006\u0010)\u001a\u00020\nH\u0002J\u001e\u00100\u001a\u00020/2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u0014012\u0006\u0010)\u001a\u00020\nH\u0002J\u001c\u00102\u001a\b\u0012\u0004\u0012\u00020\u00140\u001c2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001cH\u0002J\u0019\u00103\u001a\u000b0\u000bR\u00020\u0000\u00a2\u0006\u0002\b\u00162\u0006\u0010)\u001a\u00020\nH\u0002J\u0016\u00104\u001a\u00020/2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001cH\u0016J\u0010\u00104\u001a\u00020/2\u0006\u00105\u001a\u00020\u001dH\u0016J\u001a\u00106\u001a\u0004\u0018\u00010/2\u0006\u0010+\u001a\u0002072\u0006\u0010!\u001a\u00020\"H\u0016J\u001a\u00108\u001a\u0004\u0018\u00010/2\u0006\u0010\u001f\u001a\u0002092\u0006\u0010)\u001a\u00020\nH\u0016J\u001a\u00108\u001a\u0004\u0018\u00010/2\u0006\u0010\u001f\u001a\u0002092\u0006\u0010!\u001a\u00020\"H\u0016J\u0018\u00108\u001a\u00020/2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"H\u0016J\u0018\u0010:\u001a\u00020/2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010)\u001a\u00020\nH\u0002J\u001e\u0010;\u001a\u00020/2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001c2\u0006\u0010!\u001a\u00020\"H\u0016J\b\u0010<\u001a\u00020\u000eH\u0016J\u0010\u0010=\u001a\u00020\u00072\u0006\u0010)\u001a\u00020\nH\u0002J\f\u0010>\u001a\u00020\u0014*\u00020\u001dH\u0002J \u0010*\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013*\b\u0012\u0004\u0012\u00020\u0014012\u0006\u0010\u001f\u001a\u00020 H\u0002J\u000e\u0010?\u001a\u0004\u0018\u00010\u0014*\u00020\u0014H\u0002J\u0018\u0010@\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013*\b\u0012\u0004\u0012\u00020\u001401H\u0002J\u000e\u0010A\u001a\u0004\u0018\u00010\u0014*\u00020BH\u0002J1\u0010C\u001a\u0002HD\"\u0004\b\u0000\u0010E\"\u0004\b\u0001\u0010D*\u000e\u0012\u0004\u0012\u0002HE\u0012\u0004\u0012\u0002HD0\t2\u0006\u0010F\u001a\u0002HEH\u0002\u00a2\u0006\u0002\u0010GJ\f\u0010H\u001a\u00020\u001a*\u00020\u0014H\u0002J\u0014\u0010I\u001a\u00020\n*\u00020 2\u0006\u0010J\u001a\u00020\"H\u0002R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\b\u001a\u0012\u0012\u0004\u0012\u00020\n\u0012\b\u0012\u00060\u000bR\u00020\u00000\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010Rv\u0010\u0011\u001aj\u0012f\u0012d\u0012\u0018\u0012\u0016\u0012\u0004\u0012\u00020\u0014 \u0015*\n\u0012\u0004\u0012\u00020\u0014\u0018\u00010\u00130\u0013\u0012\f\u0012\n \u0015*\u0004\u0018\u00010\u00070\u0007 \u0015*1\u0012\u0018\u0012\u0016\u0012\u0004\u0012\u00020\u0014 \u0015*\n\u0012\u0004\u0012\u00020\u0014\u0018\u00010\u00130\u0013\u0012\f\u0012\n \u0015*\u0004\u0018\u00010\u00070\u0007\u0018\u00010\t\u00a2\u0006\u0002\b\u00160\t\u00a2\u0006\u0002\b\u00160\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u00a9\u0001\u0010\u0017\u001a\u009c\u0001\u0012\u0097\u0001\u0012\u0094\u0001\u00120\u0012.\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00140\u0013\u0012\u0004\u0012\u00020\n \u0015*\u0016\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00140\u0013\u0012\u0004\u0012\u00020\n\u0018\u00010\u00180\u0018\u0012\f\u0012\n \u0015*\u0004\u0018\u00010\u00070\u0007 \u0015*I\u00120\u0012.\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00140\u0013\u0012\u0004\u0012\u00020\n \u0015*\u0016\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00140\u0013\u0012\u0004\u0012\u00020\n\u0018\u00010\u00180\u0018\u0012\f\u0012\n \u0015*\u0004\u0018\u00010\u00070\u0007\u0018\u00010\t\u00a2\u0006\u0002\b\u00160\t\u00a2\u0006\u0002\b\u00160\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006L"}, d2={"Lorg/jetbrains/kotlin/idea/caches/resolve/KotlinCacheServiceImpl;", "Lorg/jetbrains/kotlin/caches/resolve/KotlinCacheService;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "facadeForScriptDependenciesForProject", "Lkotlin/Lazy;", "Lorg/jetbrains/kotlin/idea/caches/resolve/ProjectResolutionFacade;", "globalFacadesPerPlatformAndSdk", "Lcom/intellij/util/containers/SLRUCache;", "Lorg/jetbrains/kotlin/caches/resolve/PlatformAnalysisSettings;", "Lorg/jetbrains/kotlin/idea/caches/resolve/KotlinCacheServiceImpl$GlobalFacade;", "kotlinSuppressCache", "Lcom/intellij/psi/util/CachedValue;", "Lorg/jetbrains/kotlin/resolve/diagnostics/KotlinSuppressCache;", "getProject", "()Lcom/intellij/openapi/project/Project;", "scriptsCacheProvider", "Lcom/intellij/psi/util/CachedValueProvider;", "", "Lorg/jetbrains/kotlin/psi/KtFile;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "specialFilesCacheProvider", "Lkotlin/Pair;", "canGetFacadeWithForcedPlatform", "", "elements", "", "Lorg/jetbrains/kotlin/psi/KtElement;", "files", "moduleInfo", "Lorg/jetbrains/kotlin/idea/base/projectStructure/moduleInfo/IdeaModuleInfo;", "platform", "Lorg/jetbrains/kotlin/platform/TargetPlatform;", "createFacadeForFilesWithSpecialModuleInfo", "explicitSettings", "createFacadeForScriptDependencies", "dependenciesModuleInfo", "Lorg/jetbrains/kotlin/idea/base/scripting/projectStructure/ScriptDependenciesInfo;", "facadeForModules", "settings", "filterNotInProjectSource", "file", "getFacadeForScripts", "getFacadeForSpecialFiles", "getFacadeToAnalyzeFile", "Lorg/jetbrains/kotlin/idea/resolve/ResolutionFacade;", "getFacadeToAnalyzeFiles", "", "getFilesForElements", "getOrBuildGlobalFacade", "getResolutionFacade", "element", "getResolutionFacadeByFile", "Lcom/intellij/psi/PsiFile;", "getResolutionFacadeByModuleInfo", "Lorg/jetbrains/kotlin/analyzer/ModuleInfo;", "getResolutionFacadeByModuleInfoAndSettings", "getResolutionFacadeWithForcedPlatform", "getSuppressionCache", "librariesFacade", "fileForElement", "filterScript", "filterScripts", "getContextFile", "Lorg/jetbrains/kotlin/psi/KtCodeFragment;", "getOrCreateValue", "V", "K", "key", "(Lcom/intellij/util/containers/SLRUCache;Ljava/lang/Object;)Ljava/lang/Object;", "isScript", "platformSettings", "targetPlatform", "GlobalFacade", "kotlin.base.fe10.analysis"})
@SourceDebugExtension(value={"SMAP\nKotlinCacheServiceImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinCacheServiceImpl.kt\norg/jetbrains/kotlin/idea/caches/resolve/KotlinCacheServiceImpl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 addToStdlib.kt\norg/jetbrains/kotlin/utils/addToStdlib/AddToStdlibKt\n*L\n1#1,617:1\n1549#2:618\n1620#2,3:619\n1549#2:623\n1620#2,3:624\n1549#2:627\n1620#2,3:628\n1726#2,3:631\n1611#2:634\n1855#2:635\n1856#2:637\n1612#2:638\n1611#2:639\n1855#2:640\n1856#2:642\n1612#2:643\n1#3:622\n1#3:636\n1#3:641\n181#4,5:644\n181#4,5:649\n*S KotlinDebug\n*F\n+ 1 KotlinCacheServiceImpl.kt\norg/jetbrains/kotlin/idea/caches/resolve/KotlinCacheServiceImpl\n*L\n182#1:618\n182#1:619,3\n303#1:623\n303#1:624,3\n304#1:627\n304#1:628,3\n308#1:631,3\n579#1:634\n579#1:635\n579#1:637\n579#1:638\n598#1:639\n598#1:640\n598#1:642\n598#1:643\n579#1:636\n598#1:641\n309#1:644,5\n310#1:649,5\n*E\n"})
public final class KotlinCacheServiceImpl
implements KotlinCacheService {
    @NotNull
    private final Project project;
    @NotNull
    private final SLRUCache<PlatformAnalysisSettings, GlobalFacade> globalFacadesPerPlatformAndSdk;
    @NotNull
    private final Lazy<ProjectResolutionFacade> facadeForScriptDependenciesForProject;
    @NotNull
    private final CachedValue<KotlinSuppressCache> kotlinSuppressCache;
    @NotNull
    private final CachedValueProvider<SLRUCache<Pair<Set<KtFile>, PlatformAnalysisSettings>, ProjectResolutionFacade>> specialFilesCacheProvider;
    @NotNull
    private final CachedValueProvider<SLRUCache<Set<KtFile>, ProjectResolutionFacade>> scriptsCacheProvider;

    public KotlinCacheServiceImpl(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        this.project = project2;
        SLRUCache sLRUCache = SLRUCache.slruCache((int)12, (int)12, arg_0 -> KotlinCacheServiceImpl.globalFacadesPerPlatformAndSdk$lambda$2(this, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)sLRUCache, (String)"slruCache(...)");
        this.globalFacadesPerPlatformAndSdk = sLRUCache;
        this.facadeForScriptDependenciesForProject = LazyKt.lazy((Function0)((Function0)new Function0<ProjectResolutionFacade>(this){
            final /* synthetic */ KotlinCacheServiceImpl this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final ProjectResolutionFacade invoke() {
                return KotlinCacheServiceImpl.access$createFacadeForScriptDependencies(this.this$0, new ScriptDependenciesInfo.ForProject(this.this$0.getProject()));
            }
        }));
        CachedValue cachedValue2 = CachedValuesManager.getManager((Project)this.project).createCachedValue(() -> KotlinCacheServiceImpl.kotlinSuppressCache$lambda$11(this), false);
        Intrinsics.checkNotNullExpressionValue((Object)cachedValue2, (String)"createCachedValue(...)");
        this.kotlinSuppressCache = cachedValue2;
        this.specialFilesCacheProvider = () -> KotlinCacheServiceImpl.specialFilesCacheProvider$lambda$13(this);
        this.scriptsCacheProvider = () -> KotlinCacheServiceImpl.scriptsCacheProvider$lambda$14(this);
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @Override
    @NotNull
    public ResolutionFacade getResolutionFacade(@NotNull KtElement element3) {
        Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
        KtFile file2 = this.fileForElement(element3);
        Object object = CachedValuesManager.getCachedValue((PsiElement)((PsiElement)file2), () -> KotlinCacheServiceImpl.getResolutionFacade$lambda$0(this, file2));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getCachedValue(...)");
        return (ResolutionFacade)object;
    }

    @Override
    @NotNull
    public ResolutionFacade getResolutionFacade(@NotNull List<? extends KtElement> elements2) {
        Intrinsics.checkNotNullParameter(elements2, (String)"elements");
        List<KtFile> files2 = this.getFilesForElements(elements2);
        if (files2.size() == 1) {
            return this.getResolutionFacade((KtElement)CollectionsKt.single(files2));
        }
        TargetPlatform platform2 = TargetPlatformDetectorUtils.getPlatform((KtElement)CollectionsKt.first(files2));
        PlatformAnalysisSettings settings2 = this.platformSettings(ModuleInfoProviderUtils.getModuleInfo((PsiElement)CollectionsKt.first(files2)), platform2);
        return this.getFacadeToAnalyzeFiles((Collection<? extends KtFile>)files2, settings2);
    }

    @Override
    @NotNull
    public ResolutionFacade getResolutionFacadeWithForcedPlatform(@NotNull List<? extends KtElement> elements2, @NotNull TargetPlatform platform2) {
        Intrinsics.checkNotNullParameter(elements2, (String)"elements");
        Intrinsics.checkNotNullParameter((Object)platform2, (String)"platform");
        List<KtFile> files2 = this.getFilesForElements(elements2);
        IdeaModuleInfo moduleInfo = ModuleInfoProviderUtils.getModuleInfo((PsiElement)CollectionsKt.first(files2));
        PlatformAnalysisSettingsImpl settings2 = new PlatformAnalysisSettingsImpl(platform2, moduleInfo.sdk());
        if (!this.canGetFacadeWithForcedPlatform(elements2, files2, moduleInfo, platform2)) {
            return this.getResolutionFacade(elements2);
        }
        return this.getFacadeToAnalyzeFiles((Collection<? extends KtFile>)files2, settings2);
    }

    private final boolean canGetFacadeWithForcedPlatform(List<? extends KtElement> elements2, List<? extends KtFile> files2, IdeaModuleInfo moduleInfo, TargetPlatform platform2) {
        boolean bl;
        Set<KtFile> specialFiles = this.filterNotInProjectSource((Collection<? extends KtFile>)files2, moduleInfo);
        Set<KtFile> scripts = this.filterScripts((Collection<? extends KtFile>)specialFiles);
        if (platform2.size() > 1) {
            KotlinCacheServiceImplKt.getLOG().error("Getting resolution facade with non-trivial platform " + platform2 + " is strongly discouraged,\nas it can lead to heavy memory consumption. Facade with non-forced platform will be used instead.");
            bl = false;
        } else if (moduleInfo instanceof ScriptDependenciesInfo || moduleInfo instanceof ScriptDependenciesSourceInfo) {
            KotlinCacheServiceImplKt.getLOG().error("Getting resolution facade for ScriptDependencies is not supported\nRequested elements: " + elements2 + "\nFiles for requested elements: " + files2 + "\nModule info for the first file: " + moduleInfo);
            bl = false;
        } else if (!((Collection)scripts).isEmpty()) {
            KotlinCacheServiceImplKt.getLOG().error("Getting resolution facade with forced platform is not supported for scripts\nRequested elements: " + elements2 + "\nFiles for requested elements: " + files2 + "\nAmong them, following are scripts: " + scripts);
            bl = false;
        } else {
            bl = true;
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    private final List<KtFile> getFilesForElements(List<? extends KtElement> elements2) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = elements2;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            KtElement ktElement = (KtElement)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this.fileForElement((KtElement)it));
        }
        return CollectionsKt.distinct((Iterable)((List)destination$iv$iv));
    }

    private final KtFile fileForElement(KtElement $this$fileForElement) {
        KtFile ktFile2;
        try {
            KtFile ktFile3 = $this$fileForElement.getContainingKtFile();
            if (ktFile3 == null) {
                throw new IllegalStateException("containingKtFile was null for " + $this$fileForElement + " of " + $this$fileForElement.getClass());
            }
            ktFile2 = ktFile3;
        }
        catch (Exception e) {
            if (e instanceof ControlFlowException) {
                throw e;
            }
            throw new KotlinExceptionWithAttachments("Couldn't get containingKtFile for ktElement", (Throwable)e).withPsiAttachment("element", (PsiElement)$this$fileForElement).withPsiAttachment("file", (PsiElement)$this$fileForElement.getContainingFile()).withAttachment("original", (Object)e.getMessage());
        }
        return ktFile2;
    }

    @Override
    @NotNull
    public KotlinSuppressCache getSuppressionCache() {
        Object object = this.kotlinSuppressCache.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getValue(...)");
        return (KotlinSuppressCache)object;
    }

    private final ProjectResolutionFacade createFacadeForScriptDependencies(ScriptDependenciesInfo dependenciesModuleInfo) {
        List<Module> relatedModules;
        List<Module> list2;
        VirtualFile scriptFile;
        Sdk sdk2 = dependenciesModuleInfo.getSdk();
        TargetPlatform platform2 = JvmPlatforms.INSTANCE.getDefaultJvmPlatform();
        PlatformAnalysisSettings settings2 = KotlinCacheServiceImplKt.createPlatformAnalysisSettings(this.project, platform2, sdk2);
        Object[] objectArray = new ModificationTracker[]{JavaLibraryModificationTracker.getInstance((Project)this.project), ScriptDependenciesModificationTracker.Companion.getInstance(this.project)};
        List dependenciesForScriptDependencies = CollectionsKt.listOf((Object[])objectArray);
        ScriptDependenciesInfo.ForFile forFile = dependenciesModuleInfo instanceof ScriptDependenciesInfo.ForFile ? (ScriptDependenciesInfo.ForFile)dependenciesModuleInfo : null;
        VirtualFile virtualFile2 = scriptFile = forFile != null ? forFile.getScriptFile() : null;
        if (virtualFile2 != null) {
            VirtualFile it = virtualFile2;
            boolean bl = false;
            list2 = ScriptAdditionalIdeaDependenciesProvider.Companion.getRelatedModules(it, this.project);
        } else {
            list2 = null;
        }
        List<Module> list3 = relatedModules = list2;
        ProjectResolutionFacade globalFacade = (list3 != null ? !((Collection)list3).isEmpty() : false) ? this.facadeForModules(settings2) : this.getOrBuildGlobalFacade(settings2).getFacadeForSdk();
        GlobalContextImpl globalContext = GlobalContextUtilsKt.contextWithCompositeExceptionTracker(globalFacade.getGlobalContext(), this.project, "facadeForScriptDependencies");
        Project project2 = this.project;
        List<IdeaModuleInfo> list4 = dependenciesModuleInfo.dependencies();
        return new ProjectResolutionFacade("facadeForScriptDependencies", "dependencies of scripts", project2, globalContext, settings2, globalFacade, (Function1)new Function1<IdeaModuleInfo, Boolean>(dependenciesModuleInfo){
            final /* synthetic */ ScriptDependenciesInfo $dependenciesModuleInfo;
            {
                this.$dependenciesModuleInfo = $dependenciesModuleInfo;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull IdeaModuleInfo it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return Intrinsics.areEqual((Object)it, (Object)this.$dependenciesModuleInfo);
            }
        }, dependenciesForScriptDependencies, false, null, list4, 512, null);
    }

    private final PlatformAnalysisSettings platformSettings(IdeaModuleInfo $this$platformSettings, TargetPlatform targetPlatform) {
        return KotlinCacheServiceImplKt.createPlatformAnalysisSettings(this.project, targetPlatform, $this$platformSettings.sdk());
    }

    private final ProjectResolutionFacade facadeForModules(PlatformAnalysisSettings settings2) {
        return this.getOrBuildGlobalFacade(settings2).getFacadeForModules();
    }

    private final ProjectResolutionFacade librariesFacade(PlatformAnalysisSettings settings2) {
        return this.getOrBuildGlobalFacade(settings2).getFacadeForLibraries();
    }

    private final synchronized GlobalFacade getOrBuildGlobalFacade(PlatformAnalysisSettings settings2) {
        Object object = this.globalFacadesPerPlatformAndSdk.get((Object)settings2);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        return (GlobalFacade)object;
    }

    /*
     * WARNING - void declaration
     */
    private final ProjectResolutionFacade createFacadeForFilesWithSpecialModuleInfo(Set<? extends KtFile> files2, PlatformAnalysisSettings explicitSettings) {
        ProjectResolutionFacade projectResolutionFacade;
        boolean bl;
        PlatformAnalysisSettings settings2;
        IdeaModuleInfo specialModuleInfo;
        TargetPlatform targetPlatform;
        block18: {
            void $this$mapTo$iv$iv;
            KtFile it;
            Collection collection;
            void $this$mapTo$iv$iv2;
            Iterable $this$map$iv = files2;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                KtFile ktFile2 = (KtFile)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl2 = false;
                collection.add(TargetPlatformDetectorUtils.getPlatform((KtElement)it));
            }
            targetPlatform = (TargetPlatform)CollectionsKt.single((Iterable)CollectionsKt.toSet((Iterable)((List)destination$iv$iv)));
            Iterable $this$map$iv2 = files2;
            boolean $i$f$map2 = false;
            destination$iv$iv = $this$map$iv2;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it2;
                KtFile bl2 = (KtFile)item$iv$iv;
                collection = destination$iv$iv2;
                boolean bl3 = false;
                collection.add(ModuleInfoProviderUtils.getModuleInfo((PsiElement)it2));
            }
            specialModuleInfo = (IdeaModuleInfo)CollectionsKt.single((Iterable)CollectionsKt.toSet((Iterable)((List)destination$iv$iv2)));
            PlatformAnalysisSettings platformAnalysisSettings = explicitSettings;
            if (platformAnalysisSettings == null) {
                platformAnalysisSettings = this.platformSettings(specialModuleInfo, specialModuleInfo.getPlatform());
            }
            settings2 = platformAnalysisSettings;
            Iterable $this$all$iv = files2;
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    it = (KtFile)element$iv;
                    boolean bl4 = false;
                    if (!Intrinsics.areEqual((Object)it.getOriginalFile(), (Object)it)) continue;
                    bl = false;
                    break block18;
                }
                bl = true;
            }
        }
        ModificationTracker dependencyTrackerForSyntheticFileCache = bl ? () -> KotlinCacheServiceImpl.createFacadeForFilesWithSpecialModuleInfo$lambda$8(files2) : () -> KotlinCacheServiceImpl.createFacadeForFilesWithSpecialModuleInfo$lambda$10(files2);
        String resolverDebugName2 = "completion/highlighting in  " + specialModuleInfo + " for files " + CollectionsKt.joinToString$default((Iterable)files2, null, null, null, (int)0, null, (Function1)createFacadeForFilesWithSpecialModuleInfo.resolverDebugName.1.INSTANCE, (int)31, null) + " for platform " + targetPlatform;
        if (specialModuleInfo instanceof ModuleSourceInfo) {
            Set<ModuleSourceInfo> dependentModules = ModuleIndexCacheKt.getDependentModules((ModuleSourceInfo)specialModuleInfo);
            ProjectResolutionFacade modulesFacade = this.facadeForModules(settings2);
            globalContext = GlobalContextUtilsKt.contextWithCompositeExceptionTracker(modulesFacade.getGlobalContext(), this.project, "facadeForSpecialModuleInfo (ModuleSourceInfo)");
            projectResolutionFacade = KotlinCacheServiceImpl.createFacadeForFilesWithSpecialModuleInfo$makeProjectResolutionFacade$default(this, dependencyTrackerForSyntheticFileCache, resolverDebugName2, settings2, files2, "facadeForSpecialModuleInfo (ModuleSourceInfo)", globalContext, modulesFacade, (Function1)new Function1<IdeaModuleInfo, Boolean>(dependentModules){
                final /* synthetic */ Set<ModuleSourceInfo> $dependentModules;
                {
                    this.$dependentModules = $dependentModules;
                    super(1);
                }

                @NotNull
                public final Boolean invoke(@NotNull IdeaModuleInfo it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    return CollectionsKt.contains((Iterable)this.$dependentModules, (Object)it);
                }
            }, null, 512, null);
        } else if (specialModuleInfo instanceof ScriptModuleInfo) {
            ProjectResolutionFacade facadeForScriptDependencies = this.createFacadeForScriptDependencies(new ScriptDependenciesInfo.ForFile(this.project, ((ScriptModuleInfo)specialModuleInfo).getScriptFile(), ((ScriptModuleInfo)specialModuleInfo).getScriptDefinition()));
            GlobalContextImpl globalContext2 = GlobalContextUtilsKt.contextWithCompositeExceptionTracker(facadeForScriptDependencies.getGlobalContext(), this.project, "facadeForSpecialModuleInfo (ScriptModuleInfo)");
            globalContext = specialModuleInfo.dependencies();
            projectResolutionFacade = KotlinCacheServiceImpl.createFacadeForFilesWithSpecialModuleInfo$makeProjectResolutionFacade(this, dependencyTrackerForSyntheticFileCache, resolverDebugName2, settings2, files2, "facadeForSpecialModuleInfo (ScriptModuleInfo)", globalContext2, facadeForScriptDependencies, (Function1<? super IdeaModuleInfo, Boolean>)((Function1)new Function1<IdeaModuleInfo, Boolean>(specialModuleInfo){
                final /* synthetic */ IdeaModuleInfo $specialModuleInfo;
                {
                    this.$specialModuleInfo = $specialModuleInfo;
                    super(1);
                }

                @NotNull
                public final Boolean invoke(@NotNull IdeaModuleInfo it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    return Intrinsics.areEqual((Object)it, (Object)this.$specialModuleInfo);
                }
            }), (Collection)globalContext);
        } else if (specialModuleInfo instanceof ScriptDependenciesInfo) {
            projectResolutionFacade = (ProjectResolutionFacade)this.facadeForScriptDependenciesForProject.getValue();
        } else if (specialModuleInfo instanceof ScriptDependenciesSourceInfo) {
            GlobalContextImpl globalContext = GlobalContextUtilsKt.contextWithCompositeExceptionTracker(((ProjectResolutionFacade)this.facadeForScriptDependenciesForProject.getValue()).getGlobalContext(), this.project, "facadeForSpecialModuleInfo (ScriptDependenciesSourceInfo)");
            ProjectResolutionFacade globalContext2 = (ProjectResolutionFacade)this.facadeForScriptDependenciesForProject.getValue();
            globalContext = specialModuleInfo.dependencies();
            projectResolutionFacade = KotlinCacheServiceImpl.createFacadeForFilesWithSpecialModuleInfo$makeProjectResolutionFacade(this, dependencyTrackerForSyntheticFileCache, resolverDebugName2, settings2, files2, "facadeForSpecialModuleInfo (ScriptDependenciesSourceInfo)", globalContext, globalContext2, (Function1<? super IdeaModuleInfo, Boolean>)((Function1)new Function1<IdeaModuleInfo, Boolean>(specialModuleInfo){
                final /* synthetic */ IdeaModuleInfo $specialModuleInfo;
                {
                    this.$specialModuleInfo = $specialModuleInfo;
                    super(1);
                }

                @NotNull
                public final Boolean invoke(@NotNull IdeaModuleInfo it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    return Intrinsics.areEqual((Object)it, (Object)this.$specialModuleInfo);
                }
            }), (Collection)globalContext);
        } else if (specialModuleInfo instanceof LibrarySourceInfo || specialModuleInfo instanceof NotUnderContentRootModuleInfo) {
            ProjectResolutionFacade librariesFacade = this.librariesFacade(settings2);
            String debugName = "facadeForSpecialModuleInfo (LibrarySourceInfo or NotUnderContentRootModuleInfo)";
            globalContext = GlobalContextUtilsKt.contextWithCompositeExceptionTracker(librariesFacade.getGlobalContext(), this.project, debugName);
            projectResolutionFacade = KotlinCacheServiceImpl.createFacadeForFilesWithSpecialModuleInfo$makeProjectResolutionFacade$default(this, dependencyTrackerForSyntheticFileCache, resolverDebugName2, settings2, files2, debugName, globalContext, librariesFacade, (Function1)new Function1<IdeaModuleInfo, Boolean>(specialModuleInfo){
                final /* synthetic */ IdeaModuleInfo $specialModuleInfo;
                {
                    this.$specialModuleInfo = $specialModuleInfo;
                    super(1);
                }

                @NotNull
                public final Boolean invoke(@NotNull IdeaModuleInfo it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    return Intrinsics.areEqual((Object)it, (Object)this.$specialModuleInfo);
                }
            }, null, 512, null);
        } else if (IdeaModuleInfoUtils.isLibraryClasses(specialModuleInfo)) {
            KotlinCacheServiceImplKt.getLOG().warn("Creating cache with synthetic files (" + files2 + ") in classes of library " + specialModuleInfo);
            GlobalContextImpl globalContext = ContextKt.GlobalContext((String)"facadeForSpecialModuleInfo for file under both classes and root");
            projectResolutionFacade = KotlinCacheServiceImpl.createFacadeForFilesWithSpecialModuleInfo$makeProjectResolutionFacade$default(this, dependencyTrackerForSyntheticFileCache, resolverDebugName2, settings2, files2, "facadeForSpecialModuleInfo for file under both classes and root", globalContext, null, null, null, 896, null);
        } else {
            throw new IllegalStateException("Unknown IdeaModuleInfo " + specialModuleInfo.getClass());
        }
        return projectResolutionFacade;
    }

    static /* synthetic */ ProjectResolutionFacade createFacadeForFilesWithSpecialModuleInfo$default(KotlinCacheServiceImpl kotlinCacheServiceImpl, Set set, PlatformAnalysisSettings platformAnalysisSettings, int n, Object object) {
        if ((n & 2) != 0) {
            platformAnalysisSettings = null;
        }
        return kotlinCacheServiceImpl.createFacadeForFilesWithSpecialModuleInfo(set, platformAnalysisSettings);
    }

    private final ProjectResolutionFacade getFacadeForSpecialFiles(Set<? extends KtFile> files2, PlatformAnalysisSettings settings2) {
        Object object = CachedValuesManager.getManager((Project)this.project).getCachedValue((UserDataHolder)this.project, this.specialFilesCacheProvider);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getCachedValue(...)");
        SLRUCache cachedValue2 = (SLRUCache)object;
        return (ProjectResolutionFacade)this.getOrCreateValue(cachedValue2, TuplesKt.to(files2, (Object)settings2));
    }

    private final ProjectResolutionFacade getFacadeForScripts(Set<? extends KtFile> files2) {
        Object object = CachedValuesManager.getManager((Project)this.project).getCachedValue((UserDataHolder)this.project, this.scriptsCacheProvider);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getCachedValue(...)");
        SLRUCache cachedValue2 = (SLRUCache)object;
        return (ProjectResolutionFacade)this.getOrCreateValue(cachedValue2, files2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final <K, V> V getOrCreateValue(SLRUCache<K, V> $this$getOrCreateValue, K key) {
        Object object;
        SLRUCache<K, V> sLRUCache = $this$getOrCreateValue;
        synchronized (sLRUCache) {
            boolean $i$a$-synchronized-KotlinCacheServiceImpl$getOrCreateValue$22 = false;
            Object $i$a$-synchronized-KotlinCacheServiceImpl$getOrCreateValue$22 = $this$getOrCreateValue.getIfCached(key);
            // MONITOREXIT @DISABLED, blocks:[0, 2] lbl7 : MonitorExitStatement: MONITOREXIT : var3_3
            object = $i$a$-synchronized-KotlinCacheServiceImpl$getOrCreateValue$22;
        }
        Object object2 = object;
        if (object == null) {
            SLRUCache<K, V> $this$getOrCreateValue_u24lambda_u2418 = $this$getOrCreateValue;
            boolean bl = false;
            Object object3 = $this$getOrCreateValue_u24lambda_u2418.createValue(key);
            Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"createValue(...)");
            Object newValue2 = object3;
            SLRUCache<K, V> sLRUCache2 = $this$getOrCreateValue_u24lambda_u2418;
            synchronized (sLRUCache2) {
                boolean bl2 = false;
                Object cached2 = $this$getOrCreateValue_u24lambda_u2418.getIfCached(key);
                Object object4 = cached2;
                if (object4 == null) {
                    SLRUCache<K, V> $this$getOrCreateValue_u24lambda_u2418_u24lambda_u2417_u24lambda_u2416 = $this$getOrCreateValue_u24lambda_u2418;
                    boolean bl3 = false;
                    $this$getOrCreateValue_u24lambda_u2418_u24lambda_u2417_u24lambda_u2416.put(key, newValue2);
                    object4 = newValue2;
                }
                Object object5 = object4;
                // MONITOREXIT @DISABLED, blocks:[1, 3, 7] lbl35 : MonitorExitStatement: MONITOREXIT : var7_9
                object2 = object5;
            }
        }
        return (V)object2;
    }

    private final ResolutionFacade getFacadeToAnalyzeFiles(Collection<? extends KtFile> files2, PlatformAnalysisSettings settings2) {
        IdeaModuleInfo moduleInfo = ModuleInfoProviderUtils.getModuleInfo((PsiElement)CollectionsKt.first((Iterable)files2));
        Set<KtFile> specialFiles = this.filterNotInProjectSource(files2, moduleInfo);
        Set<KtFile> scripts = this.filterScripts((Collection<? extends KtFile>)specialFiles);
        if (!((Collection)scripts).isEmpty()) {
            ProjectResolutionFacade projectFacade = this.getFacadeForScripts(scripts);
            return ResolutionFacadeWithDebugInfoKt.createdFor(new ModuleResolutionFacadeImpl(projectFacade, moduleInfo), (Collection<? extends KtFile>)scripts, moduleInfo, settings2);
        }
        if (!((Collection)specialFiles).isEmpty()) {
            ProjectResolutionFacade projectFacade = this.getFacadeForSpecialFiles(specialFiles, settings2);
            return ResolutionFacadeWithDebugInfoKt.createdFor(new ModuleResolutionFacadeImpl(projectFacade, moduleInfo), (Collection<? extends KtFile>)specialFiles, moduleInfo, settings2);
        }
        return ResolutionFacadeWithDebugInfoKt.createdFor(this.getResolutionFacadeByModuleInfoAndSettings(moduleInfo, settings2), CollectionsKt.emptyList(), moduleInfo, settings2);
    }

    private final ResolutionFacade getFacadeToAnalyzeFile(KtFile file2, PlatformAnalysisSettings settings2) {
        IdeaModuleInfo moduleInfo = ModuleInfoProviderUtils.getModuleInfo((PsiElement)file2);
        KtFile specialFile = this.filterNotInProjectSource(file2, moduleInfo);
        KtFile ktFile2 = specialFile;
        if (ktFile2 != null && (ktFile2 = this.filterScript(ktFile2)) != null) {
            KtFile script = ktFile2;
            boolean bl = false;
            Set scripts = SetsKt.setOf((Object)script);
            ProjectResolutionFacade projectFacade = this.getFacadeForScripts(scripts);
            return ResolutionFacadeWithDebugInfoKt.createdFor(new ModuleResolutionFacadeImpl(projectFacade, moduleInfo), scripts, moduleInfo, settings2);
        }
        if (specialFile != null) {
            Set specialFiles = SetsKt.setOf((Object)specialFile);
            ProjectResolutionFacade projectFacade = this.getFacadeForSpecialFiles(specialFiles, settings2);
            return ResolutionFacadeWithDebugInfoKt.createdFor(new ModuleResolutionFacadeImpl(projectFacade, moduleInfo), specialFiles, moduleInfo, settings2);
        }
        return ResolutionFacadeWithDebugInfoKt.createdFor(this.getResolutionFacadeByModuleInfoAndSettings(moduleInfo, settings2), CollectionsKt.emptyList(), moduleInfo, settings2);
    }

    @Override
    @Nullable
    public ResolutionFacade getResolutionFacadeByFile(@NotNull PsiFile file2, @NotNull TargetPlatform platform2) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Intrinsics.checkNotNullParameter((Object)platform2, (String)"platform");
        if (!SourceKindFilterUtils.matches(RootKindFilter.everything, (PsiElement)file2)) {
            return null;
        }
        boolean bl2 = bl = !(file2 instanceof PsiCodeFragment);
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        IdeaModuleInfo moduleInfo = ModuleInfoProviderUtils.getModuleInfo((PsiElement)file2);
        return this.getResolutionFacadeByModuleInfo(moduleInfo, platform2);
    }

    @Override
    @NotNull
    public ResolutionFacade getResolutionFacadeByModuleInfo(@NotNull IdeaModuleInfo moduleInfo, @NotNull TargetPlatform platform2) {
        Intrinsics.checkNotNullParameter((Object)moduleInfo, (String)"moduleInfo");
        Intrinsics.checkNotNullParameter((Object)platform2, (String)"platform");
        PlatformAnalysisSettings settings2 = this.platformSettings(moduleInfo, platform2);
        return this.getResolutionFacadeByModuleInfoAndSettings(moduleInfo, settings2);
    }

    private final ResolutionFacade getResolutionFacadeByModuleInfoAndSettings(IdeaModuleInfo moduleInfo, PlatformAnalysisSettings settings2) {
        IdeaModuleInfo ideaModuleInfo = moduleInfo;
        ProjectResolutionFacade projectFacade = (ideaModuleInfo instanceof ScriptDependenciesInfo.ForProject ? true : ideaModuleInfo instanceof ScriptDependenciesSourceInfo.ForProject) ? (ProjectResolutionFacade)this.facadeForScriptDependenciesForProject.getValue() : (ideaModuleInfo instanceof ScriptDependenciesInfo.ForFile ? this.createFacadeForScriptDependencies((ScriptDependenciesInfo)moduleInfo) : this.facadeForModules(settings2));
        return new ModuleResolutionFacadeImpl(projectFacade, moduleInfo);
    }

    @Override
    @Nullable
    public ResolutionFacade getResolutionFacadeByModuleInfo(@NotNull ModuleInfo moduleInfo, @NotNull TargetPlatform platform2) {
        ResolutionFacade resolutionFacade2;
        Intrinsics.checkNotNullParameter((Object)moduleInfo, (String)"moduleInfo");
        Intrinsics.checkNotNullParameter((Object)platform2, (String)"platform");
        IdeaModuleInfo ideaModuleInfo = moduleInfo instanceof IdeaModuleInfo ? (IdeaModuleInfo)moduleInfo : null;
        if (ideaModuleInfo != null) {
            IdeaModuleInfo it = ideaModuleInfo;
            boolean bl = false;
            resolutionFacade2 = this.getResolutionFacadeByModuleInfo(it, platform2);
        } else {
            resolutionFacade2 = null;
        }
        return resolutionFacade2;
    }

    @Override
    @Nullable
    public ResolutionFacade getResolutionFacadeByModuleInfo(@NotNull ModuleInfo moduleInfo, @NotNull PlatformAnalysisSettings settings2) {
        Intrinsics.checkNotNullParameter((Object)moduleInfo, (String)"moduleInfo");
        Intrinsics.checkNotNullParameter((Object)settings2, (String)"settings");
        IdeaModuleInfo ideaModuleInfo = moduleInfo instanceof IdeaModuleInfo ? (IdeaModuleInfo)moduleInfo : null;
        if (ideaModuleInfo == null) {
            return null;
        }
        IdeaModuleInfo ideaModuleInfo2 = ideaModuleInfo;
        return this.getResolutionFacadeByModuleInfoAndSettings(ideaModuleInfo2, settings2);
    }

    /*
     * WARNING - void declaration
     */
    private final Set<KtFile> filterNotInProjectSource(Collection<? extends KtFile> $this$filterNotInProjectSource, IdeaModuleInfo moduleInfo) {
        void destination$iv;
        void $this$mapNotNullTo$iv;
        Iterable iterable = $this$filterNotInProjectSource;
        Collection collection = new LinkedHashSet();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv = $this$mapNotNullTo$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv.iterator();
        while (iterator2.hasNext()) {
            KtFile it$iv;
            Object element$iv$iv;
            Object element$iv = element$iv$iv = iterator2.next();
            boolean bl = false;
            KtFile it = (KtFile)element$iv;
            boolean bl2 = false;
            if (this.filterNotInProjectSource(it, moduleInfo) == null) continue;
            boolean bl3 = false;
            destination$iv.add(it$iv);
        }
        return (Set)destination$iv;
    }

    private final KtFile filterNotInProjectSource(KtFile file2, IdeaModuleInfo moduleInfo) {
        KtFile fileToAnalyze;
        KtFile ktFile2 = fileToAnalyze = file2 instanceof KtCodeFragment ? this.getContextFile((KtCodeFragment)file2) : file2;
        if (fileToAnalyze == null) {
            return null;
        }
        boolean isInProjectSource = SourceKindFilterUtils.matches(RootKindFilter.projectSources, (PsiElement)fileToAnalyze) && PsiUtilsKt.contains((SearchScope)((SearchScope)moduleInfo.getContentScope()), (PsiElement)((PsiElement)fileToAnalyze));
        return !isInProjectSource ? fileToAnalyze : null;
    }

    /*
     * WARNING - void declaration
     */
    private final Set<KtFile> filterScripts(Collection<? extends KtFile> $this$filterScripts) {
        void var3_3;
        void $this$mapNotNullTo$iv;
        Iterable iterable = $this$filterScripts;
        Collection destination$iv = new LinkedHashSet();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv = $this$mapNotNullTo$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv.iterator();
        while (iterator2.hasNext()) {
            KtFile it$iv;
            Object element$iv$iv;
            Object element$iv = element$iv$iv = iterator2.next();
            boolean bl = false;
            KtFile it = (KtFile)element$iv;
            boolean bl2 = false;
            if (this.filterScript(it) == null) continue;
            boolean bl3 = false;
            destination$iv.add(it$iv);
        }
        return (Set)var3_3;
    }

    private final KtFile filterScript(KtFile $this$filterScript) {
        Object object;
        KtFile contextFile;
        KtFile ktFile2 = contextFile = $this$filterScript instanceof KtCodeFragment ? this.getContextFile((KtCodeFragment)$this$filterScript) : $this$filterScript;
        if (ktFile2 != null) {
            KtFile ktFile3;
            KtFile it = ktFile3 = ktFile2;
            boolean bl = false;
            object = it.isScript() ? ktFile3 : null;
        } else {
            object = null;
        }
        return object;
    }

    private final boolean isScript(KtFile $this$isScript) {
        KtFile contextFile;
        KtFile ktFile2 = contextFile = $this$isScript instanceof KtCodeFragment ? this.getContextFile((KtCodeFragment)$this$isScript) : $this$isScript;
        return ktFile2 != null ? ktFile2.isScript() : false;
    }

    private final KtFile getContextFile(KtCodeFragment $this$getContextFile) {
        PsiElement psiElement2 = $this$getContextFile.getContext();
        if (psiElement2 == null) {
            return null;
        }
        PsiElement contextElement = psiElement2;
        KtElement ktElement = contextElement instanceof KtElement ? (KtElement)contextElement : null;
        if (ktElement == null || (ktElement = ktElement.getContainingKtFile()) == null) {
            throw new AssertionError((Object)("Analyzing kotlin code fragment of type " + $this$getContextFile.getClass() + " with java context of type " + contextElement.getClass()));
        }
        KtElement contextFile = ktElement;
        return contextFile instanceof KtCodeFragment ? this.getContextFile((KtCodeFragment)contextFile) : contextFile;
    }

    private static final CachedValueProvider.Result getResolutionFacade$lambda$0(KotlinCacheServiceImpl this$0, KtFile $file) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$file, (String)"$file");
        PlatformAnalysisSettings settings2 = this$0.platformSettings(ModuleInfoProviderUtils.getModuleInfo((PsiElement)$file), TargetPlatformDetectorUtils.getPlatform((KtElement)$file));
        Object[] objectArray = new Object[]{UastModificationTracker.Companion.getInstance(this$0.project), ProjectRootModificationTracker.getInstance((Project)this$0.project)};
        return new CachedValueProvider.Result((Object)this$0.getFacadeToAnalyzeFile($file, settings2), objectArray);
    }

    private static final GlobalFacade globalFacadesPerPlatformAndSdk$lambda$2(KotlinCacheServiceImpl this$0, PlatformAnalysisSettings it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return this$0.new GlobalFacade(it);
    }

    /*
     * WARNING - void declaration
     */
    private static final long createFacadeForFilesWithSpecialModuleInfo$lambda$8(Set $files) {
        void var3_3;
        Intrinsics.checkNotNullParameter((Object)$files, (String)"$files");
        Iterable $this$sumByLong$iv = $files;
        boolean $i$f$sumByLong = false;
        long sum$iv = 0L;
        for (Object element$iv : $this$sumByLong$iv) {
            void it;
            KtFile ktFile2 = (KtFile)element$iv;
            long l = sum$iv;
            boolean bl = false;
            long l2 = PureKotlinCodeBlockModificationListenerKt.getOutOfBlockModificationCount((KtFile)it);
            sum$iv = l + l2;
        }
        return (long)var3_3;
    }

    /*
     * WARNING - void declaration
     */
    private static final long createFacadeForFilesWithSpecialModuleInfo$lambda$10(Set $files) {
        void var3_3;
        Intrinsics.checkNotNullParameter((Object)$files, (String)"$files");
        Iterable $this$sumByLong$iv = $files;
        boolean $i$f$sumByLong = false;
        long sum$iv = 0L;
        for (Object element$iv : $this$sumByLong$iv) {
            void it;
            KtFile ktFile2 = (KtFile)element$iv;
            long l = sum$iv;
            boolean bl = false;
            long l2 = it.getModificationStamp();
            sum$iv = l + l2;
        }
        return (long)var3_3;
    }

    private static final ProjectResolutionFacade createFacadeForFilesWithSpecialModuleInfo$makeProjectResolutionFacade(KotlinCacheServiceImpl this$0, ModificationTracker dependencyTrackerForSyntheticFileCache, String resolverDebugName2, PlatformAnalysisSettings settings2, Set<? extends KtFile> $files, String debugName, GlobalContextImpl globalContext, ProjectResolutionFacade reuseDataFrom, Function1<? super IdeaModuleInfo, Boolean> moduleFilter, Collection<? extends IdeaModuleInfo> allModules2) {
        Project project2 = this$0.project;
        Object[] objectArray = new ModificationTracker[]{dependencyTrackerForSyntheticFileCache, ProjectRootModificationTracker.getInstance((Project)this$0.project)};
        List list2 = CollectionsKt.listOf((Object[])objectArray);
        return new ProjectResolutionFacade(debugName, resolverDebugName2, project2, globalContext, settings2, reuseDataFrom, moduleFilter, list2, true, (Collection<? extends KtFile>)$files, allModules2);
    }

    static /* synthetic */ ProjectResolutionFacade createFacadeForFilesWithSpecialModuleInfo$makeProjectResolutionFacade$default(KotlinCacheServiceImpl kotlinCacheServiceImpl, ModificationTracker modificationTracker, String string, PlatformAnalysisSettings platformAnalysisSettings, Set set, String string2, GlobalContextImpl globalContextImpl, ProjectResolutionFacade projectResolutionFacade, Function1 function1, Collection collection, int n, Object object) {
        if ((n & 0x80) != 0) {
            projectResolutionFacade = null;
        }
        if ((n & 0x100) != 0) {
            function1 = createFacadeForFilesWithSpecialModuleInfo.makeProjectResolutionFacade.1.INSTANCE;
        }
        if ((n & 0x200) != 0) {
            collection = null;
        }
        return KotlinCacheServiceImpl.createFacadeForFilesWithSpecialModuleInfo$makeProjectResolutionFacade(kotlinCacheServiceImpl, modificationTracker, string, platformAnalysisSettings, set, string2, globalContextImpl, projectResolutionFacade, (Function1<? super IdeaModuleInfo, Boolean>)function1, collection);
    }

    private static final CachedValueProvider.Result kotlinSuppressCache$lambda$11(KotlinCacheServiceImpl this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Object[] objectArray = this$0.project;
        KotlinSuppressCache kotlinSuppressCache2 = new KotlinSuppressCache((Project)objectArray){

            /*
             * WARNING - void declaration
             */
            @NotNull
            public List<AnnotationDescriptor> getSuppressionAnnotations(@NotNull PsiElement annotated) {
                void $this$mapNotNullTo$iv$iv;
                Object object;
                Intrinsics.checkNotNullParameter((Object)annotated, (String)"annotated");
                if (!(annotated instanceof KtAnnotated)) {
                    return CollectionsKt.emptyList();
                }
                if (!KotlinPsiHeuristics.hasSuppressAnnotation((KtAnnotated)annotated)) {
                    return CollectionsKt.emptyList();
                }
                PsiElement psiElement2 = annotated;
                if (psiElement2 instanceof KtFile) {
                    KtFileAnnotationList ktFileAnnotationList = ((KtFile)annotated).getFileAnnotationList();
                    object = ktFileAnnotationList != null ? ResolutionUtils.safeAnalyze((KtElement)ktFileAnnotationList, BodyResolveMode.PARTIAL_NO_ADDITIONAL) : null;
                } else if (psiElement2 instanceof KtModifierListOwner) {
                    KtModifierList ktModifierList = ((KtModifierListOwner)annotated).getModifierList();
                    object = ktModifierList != null ? ResolutionUtils.safeAnalyze((KtElement)ktModifierList, BodyResolveMode.PARTIAL_NO_ADDITIONAL) : null;
                } else {
                    object = ResolutionUtils.safeAnalyze((KtElement)annotated, BodyResolveMode.PARTIAL_NO_ADDITIONAL);
                }
                if (object == null) {
                    return CollectionsKt.emptyList();
                }
                BindingContext context2 = object;
                DeclarationDescriptor annotatedDescriptor = (DeclarationDescriptor)context2.get(BindingContext.DECLARATION_TO_DESCRIPTOR, (Object)annotated);
                if (annotatedDescriptor != null) {
                    return CollectionsKt.toList((Iterable)((Iterable)annotatedDescriptor.getAnnotations()));
                }
                List list2 = ((KtAnnotated)annotated).getAnnotationEntries();
                Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getAnnotationEntries(...)");
                Iterable $this$mapNotNull$iv = list2;
                boolean $i$f$mapNotNull = false;
                Iterable iterable = $this$mapNotNull$iv;
                Collection destination$iv$iv = new ArrayList<E>();
                boolean $i$f$mapNotNullTo = false;
                void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                boolean $i$f$forEach = false;
                Iterator<T> iterator2 = $this$forEach$iv$iv$iv.iterator();
                while (iterator2.hasNext()) {
                    AnnotationDescriptor it$iv$iv;
                    T element$iv$iv$iv;
                    T element$iv$iv = element$iv$iv$iv = iterator2.next();
                    boolean bl = false;
                    KtAnnotationEntry it = (KtAnnotationEntry)element$iv$iv;
                    boolean bl2 = false;
                    if ((AnnotationDescriptor)context2.get((ReadOnlySlice)BindingContext.ANNOTATION, (Object)it) == null) continue;
                    boolean bl3 = false;
                    destination$iv$iv.add(it$iv$iv);
                }
                return (List)destination$iv$iv;
            }
        };
        objectArray = new Object[]{JavaLibraryModificationTracker.getInstance((Project)this$0.project), UastModificationTracker.Companion.getInstance(this$0.project)};
        return new CachedValueProvider.Result((Object)kotlinSuppressCache2, objectArray);
    }

    private static final ProjectResolutionFacade specialFilesCacheProvider$lambda$13$lambda$12(KotlinCacheServiceImpl this$0, Pair it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return this$0.createFacadeForFilesWithSpecialModuleInfo((Set)it.getFirst(), (PlatformAnalysisSettings)it.getSecond());
    }

    private static final CachedValueProvider.Result specialFilesCacheProvider$lambda$13(KotlinCacheServiceImpl this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Object[] objectArray = new Object[]{JavaLibraryModificationTracker.getInstance((Project)this$0.project), ProjectRootModificationTracker.getInstance((Project)this$0.project)};
        return new CachedValueProvider.Result((Object)SLRUCache.slruCache((int)2, (int)3, arg_0 -> KotlinCacheServiceImpl.specialFilesCacheProvider$lambda$13$lambda$12(this$0, arg_0)), objectArray);
    }

    private static final CachedValueProvider.Result scriptsCacheProvider$lambda$14(KotlinCacheServiceImpl this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Object[] objectArray = new Object[]{JavaLibraryModificationTracker.getInstance((Project)this$0.project), ProjectRootModificationTracker.getInstance((Project)this$0.project), ScriptDependenciesModificationTracker.Companion.getInstance(this$0.project)};
        return new CachedValueProvider.Result((Object)SLRUCache.slruCache((int)10, (int)5, p0 -> KotlinCacheServiceImpl.createFacadeForFilesWithSpecialModuleInfo$default(this$0, p0, null, 2, null)), objectArray);
    }

    public static final /* synthetic */ ProjectResolutionFacade access$createFacadeForScriptDependencies(KotlinCacheServiceImpl $this, ScriptDependenciesInfo dependenciesModuleInfo) {
        return $this.createFacadeForScriptDependencies(dependenciesModuleInfo);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0082\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\t\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\bR\u0011\u0010\u000b\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\bR\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/idea/caches/resolve/KotlinCacheServiceImpl$GlobalFacade;", "", "settings", "Lorg/jetbrains/kotlin/caches/resolve/PlatformAnalysisSettings;", "(Lorg/jetbrains/kotlin/idea/caches/resolve/KotlinCacheServiceImpl;Lorg/jetbrains/kotlin/caches/resolve/PlatformAnalysisSettings;)V", "facadeForLibraries", "Lorg/jetbrains/kotlin/idea/caches/resolve/ProjectResolutionFacade;", "getFacadeForLibraries", "()Lorg/jetbrains/kotlin/idea/caches/resolve/ProjectResolutionFacade;", "facadeForModules", "getFacadeForModules", "facadeForSdk", "getFacadeForSdk", "librariesContext", "Lorg/jetbrains/kotlin/context/GlobalContextImpl;", "moduleFilters", "Lorg/jetbrains/kotlin/idea/caches/resolve/util/GlobalFacadeModuleFilters;", "modulesContext", "sdkContext", "kotlin.base.fe10.analysis"})
    private final class GlobalFacade {
        @NotNull
        private final GlobalContextImpl sdkContext;
        @NotNull
        private final GlobalFacadeModuleFilters moduleFilters;
        @NotNull
        private final ProjectResolutionFacade facadeForSdk;
        @NotNull
        private final GlobalContextImpl librariesContext;
        @NotNull
        private final ProjectResolutionFacade facadeForLibraries;
        @NotNull
        private final GlobalContextImpl modulesContext;
        @NotNull
        private final ProjectResolutionFacade facadeForModules;

        public GlobalFacade(PlatformAnalysisSettings settings2) {
            Intrinsics.checkNotNullParameter((Object)settings2, (String)"settings");
            this.sdkContext = ContextKt.GlobalContext((String)"sdk");
            this.moduleFilters = new GlobalFacadeModuleFilters(KotlinCacheServiceImpl.this.getProject());
            String string = "sdk with settings=" + settings2;
            Project project2 = KotlinCacheServiceImpl.this.getProject();
            GlobalContextImpl globalContextImpl = this.sdkContext;
            Object object = (KFunction)new Function1<IdeaModuleInfo, Boolean>((Object)this.moduleFilters){

                @NotNull
                public final Boolean invoke(@NotNull IdeaModuleInfo p0) {
                    Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                    return ((GlobalFacadeModuleFilters)this.receiver).sdkFacadeFilter(p0);
                }
            };
            Object object2 = new ModificationTracker[]{JavaLibraryModificationTracker.getInstance((Project)KotlinCacheServiceImpl.this.getProject()), ProjectRootModificationTracker.getInstance((Project)KotlinCacheServiceImpl.this.getProject())};
            List list2 = CollectionsKt.listOf((Object[])object2);
            this.facadeForSdk = new ProjectResolutionFacade("facadeForSdk", string, project2, globalContextImpl, settings2, null, (Function1)object, list2, false, null, null, 1536, null);
            this.librariesContext = GlobalContextUtilsKt.contextWithCompositeExceptionTracker(this.sdkContext, KotlinCacheServiceImpl.this.getProject(), "project libraries");
            string = "project libraries with settings=" + settings2;
            project2 = KotlinCacheServiceImpl.this.getProject();
            globalContextImpl = this.librariesContext;
            object = this.facadeForSdk;
            list2 = (KFunction)new Function1<IdeaModuleInfo, Boolean>((Object)this.moduleFilters){

                @NotNull
                public final Boolean invoke(@NotNull IdeaModuleInfo p0) {
                    Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                    return ((GlobalFacadeModuleFilters)this.receiver).libraryFacadeFilter(p0);
                }
            };
            Object[] objectArray = new ModificationTracker[]{JavaLibraryModificationTracker.getInstance((Project)KotlinCacheServiceImpl.this.getProject()), ProjectRootModificationTracker.getInstance((Project)KotlinCacheServiceImpl.this.getProject())};
            object2 = CollectionsKt.listOf((Object[])objectArray);
            this.facadeForLibraries = new ProjectResolutionFacade("facadeForLibraries", string, project2, globalContextImpl, settings2, (ProjectResolutionFacade)object, (Function1)list2, (List)object2, false, null, null, 1536, null);
            this.modulesContext = GlobalContextUtilsKt.contextWithCompositeExceptionTracker(this.librariesContext, KotlinCacheServiceImpl.this.getProject(), "project source roots and libraries");
            this.facadeForModules = new ProjectResolutionFacade("facadeForModules", "project source roots and libraries with settings=" + settings2, KotlinCacheServiceImpl.this.getProject(), this.modulesContext, settings2, this.facadeForLibraries, (Function1)new Function1<IdeaModuleInfo, Boolean>((Object)this.moduleFilters){

                @NotNull
                public final Boolean invoke(@NotNull IdeaModuleInfo p0) {
                    Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                    return ((GlobalFacadeModuleFilters)this.receiver).moduleFacadeFilter(p0);
                }
            }, CollectionsKt.listOf((Object)ProjectRootModificationTracker.getInstance((Project)KotlinCacheServiceImpl.this.getProject())), true, null, null, 1536, null);
        }

        @NotNull
        public final ProjectResolutionFacade getFacadeForSdk() {
            return this.facadeForSdk;
        }

        @NotNull
        public final ProjectResolutionFacade getFacadeForLibraries() {
            return this.facadeForLibraries;
        }

        @NotNull
        public final ProjectResolutionFacade getFacadeForModules() {
            return this.facadeForModules;
        }
    }
}

