/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.caches;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PsiShortNamesCache;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Processor;
import com.intellij.util.Processors;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.IdFilter;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analysis.decompiler.psi.KotlinBuiltInFileType;
import org.jetbrains.kotlin.asJava.LightClassUtil;
import org.jetbrains.kotlin.asJava.LightClassUtilKt;
import org.jetbrains.kotlin.asJava.LightClassUtilsKt;
import org.jetbrains.kotlin.asJava.finder.JavaElementFinder;
import org.jetbrains.kotlin.fileClasses.JvmFileClassUtilKt;
import org.jetbrains.kotlin.idea.base.projectStructure.scope.KotlinSourceFilterScope;
import org.jetbrains.kotlin.idea.base.psi.KotlinPsiHeuristics;
import org.jetbrains.kotlin.idea.stubindex.KotlinClassShortNameIndex;
import org.jetbrains.kotlin.idea.stubindex.KotlinFileFacadeShortNameIndex;
import org.jetbrains.kotlin.idea.stubindex.KotlinFunctionShortNameIndex;
import org.jetbrains.kotlin.idea.stubindex.KotlinPropertyShortNameIndex;
import org.jetbrains.kotlin.load.java.JvmAbi;
import org.jetbrains.kotlin.load.java.PropertiesConventionUtilKt;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtAnnotated;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtModifierListOwner;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtValVarKeywordOwner;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u0000 62\u00020\u0001:\u000256B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0013\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0016\u00a2\u0006\u0002\u0010\rJ\u0013\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0016\u00a2\u0006\u0002\u0010\rJ\u0013\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0016\u00a2\u0006\u0002\u0010\rJ#\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\u000b2\u0006\u0010\u0012\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\u0014H\u0016\u00a2\u0006\u0002\u0010\u0015J#\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00170\u000b2\u0006\u0010\u0012\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\u0014H\u0016\u00a2\u0006\u0002\u0010\u0018J+\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00170\u000b2\u0006\u0010\u0012\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u001a\u001a\u00020\u001bH\u0016\u00a2\u0006\u0002\u0010\u001cJ#\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001e0\u000b2\u0006\u0010\u0012\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\u0014H\u0016\u00a2\u0006\u0002\u0010\u001fJ+\u0010 \u001a\b\u0012\u0004\u0012\u00020\u001e0\u000b2\u0006\u0010\u0012\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u001a\u001a\u00020\u001bH\u0016\u00a2\u0006\u0002\u0010!J\u0010\u0010\"\u001a\u00020\u00142\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0018\u0010#\u001a\u00020\u00072\u000e\u0010$\u001a\n\u0012\u0006\b\u0000\u0012\u00020\f0%H\u0016J*\u0010#\u001a\u00020\u00072\u000e\u0010$\u001a\n\u0012\u0006\b\u0000\u0012\u00020\f0%2\u0006\u0010\u0013\u001a\u00020\u00142\b\u0010&\u001a\u0004\u0018\u00010'H\u0016J\u0018\u0010(\u001a\u00020\u00072\u000e\u0010$\u001a\n\u0012\u0006\b\u0000\u0012\u00020\f0%H\u0002J*\u0010(\u001a\u00020\u00072\u000e\u0010$\u001a\n\u0012\u0006\b\u0000\u0012\u00020\f0%2\u0006\u0010\u0013\u001a\u00020\u00142\b\u0010&\u001a\u0004\u0018\u00010'H\u0016J\u0018\u0010)\u001a\u00020\u00072\u000e\u0010$\u001a\n\u0012\u0006\b\u0000\u0012\u00020\f0%H\u0002J*\u0010)\u001a\u00020\u00072\u000e\u0010$\u001a\n\u0012\u0006\b\u0000\u0012\u00020\f0%2\u0006\u0010\u0013\u001a\u00020\u00142\b\u0010&\u001a\u0004\u0018\u00010'H\u0016J2\u0010*\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\f2\u000e\u0010$\u001a\n\u0012\u0006\b\u0000\u0012\u00020\u00110%2\u0006\u0010\u0013\u001a\u00020\u00142\b\u0010&\u001a\u0004\u0018\u00010'H\u0016J2\u0010+\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\f2\u000e\u0010$\u001a\n\u0012\u0006\b\u0000\u0012\u00020\u00170%2\u0006\u0010\u0013\u001a\u00020\u00142\b\u0010&\u001a\u0004\u0018\u00010'H\u0016J(\u0010,\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\u00142\u000e\u0010$\u001a\n\u0012\u0006\b\u0000\u0012\u00020\u001e0%H\u0016J2\u0010,\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\f2\u000e\u0010$\u001a\n\u0012\u0006\b\u0000\u0012\u00020\u001e0%2\u0006\u0010\u0013\u001a\u00020\u00142\b\u0010&\u001a\u0004\u0018\u00010'H\u0016JB\u0010-\u001a\b\u0012\u0004\u0012\u0002H.0\u000b\"\u0004\b\u0000\u0010.2\f\u0010/\u001a\b\u0012\u0004\u0012\u0002H.0\u000b2\u0018\u00100\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u0002H.02\u0012\u0004\u0012\u00020301H\u0082\b\u00a2\u0006\u0002\u00104R\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00067"}, d2={"Lorg/jetbrains/kotlin/idea/caches/KotlinShortNamesCache;", "Lcom/intellij/psi/search/PsiShortNamesCache;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "disableSearch", "Ljava/lang/ThreadLocal;", "", "getDisableSearch", "()Ljava/lang/ThreadLocal;", "getAllClassNames", "", "", "()[Ljava/lang/String;", "getAllFieldNames", "getAllMethodNames", "getClassesByName", "Lcom/intellij/psi/PsiClass;", "name", "scope", "Lcom/intellij/psi/search/GlobalSearchScope;", "(Ljava/lang/String;Lcom/intellij/psi/search/GlobalSearchScope;)[Lcom/intellij/psi/PsiClass;", "getFieldsByName", "Lcom/intellij/psi/PsiField;", "(Ljava/lang/String;Lcom/intellij/psi/search/GlobalSearchScope;)[Lcom/intellij/psi/PsiField;", "getFieldsByNameIfNotMoreThan", "maxCount", "", "(Ljava/lang/String;Lcom/intellij/psi/search/GlobalSearchScope;I)[Lcom/intellij/psi/PsiField;", "getMethodsByName", "Lcom/intellij/psi/PsiMethod;", "(Ljava/lang/String;Lcom/intellij/psi/search/GlobalSearchScope;)[Lcom/intellij/psi/PsiMethod;", "getMethodsByNameIfNotMoreThan", "(Ljava/lang/String;Lcom/intellij/psi/search/GlobalSearchScope;I)[Lcom/intellij/psi/PsiMethod;", "kotlinDeclarationsVisibleFromJavaScope", "processAllClassNames", "processor", "Lcom/intellij/util/Processor;", "filter", "Lcom/intellij/util/indexing/IdFilter;", "processAllFieldNames", "processAllMethodNames", "processClassesWithName", "processFieldsWithName", "processMethodsWithName", "withArrayProcessor", "T", "result", "process", "Lkotlin/Function1;", "Lorg/jetbrains/kotlin/idea/caches/KotlinShortNamesCache$CancelableArrayCollectProcessor;", "", "([Ljava/lang/Object;Lkotlin/jvm/functions/Function1;)[Ljava/lang/Object;", "CancelableArrayCollectProcessor", "Companion", "kotlin.base.analysis"})
@SourceDebugExtension(value={"SMAP\nKotlinShortNamesCache.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinShortNamesCache.kt\norg/jetbrains/kotlin/idea/caches/KotlinShortNamesCache\n*L\n1#1,340:1\n322#1,3:341\n322#1,3:344\n322#1,3:347\n322#1,3:350\n322#1,3:353\n322#1,3:356\n322#1,3:359\n322#1,3:362\n*S KotlinDebug\n*F\n+ 1 KotlinShortNamesCache.kt\norg/jetbrains/kotlin/idea/caches/KotlinShortNamesCache\n*L\n69#1:341,3\n133#1:344,3\n162#1:347,3\n224#1:350,3\n233#1:353,3\n264#1:356,3\n296#1:359,3\n305#1:362,3\n*E\n"})
public final class KotlinShortNamesCache
extends PsiShortNamesCache {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final ThreadLocal<Boolean> disableSearch;
    @NotNull
    private static final Logger LOG;

    public KotlinShortNamesCache(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        this.project = project2;
        this.disableSearch = new ThreadLocal<Boolean>(){

            @NotNull
            protected Boolean initialValue() {
                return false;
            }
        };
    }

    @NotNull
    public final ThreadLocal<Boolean> getDisableSearch() {
        return this.disableSearch;
    }

    public boolean processAllClassNames(@NotNull Processor<? super String> processor2) {
        Intrinsics.checkNotNullParameter(processor2, (String)"processor");
        Boolean bl = this.disableSearch.get();
        Intrinsics.checkNotNullExpressionValue((Object)bl, (String)"get(...)");
        if (bl.booleanValue()) {
            return true;
        }
        return KotlinClassShortNameIndex.Helper.processAllKeys(this.project, processor2) && KotlinFileFacadeShortNameIndex.Helper.processAllKeys(this.project, processor2);
    }

    public boolean processAllClassNames(@NotNull Processor<? super String> processor2, @NotNull GlobalSearchScope scope2, @Nullable IdFilter filter2) {
        Intrinsics.checkNotNullParameter(processor2, (String)"processor");
        Intrinsics.checkNotNullParameter((Object)scope2, (String)"scope");
        Boolean bl = this.disableSearch.get();
        Intrinsics.checkNotNullExpressionValue((Object)bl, (String)"get(...)");
        if (bl.booleanValue()) {
            return true;
        }
        return this.processAllClassNames(processor2);
    }

    @NotNull
    public String[] getAllClassNames() {
        CancelableArrayCollectProcessor<Object> cancelableArrayCollectProcessor;
        Boolean bl = this.disableSearch.get();
        Intrinsics.checkNotNullExpressionValue((Object)bl, (String)"get(...)");
        if (bl.booleanValue()) {
            Intrinsics.checkNotNullExpressionValue((Object)ArrayUtil.EMPTY_STRING_ARRAY, (String)"EMPTY_STRING_ARRAY");
            return ArrayUtil.EMPTY_STRING_ARRAY;
        }
        KotlinShortNamesCache kotlinShortNamesCache = this;
        Intrinsics.checkNotNullExpressionValue((Object)ArrayUtil.EMPTY_STRING_ARRAY, (String)"EMPTY_STRING_ARRAY");
        Object[] result$iv = ArrayUtil.EMPTY_STRING_ARRAY;
        boolean $i$f$withArrayProcessor = false;
        CancelableArrayCollectProcessor<Object> processor$iv = cancelableArrayCollectProcessor = new CancelableArrayCollectProcessor<Object>();
        boolean bl2 = false;
        CancelableArrayCollectProcessor<Object> processor2 = processor$iv;
        boolean bl3 = false;
        this.processAllClassNames((Processor<? super String>)processor2);
        return (String[])cancelableArrayCollectProcessor.toArray(result$iv);
    }

    public boolean processClassesWithName(@NotNull String name2, @NotNull Processor<? super PsiClass> processor2, @NotNull GlobalSearchScope scope2, @Nullable IdFilter filter2) {
        Processor fqNameProcessor;
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        Intrinsics.checkNotNullParameter(processor2, (String)"processor");
        Intrinsics.checkNotNullParameter((Object)scope2, (String)"scope");
        Boolean bl = this.disableSearch.get();
        Intrinsics.checkNotNullExpressionValue((Object)bl, (String)"get(...)");
        if (bl.booleanValue()) {
            return true;
        }
        GlobalSearchScope effectiveScope = this.kotlinDeclarationsVisibleFromJavaScope(scope2);
        boolean allKtClassOrObjectsProcessed2 = KotlinClassShortNameIndex.Helper.processElements(name2, this.project, effectiveScope, filter2, arg_0 -> KotlinShortNamesCache.processClassesWithName$lambda$2((Function1)new Function1<KtClassOrObject, Boolean>((Processor<FqName>)(fqNameProcessor = arg_0 -> KotlinShortNamesCache.processClassesWithName$lambda$1(name2, this, effectiveScope, processor2, arg_0))){
            final /* synthetic */ Processor<FqName> $fqNameProcessor;
            {
                this.$fqNameProcessor = $fqNameProcessor;
                super(1);
            }

            @NotNull
            public final Boolean invoke(KtClassOrObject ktClassOrObject) {
                return this.$fqNameProcessor.process((Object)ktClassOrObject.getFqName());
            }
        }, arg_0));
        if (!allKtClassOrObjectsProcessed2) {
            return false;
        }
        return KotlinFileFacadeShortNameIndex.Helper.processElements(name2, this.project, effectiveScope, filter2, arg_0 -> KotlinShortNamesCache.processClassesWithName$lambda$3((Function1)new Function1<KtFile, Boolean>((Processor<FqName>)fqNameProcessor){
            final /* synthetic */ Processor<FqName> $fqNameProcessor;
            {
                this.$fqNameProcessor = $fqNameProcessor;
                super(1);
            }

            @NotNull
            public final Boolean invoke(KtFile ktFile2) {
                Intrinsics.checkNotNull((Object)ktFile2);
                return this.$fqNameProcessor.process((Object)JvmFileClassUtilKt.getJavaFileFacadeFqName((KtFile)ktFile2));
            }
        }, arg_0));
    }

    @NotNull
    public PsiClass[] getClassesByName(@NotNull String name2, @NotNull GlobalSearchScope scope2) {
        CancelableArrayCollectProcessor<Object> cancelableArrayCollectProcessor;
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        Intrinsics.checkNotNullParameter((Object)scope2, (String)"scope");
        Boolean bl = this.disableSearch.get();
        Intrinsics.checkNotNullExpressionValue((Object)bl, (String)"get(...)");
        if (bl.booleanValue()) {
            Intrinsics.checkNotNullExpressionValue((Object)PsiClass.EMPTY_ARRAY, (String)"EMPTY_ARRAY");
            return PsiClass.EMPTY_ARRAY;
        }
        KotlinShortNamesCache kotlinShortNamesCache = this;
        Intrinsics.checkNotNullExpressionValue((Object)PsiClass.EMPTY_ARRAY, (String)"EMPTY_ARRAY");
        Object[] result$iv = PsiClass.EMPTY_ARRAY;
        boolean $i$f$withArrayProcessor = false;
        CancelableArrayCollectProcessor<Object> processor$iv = cancelableArrayCollectProcessor = new CancelableArrayCollectProcessor<Object>();
        boolean bl2 = false;
        CancelableArrayCollectProcessor<Object> processor2 = processor$iv;
        boolean bl3 = false;
        this.processClassesWithName(name2, (Processor<? super PsiClass>)processor2, scope2, null);
        return (PsiClass[])cancelableArrayCollectProcessor.toArray(result$iv);
    }

    private final GlobalSearchScope kotlinDeclarationsVisibleFromJavaScope(GlobalSearchScope scope2) {
        Project project2 = this.project;
        GlobalSearchScope noBuiltInsScope2 = new GlobalSearchScope(project2){

            public boolean isSearchInModuleContent(@NotNull Module aModule) {
                Intrinsics.checkNotNullParameter((Object)aModule, (String)"aModule");
                return true;
            }

            public int compare(@NotNull VirtualFile file1, @NotNull VirtualFile file2) {
                Intrinsics.checkNotNullParameter((Object)file1, (String)"file1");
                Intrinsics.checkNotNullParameter((Object)file2, (String)"file2");
                return 0;
            }

            public boolean isSearchInLibraries() {
                return true;
            }

            public boolean contains(@NotNull VirtualFile file2) {
                Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
                return !FileTypeRegistry.getInstance().isFileOfType(file2, (FileType)KotlinBuiltInFileType.INSTANCE);
            }
        };
        GlobalSearchScope globalSearchScope = KotlinSourceFilterScope.Companion.projectSourcesAndLibraryClasses(scope2, this.project).intersectWith(noBuiltInsScope2);
        Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope, (String)"intersectWith(...)");
        return globalSearchScope;
    }

    public boolean processAllMethodNames(@NotNull Processor<? super String> processor2, @NotNull GlobalSearchScope scope2, @Nullable IdFilter filter2) {
        Intrinsics.checkNotNullParameter(processor2, (String)"processor");
        Intrinsics.checkNotNullParameter((Object)scope2, (String)"scope");
        Boolean bl = this.disableSearch.get();
        Intrinsics.checkNotNullExpressionValue((Object)bl, (String)"get(...)");
        if (bl.booleanValue()) {
            return true;
        }
        return this.processAllMethodNames(processor2);
    }

    @NotNull
    public String[] getAllMethodNames() {
        CancelableArrayCollectProcessor<Object> cancelableArrayCollectProcessor;
        Boolean bl = this.disableSearch.get();
        Intrinsics.checkNotNullExpressionValue((Object)bl, (String)"get(...)");
        if (bl.booleanValue()) {
        }
        KotlinShortNamesCache kotlinShortNamesCache = this;
        Intrinsics.checkNotNullExpressionValue((Object)ArrayUtil.EMPTY_STRING_ARRAY, (String)"EMPTY_STRING_ARRAY");
        Object[] result$iv = ArrayUtil.EMPTY_STRING_ARRAY;
        boolean $i$f$withArrayProcessor = false;
        CancelableArrayCollectProcessor<Object> processor$iv = cancelableArrayCollectProcessor = new CancelableArrayCollectProcessor<Object>();
        boolean bl2 = false;
        CancelableArrayCollectProcessor<Object> processor2 = processor$iv;
        boolean bl3 = false;
        this.processAllMethodNames((Processor<? super String>)processor2);
        return (String[])cancelableArrayCollectProcessor.toArray(result$iv);
    }

    private final boolean processAllMethodNames(Processor<? super String> processor2) {
        Boolean bl = this.disableSearch.get();
        Intrinsics.checkNotNullExpressionValue((Object)bl, (String)"get(...)");
        if (bl.booleanValue()) {
            return true;
        }
        if (!KotlinFunctionShortNameIndex.Helper.processAllKeys(this.project, processor2)) {
            return false;
        }
        return KotlinPropertyShortNameIndex.Helper.processAllKeys(this.project, (Processor<String>)((Processor)arg_0 -> KotlinShortNamesCache.processAllMethodNames$lambda$6((Function1)new Function1<String, Boolean>(processor2){
            final /* synthetic */ Processor<? super String> $processor;
            {
                this.$processor = $processor;
                super(1);
            }

            @NotNull
            public final Boolean invoke(String name2) {
                Intrinsics.checkNotNull((Object)name2);
                return this.$processor.process((Object)JvmAbi.setterName((String)name2)) && this.$processor.process((Object)JvmAbi.getterName((String)name2));
            }
        }, arg_0)));
    }

    public boolean processMethodsWithName(@NotNull String name2, @NotNull Processor<? super PsiMethod> processor2, @NotNull GlobalSearchScope scope2, @Nullable IdFilter filter2) {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        Intrinsics.checkNotNullParameter(processor2, (String)"processor");
        Intrinsics.checkNotNullParameter((Object)scope2, (String)"scope");
        Boolean bl = this.disableSearch.get();
        Intrinsics.checkNotNullExpressionValue((Object)bl, (String)"get(...)");
        if (bl.booleanValue() || DumbService.Companion.isDumb(this.project)) {
            return true;
        }
        boolean allFunctionsProcessed2 = KotlinFunctionShortNameIndex.Helper.processElements(name2, this.project, scope2, filter2, arg_0 -> KotlinShortNamesCache.processMethodsWithName$lambda$7((Function1)new Function1<KtNamedFunction, Boolean>(name2, processor2){
            final /* synthetic */ String $name;
            final /* synthetic */ Processor<? super PsiMethod> $processor;
            {
                this.$name = $name;
                this.$processor = $processor;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final Boolean invoke(KtNamedFunction ktNamedFunction) {
                boolean bl;
                block3: {
                    void $this$all$iv;
                    ProgressManager.checkCanceled();
                    Intrinsics.checkNotNull((Object)ktNamedFunction);
                    List methods2 = SequencesKt.toList((Sequence)LightClassUtil.INSTANCE.getLightClassMethodsByName((KtFunction)ktNamedFunction, this.$name));
                    Iterable iterable = methods2;
                    Processor<? super PsiMethod> processor2 = this.$processor;
                    boolean $i$f$all = false;
                    if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                        bl = true;
                    } else {
                        for (T element$iv : $this$all$iv) {
                            PsiMethod p0 = (PsiMethod)element$iv;
                            boolean bl2 = false;
                            if (processor2.process((Object)p0)) continue;
                            bl = false;
                            break block3;
                        }
                        bl = true;
                    }
                }
                return bl;
            }
        }, arg_0));
        if (!allFunctionsProcessed2) {
            return false;
        }
        Name name3 = Name.identifier((String)name2);
        Intrinsics.checkNotNullExpressionValue((Object)name3, (String)"identifier(...)");
        for (Name propertyName : PropertiesConventionUtilKt.getPropertyNamesCandidatesByAccessorName((Name)name3)) {
            String string = propertyName.asString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"asString(...)");
            boolean allProcessed2 = KotlinPropertyShortNameIndex.Helper.processElements(string, this.project, scope2, filter2, arg_0 -> KotlinShortNamesCache.processMethodsWithName$lambda$8((Function1)new Function1<KtNamedDeclaration, Boolean>(processor2, name2){
                final /* synthetic */ Processor<? super PsiMethod> $processor;
                final /* synthetic */ String $name;
                {
                    this.$processor = $processor;
                    this.$name = $name;
                    super(1);
                }

                /*
                 * WARNING - void declaration
                 */
                @NotNull
                public final Boolean invoke(KtNamedDeclaration ktNamedDeclaration) {
                    boolean bl;
                    block2: {
                        void $this$all$iv;
                        ProgressManager.checkCanceled();
                        if (ktNamedDeclaration instanceof KtValVarKeywordOwner && (KtPsiUtilKt.isPrivate((KtModifierListOwner)((KtModifierListOwner)ktNamedDeclaration)) || KotlinPsiHeuristics.hasJvmFieldAnnotation((KtAnnotated)ktNamedDeclaration))) {
                            return true;
                        }
                        Intrinsics.checkNotNull((Object)ktNamedDeclaration);
                        Sequence sequence2 = SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)((Iterable)LightClassUtilKt.getAccessorLightMethods((KtNamedDeclaration)ktNamedDeclaration))), (Function1)((Function1)new Function1<PsiMethod, Boolean>(this.$name){
                            final /* synthetic */ String $name;
                            {
                                this.$name = $name;
                                super(1);
                            }

                            @NotNull
                            public final Boolean invoke(@NotNull PsiMethod it) {
                                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                                return Intrinsics.areEqual((Object)it.getName(), (Object)this.$name);
                            }
                        }));
                        Processor<? super PsiMethod> processor2 = this.$processor;
                        boolean $i$f$all = false;
                        for (E element$iv : $this$all$iv) {
                            PsiMethod p0 = (PsiMethod)element$iv;
                            boolean bl2 = false;
                            if (processor2.process((Object)p0)) continue;
                            bl = false;
                            break block2;
                        }
                        bl = true;
                    }
                    return bl;
                }
            }, arg_0));
            if (allProcessed2) continue;
            return false;
        }
        return true;
    }

    @NotNull
    public PsiMethod[] getMethodsByName(@NotNull String name2, @NotNull GlobalSearchScope scope2) {
        CancelableArrayCollectProcessor<Object> cancelableArrayCollectProcessor;
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        Intrinsics.checkNotNullParameter((Object)scope2, (String)"scope");
        Boolean bl = this.disableSearch.get();
        Intrinsics.checkNotNullExpressionValue((Object)bl, (String)"get(...)");
        if (bl.booleanValue()) {
            Intrinsics.checkNotNullExpressionValue((Object)PsiMethod.EMPTY_ARRAY, (String)"EMPTY_ARRAY");
            return PsiMethod.EMPTY_ARRAY;
        }
        KotlinShortNamesCache kotlinShortNamesCache = this;
        Intrinsics.checkNotNullExpressionValue((Object)PsiMethod.EMPTY_ARRAY, (String)"EMPTY_ARRAY");
        Object[] result$iv = PsiMethod.EMPTY_ARRAY;
        boolean $i$f$withArrayProcessor = false;
        CancelableArrayCollectProcessor<Object> processor$iv = cancelableArrayCollectProcessor = new CancelableArrayCollectProcessor<Object>();
        boolean bl2 = false;
        CancelableArrayCollectProcessor<Object> processor2 = processor$iv;
        boolean bl3 = false;
        this.processMethodsWithName(name2, (Processor<? super PsiMethod>)processor2, scope2, null);
        return (PsiMethod[])cancelableArrayCollectProcessor.toArray(result$iv);
    }

    @NotNull
    public PsiMethod[] getMethodsByNameIfNotMoreThan(@NotNull String name2, @NotNull GlobalSearchScope scope2, int maxCount) {
        CancelableArrayCollectProcessor<PsiMethod> cancelableArrayCollectProcessor;
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        Intrinsics.checkNotNullParameter((Object)scope2, (String)"scope");
        Boolean bl = this.disableSearch.get();
        Intrinsics.checkNotNullExpressionValue((Object)bl, (String)"get(...)");
        if (bl.booleanValue()) {
            Intrinsics.checkNotNullExpressionValue((Object)PsiMethod.EMPTY_ARRAY, (String)"EMPTY_ARRAY");
            return PsiMethod.EMPTY_ARRAY;
        }
        if (!(maxCount >= 0)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        KotlinShortNamesCache kotlinShortNamesCache = this;
        Intrinsics.checkNotNullExpressionValue((Object)PsiMethod.EMPTY_ARRAY, (String)"EMPTY_ARRAY");
        Object[] result$iv = PsiMethod.EMPTY_ARRAY;
        boolean $i$f$withArrayProcessor = false;
        CancelableArrayCollectProcessor<PsiMethod> processor$iv = cancelableArrayCollectProcessor = new CancelableArrayCollectProcessor<PsiMethod>();
        boolean bl2 = false;
        CancelableArrayCollectProcessor<PsiMethod> processor2 = processor$iv;
        boolean bl3 = false;
        this.processMethodsWithName(name2, (Processor<? super PsiMethod>)((Processor)arg_0 -> KotlinShortNamesCache.getMethodsByNameIfNotMoreThan$lambda$11$lambda$10((Function1)new Function1<PsiMethod, Boolean>(processor2, maxCount){
            final /* synthetic */ CancelableArrayCollectProcessor<PsiMethod> $processor;
            final /* synthetic */ int $maxCount;
            {
                this.$processor = $processor;
                this.$maxCount = $maxCount;
                super(1);
            }

            @NotNull
            public final Boolean invoke(PsiMethod psiMethod2) {
                return this.$processor.getSize() != this.$maxCount && this.$processor.process(psiMethod2);
            }
        }, arg_0)), scope2, null);
        return cancelableArrayCollectProcessor.toArray((PsiMethod[])result$iv);
    }

    public boolean processMethodsWithName(@NotNull String name2, @NotNull GlobalSearchScope scope2, @NotNull Processor<? super PsiMethod> processor2) {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        Intrinsics.checkNotNullParameter((Object)scope2, (String)"scope");
        Intrinsics.checkNotNullParameter(processor2, (String)"processor");
        Boolean bl = this.disableSearch.get();
        Intrinsics.checkNotNullExpressionValue((Object)bl, (String)"get(...)");
        if (bl.booleanValue()) {
            return true;
        }
        return ContainerUtil.process((Object[])this.getMethodsByName(name2, scope2), processor2);
    }

    public boolean processAllFieldNames(@NotNull Processor<? super String> processor2, @NotNull GlobalSearchScope scope2, @Nullable IdFilter filter2) {
        Intrinsics.checkNotNullParameter(processor2, (String)"processor");
        Intrinsics.checkNotNullParameter((Object)scope2, (String)"scope");
        Boolean bl = this.disableSearch.get();
        Intrinsics.checkNotNullExpressionValue((Object)bl, (String)"get(...)");
        if (bl.booleanValue()) {
            return true;
        }
        return this.processAllFieldNames(processor2);
    }

    @NotNull
    public String[] getAllFieldNames() {
        CancelableArrayCollectProcessor<Object> cancelableArrayCollectProcessor;
        Boolean bl = this.disableSearch.get();
        Intrinsics.checkNotNullExpressionValue((Object)bl, (String)"get(...)");
        if (bl.booleanValue()) {
            Intrinsics.checkNotNullExpressionValue((Object)ArrayUtil.EMPTY_STRING_ARRAY, (String)"EMPTY_STRING_ARRAY");
            return ArrayUtil.EMPTY_STRING_ARRAY;
        }
        KotlinShortNamesCache kotlinShortNamesCache = this;
        Intrinsics.checkNotNullExpressionValue((Object)ArrayUtil.EMPTY_STRING_ARRAY, (String)"EMPTY_STRING_ARRAY");
        Object[] result$iv = ArrayUtil.EMPTY_STRING_ARRAY;
        boolean $i$f$withArrayProcessor = false;
        CancelableArrayCollectProcessor<Object> processor$iv = cancelableArrayCollectProcessor = new CancelableArrayCollectProcessor<Object>();
        boolean bl2 = false;
        CancelableArrayCollectProcessor<Object> processor2 = processor$iv;
        boolean bl3 = false;
        this.processAllFieldNames((Processor<? super String>)processor2);
        return (String[])cancelableArrayCollectProcessor.toArray(result$iv);
    }

    private final boolean processAllFieldNames(Processor<? super String> processor2) {
        Boolean bl = this.disableSearch.get();
        Intrinsics.checkNotNullExpressionValue((Object)bl, (String)"get(...)");
        if (bl.booleanValue()) {
            return true;
        }
        return KotlinPropertyShortNameIndex.Helper.processAllKeys(this.project, processor2);
    }

    public boolean processFieldsWithName(@NotNull String name2, @NotNull Processor<? super PsiField> processor2, @NotNull GlobalSearchScope scope2, @Nullable IdFilter filter2) {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        Intrinsics.checkNotNullParameter(processor2, (String)"processor");
        Intrinsics.checkNotNullParameter((Object)scope2, (String)"scope");
        Boolean bl = this.disableSearch.get();
        Intrinsics.checkNotNullExpressionValue((Object)bl, (String)"get(...)");
        if (bl.booleanValue() || DumbService.Companion.isDumb(this.project)) {
            return true;
        }
        return KotlinPropertyShortNameIndex.Helper.processElements(name2, this.project, scope2, filter2, arg_0 -> KotlinShortNamesCache.processFieldsWithName$lambda$13((Function1)new Function1<KtNamedDeclaration, Boolean>(processor2){
            final /* synthetic */ Processor<? super PsiField> $processor;
            {
                this.$processor = $processor;
                super(1);
            }

            @NotNull
            public final Boolean invoke(KtNamedDeclaration ktNamedDeclaration) {
                Intrinsics.checkNotNull((Object)ktNamedDeclaration);
                PsiField psiField2 = LightClassUtil.INSTANCE.getLightClassBackingField((KtDeclaration)ktNamedDeclaration);
                if (psiField2 == null) {
                    return true;
                }
                PsiField field2 = psiField2;
                return this.$processor.process((Object)field2);
            }
        }, arg_0));
    }

    @NotNull
    public PsiField[] getFieldsByName(@NotNull String name2, @NotNull GlobalSearchScope scope2) {
        CancelableArrayCollectProcessor<Object> cancelableArrayCollectProcessor;
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        Intrinsics.checkNotNullParameter((Object)scope2, (String)"scope");
        Boolean bl = this.disableSearch.get();
        Intrinsics.checkNotNullExpressionValue((Object)bl, (String)"get(...)");
        if (bl.booleanValue()) {
            Intrinsics.checkNotNullExpressionValue((Object)PsiField.EMPTY_ARRAY, (String)"EMPTY_ARRAY");
            return PsiField.EMPTY_ARRAY;
        }
        KotlinShortNamesCache kotlinShortNamesCache = this;
        Intrinsics.checkNotNullExpressionValue((Object)PsiField.EMPTY_ARRAY, (String)"EMPTY_ARRAY");
        Object[] result$iv = PsiField.EMPTY_ARRAY;
        boolean $i$f$withArrayProcessor = false;
        CancelableArrayCollectProcessor<Object> processor$iv = cancelableArrayCollectProcessor = new CancelableArrayCollectProcessor<Object>();
        boolean bl2 = false;
        CancelableArrayCollectProcessor<Object> processor2 = processor$iv;
        boolean bl3 = false;
        this.processFieldsWithName(name2, (Processor<? super PsiField>)processor2, scope2, null);
        return (PsiField[])cancelableArrayCollectProcessor.toArray(result$iv);
    }

    @NotNull
    public PsiField[] getFieldsByNameIfNotMoreThan(@NotNull String name2, @NotNull GlobalSearchScope scope2, int maxCount) {
        CancelableArrayCollectProcessor<PsiField> cancelableArrayCollectProcessor;
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        Intrinsics.checkNotNullParameter((Object)scope2, (String)"scope");
        Boolean bl = this.disableSearch.get();
        Intrinsics.checkNotNullExpressionValue((Object)bl, (String)"get(...)");
        if (bl.booleanValue()) {
            Intrinsics.checkNotNullExpressionValue((Object)PsiField.EMPTY_ARRAY, (String)"EMPTY_ARRAY");
            return PsiField.EMPTY_ARRAY;
        }
        if (!(maxCount >= 0)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        KotlinShortNamesCache kotlinShortNamesCache = this;
        Intrinsics.checkNotNullExpressionValue((Object)PsiField.EMPTY_ARRAY, (String)"EMPTY_ARRAY");
        Object[] result$iv = PsiField.EMPTY_ARRAY;
        boolean $i$f$withArrayProcessor = false;
        CancelableArrayCollectProcessor<PsiField> processor$iv = cancelableArrayCollectProcessor = new CancelableArrayCollectProcessor<PsiField>();
        boolean bl2 = false;
        CancelableArrayCollectProcessor<PsiField> processor2 = processor$iv;
        boolean bl3 = false;
        this.processFieldsWithName(name2, (Processor<? super PsiField>)((Processor)arg_0 -> KotlinShortNamesCache.getFieldsByNameIfNotMoreThan$lambda$16$lambda$15((Function1)new Function1<PsiField, Boolean>(processor2, maxCount){
            final /* synthetic */ CancelableArrayCollectProcessor<PsiField> $processor;
            final /* synthetic */ int $maxCount;
            {
                this.$processor = $processor;
                this.$maxCount = $maxCount;
                super(1);
            }

            @NotNull
            public final Boolean invoke(PsiField psiField2) {
                return this.$processor.getSize() != this.$maxCount && this.$processor.process(psiField2);
            }
        }, arg_0)), scope2, null);
        return cancelableArrayCollectProcessor.toArray((PsiField[])result$iv);
    }

    private final <T> T[] withArrayProcessor(T[] result2, Function1<? super CancelableArrayCollectProcessor<T>, Unit> process2) {
        CancelableArrayCollectProcessor<T> cancelableArrayCollectProcessor;
        boolean $i$f$withArrayProcessor = false;
        CancelableArrayCollectProcessor<T> processor2 = cancelableArrayCollectProcessor = new CancelableArrayCollectProcessor<T>();
        boolean bl = false;
        process2.invoke(processor2);
        return cancelableArrayCollectProcessor.toArray(result2);
    }

    private static final boolean processClassesWithName$lambda$1(String $name, KotlinShortNamesCache this$0, GlobalSearchScope $effectiveScope, Processor $processor, FqName fqName2) {
        boolean isInterfaceDefaultImpl;
        Intrinsics.checkNotNullParameter((Object)$name, (String)"$name");
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$effectiveScope, (String)"$effectiveScope");
        Intrinsics.checkNotNullParameter((Object)$processor, (String)"$processor");
        if (fqName2 == null) {
            return true;
        }
        boolean bl = isInterfaceDefaultImpl = Intrinsics.areEqual((Object)$name, (Object)"DefaultImpls") && !Intrinsics.areEqual((Object)fqName2.shortName().asString(), (Object)$name);
        if (!Intrinsics.areEqual((Object)fqName2.shortName().asString(), (Object)$name) && !isInterfaceDefaultImpl) {
            LOG.error("A declaration obtained from index has non-matching name:\nin index: " + $name + "\ndeclared: " + fqName2.shortName() + "(" + fqName2 + ")");
            return true;
        }
        FqName fqNameToSearch = isInterfaceDefaultImpl ? LightClassUtilsKt.defaultImplsChild((FqName)fqName2) : fqName2;
        JavaElementFinder javaElementFinder = JavaElementFinder.Companion.getInstance(this$0.project);
        String string = fqNameToSearch.asString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"asString(...)");
        PsiClass psiClass2 = javaElementFinder.findClass(string, $effectiveScope);
        if (psiClass2 == null) {
            return true;
        }
        PsiClass psiClass3 = psiClass2;
        return $processor.process((Object)psiClass3);
    }

    private static final boolean processClassesWithName$lambda$2(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final boolean processClassesWithName$lambda$3(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final boolean processAllMethodNames$lambda$6(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final boolean processMethodsWithName$lambda$7(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final boolean processMethodsWithName$lambda$8(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final boolean getMethodsByNameIfNotMoreThan$lambda$11$lambda$10(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final boolean processFieldsWithName$lambda$13(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final boolean getFieldsByNameIfNotMoreThan$lambda$16$lambda$15(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    static {
        Logger logger = Logger.getInstance(KotlinShortNamesCache.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0003\b\u0002\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0015\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u0011J\u001f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00028\u00000\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00028\u00000\u0013\u00a2\u0006\u0002\u0010\u0015R!\u0010\u0004\u001a\u0015\u0012\f\u0012\n \u0005*\u0004\u0018\u00018\u00008\u00000\u0002\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0007\u001a\u0012\u0012\u0004\u0012\u00028\u00000\bj\b\u0012\u0004\u0012\u00028\u0000`\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\n\u001a\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/idea/caches/KotlinShortNamesCache$CancelableArrayCollectProcessor;", "T", "Lcom/intellij/util/Processor;", "()V", "processor", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "set", "Ljava/util/HashSet;", "Lkotlin/collections/HashSet;", "size", "", "getSize", "()I", "process", "", "value", "(Ljava/lang/Object;)Z", "toArray", "", "a", "([Ljava/lang/Object;)[Ljava/lang/Object;", "kotlin.base.analysis"})
    private static final class CancelableArrayCollectProcessor<T>
    implements Processor<T> {
        @NotNull
        private final HashSet<T> set = new HashSet();
        @NotNull
        private final Processor<T> processor;

        public CancelableArrayCollectProcessor() {
            Processor processor2 = Processors.cancelableCollectProcessor((Collection)this.set);
            Intrinsics.checkNotNullExpressionValue((Object)processor2, (String)"cancelableCollectProcessor(...)");
            this.processor = processor2;
        }

        public boolean process(T value2) {
            return this.processor.process(value2);
        }

        public final int getSize() {
            return this.set.size();
        }

        @NotNull
        public final T[] toArray(@NotNull T[] a) {
            Intrinsics.checkNotNullParameter(a, (String)"a");
            T[] TArray = this.set.toArray(a);
            Intrinsics.checkNotNullExpressionValue(TArray, (String)"toArray(...)");
            return TArray;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/kotlin/idea/caches/KotlinShortNamesCache$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "kotlin.base.analysis"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

