/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.base.util;

import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.base.util.TransformingIterator;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u001c\n\u0002\b\u0002\n\u0002\u0010(\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0002\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B\u001b\u0012\u0014\u0010\u0003\u001a\u0010\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00018\u00000\u00050\u0004\u00a2\u0006\u0002\u0010\u0006J\b\u0010\n\u001a\u00020\u000bH\u0014J\u000f\u0010\f\u001a\u0004\u0018\u00018\u0000H\u0014\u00a2\u0006\u0002\u0010\rJ\t\u0010\u000e\u001a\u00020\u000bH\u0096\u0002R\u0018\u0010\u0007\u001a\f\u0012\u0006\u0012\u0004\u0018\u00018\u0000\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\t\u001a\u0012\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00018\u00000\u0005\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/idea/base/util/SeqIterator;", "T", "Lorg/jetbrains/kotlin/idea/base/util/TransformingIterator;", "providers", "", "", "(Ljava/util/List;)V", "iterator", "", "providersIterator", "calculateHasNext", "", "calculateNext", "()Ljava/lang/Object;", "hasNext", "kotlin.base.project-structure"})
final class SeqIterator<T>
extends TransformingIterator<T> {
    @Nullable
    private Iterator<? extends Iterable<? extends T>> providersIterator;
    @Nullable
    private Iterator<? extends T> iterator;

    public SeqIterator(@NotNull List<? extends Iterable<? extends T>> providers) {
        Intrinsics.checkNotNullParameter(providers, (String)"providers");
        this.providersIterator = providers.iterator();
    }

    @Override
    protected boolean calculateHasNext() {
        while (this.providersIterator != null) {
            Iterator<Iterable<T>> providersIt;
            Iterator<T> iterator2 = this.iterator;
            boolean bl = iterator2 != null ? iterator2.hasNext() : false;
            if (bl) {
                return true;
            }
            Iterator<Iterable<T>> iterator3 = providersIt = this.providersIterator;
            if (!(iterator3 != null ? iterator3.hasNext() : false)) {
                return false;
            }
            Iterable<T> next2 = providersIt.next();
            Iterator<T> nextIterator = next2.iterator();
            this.iterator = nextIterator;
            if (!nextIterator.hasNext()) continue;
            return true;
        }
        return false;
    }

    @Override
    @Nullable
    protected T calculateNext() {
        Iterator<T> iterator2 = this.iterator;
        return (T)(iterator2 != null ? iterator2.next() : null);
    }

    @Override
    public boolean hasNext() {
        boolean hasNext = super.hasNext();
        if (!hasNext) {
            this.iterator = null;
            this.providersIterator = null;
        }
        return hasNext;
    }
}

