/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.base.scripting;

import com.intellij.ide.scratch.ScratchFileService;
import com.intellij.ide.scratch.ScratchRootType;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.base.plugin.KotlinPluginModeProvider;
import org.jetbrains.kotlin.idea.base.projectStructure.KotlinBinaryExtensionKt;
import org.jetbrains.kotlin.idea.base.projectStructure.ModuleInfoProvider;
import org.jetbrains.kotlin.idea.base.projectStructure.ModuleInfoProviderExtension;
import org.jetbrains.kotlin.idea.base.projectStructure.ModuleInfoProviderKt;
import org.jetbrains.kotlin.idea.base.projectStructure.moduleInfo.IdeaModuleInfo;
import org.jetbrains.kotlin.idea.base.projectStructure.moduleInfo.LibraryInfo;
import org.jetbrains.kotlin.idea.base.scripting.projectStructure.ScriptDependenciesInfo;
import org.jetbrains.kotlin.idea.base.scripting.projectStructure.ScriptDependenciesSourceInfo;
import org.jetbrains.kotlin.idea.base.scripting.projectStructure.ScriptModuleInfo;
import org.jetbrains.kotlin.idea.base.scripting.projectStructure.ScriptModuleInfoKt;
import org.jetbrains.kotlin.idea.base.util.SeqScope;
import org.jetbrains.kotlin.idea.core.script.ScriptDependencyAware;
import org.jetbrains.kotlin.idea.core.script.ScriptRelatedModuleNameFile;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.scripting.definitions.DefinitionsKt;
import org.jetbrains.kotlin.scripting.definitions.ScriptDefinition;
import org.jetbrains.kotlin.scripting.resolve.VirtualFileScriptSource;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J0\u0010\u0003\u001a\u00020\u0004*\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u00052\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J8\u0010\u000e\u001a\u00020\u0004*\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u00052\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\"\u0010\u0015\u001a\u00020\u0004*\b\u0012\u0004\u0012\u00020\u00160\u00052\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\f\u001a\u00020\rH\u0016\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/idea/base/scripting/ScriptingModuleInfoProviderExtension;", "Lorg/jetbrains/kotlin/idea/base/projectStructure/ModuleInfoProviderExtension;", "()V", "collectByElement", "", "Lorg/jetbrains/kotlin/idea/base/util/SeqScope;", "Lkotlin/Result;", "Lorg/jetbrains/kotlin/idea/base/projectStructure/moduleInfo/IdeaModuleInfo;", "element", "Lcom/intellij/psi/PsiElement;", "file", "Lcom/intellij/psi/PsiFile;", "virtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "collectByFile", "project", "Lcom/intellij/openapi/project/Project;", "isLibrarySource", "", "config", "Lorg/jetbrains/kotlin/idea/base/projectStructure/ModuleInfoProvider$Configuration;", "findContainingModules", "Lcom/intellij/openapi/module/Module;", "kotlin.base.scripting"})
@SourceDebugExtension(value={"SMAP\nScriptingModuleInfoProviderExtension.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ScriptingModuleInfoProviderExtension.kt\norg/jetbrains/kotlin/idea/base/scripting/ScriptingModuleInfoProviderExtension\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,105:1\n1313#2,2:106\n*S KotlinDebug\n*F\n+ 1 ScriptingModuleInfoProviderExtension.kt\norg/jetbrains/kotlin/idea/base/scripting/ScriptingModuleInfoProviderExtension\n*L\n58#1:106,2\n*E\n"})
public final class ScriptingModuleInfoProviderExtension
implements ModuleInfoProviderExtension {
    @Override
    public void collectByElement(@NotNull SeqScope<? super Result<? extends IdeaModuleInfo>> $this$collectByElement, @NotNull PsiElement element3, @NotNull PsiFile file2, @NotNull VirtualFile virtualFile2) {
        ScriptDefinition scriptDefinition;
        Intrinsics.checkNotNullParameter($this$collectByElement, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Intrinsics.checkNotNullParameter((Object)virtualFile2, (String)"virtualFile");
        KtFile ktFile2 = file2 instanceof KtFile ? (KtFile)file2 : null;
        if (ktFile2 == null) {
            return;
        }
        KtFile ktFile3 = ktFile2;
        boolean isScript2 = (Boolean)ActionsKt.runReadAction((Function0)((Function0)new Function0<Boolean>(ktFile3){
            final /* synthetic */ KtFile $ktFile;
            {
                this.$ktFile = $ktFile;
                super(0);
            }

            @NotNull
            public final Boolean invoke() {
                return this.$ktFile.isValid() && this.$ktFile.isScript();
            }
        }));
        if (isScript2 && (scriptDefinition = DefinitionsKt.findScriptDefinition((PsiFile)ktFile3)) != null) {
            Project project2 = element3.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
            ModuleInfoProviderKt.register($this$collectByElement, new ScriptModuleInfo(project2, virtualFile2, scriptDefinition));
        }
    }

    @Override
    public void collectByFile(@NotNull SeqScope<? super Result<? extends IdeaModuleInfo>> $this$collectByFile, @NotNull Project project2, @NotNull VirtualFile virtualFile2, boolean isLibrarySource, @NotNull ModuleInfoProvider.Configuration config2) {
        Intrinsics.checkNotNullParameter($this$collectByFile, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)virtualFile2, (String)"virtualFile");
        Intrinsics.checkNotNullParameter((Object)config2, (String)"config");
        FileType fileType = virtualFile2.getFileType();
        Intrinsics.checkNotNullExpressionValue((Object)fileType, (String)"getFileType(...)");
        boolean isBinary = KotlinBinaryExtensionKt.isKotlinBinary(fileType);
        if (isBinary) {
            if (KotlinPluginModeProvider.Companion.isK2Mode()) {
                IdeaModuleInfo ideaModuleInfo = config2.getContextualModuleInfo();
                ScriptModuleInfo scriptModuleInfo = ideaModuleInfo instanceof ScriptModuleInfo ? (ScriptModuleInfo)ideaModuleInfo : null;
                Object scriptFile = scriptModuleInfo != null ? scriptModuleInfo.getScriptFile() : null;
                Sequence<LibraryInfo> sequence2 = scriptFile;
                if (sequence2 != null && (sequence2 = ScriptModuleInfoKt.scriptLibraryDependencies((VirtualFile)sequence2, project2)) != null) {
                    Sequence<LibraryInfo> $this$forEach$iv = sequence2;
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        IdeaModuleInfo p0 = (IdeaModuleInfo)element$iv;
                        boolean bl = false;
                        ModuleInfoProviderKt.register($this$collectByFile, p0);
                    }
                }
            } else if (ScriptDependencyAware.Companion.getInstance(project2).getAllScriptsDependenciesClassFilesScope().contains(virtualFile2)) {
                if (isLibrarySource) {
                    ModuleInfoProviderKt.register($this$collectByFile, new ScriptDependenciesSourceInfo.ForProject(project2));
                } else {
                    VirtualFile scriptFile;
                    IdeaModuleInfo scriptModuleInfo = config2.getContextualModuleInfo();
                    Object object = scriptModuleInfo instanceof ScriptModuleInfo ? ((ScriptModuleInfo)scriptModuleInfo).getScriptFile() : (scriptFile = scriptModuleInfo instanceof ScriptDependenciesInfo.ForFile ? ((ScriptDependenciesInfo.ForFile)scriptModuleInfo).getScriptFile() : null);
                    if (scriptFile != null) {
                        ModuleInfoProviderKt.register($this$collectByFile, (Function0<? extends IdeaModuleInfo>)((Function0)new Function0<IdeaModuleInfo>(project2, scriptFile){
                            final /* synthetic */ Project $project;
                            final /* synthetic */ VirtualFile $scriptFile;
                            {
                                this.$project = $project;
                                this.$scriptFile = $scriptFile;
                                super(0);
                            }

                            @Nullable
                            public final IdeaModuleInfo invoke() {
                                return new ScriptDependenciesInfo.ForFile(this.$project, this.$scriptFile, DefinitionsKt.findScriptDefinition(this.$project, new VirtualFileScriptSource(this.$scriptFile, null, 2, null)));
                            }
                        }));
                    } else {
                        ModuleInfoProviderKt.register($this$collectByFile, new ScriptDependenciesInfo.ForProject(project2));
                    }
                }
            }
        } else {
            ModuleInfoProviderKt.register($this$collectByFile, (Function0<? extends IdeaModuleInfo>)((Function0)new Function0<IdeaModuleInfo>(project2, virtualFile2){
                final /* synthetic */ Project $project;
                final /* synthetic */ VirtualFile $virtualFile;
                {
                    this.$project = $project;
                    this.$virtualFile = $virtualFile;
                    super(0);
                }

                @Nullable
                public final IdeaModuleInfo invoke() {
                    return ScriptDependencyAware.Companion.getInstance(this.$project).getAllScriptDependenciesSourcesScope().contains(this.$virtualFile) ? (IdeaModuleInfo)new ScriptDependenciesSourceInfo.ForProject(this.$project) : null;
                }
            }));
        }
    }

    @Override
    public void findContainingModules(@NotNull SeqScope<? super Module> $this$findContainingModules, @NotNull Project project2, @NotNull VirtualFile virtualFile2) {
        Intrinsics.checkNotNullParameter($this$findContainingModules, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)virtualFile2, (String)"virtualFile");
        $this$findContainingModules.yield((Function0<? super Module>)((Function0)new Function0<Module>(virtualFile2, project2){
            final /* synthetic */ VirtualFile $virtualFile;
            final /* synthetic */ Project $project;
            {
                this.$virtualFile = $virtualFile;
                this.$project = $project;
                super(0);
            }

            @Nullable
            public final Module invoke() {
                Module module2;
                if (ScratchFileService.getInstance().getRootType(this.$virtualFile) instanceof ScratchRootType) {
                    String string = ScriptRelatedModuleNameFile.Companion.get(this.$project, this.$virtualFile);
                    if (string != null) {
                        String string2 = string;
                        Project project2 = this.$project;
                        String scratchModuleName = string2;
                        boolean bl = false;
                        ModuleManager moduleManager = ModuleManager.Companion.getInstance(project2);
                        module2 = moduleManager.findModuleByName(scratchModuleName);
                    } else {
                        module2 = null;
                    }
                } else {
                    module2 = null;
                }
                return module2;
            }
        }));
    }
}

