/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.base.projectStructure;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectModelExternalSource;
import com.intellij.openapi.roots.libraries.Library;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.InlineMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.MatchGroup;
import kotlin.text.MatchGroupCollection;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import kotlin.text.jdk8.RegexExtensionsJDK8Kt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.base.platforms.KotlinJavaScriptStdlibDetectorFacility;
import org.jetbrains.kotlin.idea.base.platforms.KotlinJvmStdlibDetectorFacility;
import org.jetbrains.kotlin.idea.base.platforms.StdlibDetectorFacility;
import org.jetbrains.kotlin.idea.base.projectStructure.LibraryInfoCache;
import org.jetbrains.kotlin.idea.base.projectStructure.LibraryInfoListener;
import org.jetbrains.kotlin.idea.base.projectStructure.LibraryInfoVariantsService;
import org.jetbrains.kotlin.idea.base.projectStructure.moduleInfo.LibraryInfo;
import org.jetbrains.kotlin.idea.base.projectStructure.moduleInfo.NativeKlibLibraryInfo;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000G\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0004*\u0001\u0006\b\u0007\u0018\u0000 \u00192\u00020\u0001:\u0001\u0019B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\"\u0010\u0010\u001a\u0002H\u0011\"\u0004\b\u0000\u0010\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u0002H\u00110\u0013H\u0082\b\u00a2\u0006\u0002\u0010\u0014J\u0014\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\r0\u00162\u0006\u0010\u0017\u001a\u00020\rJ\u0014\u0010\u0018\u001a\n\u0018\u00010\nj\u0004\u0018\u0001`\u000b*\u00020\rH\u0002R\u0010\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0007R$\u0010\b\u001a\u0018\u0012\b\u0012\u00060\nj\u0002`\u000b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0\f0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/kotlin/idea/base/projectStructure/LibraryInfoVariantsService;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "libraryInfoListener", "org/jetbrains/kotlin/idea/base/projectStructure/LibraryInfoVariantsService$libraryInfoListener$1", "Lorg/jetbrains/kotlin/idea/base/projectStructure/LibraryInfoVariantsService$libraryInfoListener$1;", "storage", "", "", "Lorg/jetbrains/kotlin/idea/base/projectStructure/MavenGroupArtifactId;", "", "Lorg/jetbrains/kotlin/idea/base/projectStructure/moduleInfo/LibraryInfo;", "dispose", "", "useStorage", "R", "block", "Lkotlin/Function0;", "(Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "variants", "", "libraryInfo", "mavenGroupArtifactId", "Companion", "kotlin.base.project-structure"})
@SourceDebugExtension(value={"SMAP\nLibraryInfoVariantsService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LibraryInfoVariantsService.kt\norg/jetbrains/kotlin/idea/base/projectStructure/LibraryInfoVariantsService\n*L\n1#1,159:1\n67#1:160\n67#1:161\n*S KotlinDebug\n*F\n+ 1 LibraryInfoVariantsService.kt\norg/jetbrains/kotlin/idea/base/projectStructure/LibraryInfoVariantsService\n*L\n59#1:160\n63#1:161\n*E\n"})
public final class LibraryInfoVariantsService
implements Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Map<String, Set<LibraryInfo>> storage;
    @NotNull
    private final libraryInfoListener.1 libraryInfoListener;
    @NotNull
    private static final Regex GRADLE_LIBRARY_NAME_REGEX = new Regex("^(?<prefix>\\S+: )?(?<group>\\S+?):(?<artifactId>\\S+?):((?<variant>\\S+?):)?(?<version>\\S+)$");
    @NotNull
    private static final String GROUP = "group";
    @NotNull
    private static final String ARTIFACT_ID = "artifactId";
    @NotNull
    private static final String VARIANT = "variant";

    public LibraryInfoVariantsService(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        this.storage = new LinkedHashMap();
        this.libraryInfoListener = new LibraryInfoListener(this){
            final /* synthetic */ LibraryInfoVariantsService this$0;
            {
                this.this$0 = $receiver;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * WARNING - void declaration
             */
            public void libraryInfosAdded(@NotNull Collection<? extends LibraryInfo> libraryInfos) {
                void this_$iv;
                Intrinsics.checkNotNullParameter(libraryInfos, (String)"libraryInfos");
                LibraryInfoVariantsService libraryInfoVariantsService = this.this$0;
                LibraryInfoVariantsService libraryInfoVariantsService2 = this.this$0;
                boolean $i$f$useStorage = false;
                Map map2 = LibraryInfoVariantsService.access$getStorage$p((LibraryInfoVariantsService)this_$iv);
                synchronized (map2) {
                    boolean bl = false;
                    Iterable $this$forEach$iv = libraryInfos;
                    boolean $i$f$forEach = false;
                    for (T element$iv : $this$forEach$iv) {
                        LibraryInfo libraryInfo = (LibraryInfo)element$iv;
                        boolean bl2 = false;
                        String id = LibraryInfoVariantsService.access$mavenGroupArtifactId(libraryInfoVariantsService2, libraryInfo);
                        if (id == null) continue;
                        LibraryInfoVariantsService.access$getStorage$p(libraryInfoVariantsService2).computeIfAbsent(id, arg_0 -> libraryInfoListener.1.libraryInfosAdded$lambda$2$lambda$1$lambda$0(libraryInfoListener.libraryInfosAdded.1.1.1.INSTANCE, arg_0)).add(libraryInfo);
                    }
                    Unit unit = Unit.INSTANCE;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * WARNING - void declaration
             */
            public void libraryInfosRemoved(@NotNull Collection<? extends LibraryInfo> libraryInfos) {
                void this_$iv;
                Intrinsics.checkNotNullParameter(libraryInfos, (String)"libraryInfos");
                LibraryInfoVariantsService libraryInfoVariantsService = this.this$0;
                LibraryInfoVariantsService libraryInfoVariantsService2 = this.this$0;
                boolean $i$f$useStorage = false;
                Map map2 = LibraryInfoVariantsService.access$getStorage$p((LibraryInfoVariantsService)this_$iv);
                synchronized (map2) {
                    boolean bl = false;
                    Iterable $this$forEach$iv = libraryInfos;
                    boolean $i$f$forEach = false;
                    for (T element$iv : $this$forEach$iv) {
                        LibraryInfo libraryInfo = (LibraryInfo)element$iv;
                        boolean bl2 = false;
                        Set set = (Set)LibraryInfoVariantsService.access$getStorage$p(libraryInfoVariantsService2).get(LibraryInfoVariantsService.access$mavenGroupArtifactId(libraryInfoVariantsService2, libraryInfo));
                        if (set == null) continue;
                        set.remove(libraryInfo);
                    }
                    Unit unit = Unit.INSTANCE;
                }
            }

            private static final Set libraryInfosAdded$lambda$2$lambda$1$lambda$0(Function1 $tmp0, Object p0) {
                Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
                return (Set)$tmp0.invoke(p0);
            }
        };
        project2.getMessageBus().connect((Disposable)this).subscribe(LibraryInfoListener.Companion.getTOPIC(), (Object)this.libraryInfoListener);
        this.libraryInfoListener.libraryInfosAdded(CollectionsKt.flatten((Iterable)LibraryInfoCache.Companion.getInstance(project2).values()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final List<LibraryInfo> variants(@NotNull LibraryInfo libraryInfo) {
        Intrinsics.checkNotNullParameter((Object)libraryInfo, (String)"libraryInfo");
        LibraryInfoVariantsService this_$iv = this;
        boolean $i$f$useStorage = false;
        Map map2 = this_$iv.storage;
        synchronized (map2) {
            boolean bl = false;
            Set set = this.storage.get(this.mavenGroupArtifactId(libraryInfo));
            if (set == null) {
                set = SetsKt.emptySet();
            }
            List list2 = CollectionsKt.toList((Iterable)set);
            return list2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        LibraryInfoVariantsService this_$iv = this;
        boolean $i$f$useStorage = false;
        Map map2 = this_$iv.storage;
        synchronized (map2) {
            boolean bl = false;
            this.storage.clear();
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final <R> R useStorage(Function0<? extends R> block2) {
        boolean $i$f$useStorage = false;
        Map map2 = this.storage;
        synchronized (map2) {
            Object object;
            try {
                object = block2.invoke();
            }
            finally {
                InlineMarker.finallyStart((int)1);
                // MONITOREXIT @DISABLED, blocks:[1, 3] lbl10 : MonitorExitStatement: MONITOREXIT : var3_3
                InlineMarker.finallyEnd((int)1);
            }
            return (R)object;
        }
    }

    private final String mavenGroupArtifactId(LibraryInfo $this$mavenGroupArtifactId) {
        ProjectModelExternalSource externalSource;
        if (Companion.bundledLibraryVariant($this$mavenGroupArtifactId) != null) {
            return "org.jetbrains.kotlin:kotlin-bundled";
        }
        ProjectModelExternalSource projectModelExternalSource = externalSource = $this$mavenGroupArtifactId.getLibrary().getExternalSource();
        if (!Intrinsics.areEqual((Object)(projectModelExternalSource != null ? projectModelExternalSource.getId() : null), (Object)"GRADLE")) {
            return null;
        }
        return Companion.extractArtifactIdWithoutVariant($this$mavenGroupArtifactId.getLibrary().getName());
    }

    public static final /* synthetic */ String access$mavenGroupArtifactId(LibraryInfoVariantsService $this, LibraryInfo $receiver) {
        return $this.mavenGroupArtifactId($receiver);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001:\u0001\u0014B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\fJ\u0012\u0010\r\u001a\u0004\u0018\u00010\u00042\b\u0010\u000e\u001a\u0004\u0018\u00010\u0004J\u0012\u0010\u000f\u001a\u0004\u0018\u00010\u00042\b\u0010\u000e\u001a\u0004\u0018\u00010\u0004J\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/idea/base/projectStructure/LibraryInfoVariantsService$Companion;", "", "()V", "ARTIFACT_ID", "", "GRADLE_LIBRARY_NAME_REGEX", "Lkotlin/text/Regex;", "GROUP", "VARIANT", "bundledLibraryVariant", "Lorg/jetbrains/kotlin/idea/base/projectStructure/LibraryInfoVariantsService$Companion$BundledLibraryVariant;", "libraryInfo", "Lorg/jetbrains/kotlin/idea/base/projectStructure/moduleInfo/LibraryInfo;", "extractArtifactIdWithoutVariant", "library", "extractVariantName", "getInstance", "Lorg/jetbrains/kotlin/idea/base/projectStructure/LibraryInfoVariantsService;", "project", "Lcom/intellij/openapi/project/Project;", "BundledLibraryVariant", "kotlin.base.project-structure"})
    @SourceDebugExtension(value={"SMAP\nLibraryInfoVariantsService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LibraryInfoVariantsService.kt\norg/jetbrains/kotlin/idea/base/projectStructure/LibraryInfoVariantsService$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,159:1\n31#2,2:160\n288#3,2:162\n*S KotlinDebug\n*F\n+ 1 LibraryInfoVariantsService.kt\norg/jetbrains/kotlin/idea/base/projectStructure/LibraryInfoVariantsService$Companion\n*L\n90#1:160,2\n125#1:162,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final LibraryInfoVariantsService getInstance(@NotNull Project project2) {
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            ComponentManager $this$service$iv = (ComponentManager)project2;
            boolean $i$f$service = false;
            Class<LibraryInfoVariantsService> serviceClass$iv = LibraryInfoVariantsService.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            return (LibraryInfoVariantsService)object;
        }

        @Nullable
        public final BundledLibraryVariant bundledLibraryVariant(@NotNull LibraryInfo libraryInfo) {
            BundledLibraryVariant bundledLibraryVariant;
            Intrinsics.checkNotNullParameter((Object)libraryInfo, (String)"libraryInfo");
            String string = libraryInfo.getLibrary().getName();
            if (string == null) {
                string = "";
            }
            String name2 = StringsKt.substringBeforeLast$default((String)string, (char)':', null, (int)2, null);
            if (libraryInfo instanceof NativeKlibLibraryInfo && ((NativeKlibLibraryInfo)libraryInfo).isStdlib()) {
                bundledLibraryVariant = BundledLibraryVariant.Native;
            } else if (StdlibDetectorFacility.isStdlib$default(KotlinJvmStdlibDetectorFacility.INSTANCE, libraryInfo.getProject(), (Library)libraryInfo.getLibrary(), false, 4, null)) {
                bundledLibraryVariant = BundledLibraryVariant.Jvm;
            } else if (StdlibDetectorFacility.isStdlib$default(KotlinJavaScriptStdlibDetectorFacility.INSTANCE, libraryInfo.getProject(), (Library)libraryInfo.getLibrary(), false, 4, null)) {
                bundledLibraryVariant = BundledLibraryVariant.Js;
            } else {
                Object v2;
                block8: {
                    Iterable $this$firstOrNull$iv = (Iterable)BundledLibraryVariant.getEntries();
                    boolean $i$f$firstOrNull = false;
                    for (Object element$iv : $this$firstOrNull$iv) {
                        BundledLibraryVariant bundledLibraryVariant2 = (BundledLibraryVariant)((Object)element$iv);
                        boolean bl = false;
                        if (!bundledLibraryVariant2.getWellKnownCoordinates().contains(name2)) continue;
                        v2 = element$iv;
                        break block8;
                    }
                    v2 = null;
                }
                bundledLibraryVariant = v2;
            }
            return bundledLibraryVariant;
        }

        @Nullable
        public final String extractArtifactIdWithoutVariant(@Nullable String library2) {
            Regex regex = GRADLE_LIBRARY_NAME_REGEX;
            String string = library2;
            if (string == null) {
                string = "";
            }
            MatchResult matchResult2 = regex.matchEntire((CharSequence)string);
            if (matchResult2 == null) {
                return null;
            }
            MatchResult match2 = matchResult2;
            MatchGroup variant = RegexExtensionsJDK8Kt.get((MatchGroupCollection)match2.getGroups(), (String)LibraryInfoVariantsService.VARIANT);
            Object object = RegexExtensionsJDK8Kt.get((MatchGroupCollection)match2.getGroups(), (String)LibraryInfoVariantsService.GROUP);
            if (object == null || (object = object.getValue()) == null) {
                return null;
            }
            Object groupId2 = object;
            Object object2 = RegexExtensionsJDK8Kt.get((MatchGroupCollection)match2.getGroups(), (String)LibraryInfoVariantsService.ARTIFACT_ID);
            if (object2 == null || (object2 = object2.getValue()) == null) {
                return null;
            }
            Object artifactId2 = object2;
            Object artifactIdWithoutVariant = variant != null ? artifactId2 : StringsKt.substringBeforeLast$default((String)artifactId2, (char)'-', null, (int)2, null);
            return (String)groupId2 + ":" + (String)artifactIdWithoutVariant;
        }

        @Nullable
        public final String extractVariantName(@Nullable String library2) {
            Regex regex = GRADLE_LIBRARY_NAME_REGEX;
            String string = library2;
            if (string == null) {
                string = "";
            }
            MatchResult matchResult2 = regex.matchEntire((CharSequence)string);
            if (matchResult2 == null) {
                return null;
            }
            MatchResult match2 = matchResult2;
            MatchGroup variant = RegexExtensionsJDK8Kt.get((MatchGroupCollection)match2.getGroups(), (String)LibraryInfoVariantsService.VARIANT);
            Object object = RegexExtensionsJDK8Kt.get((MatchGroupCollection)match2.getGroups(), (String)LibraryInfoVariantsService.ARTIFACT_ID);
            if (object == null || (object = object.getValue()) == null) {
                return null;
            }
            Object artifactId2 = object;
            Object object2 = variant;
            if (object2 == null || (object2 = object2.getValue()) == null) {
                object2 = StringsKt.substringAfterLast$default((String)artifactId2, (char)'-', null, (int)2, null);
            }
            return object2;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\"\n\u0002\b\n\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u001d\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u00a2\u0006\u0002\u0010\u0006R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nj\u0002\b\u000bj\u0002\b\fj\u0002\b\rj\u0002\b\u000e\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/idea/base/projectStructure/LibraryInfoVariantsService$Companion$BundledLibraryVariant;", "", "displayName", "", "wellKnownCoordinates", "", "(Ljava/lang/String;ILjava/lang/String;Ljava/util/Set;)V", "getDisplayName", "()Ljava/lang/String;", "getWellKnownCoordinates", "()Ljava/util/Set;", "Jvm", "Js", "Native", "Common", "kotlin.base.project-structure"})
        public static final class BundledLibraryVariant
        extends Enum<BundledLibraryVariant> {
            @NotNull
            private final String displayName;
            @NotNull
            private final Set<String> wellKnownCoordinates;
            public static final /* enum */ BundledLibraryVariant Jvm;
            public static final /* enum */ BundledLibraryVariant Js;
            public static final /* enum */ BundledLibraryVariant Native;
            public static final /* enum */ BundledLibraryVariant Common;
            private static final /* synthetic */ BundledLibraryVariant[] $VALUES;
            private static final /* synthetic */ EnumEntries $ENTRIES;

            private BundledLibraryVariant(String displayName, Set<String> wellKnownCoordinates) {
                this.displayName = displayName;
                this.wellKnownCoordinates = wellKnownCoordinates;
            }

            @NotNull
            public final String getDisplayName() {
                return this.displayName;
            }

            @NotNull
            public final Set<String> getWellKnownCoordinates() {
                return this.wellKnownCoordinates;
            }

            public static BundledLibraryVariant[] values() {
                return (BundledLibraryVariant[])$VALUES.clone();
            }

            public static BundledLibraryVariant valueOf(String value2) {
                return Enum.valueOf(BundledLibraryVariant.class, value2);
            }

            @NotNull
            public static EnumEntries<BundledLibraryVariant> getEntries() {
                return $ENTRIES;
            }

            static {
                Object[] objectArray = new String[]{"org.jetbrains.kotlin:kotlin-test", "org.jetbrains.kotlin:kotlin-test-junit", "org.jetbrains.kotlin:kotlin-test-junit5", "org.jetbrains.kotlin:kotlin-test-testng"};
                Jvm = new BundledLibraryVariant("jvm", SetsKt.setOf((Object[])objectArray));
                Js = new BundledLibraryVariant("js", SetsKt.setOf((Object)"org.jetbrains.kotlin:kotlin-test-js"));
                Native = new BundledLibraryVariant("native", SetsKt.emptySet());
                objectArray = new String[]{"org.jetbrains.kotlin:kotlin-test-common", "org.jetbrains.kotlin:kotlin-test-annotations-common", "org.jetbrains.kotlin:kotlin-test:annotationsCommonMain", "org.jetbrains.kotlin:kotlin-test:assertionsCommonMain", "org.jetbrains.kotlin:kotlin-stdlib:commonMain"};
                Common = new BundledLibraryVariant("common", SetsKt.setOf((Object[])objectArray));
                $VALUES = bundledLibraryVariantArray = new BundledLibraryVariant[]{BundledLibraryVariant.Jvm, BundledLibraryVariant.Js, BundledLibraryVariant.Native, BundledLibraryVariant.Common};
                $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
            }
        }
    }
}

