/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.base.indices.names;

import com.intellij.ide.highlighter.JavaClassFileType;
import com.intellij.openapi.diagnostic.ControlFlowException;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.openapi.vfs.jrt.JrtFileSystem;
import com.intellij.util.indexing.DataIndexer;
import com.intellij.util.indexing.DefaultFileTypeSpecificInputFilter;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileBasedIndexExtension;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.indexing.ID;
import com.intellij.util.io.EnumeratorStringDescriptor;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analysis.decompiler.konan.FileWithMetadata;
import org.jetbrains.kotlin.analysis.decompiler.konan.KlibMetaFileType;
import org.jetbrains.kotlin.analysis.decompiler.psi.BuiltInDefinitionFile;
import org.jetbrains.kotlin.analysis.decompiler.psi.KotlinBuiltInFileType;
import org.jetbrains.kotlin.analysis.decompiler.stub.file.KotlinMetadataStubBuilder;
import org.jetbrains.kotlin.idea.base.indices.names.InternalUtilsKt;
import org.jetbrains.kotlin.idea.base.indices.names.KotlinBinaryRootToPackageIndexKt;
import org.jetbrains.kotlin.incremental.storage.StringExternalizer;
import org.jetbrains.kotlin.load.kotlin.KotlinJvmBinaryClass;
import org.jetbrains.kotlin.name.FqName;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\u0018\u0000 \u00142\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0014B\u0005\u00a2\u0006\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\u001a\u0010\u0006\u001a\u0014\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\b0\u0007H\u0016J\b\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\n \r*\u0004\u0018\u00010\f0\fH\u0016J\u0014\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00020\u000fH\u0016J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\b\u0010\u0012\u001a\u00020\u0013H\u0016\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/idea/base/indices/names/KotlinBinaryRootToPackageIndex;", "Lcom/intellij/util/indexing/FileBasedIndexExtension;", "", "()V", "dependsOnFileContent", "", "getIndexer", "Lcom/intellij/util/indexing/DataIndexer;", "Lcom/intellij/util/indexing/FileContent;", "getInputFilter", "Lcom/intellij/util/indexing/FileBasedIndex$InputFilter;", "getKeyDescriptor", "Lcom/intellij/util/io/EnumeratorStringDescriptor;", "kotlin.jvm.PlatformType", "getName", "Lcom/intellij/util/indexing/ID;", "getValueExternalizer", "Lorg/jetbrains/kotlin/incremental/storage/StringExternalizer;", "getVersion", "", "Companion", "kotlin.base.indices"})
public final class KotlinBinaryRootToPackageIndex
extends FileBasedIndexExtension<String, String> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final ID<String, String> NAME;

    @NotNull
    public ID<String, String> getName() {
        return NAME;
    }

    public boolean dependsOnFileContent() {
        return true;
    }

    public EnumeratorStringDescriptor getKeyDescriptor() {
        return EnumeratorStringDescriptor.INSTANCE;
    }

    @NotNull
    public StringExternalizer getValueExternalizer() {
        return StringExternalizer.INSTANCE;
    }

    @NotNull
    public FileBasedIndex.InputFilter getInputFilter() {
        FileType[] fileTypeArray = new FileType[]{JavaClassFileType.INSTANCE, KotlinBuiltInFileType.INSTANCE, KlibMetaFileType.INSTANCE};
        return (FileBasedIndex.InputFilter)new DefaultFileTypeSpecificInputFilter(fileTypeArray);
    }

    public int getVersion() {
        return 5;
    }

    @NotNull
    public DataIndexer<String, String, FileContent> getIndexer() {
        return KotlinBinaryRootToPackageIndex::getIndexer$lambda$1;
    }

    private static final Map getIndexer$lambda$1(FileContent fileContent) {
        Intrinsics.checkNotNullParameter((Object)fileContent, (String)"fileContent");
        try {
            VirtualFile binaryRoot;
            FqName packageName;
            FileType fileType = fileContent.getFileType();
            if (Intrinsics.areEqual((Object)fileType, (Object)JavaClassFileType.INSTANCE)) {
                KotlinJvmBinaryClass kotlinJvmBinaryClass = InternalUtilsKt.toKotlinJvmBinaryClass(fileContent);
                v1 = kotlinJvmBinaryClass != null ? InternalUtilsKt.getPackageName(kotlinJvmBinaryClass) : null;
            } else if (Intrinsics.areEqual((Object)fileType, (Object)KotlinBuiltInFileType.INSTANCE)) {
                KotlinMetadataStubBuilder.FileWithMetadata.Compatible compatible = InternalUtilsKt.readKotlinMetadataDefinition(fileContent);
                BuiltInDefinitionFile builtInDefinitionFile = compatible instanceof BuiltInDefinitionFile ? (BuiltInDefinitionFile)compatible : null;
                v1 = builtInDefinitionFile != null ? builtInDefinitionFile.getPackageFqName() : null;
            } else if (Intrinsics.areEqual((Object)fileType, (Object)KlibMetaFileType.INSTANCE)) {
                FileWithMetadata.Compatible compatible = InternalUtilsKt.toCompatibleFileWithMetadata(fileContent);
                v1 = compatible != null ? compatible.getPackageFqName() : null;
            } else {
                v1 = packageName = null;
            }
            if (packageName == null) {
                return MapsKt.emptyMap();
            }
            VirtualFileSystem virtualFileSystem = fileContent.getFile().getFileSystem();
            Intrinsics.checkNotNullExpressionValue((Object)virtualFileSystem, (String)"getFileSystem(...)");
            VirtualFileSystem fileSystem = virtualFileSystem;
            if (fileSystem instanceof JarFileSystem) {
                VirtualFile virtualFile2 = ((JarFileSystem)fileSystem).getLocalByEntry(fileContent.getFile());
                if (virtualFile2 != null) {
                    VirtualFile virtualFile3;
                    VirtualFile jarFile = virtualFile3 = virtualFile2;
                    boolean bl = false;
                    v6 = KotlinBinaryRootToPackageIndexKt.isSupportedByBinaryRootToPackageIndex(jarFile) ? virtualFile3 : null;
                } else {
                    v6 = null;
                }
            } else if (fileSystem instanceof JrtFileSystem) {
                VirtualFile virtualFile4 = fileContent.getFile();
                Intrinsics.checkNotNullExpressionValue((Object)virtualFile4, (String)"getFile(...)");
                v6 = InternalUtilsKt.getJrtModuleRoot(virtualFile4);
            } else {
                v6 = binaryRoot = null;
            }
            if (binaryRoot == null) {
                return MapsKt.emptyMap();
            }
            return MapsKt.mapOf((Pair)TuplesKt.to((Object)binaryRoot.getName(), (Object)packageName.asString()));
        }
        catch (Exception e) {
            if (e instanceof ControlFlowException) {
                throw e;
            }
            throw new RuntimeException("Error on indexing " + fileContent.getFile(), e);
        }
    }

    static {
        ID iD = ID.create((String)KotlinBinaryRootToPackageIndex.class.getSimpleName());
        Intrinsics.checkNotNullExpressionValue((Object)iD, (String)"create(...)");
        NAME = iD;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001d\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/idea/base/indices/names/KotlinBinaryRootToPackageIndex$Companion;", "", "()V", "NAME", "Lcom/intellij/util/indexing/ID;", "", "getNAME", "()Lcom/intellij/util/indexing/ID;", "kotlin.base.indices"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ID<String, String> getNAME() {
            return NAME;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

