/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.config;

import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.config.AnalysisFlags;
import org.jetbrains.kotlin.fir.analysis.checkers.config.FirLanguageVersionSettingsChecker;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.declarations.DeprecationsPerUseSite;
import org.jetbrains.kotlin.fir.declarations.FirAnnotationUtilsKt;
import org.jetbrains.kotlin.fir.declarations.FirDeprecationInfo;
import org.jetbrains.kotlin.fir.resolve.providers.FirSymbolProviderKt;
import org.jetbrains.kotlin.fir.resolve.transformers.ImportUtilsKt;
import org.jetbrains.kotlin.fir.resolve.transformers.PackageResolutionResult;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.resolve.checkers.OptInNames;
import org.jetbrains.kotlin.resolve.deprecation.DeprecationLevelValue;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J*\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0018\u0010\b\u001a\u0014\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00050\tH\u0016J2\u0010\f\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u000b2\u0018\u0010\b\u001a\u0014\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00050\tH\u0002\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/config/FirOptInLanguageVersionSettingsChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/config/FirLanguageVersionSettingsChecker;", "<init>", "()V", "check", "", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "rawReport", "Lkotlin/Function2;", "", "", "checkOptInMarkerArgument", "fqNameAsString", "checkers"})
@SourceDebugExtension(value={"SMAP\nFirOptInLanguageVersionSettingsChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirOptInLanguageVersionSettingsChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/config/FirOptInLanguageVersionSettingsChecker\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,51:1\n1863#2,2:52\n1#3:54\n*S KotlinDebug\n*F\n+ 1 FirOptInLanguageVersionSettingsChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/config/FirOptInLanguageVersionSettingsChecker\n*L\n21#1:52,2\n*E\n"})
public final class FirOptInLanguageVersionSettingsChecker
extends FirLanguageVersionSettingsChecker {
    @NotNull
    public static final FirOptInLanguageVersionSettingsChecker INSTANCE = new FirOptInLanguageVersionSettingsChecker();

    private FirOptInLanguageVersionSettingsChecker() {
    }

    @Override
    public void check(@NotNull CheckerContext context2, @NotNull Function2<? super Boolean, ? super String, Unit> rawReport) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter(rawReport, (String)"rawReport");
        Iterable $this$forEach$iv = (Iterable)context2.getLanguageVersionSettings().getFlag(AnalysisFlags.getOptIn());
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String fqNameAsString = (String)element$iv;
            boolean bl = false;
            if (Intrinsics.areEqual((Object)fqNameAsString, (Object)OptInNames.INSTANCE.getREQUIRES_OPT_IN_FQ_NAME().asString())) continue;
            INSTANCE.checkOptInMarkerArgument(context2, fqNameAsString, rawReport);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void checkOptInMarkerArgument(CheckerContext context2, String fqNameAsString, Function2<? super Boolean, ? super String, Unit> rawReport) {
        String string;
        String string2;
        FirClassLikeSymbol<?> symbol2;
        PackageResolutionResult packageOrClass = ImportUtilsKt.resolveToPackageOrClass(FirSymbolProviderKt.getSymbolProvider(context2.getSession()), new FqName(fqNameAsString));
        PackageResolutionResult.PackageOrClass packageOrClass2 = packageOrClass instanceof PackageResolutionResult.PackageOrClass ? (PackageResolutionResult.PackageOrClass)packageOrClass : null;
        FirClassLikeSymbol<Object> firClassLikeSymbol = symbol2 = packageOrClass2 != null ? packageOrClass2.getClassSymbol() : null;
        if (symbol2 == null) {
            rawReport.invoke((Object)false, (Object)("Opt-in requirement marker " + fqNameAsString + " is unresolved. Please make sure it's present in the module dependencies"));
            return;
        }
        if (FirAnnotationUtilsKt.getAnnotationByClassId((FirBasedSymbol)symbol2, OptInNames.INSTANCE.getREQUIRES_OPT_IN_CLASS_ID(), context2.getSession()) == null) {
            rawReport.invoke((Object)false, (Object)("Class " + fqNameAsString + " is not an opt-in requirement marker"));
            return;
        }
        Object object = symbol2.getOwnDeprecation(context2.getLanguageVersionSettings());
        if (object == null || (object = ((DeprecationsPerUseSite)object).getAll()) == null) {
            return;
        }
        Object deprecationInfo2 = object;
        Function2<? super Boolean, ? super String, Unit> function2 = rawReport;
        Boolean bl = ((FirDeprecationInfo)deprecationInfo2).getDeprecationLevel() != DeprecationLevelValue.WARNING;
        StringBuilder stringBuilder = new StringBuilder().append("Opt-in requirement marker ").append(fqNameAsString).append(" is deprecated");
        String string3 = ((FirDeprecationInfo)deprecationInfo2).getMessage(context2.getSession());
        if (string3 != null) {
            void it;
            String string4 = string3;
            StringBuilder stringBuilder2 = stringBuilder;
            Boolean bl2 = bl;
            Function2<? super Boolean, ? super String, Unit> function22 = function2;
            boolean bl3 = false;
            String string5 = ". " + (String)it;
            function2 = function22;
            bl = bl2;
            stringBuilder = stringBuilder2;
            string2 = string5;
        } else {
            string2 = string = null;
        }
        if (string2 == null) {
            string = "";
        }
        function2.invoke((Object)bl, (Object)stringBuilder.append(string).toString());
    }
}

