/*
 * Decompiled with CFR 0.152.
 */
package javaslang.collection;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.Objects;
import java.util.function.Function;
import javaslang.Tuple;
import javaslang.Tuple2;
import javaslang.Tuple3;
import javaslang.collection.LinearSeq;
import javaslang.collection.List;
import javaslang.collection.Stream;
import javaslang.collection.Traversable;
import javaslang.collection.Tree;

interface TreeModule {

    public static final class ZipAll {
        static <T, U> Tree<Tuple2<T, U>> apply(Tree.Node<T> node2, Iterator<? extends U> that, U thatElem) {
            if (!that.hasNext()) {
                return node2.map(value2 -> Tuple.of(value2, thatElem));
            }
            Tuple2<T, U> value3 = Tuple.of(node2.getValue(), that.next());
            List children2 = (List)node2.getChildren().map(child2 -> ZipAll.apply(child2, that, thatElem)).filter(Traversable::nonEmpty);
            return new Tree.Node<Tuple2<T, U>>(value3, children2);
        }
    }

    public static final class Zip {
        static <T, U> Tree<Tuple2<T, U>> apply(Tree.Node<T> node2, Iterator<? extends U> that) {
            if (!that.hasNext()) {
                return Tree.Empty.instance();
            }
            Tuple2<T, U> value2 = Tuple.of(node2.getValue(), that.next());
            List children2 = (List)node2.getChildren().map(child2 -> Zip.apply(child2, that)).filter(Traversable::nonEmpty);
            return new Tree.Node<Tuple2<T, U>>(value2, children2);
        }
    }

    public static final class Unzip {
        static <T, T1, T2> Tuple2<Tree.Node<T1>, Tree.Node<T2>> apply(Tree.Node<T> node2, Function<? super T, Tuple2<? extends T1, ? extends T2>> unzipper) {
            Tuple2<? extends T1, ? extends T2> value2 = unzipper.apply(node2.getValue());
            LinearSeq children2 = node2.getChildren().map(child2 -> Unzip.apply(child2, unzipper));
            Tree.Node node1 = new Tree.Node(value2._1, children2.map(t -> (Tree.Node)t._1));
            Tree.Node node22 = new Tree.Node(value2._2, children2.map(t -> (Tree.Node)t._2));
            return Tuple.of(node1, node22);
        }

        static <T, T1, T2, T3> Tuple3<Tree.Node<T1>, Tree.Node<T2>, Tree.Node<T3>> apply3(Tree.Node<T> node2, Function<? super T, Tuple3<? extends T1, ? extends T2, ? extends T3>> unzipper) {
            Tuple3<? extends T1, ? extends T2, ? extends T3> value2 = unzipper.apply(node2.getValue());
            LinearSeq children2 = node2.getChildren().map(child2 -> Unzip.apply3(child2, unzipper));
            Tree.Node node1 = new Tree.Node(value2._1, children2.map(t -> (Tree.Node)t._1));
            Tree.Node node22 = new Tree.Node(value2._2, children2.map(t -> (Tree.Node)t._2));
            Tree.Node node3 = new Tree.Node(value2._3, children2.map(t -> (Tree.Node)t._3));
            return Tuple.of(node1, node22, node3);
        }
    }

    public static final class Traversal {
        static <T> Stream<Tree.Node<T>> preOrder(Tree.Node<T> node2) {
            return node2.getChildren().foldLeft(Stream.of(node2), (acc, child2) -> acc.appendAll((Iterable)Traversal.preOrder(child2)));
        }

        static <T> Stream<Tree.Node<T>> inOrder(Tree.Node<T> node2) {
            if (node2.isLeaf()) {
                return Stream.of(node2);
            }
            List<Tree.Node<T>> children2 = node2.getChildren();
            return children2.tail().foldLeft(Stream.empty(), (acc, child2) -> acc.appendAll((Iterable)Traversal.inOrder(child2))).prepend(node2).prependAll(Traversal.inOrder((Tree.Node)children2.head()));
        }

        static <T> Stream<Tree.Node<T>> postOrder(Tree.Node<T> node2) {
            return node2.getChildren().foldLeft(Stream.empty(), (acc, child2) -> acc.appendAll((Iterable)Traversal.postOrder(child2))).append(node2);
        }

        static <T> Stream<Tree.Node<T>> levelOrder(Tree.Node<T> node2) {
            LinearSeq result2 = Stream.empty();
            LinkedList<Tree.Node<T>> queue = new LinkedList<Tree.Node<T>>();
            queue.add(node2);
            while (!queue.isEmpty()) {
                Tree.Node next2 = (Tree.Node)queue.remove();
                result2 = result2.prepend(next2);
                queue.addAll(next2.getChildren().toJavaList());
            }
            return result2.reverse();
        }
    }

    public static final class Replace {
        static <T> Tree.Node<T> apply(Tree.Node<T> node2, T currentElement, T newElement2) {
            if (Objects.equals(node2.getValue(), currentElement)) {
                return new Tree.Node<T>(newElement2, node2.getChildren());
            }
            for (Tree.Node node3 : node2.getChildren()) {
                Tree.Node<T> newChild = Replace.apply(node3, currentElement, newElement2);
                boolean found2 = newChild != node3;
                if (!found2) continue;
                LinearSeq newChildren = node2.getChildren().replace((Object)node3, newChild);
                return new Tree.Node<T>(node2.getValue(), newChildren);
            }
            return node2;
        }
    }

    public static final class Map {
        static <T, U> Tree.Node<U> apply(Tree.Node<T> node2, Function<? super T, ? extends U> mapper2) {
            U value2 = mapper2.apply(node2.getValue());
            LinearSeq children2 = node2.getChildren().map(child2 -> Map.apply(child2, mapper2));
            return new Tree.Node<U>(value2, children2);
        }
    }

    public static final class FlatMap {
        static <T, U> Tree<U> apply(Tree.Node<T> node2, Function<? super T, ? extends Iterable<? extends U>> mapper2) {
            Tree<U> mapped = Tree.ofAll(mapper2.apply(node2.getValue()));
            if (mapped.isEmpty()) {
                return Tree.empty();
            }
            List children2 = (List)node2.getChildren().map(child2 -> FlatMap.apply(child2, mapper2)).filter(Traversable::nonEmpty);
            return Tree.of(mapped.getValue(), children2.prependAll(mapped.getChildren()));
        }
    }
}

