/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.service.project;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.ExternalSystemAutoImportAware;
import com.intellij.openapi.externalSystem.ExternalSystemManager;
import com.intellij.openapi.externalSystem.importing.ProjectResolverPolicy;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.settings.AbstractExternalSystemSettings;
import com.intellij.openapi.externalSystem.settings.ExternalProjectSettings;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.CompilerModuleExtension;
import com.intellij.openapi.roots.CompilerProjectExtension;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SmartList;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.model.VersionCatalogsModel;
import org.jetbrains.plugins.gradle.model.data.BuildScriptClasspathData;
import org.jetbrains.plugins.gradle.service.execution.GradleUserHomeUtil;
import org.jetbrains.plugins.gradle.service.project.GradleAutoReloadSettingsCollector;
import org.jetbrains.plugins.gradle.settings.DistributionType;
import org.jetbrains.plugins.gradle.settings.GradleProjectSettings;
import org.jetbrains.plugins.gradle.settings.GradleSettings;
import org.jetbrains.plugins.gradle.util.GradleConstants;

public class GradleAutoImportAware
implements ExternalSystemAutoImportAware {
    private static final Logger LOG = Logger.getInstance(GradleAutoImportAware.class);

    @Nullable
    public String getAffectedExternalProjectPath(@NotNull String changedFileOrDirPath, @NotNull Project project2) {
        if (changedFileOrDirPath == null) {
            GradleAutoImportAware.$$$reportNull$$$0(0);
        }
        if (project2 == null) {
            GradleAutoImportAware.$$$reportNull$$$0(1);
        }
        if (!changedFileOrDirPath.endsWith(".gradle") && !changedFileOrDirPath.endsWith(".gradle.kts")) {
            return null;
        }
        if (GradleAutoImportAware.isInsideCompileOutput(changedFileOrDirPath, project2)) {
            return null;
        }
        File file = new File(changedFileOrDirPath);
        if (file.isDirectory()) {
            return null;
        }
        ExternalSystemManager manager = ExternalSystemApiUtil.getManager((ProjectSystemId)GradleConstants.SYSTEM_ID);
        assert (manager != null);
        AbstractExternalSystemSettings systemSettings = (AbstractExternalSystemSettings)manager.getSettingsProvider().fun((Object)project2);
        Collection projectsSettings = systemSettings.getLinkedProjectsSettings();
        if (projectsSettings.isEmpty()) {
            return null;
        }
        HashMap<String, String> rootPaths = new HashMap<String, String>();
        for (ExternalProjectSettings setting : projectsSettings) {
            if (setting == null) continue;
            for (String path : setting.getModules()) {
                rootPaths.put(new File(path).getPath(), setting.getExternalProjectPath());
            }
        }
        for (File f = file.getParentFile(); f != null; f = f.getParentFile()) {
            String dirPath = f.getPath();
            if (!rootPaths.containsKey(dirPath)) continue;
            return (String)rootPaths.get(dirPath);
        }
        return null;
    }

    private static boolean isInsideCompileOutput(@NotNull String path, @NotNull Project project2) {
        if (path == null) {
            GradleAutoImportAware.$$$reportNull$$$0(2);
        }
        if (project2 == null) {
            GradleAutoImportAware.$$$reportNull$$$0(3);
        }
        String url = VfsUtilCore.pathToUrl((String)path);
        boolean isInsideProjectCompile = Optional.ofNullable(CompilerProjectExtension.getInstance((Project)project2)).map(CompilerProjectExtension::getCompilerOutputUrl).filter(outputUrl -> VfsUtilCore.isEqualOrAncestor((String)outputUrl, (String)url)).isPresent();
        if (isInsideProjectCompile) {
            return true;
        }
        return Arrays.stream(ModuleManager.getInstance((Project)project2).getModules()).map(CompilerModuleExtension::getInstance).filter(Objects::nonNull).flatMap(ex -> Stream.of(ex.getCompilerOutputUrl(), ex.getCompilerOutputUrlForTests())).filter(Objects::nonNull).anyMatch(outputUrl -> VfsUtilCore.isEqualOrAncestor((String)outputUrl, (String)url));
    }

    public List<File> getAffectedExternalProjectFiles(@NotNull String externalProjectPath2, @NotNull Project project2) {
        GradleSettings settings2;
        GradleProjectSettings projectSettings;
        if (externalProjectPath2 == null) {
            GradleAutoImportAware.$$$reportNull$$$0(4);
        }
        if (project2 == null) {
            GradleAutoImportAware.$$$reportNull$$$0(5);
        }
        if ((projectSettings = (GradleProjectSettings)(settings2 = GradleSettings.getInstance(project2)).getLinkedProjectSettings(externalProjectPath2)) == null) {
            return null;
        }
        return GradleAutoReloadSettingsCollector.EP_NAME.getExtensionList().stream().flatMap(it -> it.collectSettingsFiles(project2, projectSettings).stream()).collect(Collectors.toList());
    }

    public boolean isApplicable(@Nullable ProjectResolverPolicy resolverPolicy) {
        return resolverPolicy == null || !resolverPolicy.isPartialDataResolveAllowed();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changedFileOrDirPath";
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "externalProjectPath";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/gradle/service/project/GradleAutoImportAware";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getAffectedExternalProjectPath";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "isInsideCompileOutput";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "getAffectedExternalProjectFiles";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static final class GradleScriptCollector
    implements GradleAutoReloadSettingsCollector {
        @Override
        @NotNull
        public List<File> collectSettingsFiles(@NotNull Project project2, @NotNull GradleProjectSettings projectSettings) {
            if (project2 == null) {
                GradleScriptCollector.$$$reportNull$$$0(0);
            }
            if (projectSettings == null) {
                GradleScriptCollector.$$$reportNull$$$0(1);
            }
            SmartList files = new SmartList();
            for (String modulePath : projectSettings.getModules()) {
                ProgressManager.checkCanceled();
                try {
                    Files.walkFileTree(Paths.get(modulePath, new String[0]), EnumSet.noneOf(FileVisitOption.class), 1, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>((List)files){
                        final /* synthetic */ List val$files;
                        {
                            this.val$files = list2;
                        }

                        @Override
                        public FileVisitResult visitFile(Path path, BasicFileAttributes attrs) {
                            File file;
                            String fileName = path.getFileName().toString();
                            if ((fileName.endsWith(".gradle") || fileName.endsWith(".gradle.kts")) && (file = path.toFile()).isFile()) {
                                this.val$files.add(file);
                            }
                            return FileVisitResult.CONTINUE;
                        }
                    });
                }
                catch (IOException | InvalidPathException e) {
                    LOG.debug((Throwable)e);
                }
            }
            SmartList smartList = files;
            if (smartList == null) {
                GradleScriptCollector.$$$reportNull$$$0(2);
            }
            return smartList;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "projectSettings";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/plugins/gradle/service/project/GradleAutoImportAware$GradleScriptCollector";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/plugins/gradle/service/project/GradleAutoImportAware$GradleScriptCollector";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "collectSettingsFiles";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "collectSettingsFiles";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string2);
                case 2 -> new IllegalStateException(string2);
            };
        }
    }

    public static final class WrapperConfigCollector
    implements GradleAutoReloadSettingsCollector {
        @Override
        @NotNull
        public List<File> collectSettingsFiles(@NotNull Project project2, @NotNull GradleProjectSettings projectSettings) {
            if (project2 == null) {
                WrapperConfigCollector.$$$reportNull$$$0(0);
            }
            if (projectSettings == null) {
                WrapperConfigCollector.$$$reportNull$$$0(1);
            }
            String externalProjectPath2 = projectSettings.getExternalProjectPath();
            SmartList files = new SmartList();
            if (projectSettings.getDistributionType() == DistributionType.DEFAULT_WRAPPED) {
                files.add(new File(externalProjectPath2, "gradle/wrapper/gradle-wrapper.properties"));
            }
            SmartList smartList = files;
            if (smartList == null) {
                WrapperConfigCollector.$$$reportNull$$$0(2);
            }
            return smartList;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "projectSettings";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/plugins/gradle/service/project/GradleAutoImportAware$WrapperConfigCollector";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/plugins/gradle/service/project/GradleAutoImportAware$WrapperConfigCollector";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "collectSettingsFiles";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "collectSettingsFiles";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string2);
                case 2 -> new IllegalStateException(string2);
            };
        }
    }

    public static final class VersionCatalogCollector
    implements GradleAutoReloadSettingsCollector {
        @Override
        @NotNull
        public List<File> collectSettingsFiles(@NotNull Project project2, @NotNull GradleProjectSettings projectSettings) {
            DataNode versionCatalog;
            if (project2 == null) {
                VersionCatalogCollector.$$$reportNull$$$0(0);
            }
            if (projectSettings == null) {
                VersionCatalogCollector.$$$reportNull$$$0(1);
            }
            String externalProjectPath2 = projectSettings.getExternalProjectPath();
            SmartList files = new SmartList();
            DataNode node = ExternalSystemApiUtil.findProjectNode((Project)project2, (ProjectSystemId)GradleConstants.SYSTEM_ID, (String)externalProjectPath2);
            if (node != null && (versionCatalog = ExternalSystemApiUtil.find((DataNode)node, BuildScriptClasspathData.VERSION_CATALOGS)) != null) {
                for (String catalogFile : ((VersionCatalogsModel)versionCatalog.getData()).getCatalogsLocations().values()) {
                    files.add(new File(catalogFile));
                }
            }
            SmartList smartList = files;
            if (smartList == null) {
                VersionCatalogCollector.$$$reportNull$$$0(2);
            }
            return smartList;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "projectSettings";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/plugins/gradle/service/project/GradleAutoImportAware$VersionCatalogCollector";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/plugins/gradle/service/project/GradleAutoImportAware$VersionCatalogCollector";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "collectSettingsFiles";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "collectSettingsFiles";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string2);
                case 2 -> new IllegalStateException(string2);
            };
        }
    }

    public static final class GradlePropertiesCollector
    implements GradleAutoReloadSettingsCollector {
        @Override
        @NotNull
        public List<File> collectSettingsFiles(@NotNull Project project2, @NotNull GradleProjectSettings projectSettings) {
            if (project2 == null) {
                GradlePropertiesCollector.$$$reportNull$$$0(0);
            }
            if (projectSettings == null) {
                GradlePropertiesCollector.$$$reportNull$$$0(1);
            }
            String gradleUserHome2 = (String)ObjectUtils.chooseNotNull((Object)GradleSettings.getInstance(project2).getServiceDirectoryPath(), (Object)GradleUserHomeUtil.gradleUserHomeDir().getPath());
            String externalProjectPath2 = projectSettings.getExternalProjectPath();
            SmartList files = new SmartList();
            files.add(new File(gradleUserHome2, "gradle.properties"));
            files.add(new File(gradleUserHome2, "init.gradle"));
            files.add(new File(externalProjectPath2, "gradle.properties"));
            SmartList smartList = files;
            if (smartList == null) {
                GradlePropertiesCollector.$$$reportNull$$$0(2);
            }
            return smartList;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "projectSettings";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/plugins/gradle/service/project/GradleAutoImportAware$GradlePropertiesCollector";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/plugins/gradle/service/project/GradleAutoImportAware$GradlePropertiesCollector";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "collectSettingsFiles";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "collectSettingsFiles";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string2);
                case 2 -> new IllegalStateException(string2);
            };
        }
    }
}

