/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.jvmcompat;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.util.io.HttpRequests;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.time.Duration;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.gradle.jvmcompat.IdeVersionedDataState;
import org.jetbrains.plugins.gradle.jvmcompat.IdeVersionedDataStorage;
import org.jetbrains.plugins.gradle.jvmcompat.IdeVersionedDataUpdaterKt;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\b'\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003B\u0013\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0007\u001a\u00020\bH\u0002R\u0012\u0010\u0007\u001a\u00020\bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u000b\u001a\u00020\fX\u00a6\u0004\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000e\u0082\u0002\u000b\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b!\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/plugins/gradle/jvmcompat/IdeVersionedDataUpdater;", "T", "Lorg/jetbrains/plugins/gradle/jvmcompat/IdeVersionedDataState;", "", "dataStorage", "Lorg/jetbrains/plugins/gradle/jvmcompat/IdeVersionedDataStorage;", "(Lorg/jetbrains/plugins/gradle/jvmcompat/IdeVersionedDataStorage;)V", "configUrl", "", "getConfigUrl", "()Ljava/lang/String;", "updateInterval", "Lkotlin/time/Duration;", "getUpdateInterval-UwyO8pc", "()J", "checkForUpdates", "", "retrieveNewData", "intellij.gradle"})
@ApiStatus.Internal
public abstract class IdeVersionedDataUpdater<T extends IdeVersionedDataState> {
    @NotNull
    private final IdeVersionedDataStorage<T> dataStorage;

    public IdeVersionedDataUpdater(@NotNull IdeVersionedDataStorage<T> dataStorage) {
        Intrinsics.checkNotNullParameter(dataStorage, (String)"dataStorage");
        this.dataStorage = dataStorage;
    }

    @NotNull
    public abstract String getConfigUrl();

    public abstract long getUpdateInterval-UwyO8pc();

    public void checkForUpdates() {
        long lastUpdateTime;
        T state;
        long updateIntervalMillis = Duration.getInWholeMilliseconds-impl((long)this.getUpdateInterval-UwyO8pc());
        if (updateIntervalMillis == 0L || ((CharSequence)this.getConfigUrl()).length() == 0) {
            return;
        }
        T t = state = this.dataStorage.getState();
        long l = lastUpdateTime = t != null ? ((IdeVersionedDataState)((Object)t)).getLastUpdateTime() : 0L;
        if (lastUpdateTime + updateIntervalMillis <= System.currentTimeMillis()) {
            IdeVersionedDataUpdaterKt.access$getLOG$p().info("Updating version compatibility for " + this.getClass().getName() + ". Last update was: " + lastUpdateTime + ". Update interval: " + Duration.toString-impl((long)this.getUpdateInterval-UwyO8pc()) + " Url to update " + this.getConfigUrl());
            this.retrieveNewData(this.getConfigUrl());
        } else {
            IdeVersionedDataUpdaterKt.access$getLOG$p().debug("Will not update version compatibility for " + this.getClass().getName() + ". Last update was: " + lastUpdateTime + ". Update interval: " + Duration.toString-impl((long)this.getUpdateInterval-UwyO8pc()) + " Url to update " + this.getConfigUrl());
        }
    }

    private final void retrieveNewData(String configUrl) {
        try {
            String string2 = HttpRequests.request((String)configUrl).forceHttps(!ApplicationManager.getApplication().isUnitTestMode()).productNameAsUserAgent().readString();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"readString(...)");
            String json = string2;
            this.dataStorage.setStateAsString(json);
            IdeVersionedDataUpdaterKt.access$getLOG$p().info("IDE versioned data for " + this.getClass().getName() + " was updated");
        }
        catch (Exception e) {
            IdeVersionedDataUpdaterKt.access$getLOG$p().warn("Could not download new IDE versioned data for " + this.getClass().getName(), (Throwable)e);
        }
    }
}

