/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.issue;

import com.intellij.build.FilePosition;
import com.intellij.build.events.BuildEvent;
import com.intellij.build.issue.BuildIssue;
import com.intellij.openapi.externalSystem.service.execution.ExternalSystemJdkUtil;
import com.intellij.util.lang.JavaVersion;
import java.io.File;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gradle.internal.jvm.UnsupportedJavaRuntimeException;
import org.gradle.util.GradleVersion;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.issue.GradleIssueChecker;
import org.jetbrains.plugins.gradle.issue.GradleIssueData;
import org.jetbrains.plugins.gradle.issue.IncompatibleGradleJvmAndGradleBuildIssue;
import org.jetbrains.plugins.gradle.jvmcompat.GradleJvmSupportMatrix;
import org.jetbrains.plugins.gradle.service.execution.GradleExecutionErrorHandler;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0007\u0018\u0000 \u001e2\u00020\u0001:\u0001\u001eB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016JD\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\b\u0010\f\u001a\u0004\u0018\u00010\n2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u000e\u0010\u0011\u001a\n\u0012\u0006\b\u0000\u0012\u00020\u00130\u0012H\u0016J\u0012\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0012\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0012\u0010\u001a\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010\u001b\u001a\u00020\b2\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0010\u0010\u001c\u001a\u00020\b2\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0010\u0010\u001d\u001a\u00020\b2\u0006\u0010\u0016\u001a\u00020\u0017H\u0002\u00a8\u0006\u001f"}, d2={"Lorg/jetbrains/plugins/gradle/issue/IncompatibleGradleJvmAndGradleIssueChecker;", "Lorg/jetbrains/plugins/gradle/issue/GradleIssueChecker;", "()V", "check", "Lcom/intellij/build/issue/BuildIssue;", "issueData", "Lorg/jetbrains/plugins/gradle/issue/GradleIssueData;", "consumeBuildOutputFailureMessage", "", "message", "", "failureCause", "stacktrace", "location", "Lcom/intellij/build/FilePosition;", "parentEventId", "", "messageConsumer", "Ljava/util/function/Consumer;", "Lcom/intellij/build/events/BuildEvent;", "detectJavaVersionIfCouldNotDetermineJavaIssue", "Lcom/intellij/util/lang/JavaVersion;", "rootCause", "", "getGradleVersion", "Lorg/gradle/util/GradleVersion;", "getJavaVersion", "isCouldNotDetermineJavaIssue", "isUnsupportedClassVersionIssue", "isUnsupportedJavaRuntimeIssue", "Companion", "intellij.gradle"})
@ApiStatus.Internal
public final class IncompatibleGradleJvmAndGradleIssueChecker
implements GradleIssueChecker {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final String COULD_NOT_CREATE_SERVICE_OF_TYPE_PREFIX = "Could not create service of type ";
    @NotNull
    private static final String USING_BUILD_SCOPE_SERVICES = " using BuildScopeServices.";
    @NotNull
    private static final String COULD_NOT_DETERMINE_JAVA_VERSION_MESSAGE = "Could not determine Java version.";
    @NotNull
    private static final String COULD_NOT_DETERMINE_JAVA_USING_EXECUTABLE_PREFIX = "org.gradle.api.GradleException: Could not determine Java version using executable ";

    @Override
    public boolean consumeBuildOutputFailureMessage(@NotNull String message, @NotNull String failureCause, @Nullable String stacktrace, @Nullable FilePosition location, @NotNull Object parentEventId, @NotNull Consumer<? super BuildEvent> messageConsumer) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter((Object)failureCause, (String)"failureCause");
        Intrinsics.checkNotNullParameter((Object)parentEventId, (String)"parentEventId");
        Intrinsics.checkNotNullParameter(messageConsumer, (String)"messageConsumer");
        return StringsKt.startsWith$default((String)failureCause, (String)COULD_NOT_CREATE_SERVICE_OF_TYPE_PREFIX, (boolean)false, (int)2, null) && StringsKt.contains$default((CharSequence)failureCause, (CharSequence)USING_BUILD_SCOPE_SERVICES, (boolean)false, (int)2, null);
    }

    @Nullable
    public BuildIssue check(@NotNull GradleIssueData issueData) {
        Intrinsics.checkNotNullParameter((Object)issueData, (String)"issueData");
        Throwable rootCause = (Throwable)GradleExecutionErrorHandler.getRootCauseAndLocation((Throwable)issueData.getError()).first;
        GradleVersion gradleVersion2 = this.getGradleVersion(issueData);
        JavaVersion javaVersion = this.getJavaVersion(issueData);
        if (gradleVersion2 != null && javaVersion != null) {
            if (!GradleJvmSupportMatrix.Companion.isSupported(gradleVersion2, javaVersion)) {
                return (BuildIssue)new IncompatibleGradleJvmAndGradleBuildIssue(gradleVersion2, javaVersion, issueData.getProjectPath());
            }
        } else {
            Intrinsics.checkNotNull((Object)rootCause);
            if (this.isCouldNotDetermineJavaIssue(rootCause)) {
                JavaVersion javaVersion2 = this.detectJavaVersionIfCouldNotDetermineJavaIssue(rootCause);
                if (javaVersion2 == null) {
                    javaVersion2 = javaVersion;
                }
                JavaVersion detectedJavaVersion = javaVersion2;
                return (BuildIssue)new IncompatibleGradleJvmAndGradleBuildIssue(gradleVersion2, detectedJavaVersion, issueData.getProjectPath());
            }
            if (this.isUnsupportedClassVersionIssue(rootCause)) {
                return (BuildIssue)new IncompatibleGradleJvmAndGradleBuildIssue(gradleVersion2, javaVersion, issueData.getProjectPath());
            }
            if (this.isUnsupportedJavaRuntimeIssue(rootCause)) {
                return (BuildIssue)new IncompatibleGradleJvmAndGradleBuildIssue(gradleVersion2, javaVersion, issueData.getProjectPath());
            }
        }
        return null;
    }

    private final GradleVersion getGradleVersion(GradleIssueData issueData) {
        if (issueData.getBuildEnvironment() != null) {
            return GradleVersion.version((String)issueData.getBuildEnvironment().getGradle().getGradleVersion());
        }
        return null;
    }

    private final JavaVersion getJavaVersion(GradleIssueData issueData) {
        if (issueData.getBuildEnvironment() != null) {
            return ExternalSystemJdkUtil.getJavaVersion((String)issueData.getBuildEnvironment().getJava().getJavaHome().getPath());
        }
        return null;
    }

    private final boolean isUnsupportedClassVersionIssue(Throwable rootCause) {
        return Intrinsics.areEqual((Object)rootCause.getClass().getSimpleName(), (Object)UnsupportedClassVersionError.class.getSimpleName());
    }

    private final boolean isUnsupportedJavaRuntimeIssue(Throwable rootCause) {
        return Intrinsics.areEqual((Object)rootCause.getClass().getSimpleName(), (Object)UnsupportedJavaRuntimeException.class.getSimpleName());
    }

    private final boolean isCouldNotDetermineJavaIssue(Throwable rootCause) {
        String rootCauseText = rootCause.toString();
        if (StringsKt.startsWith$default((String)rootCauseText, (String)COULD_NOT_DETERMINE_JAVA_USING_EXECUTABLE_PREFIX, (boolean)false, (int)2, null)) {
            return true;
        }
        return Intrinsics.areEqual((Object)rootCause.getMessage(), (Object)COULD_NOT_DETERMINE_JAVA_VERSION_MESSAGE);
    }

    private final JavaVersion detectJavaVersionIfCouldNotDetermineJavaIssue(Throwable rootCause) {
        File javaHome;
        String rootCauseText = rootCause.toString();
        char[] cArray = new char[]{'.'};
        String javaExeCandidate = StringsKt.trimEnd((String)StringsKt.substringAfter$default((String)rootCauseText, (String)COULD_NOT_DETERMINE_JAVA_USING_EXECUTABLE_PREFIX, null, (int)2, null), (char[])cArray);
        File file = new File(javaExeCandidate).getParentFile();
        File file2 = javaHome = file != null ? file.getParentFile() : null;
        if (javaHome != null && javaHome.isDirectory()) {
            return ExternalSystemJdkUtil.getJavaVersion((String)javaHome.getPath());
        }
        return null;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lorg/jetbrains/plugins/gradle/issue/IncompatibleGradleJvmAndGradleIssueChecker$Companion;", "", "()V", "COULD_NOT_CREATE_SERVICE_OF_TYPE_PREFIX", "", "COULD_NOT_DETERMINE_JAVA_USING_EXECUTABLE_PREFIX", "COULD_NOT_DETERMINE_JAVA_VERSION_MESSAGE", "USING_BUILD_SCOPE_SERVICES", "intellij.gradle"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

