/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ssh.impl.sshj.tunnels;

import com.google.common.net.HostAndPort;
import com.intellij.ssh.SshTunnelAlreadyRegisteredException;
import com.intellij.ssh.SshTunnelCreationException;
import com.intellij.ssh.impl.sshj.UtilKt;
import com.intellij.ssh.impl.sshj.tunnels.LocalForwarderCollection;
import com.intellij.ssh.impl.sshj.tunnels.LocalTunnelServer;
import java.io.Closeable;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import net.schmizz.sshj.SSHClient;
import net.schmizz.sshj.connection.Connection;
import net.schmizz.sshj.connection.channel.direct.Parameters;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0010\u001a\u00020\u0011H\u0016J&\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00052\u0006\u0010\u0018\u001a\u00020\u0016J&\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00052\u0006\u0010\u0018\u001a\u00020\u0016J\u001e\u0010\u0019\u001a\u00020\u00162\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u00052\u0006\u0010\u0018\u001a\u00020\u0016J\u001e\u0010\u0019\u001a\u00020\u00162\u0006\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u0017\u001a\u00020\u00052\u0006\u0010\u0018\u001a\u00020\u0016J\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00050\u001bJ\u0010\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\u0006\u0010\u0018\u001a\u00020\u0016J \u0010\u001e\u001a\u00020\u00112\u0006\u0010\u001f\u001a\u00020\u000b2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\tH\u0002J\u0016\u0010#\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016J\u0016\u0010#\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u0016J\u0014\u0010$\u001a\u00020%*\u00020&2\u0006\u0010'\u001a\u00020\u0005H\u0002RB\u0010\u0007\u001a6\u0012\u0004\u0012\u00020\t\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\n0\bj\u001a\u0012\u0004\u0012\u00020\t\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\n`\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lcom/intellij/ssh/impl/sshj/tunnels/LocalForwarderCollection;", "Ljava/io/Closeable;", "sshClient", "Lnet/schmizz/sshj/SSHClient;", "ownerName", "", "(Lnet/schmizz/sshj/SSHClient;Ljava/lang/String;)V", "forwardersByLocalAddress", "Ljava/util/HashMap;", "Ljava/net/InetSocketAddress;", "Lkotlin/Pair;", "Lnet/schmizz/sshj/connection/channel/direct/Parameters;", "Lcom/intellij/ssh/impl/sshj/tunnels/LocalTunnelServer;", "Lkotlin/collections/HashMap;", "forwardersLock", "Ljava/util/concurrent/locks/ReentrantLock;", "close", "", "create", "localHost", "Ljava/net/InetAddress;", "localPort", "", "remoteHost", "remotePort", "createForFreePort", "get", "", "getLocalAddressForRemotePort", "Lcom/google/common/net/HostAndPort;", "initializeForwarder", "params", "serverSocket", "Ljava/net/ServerSocket;", "key", "remove", "wrapIntoTunnelCreationException", "Lcom/intellij/ssh/SshTunnelCreationException;", "Ljava/io/IOException;", "logLabel", "intellij.platform.ssh"})
@SourceDebugExtension(value={"SMAP\nLocalForwarderCollection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LocalForwarderCollection.kt\ncom/intellij/ssh/impl/sshj/tunnels/LocalForwarderCollection\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,270:1\n1855#2,2:271\n1855#2,2:273\n*S KotlinDebug\n*F\n+ 1 LocalForwarderCollection.kt\ncom/intellij/ssh/impl/sshj/tunnels/LocalForwarderCollection\n*L\n148#1:271,2\n151#1:273,2\n*E\n"})
public final class LocalForwarderCollection
implements Closeable {
    @NotNull
    private final SSHClient sshClient;
    @NotNull
    private final String ownerName;
    @NotNull
    private final HashMap<InetSocketAddress, Pair<Parameters, LocalTunnelServer>> forwardersByLocalAddress;
    @NotNull
    private final ReentrantLock forwardersLock;

    public LocalForwarderCollection(@NotNull SSHClient sshClient, @NotNull String ownerName) {
        Intrinsics.checkNotNullParameter((Object)sshClient, (String)"sshClient");
        Intrinsics.checkNotNullParameter((Object)ownerName, (String)"ownerName");
        this.sshClient = sshClient;
        this.ownerName = ownerName;
        this.forwardersByLocalAddress = new HashMap();
        this.forwardersLock = new ReentrantLock();
    }

    public final void create(@NotNull String localHost, int localPort, @NotNull String remoteHost, int remotePort) {
        Intrinsics.checkNotNullParameter((Object)localHost, (String)"localHost");
        Intrinsics.checkNotNullParameter((Object)remoteHost, (String)"remoteHost");
        InetAddress inetAddress = InetAddress.getByName(localHost);
        Intrinsics.checkNotNullExpressionValue((Object)inetAddress, (String)"getByName(...)");
        this.create(inetAddress, localPort, remoteHost, remotePort);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void create(@NotNull InetAddress localHost, int localPort, @NotNull String remoteHost, int remotePort) {
        Intrinsics.checkNotNullParameter((Object)localHost, (String)"localHost");
        Intrinsics.checkNotNullParameter((Object)remoteHost, (String)"remoteHost");
        Lock lock = this.forwardersLock;
        lock.lock();
        try {
            boolean bl = false;
            String logLabel = "local tunnel for " + this.ownerName + ": " + localHost + ":" + localPort + " ==> " + remoteHost + ":" + remotePort;
            UtilKt.getSSHJ_LOG().debug("Creating " + logLabel);
            Parameters params = new Parameters(localHost.getHostAddress(), localPort, remoteHost, remotePort);
            InetSocketAddress key = new InetSocketAddress(localHost, localPort);
            if (((Map)this.forwardersByLocalAddress).containsKey(key)) {
                throw new SshTunnelAlreadyRegisteredException("Already registered: " + logLabel);
            }
            ServerSocket serverSocket = new ServerSocket();
            try {
                serverSocket.setReuseAddress(true);
                serverSocket.bind(new InetSocketAddress(params.getLocalHost(), params.getLocalPort()));
                this.initializeForwarder(params, serverSocket, key);
            }
            catch (IOException error2) {
                Closeable closeable = serverSocket;
                Throwable throwable = null;
                try {
                    try {
                        ServerSocket it = (ServerSocket)closeable;
                        boolean bl2 = false;
                        throw this.wrapIntoTunnelCreationException(error2, logLabel);
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                }
                catch (Throwable throwable3) {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                    throw throwable3;
                }
            }
            UtilKt.getSSHJ_LOG().debug("Created " + logLabel);
            Unit unit = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
    }

    public final int createForFreePort(@NotNull String localHost, @NotNull String remoteHost, int remotePort) {
        Intrinsics.checkNotNullParameter((Object)localHost, (String)"localHost");
        Intrinsics.checkNotNullParameter((Object)remoteHost, (String)"remoteHost");
        InetAddress inetAddress = InetAddress.getByName(localHost);
        Intrinsics.checkNotNullExpressionValue((Object)inetAddress, (String)"getByName(...)");
        return this.createForFreePort(inetAddress, remoteHost, remotePort);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int createForFreePort(@NotNull InetAddress localHost, @NotNull String remoteHost, int remotePort) {
        Intrinsics.checkNotNullParameter((Object)localHost, (String)"localHost");
        Intrinsics.checkNotNullParameter((Object)remoteHost, (String)"remoteHost");
        Lock lock = this.forwardersLock;
        lock.lock();
        boolean bl = false;
        String logLabel = "local tunnel for " + this.ownerName + ": " + localHost + ":<any free port> ==> " + remoteHost + ":" + remotePort;
        UtilKt.getSSHJ_LOG().debug("Creating " + logLabel);
        Ref.ObjectRef lastError = new Ref.ObjectRef();
        for (int attempt = 0; attempt < 10; ++attempt) {
            ServerSocket serverSocket = new ServerSocket();
            try {
                serverSocket.setReuseAddress(true);
                serverSocket.bind(new InetSocketAddress(localHost, 0));
                InetSocketAddress key = new InetSocketAddress(localHost, serverSocket.getLocalPort());
                if (this.forwardersByLocalAddress.containsKey(key)) {
                    serverSocket.close();
                    continue;
                }
                Parameters params = new Parameters(key.getHostString(), key.getPort(), remoteHost, remotePort);
                this.initializeForwarder(params, serverSocket, key);
                UtilKt.getSSHJ_LOG().debug("Created " + logLabel + ", chosen port is " + key.getPort());
                int n = key.getPort();
                return n;
            }
            catch (IOException error2) {
                Closeable closeable = serverSocket;
                Throwable throwable = null;
                try {
                    ServerSocket it = (ServerSocket)closeable;
                    boolean bl2 = false;
                    lastError.element = this.wrapIntoTunnelCreationException(error2, logLabel);
                    Unit unit = Unit.INSTANCE;
                    continue;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
            }
        }
        Object object = lastError.element;
        Intrinsics.checkNotNull((Object)object);
        throw (Throwable)object;
        finally {
            lock.unlock();
        }
    }

    private final SshTunnelCreationException wrapIntoTunnelCreationException(IOException $this$wrapIntoTunnelCreationException, String logLabel) {
        String message = "Failed to create " + logLabel + ": " + $this$wrapIntoTunnelCreationException.getMessage();
        UtilKt.getSSHJ_LOG().warn(message, (Throwable)$this$wrapIntoTunnelCreationException);
        return new SshTunnelCreationException(message, $this$wrapIntoTunnelCreationException);
    }

    private final void initializeForwarder(Parameters params, ServerSocket serverSocket, InetSocketAddress key) {
        Connection connection = this.sshClient.getConnection();
        Intrinsics.checkNotNullExpressionValue((Object)connection, (String)"getConnection(...)");
        LocalTunnelServer forwarder = new LocalTunnelServer(connection, params, serverSocket, this.ownerName);
        ((Map)this.forwardersByLocalAddress).put(key, new Pair((Object)params, (Object)forwarder));
        forwarder.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final List<String> get() {
        List list2;
        Lock lock = this.forwardersLock;
        lock.lock();
        try {
            boolean bl = false;
            Collection<Pair<Parameters, LocalTunnelServer>> collection = this.forwardersByLocalAddress.values();
            Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
            list2 = SequencesKt.toMutableList((Sequence)SequencesKt.map((Sequence)SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)collection), (Function1)get.1.1.INSTANCE), (Function1)get.1.2.INSTANCE));
        }
        finally {
            lock.unlock();
        }
        return list2;
    }

    public final void remove(@NotNull String localHost, int localPort) {
        Intrinsics.checkNotNullParameter((Object)localHost, (String)"localHost");
        InetAddress inetAddress = InetAddress.getByName(localHost);
        Intrinsics.checkNotNullExpressionValue((Object)inetAddress, (String)"getByName(...)");
        this.remove(inetAddress, localPort);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void remove(@NotNull InetAddress localHost, int localPort) {
        LocalTunnelServer localTunnelServer;
        Intrinsics.checkNotNullParameter((Object)localHost, (String)"localHost");
        InetSocketAddress localAddress = new InetSocketAddress(localHost, localPort);
        Lock lock = this.forwardersLock;
        lock.lock();
        try {
            boolean bl = false;
            Pair<Parameters, LocalTunnelServer> pair = this.forwardersByLocalAddress.remove(localAddress);
            localTunnelServer = pair != null ? (LocalTunnelServer)pair.getSecond() : null;
        }
        finally {
            lock.unlock();
        }
        LocalTunnelServer forwarder = localTunnelServer;
        String logLabel = "local tunnel for " + this.ownerName + ": " + localHost + ":" + localPort + " ==>";
        if (forwarder != null) {
            forwarder.stop();
            forwarder.await();
            Parameters $this$remove_u24lambda_u246 = forwarder.getParams();
            boolean bl = false;
            UtilKt.getSSHJ_LOG().debug("Removed " + logLabel + " " + $this$remove_u24lambda_u246.getRemoteHost() + ":" + $this$remove_u24lambda_u246.getRemotePort());
        } else {
            UtilKt.getSSHJ_LOG().debug("Tried to remove non-existing " + logLabel + " <host>:<port>");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final HostAndPort getLocalAddressForRemotePort(int remotePort) {
        HostAndPort hostAndPort;
        Lock lock = this.forwardersLock;
        lock.lock();
        try {
            boolean bl = false;
            Collection<Pair<Parameters, LocalTunnelServer>> collection = this.forwardersByLocalAddress.values();
            Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
            hostAndPort = (HostAndPort)SequencesKt.firstOrNull((Sequence)SequencesKt.map((Sequence)SequencesKt.filter((Sequence)SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)collection), (Function1)getLocalAddressForRemotePort.1.1.INSTANCE), (Function1)((Function1)new Function1<Parameters, Boolean>(remotePort){
                final /* synthetic */ int $remotePort;
                {
                    this.$remotePort = $remotePort;
                    super(1);
                }

                @NotNull
                public final Boolean invoke(@NotNull Parameters it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    return it.getRemotePort() == this.$remotePort;
                }
            })), (Function1)getLocalAddressForRemotePort.1.3.INSTANCE));
        }
        finally {
            lock.unlock();
        }
        return hostAndPort;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        List $i$a$-withLock-LocalForwarderCollection$close$stoppedServers$22;
        Lock lock = this.forwardersLock;
        lock.lock();
        try {
            boolean $i$a$-withLock-LocalForwarderCollection$close$stoppedServers$22 = false;
            Collection<Pair<Parameters, LocalTunnelServer>> collection = this.forwardersByLocalAddress.values();
            Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
            List servers2 = SequencesKt.toList((Sequence)SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)collection), (Function1)close.stoppedServers.1.servers.1.INSTANCE));
            this.forwardersByLocalAddress.clear();
            Iterable $this$forEach$iv = servers2;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                LocalTunnelServer it = (LocalTunnelServer)element$iv;
                boolean bl = false;
                it.stop();
            }
            $i$a$-withLock-LocalForwarderCollection$close$stoppedServers$22 = servers2;
        }
        finally {
            lock.unlock();
        }
        List stoppedServers2 = $i$a$-withLock-LocalForwarderCollection$close$stoppedServers$22;
        Iterable $this$forEach$iv = stoppedServers2;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            LocalTunnelServer it = (LocalTunnelServer)element$iv;
            boolean bl = false;
            it.await();
        }
    }
}

