/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.impl;

import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiIntersectionType;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeVisitor;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public final class GrTraitType
extends PsiType {
    @NotNull
    private final PsiIntersectionType myDelegate;
    @NotNull
    private final PsiType myExprType;
    @NotNull
    private final List<PsiType> myTraitTypes;

    private GrTraitType(@NotNull PsiIntersectionType delegate) {
        if (delegate == null) {
            GrTraitType.$$$reportNull$$$0(0);
        }
        super(PsiAnnotation.EMPTY_ARRAY);
        this.myDelegate = delegate;
        this.myExprType = delegate.getConjuncts()[0];
        this.myTraitTypes = ContainerUtil.subArrayAsList((Object[])delegate.getConjuncts(), (int)1, (int)delegate.getConjuncts().length);
    }

    @NotNull
    public PsiType getExprType() {
        PsiType psiType = this.myExprType;
        if (psiType == null) {
            GrTraitType.$$$reportNull$$$0(1);
        }
        return psiType;
    }

    @NotNull
    public @Unmodifiable List<PsiType> getTraitTypes() {
        List<PsiType> list = this.myTraitTypes;
        if (list == null) {
            GrTraitType.$$$reportNull$$$0(2);
        }
        return list;
    }

    public PsiType @NotNull [] getConjuncts() {
        PsiType[] psiTypeArray = this.myDelegate.getConjuncts();
        if (psiTypeArray == null) {
            GrTraitType.$$$reportNull$$$0(3);
        }
        return psiTypeArray;
    }

    @NotNull
    public String getPresentableText() {
        String string = this.myExprType.getPresentableText() + " as " + StringUtil.join((Collection)ContainerUtil.map(this.myTraitTypes, type2 -> type2.getPresentableText()), (String)", ");
        if (string == null) {
            GrTraitType.$$$reportNull$$$0(4);
        }
        return string;
    }

    @NotNull
    public String getCanonicalText() {
        String string = this.myDelegate.getCanonicalText();
        if (string == null) {
            GrTraitType.$$$reportNull$$$0(5);
        }
        return string;
    }

    @NlsSafe
    @NotNull
    public String getInternalCanonicalText() {
        String string = this.myExprType.getCanonicalText() + " as " + StringUtil.join((Collection)ContainerUtil.map(this.myTraitTypes, type2 -> type2.getInternalCanonicalText()), (String)", ");
        if (string == null) {
            GrTraitType.$$$reportNull$$$0(6);
        }
        return string;
    }

    public boolean isValid() {
        return this.myDelegate.isValid();
    }

    public boolean equalsToText(@NotNull @NonNls String text) {
        if (text == null) {
            GrTraitType.$$$reportNull$$$0(7);
        }
        return this.myDelegate.equalsToText(text);
    }

    public <A> A accept(@NotNull PsiTypeVisitor<A> visitor2) {
        if (visitor2 == null) {
            GrTraitType.$$$reportNull$$$0(8);
        }
        return (A)this.myDelegate.accept(visitor2);
    }

    @Nullable
    public GlobalSearchScope getResolveScope() {
        return this.myDelegate.getResolveScope();
    }

    public PsiType @NotNull [] getSuperTypes() {
        PsiType[] psiTypeArray = this.myDelegate.getSuperTypes();
        if (psiTypeArray == null) {
            GrTraitType.$$$reportNull$$$0(9);
        }
        return psiTypeArray;
    }

    @NotNull
    public static PsiType createTraitType(@NotNull PsiType type2, @NotNull List<? extends PsiType> traits) {
        if (type2 == null) {
            GrTraitType.$$$reportNull$$$0(10);
        }
        if (traits == null) {
            GrTraitType.$$$reportNull$$$0(11);
        }
        return GrTraitType.createTraitType(ContainerUtil.prepend(traits, (Object[])new PsiType[]{type2 instanceof GrTraitType ? ((GrTraitType)type2).myDelegate : type2}));
    }

    @NotNull
    public static PsiType createTraitType(@NotNull List<PsiType> types) {
        if (types == null) {
            GrTraitType.$$$reportNull$$$0(12);
        }
        return GrTraitType.createTraitType(types.toArray(PsiType.createArray((int)types.size())));
    }

    @NotNull
    public static PsiType createTraitType(PsiType @NotNull [] types) {
        Set flattened;
        PsiType[] conjuncts;
        if (types == null) {
            GrTraitType.$$$reportNull$$$0(13);
        }
        if ((conjuncts = (flattened = PsiIntersectionType.flatten((PsiType[])types, (Set)new LinkedHashSet<PsiType>(){

            @Override
            public boolean add(PsiType type2) {
                this.remove(type2);
                return super.add(type2);
            }
        })).toArray(PsiType.createArray((int)flattened.size()))).length == 1) {
            PsiType psiType = conjuncts[0];
            if (psiType == null) {
                GrTraitType.$$$reportNull$$$0(14);
            }
            return psiType;
        }
        return new GrTraitType((PsiIntersectionType)PsiIntersectionType.createIntersection((boolean)false, (PsiType[])conjuncts));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3, 4, 5, 6, 9, 14 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "delegate";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 9: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/groovy/lang/psi/impl/GrTraitType";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "traits";
                break;
            }
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "types";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/groovy/lang/psi/impl/GrTraitType";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getExprType";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getTraitTypes";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getConjuncts";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableText";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getCanonicalText";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getInternalCanonicalText";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getSuperTypes";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "createTraitType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 9: 
            case 14: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "equalsToText";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "createTraitType";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 3, 4, 5, 6, 9, 14 -> new IllegalStateException(string);
        };
    }
}

