/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.intentions.declaration;

import com.intellij.java.JavaBundle;
import com.intellij.modcommand.ActionContext;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.Presentation;
import com.intellij.modcommand.PsiUpdateModCommandAction;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.codeStyle.SuggestedNameInfo;
import com.intellij.psi.codeStyle.VariableKind;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ArrayUtilRt;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrConstructorInvocation;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariableDeclaration;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrOpenBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrAssignmentExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.params.GrParameter;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.refactoring.GroovyRefactoringUtil;

public final class GrCreateFieldForParameterIntention
extends PsiUpdateModCommandAction<GrParameter> {
    public GrCreateFieldForParameterIntention() {
        super(GrParameter.class);
    }

    @Nullable
    protected Presentation getPresentation(@NotNull ActionContext context, @NotNull GrParameter parameter) {
        GrMethod grMethod;
        PsiElement psiElement;
        if (context == null) {
            GrCreateFieldForParameterIntention.$$$reportNull$$$0(0);
        }
        if (parameter == null) {
            GrCreateFieldForParameterIntention.$$$reportNull$$$0(1);
        }
        if (!((psiElement = parameter.getDeclarationScope()) instanceof GrMethod) || (grMethod = (GrMethod)psiElement).getContainingClass() == null || GrCreateFieldForParameterIntention.checkAssignmentToFieldExists(parameter)) {
            return null;
        }
        return Presentation.of((String)JavaBundle.message((String)"intention.create.field.from.parameter.text", (Object[])new Object[]{parameter.getName()}));
    }

    @NotNull
    public String getFamilyName() {
        String string = JavaBundle.message((String)"intention.create.field.from.parameter.family", (Object[])new Object[0]);
        if (string == null) {
            GrCreateFieldForParameterIntention.$$$reportNull$$$0(2);
        }
        return string;
    }

    protected void invoke(@NotNull ActionContext context, @NotNull GrParameter parameter, @NotNull ModPsiUpdater updater) {
        if (context == null) {
            GrCreateFieldForParameterIntention.$$$reportNull$$$0(3);
        }
        if (parameter == null) {
            GrCreateFieldForParameterIntention.$$$reportNull$$$0(4);
        }
        if (updater == null) {
            GrCreateFieldForParameterIntention.$$$reportNull$$$0(5);
        }
        Project project = context.project();
        PsiType type2 = GroovyRefactoringUtil.getSubstitutedType(parameter);
        JavaCodeStyleManager styleManager = JavaCodeStyleManager.getInstance((Project)project);
        String parameterName = parameter.getName();
        String propertyName = styleManager.variableNameToPropertyName(parameterName, VariableKind.PARAMETER);
        GrMethod method = (GrMethod)parameter.getDeclarationScope();
        PsiClass targetClass = method.getContainingClass();
        if (targetClass == null) {
            return;
        }
        boolean isMethodStatic = method.hasModifierProperty("static");
        VariableKind kind = isMethodStatic ? VariableKind.STATIC_FIELD : VariableKind.FIELD;
        SuggestedNameInfo suggestedNameInfo = styleManager.suggestVariableName(kind, propertyName, null, type2);
        SuggestedNameInfo uniqueNameInfo = styleManager.suggestUniqueVariableName(suggestedNameInfo, (PsiElement)targetClass, true);
        boolean isFinal = !isMethodStatic && method.isConstructor();
        PsiVariable variable = GrCreateFieldForParameterIntention.createField(project, targetClass, method, parameter, type2, uniqueNameInfo.names[0], isMethodStatic, isFinal);
        if (variable != null && variable.isValid()) {
            updater.rename((PsiNameIdentifierOwner)variable, List.of(Objects.requireNonNull(variable.getName())));
        }
    }

    private static boolean checkAssignmentToFieldExists(PsiParameter parameter) {
        for (PsiReference reference : ReferencesSearch.search((PsiElement)parameter).findAll()) {
            GrReferenceExpression ref2;
            GrExpression value2;
            GrAssignmentExpression parent2;
            PsiElement psiElement;
            PsiElement element = reference.getElement();
            if (!(element instanceof GrReferenceExpression) || !((psiElement = element.getParent()) instanceof GrAssignmentExpression) || (parent2 = (GrAssignmentExpression)psiElement).getRValue() != element || !((value2 = parent2.getLValue()) instanceof GrReferenceExpression) || !((ref2 = (GrReferenceExpression)value2).resolve() instanceof PsiField)) continue;
            return true;
        }
        return false;
    }

    private static PsiVariable createField(@NotNull Project project, @NotNull PsiClass targetClass, @NotNull GrMethod method, @NotNull PsiParameter myParameter, PsiType type2, @NotNull String fieldName, boolean methodStatic, boolean isFinal) {
        GrOpenBlock block;
        if (project == null) {
            GrCreateFieldForParameterIntention.$$$reportNull$$$0(6);
        }
        if (targetClass == null) {
            GrCreateFieldForParameterIntention.$$$reportNull$$$0(7);
        }
        if (method == null) {
            GrCreateFieldForParameterIntention.$$$reportNull$$$0(8);
        }
        if (myParameter == null) {
            GrCreateFieldForParameterIntention.$$$reportNull$$$0(9);
        }
        if (fieldName == null) {
            GrCreateFieldForParameterIntention.$$$reportNull$$$0(10);
        }
        if ((block = method.getBlock()) == null) {
            return null;
        }
        GroovyPsiElementFactory factory = GroovyPsiElementFactory.getInstance(project);
        GrAssignmentExpression assignment = GrCreateFieldForParameterIntention.createAssignment(targetClass, myParameter, fieldName, methodStatic, factory);
        GrStatement anchor = GrCreateFieldForParameterIntention.getAnchor(block);
        GrStatement statement = block.addStatementBefore(assignment, anchor);
        JavaCodeStyleManager.getInstance((Project)project).shortenClassReferences((PsiElement)statement);
        if (targetClass.findFieldByName(fieldName, false) == null) {
            String[] modifiers = GrCreateFieldForParameterIntention.getModifiers(methodStatic, isFinal);
            GrVariableDeclaration fieldDeclaration = factory.createFieldDeclaration(modifiers, fieldName, null, type2);
            GrVariableDeclaration inserted = (GrVariableDeclaration)targetClass.add((PsiElement)fieldDeclaration);
            JavaCodeStyleManager.getInstance((Project)project).shortenClassReferences((PsiElement)inserted);
            return inserted.getVariables()[0];
        }
        return null;
    }

    private static GrAssignmentExpression createAssignment(PsiClass targetClass, PsiParameter myParameter, String fieldName, boolean methodStatic, GroovyPsiElementFactory factory) {
        StringBuilder builder = new StringBuilder();
        if (methodStatic) {
            builder.append(targetClass.getQualifiedName());
            builder.append('.');
        } else {
            builder.append("this.");
        }
        builder.append(fieldName);
        builder.append("=").append(myParameter.getName());
        return (GrAssignmentExpression)factory.createStatementFromText(builder.toString());
    }

    @Nullable
    private static GrStatement getAnchor(GrOpenBlock block) {
        Object[] statements2 = block.getStatements();
        GrStatement fist = (GrStatement)ArrayUtil.getFirstElement((Object[])statements2);
        if (fist instanceof GrConstructorInvocation) {
            return statements2.length > 1 ? statements2[1] : null;
        }
        return fist;
    }

    private static String[] getModifiers(boolean aStatic, boolean aFinal) {
        ArrayList<String> list = new ArrayList<String>();
        list.add("private");
        if (aStatic) {
            list.add("static");
        }
        if (aFinal) {
            list.add("final");
        }
        return ArrayUtilRt.toStringArray(list);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameter";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/groovy/intentions/declaration/GrCreateFieldForParameterIntention";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "updater";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetClass";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "myParameter";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fieldName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/groovy/intentions/declaration/GrCreateFieldForParameterIntention";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getPresentation";
                break;
            }
            case 2: {
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "createField";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }
}

