/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.intentions.control;

import com.intellij.modcommand.ActionContext;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.codeInspection.utils.EquivalenceChecker;
import org.jetbrains.plugins.groovy.intentions.base.GrPsiUpdateIntention;
import org.jetbrains.plugins.groovy.intentions.base.PsiElementPredicate;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrBlockStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrIfStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.branch.GrReturnStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrAssignmentExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrConditionalExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;

public final class ReplaceIfWithTernaryIntention
extends GrPsiUpdateIntention {
    @Override
    protected void processIntention(@NotNull PsiElement element, @NotNull ActionContext context, @NotNull ModPsiUpdater updater) {
        GrConditionalExpression conditional;
        if (element == null) {
            ReplaceIfWithTernaryIntention.$$$reportNull$$$0(0);
        }
        if (context == null) {
            ReplaceIfWithTernaryIntention.$$$reportNull$$$0(1);
        }
        if (updater == null) {
            ReplaceIfWithTernaryIntention.$$$reportNull$$$0(2);
        }
        GrIfStatement ifStatement = (GrIfStatement)element.getParent();
        PsiElement thenBranch = ReplaceIfWithTernaryIntention.skipBlock(ifStatement.getThenBranch());
        PsiElement elseBranch = ReplaceIfWithTernaryIntention.skipBlock(ifStatement.getElseBranch());
        Project project = context.project();
        if (thenBranch instanceof GrAssignmentExpression) {
            GrAssignmentExpression thenAssign = (GrAssignmentExpression)thenBranch;
            if (elseBranch instanceof GrAssignmentExpression) {
                GrAssignmentExpression elseAssign = (GrAssignmentExpression)elseBranch;
                GrAssignmentExpression assignment = (GrAssignmentExpression)GroovyPsiElementFactory.getInstance(project).createStatementFromText("a = b ? c : d");
                assignment.getLValue().replaceWithExpression(thenAssign.getLValue(), true);
                conditional = (GrConditionalExpression)assignment.getRValue();
                ReplaceIfWithTernaryIntention.replaceConditional(conditional, ifStatement.getCondition(), thenAssign.getRValue(), elseAssign.getRValue());
                ifStatement.replaceWithStatement(assignment);
            }
        }
        if (thenBranch instanceof GrReturnStatement) {
            GrReturnStatement thenReturn = (GrReturnStatement)thenBranch;
            if (elseBranch instanceof GrReturnStatement) {
                GrReturnStatement elseReturn = (GrReturnStatement)elseBranch;
                GrReturnStatement returnSt = (GrReturnStatement)GroovyPsiElementFactory.getInstance(project).createStatementFromText("return a ? b : c");
                conditional = (GrConditionalExpression)returnSt.getReturnValue();
                ReplaceIfWithTernaryIntention.replaceConditional(conditional, ifStatement.getCondition(), thenReturn.getReturnValue(), elseReturn.getReturnValue());
                ifStatement.replaceWithStatement(returnSt);
            }
        }
    }

    private static void replaceConditional(GrConditionalExpression conditional, GrExpression condition, GrExpression then, GrExpression elze) {
        conditional.getCondition().replaceWithExpression(condition, true);
        conditional.getThenBranch().replaceWithExpression(then, true);
        conditional.getElseBranch().replaceWithExpression(elze, true);
    }

    @Override
    @NotNull
    protected PsiElementPredicate getElementPredicate() {
        PsiElementPredicate psiElementPredicate = e -> {
            GrReturnStatement elseReturn;
            GrReturnStatement thenReturn;
            GrAssignmentExpression elseAssign;
            GrAssignmentExpression thenAssign;
            if (!e.getNode().getElementType().equals(GroovyTokenTypes.kIF)) {
                return false;
            }
            PsiElement patt4201$temp = e.getParent();
            if (!(patt4201$temp instanceof GrIfStatement)) {
                return false;
            }
            GrIfStatement ifStatement = (GrIfStatement)patt4201$temp;
            PsiElement thenBranch = ReplaceIfWithTernaryIntention.skipBlock(ifStatement.getThenBranch());
            PsiElement elseBranch = ReplaceIfWithTernaryIntention.skipBlock(ifStatement.getElseBranch());
            if (thenBranch instanceof GrAssignmentExpression && (thenAssign = (GrAssignmentExpression)thenBranch).getRValue() != null && elseBranch instanceof GrAssignmentExpression && (elseAssign = (GrAssignmentExpression)elseBranch).getRValue() != null) {
                GrExpression lvalue1 = thenAssign.getLValue();
                GrExpression lvalue2 = elseAssign.getLValue();
                return EquivalenceChecker.expressionsAreEquivalent(lvalue1, lvalue2);
            }
            return thenBranch instanceof GrReturnStatement && (thenReturn = (GrReturnStatement)thenBranch).getReturnValue() != null && elseBranch instanceof GrReturnStatement && (elseReturn = (GrReturnStatement)elseBranch).getReturnValue() != null;
        };
        if (psiElementPredicate == null) {
            ReplaceIfWithTernaryIntention.$$$reportNull$$$0(3);
        }
        return psiElementPredicate;
    }

    private static PsiElement skipBlock(PsiElement e) {
        GrBlockStatement block;
        if (e instanceof GrBlockStatement && (block = (GrBlockStatement)e).getBlock().getStatements().length == 1) {
            return block.getBlock().getStatements()[0];
        }
        return e;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "updater";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/groovy/intentions/control/ReplaceIfWithTernaryIntention";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/groovy/intentions/control/ReplaceIfWithTernaryIntention";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getElementPredicate";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "processIntention";
                break;
            }
            case 3: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3 -> new IllegalStateException(string);
        };
    }
}

