/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.dgm;

import com.intellij.lang.Language;
import com.intellij.lang.properties.PropertiesFileType;
import com.intellij.lang.properties.PropertiesLanguage;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.fileTypes.ex.FileTypeIdentifiableByVirtualFile;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.vfs.VirtualFile;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.GroovyBundle;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\b\u0010\u0006\u001a\u00020\u0005H\u0016J\b\u0010\u0007\u001a\u00020\u0005H\u0016J\n\u0010\b\u001a\u0004\u0018\u00010\tH\u0016J\b\u0010\n\u001a\u00020\u0005H\u0016J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/plugins/groovy/dgm/DGMFileType;", "Lcom/intellij/openapi/fileTypes/LanguageFileType;", "Lcom/intellij/openapi/fileTypes/ex/FileTypeIdentifiableByVirtualFile;", "()V", "getDefaultExtension", "", "getDescription", "getDisplayName", "getIcon", "Ljavax/swing/Icon;", "getName", "isMyFileType", "", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "intellij.groovy"})
public final class DGMFileType
extends LanguageFileType
implements FileTypeIdentifiableByVirtualFile {
    @NotNull
    public static final DGMFileType INSTANCE = new DGMFileType();

    private DGMFileType() {
        super((Language)PropertiesLanguage.INSTANCE, true);
    }

    @NotNull
    public String getName() {
        return "DGM";
    }

    @NotNull
    public String getDefaultExtension() {
        return "";
    }

    @NotNull
    public String getDescription() {
        String string = GroovyBundle.message("filetype.dgm.description", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    @NotNull
    public String getDisplayName() {
        String string = GroovyBundle.message("filetype.dgm.display.name", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    @Nullable
    public Icon getIcon() {
        return PropertiesFileType.INSTANCE.getIcon();
    }

    public boolean isMyFileType(@NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        if (!Comparing.equal((CharSequence)"org.codehaus.groovy.runtime.ExtensionModule", (CharSequence)file.getNameSequence())) {
            return false;
        }
        VirtualFile virtualFile = file.getParent();
        if (virtualFile == null) {
            return false;
        }
        VirtualFile parent2 = virtualFile;
        CharSequence charSequence = parent2.getNameSequence();
        Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"getNameSequence(...)");
        CharSequence parentName = charSequence;
        if (!Comparing.equal((CharSequence)"services", (CharSequence)parentName) && !Comparing.equal((CharSequence)"groovy", (CharSequence)parentName)) {
            return false;
        }
        VirtualFile virtualFile2 = parent2.getParent();
        if (virtualFile2 == null) {
            return false;
        }
        VirtualFile gParent = virtualFile2;
        return Comparing.equal((CharSequence)"META-INF", (CharSequence)gParent.getNameSequence());
    }
}

