/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.copyright;

import com.intellij.copyright.UpdateJavaFileCopyright;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.maddyhome.idea.copyright.CopyrightProfile;
import com.maddyhome.idea.copyright.psi.UpdateCopyright;
import com.maddyhome.idea.copyright.psi.UpdateCopyrightsProvider;
import java.util.List;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrStatement;
import org.jetbrains.plugins.groovy.lang.psi.impl.synthetic.GroovyScriptClass;

public final class UpdateGroovyCopyrightsProvider
extends UpdateCopyrightsProvider {
    public UpdateCopyright createInstance(Project project, Module module, VirtualFile file, FileType base, CopyrightProfile options2) {
        return new UpdateJavaFileCopyright(project, module, file, options2){

            protected boolean accept() {
                return this.getFile() instanceof GroovyFile;
            }

            protected PsiElement[] getImportsList() {
                return ((GroovyFile)this.getFile()).getImportStatements();
            }

            protected PsiElement getPackageStatement() {
                return ((GroovyFile)this.getFile()).getPackageDefinition();
            }

            protected void checkCommentsForTopClass(PsiClass topClass, int location, List<PsiComment> comments) {
                PsiElement last;
                if (!(topClass instanceof GroovyScriptClass)) {
                    super.checkCommentsForTopClass(topClass, location, comments);
                    return;
                }
                GroovyFile containingFile = (GroovyFile)topClass.getContainingFile();
                for (last = containingFile.getFirstChild(); last != null && !(last instanceof GrStatement); last = last.getNextSibling()) {
                }
                this.checkComments(last, location == 3, comments);
            }
        };
    }
}

