/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.utils;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.codeInspection.utils.BoolUtils;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.psi.GrControlFlowOwner;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.GroovyRecursiveElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.api.GrExpressionLambdaBody;
import org.jetbrains.plugins.groovy.lang.psi.api.GrLambdaBody;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrBlockStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrCatchClause;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrClassInitializer;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrField;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrFinallyClause;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrForStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrIfStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrLabeledStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrLoopStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrSwitchStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrSynchronizedStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrTryCatchStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrWhileStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrCodeBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrOpenBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.branch.GrAssertStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.branch.GrBreakStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.branch.GrContinueStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.branch.GrReturnStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.branch.GrThrowStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.branch.GrYieldStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.clauses.GrCaseSection;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrUnaryExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.lang.psi.api.util.GrStatementOwner;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.AfterCallInstruction;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.Instruction;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.ReadWriteVariableInstruction;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.impl.ControlFlowBuilder;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.impl.GroovyControlFlow;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.impl.IfEndInstruction;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.impl.MaybeInterruptInstruction;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.impl.MaybeReturnInstruction;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.impl.MaybeYieldInstruction;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.impl.ThrowingInstruction;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.impl.VariableDescriptorFactory;
import org.jetbrains.plugins.groovy.lang.psi.dataFlow.DFAEngine;
import org.jetbrains.plugins.groovy.lang.psi.dataFlow.DfaInstance;
import org.jetbrains.plugins.groovy.lang.psi.dataFlow.Semilattice;
import org.jetbrains.plugins.groovy.lang.psi.impl.GroovyFileBaseImpl;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.blocks.GrBlockImpl;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;

public final class ControlFlowUtils {
    private static final Logger LOG = Logger.getInstance(ControlFlowUtils.class);

    public static boolean statementMayCompleteNormally(@Nullable GrStatement statement) {
        if (statement == null) {
            return true;
        }
        if (statement instanceof GrBreakStatement || statement instanceof GrContinueStatement || statement instanceof GrReturnStatement || statement instanceof GrYieldStatement || statement instanceof GrThrowStatement) {
            return false;
        }
        if (statement instanceof GrForStatement) {
            return ControlFlowUtils.forStatementMayReturnNormally((GrForStatement)statement);
        }
        if (statement instanceof GrWhileStatement) {
            return ControlFlowUtils.whileStatementMayReturnNormally((GrWhileStatement)statement);
        }
        if (statement instanceof GrBlockStatement) {
            return ControlFlowUtils.blockMayCompleteNormally((GrBlockStatement)statement);
        }
        if (statement instanceof GrSynchronizedStatement) {
            GrSynchronizedStatement syncStatement = (GrSynchronizedStatement)statement;
            return ControlFlowUtils.openBlockMayCompleteNormally(syncStatement.getBody());
        }
        if (statement instanceof GrLabeledStatement) {
            return ControlFlowUtils.labeledStatementMayCompleteNormally((GrLabeledStatement)statement);
        }
        if (statement instanceof GrIfStatement) {
            return ControlFlowUtils.ifStatementMayReturnNormally((GrIfStatement)statement);
        }
        if (statement instanceof GrTryCatchStatement) {
            return ControlFlowUtils.tryStatementMayReturnNormally((GrTryCatchStatement)statement);
        }
        if (statement instanceof GrSwitchStatement) {
            return ControlFlowUtils.switchStatementMayReturnNormally((GrSwitchStatement)statement);
        }
        return true;
    }

    private static boolean whileStatementMayReturnNormally(@NotNull GrWhileStatement loopStatement) {
        GrExpression test;
        if (loopStatement == null) {
            ControlFlowUtils.$$$reportNull$$$0(0);
        }
        return !BoolUtils.isTrue(test = loopStatement.getCondition()) || ControlFlowUtils.statementIsBreakTarget(loopStatement);
    }

    private static boolean forStatementMayReturnNormally(@NotNull GrForStatement loopStatement) {
        if (loopStatement == null) {
            ControlFlowUtils.$$$reportNull$$$0(1);
        }
        return true;
    }

    private static boolean switchStatementMayReturnNormally(@NotNull GrSwitchStatement switchStatement) {
        if (switchStatement == null) {
            ControlFlowUtils.$$$reportNull$$$0(2);
        }
        if (ControlFlowUtils.statementIsBreakTarget(switchStatement)) {
            return true;
        }
        Object[] caseClauses = switchStatement.getCaseSections();
        if (ContainerUtil.find((Object[])caseClauses, section -> section.isDefault()) == null) {
            return true;
        }
        Object lastClause = caseClauses[caseClauses.length - 1];
        GrStatement[] statements2 = lastClause.getStatements();
        if (statements2.length == 0) {
            return true;
        }
        return ControlFlowUtils.statementMayCompleteNormally(statements2[statements2.length - 1]);
    }

    private static boolean tryStatementMayReturnNormally(@NotNull GrTryCatchStatement tryStatement) {
        GrFinallyClause finallyBlock;
        if (tryStatement == null) {
            ControlFlowUtils.$$$reportNull$$$0(3);
        }
        if ((finallyBlock = tryStatement.getFinallyClause()) != null && !ControlFlowUtils.openBlockMayCompleteNormally(finallyBlock.getBody())) {
            return false;
        }
        GrOpenBlock tryBlock = tryStatement.getTryBlock();
        if (ControlFlowUtils.openBlockMayCompleteNormally(tryBlock)) {
            return true;
        }
        for (GrCatchClause catchClause : tryStatement.getCatchClauses()) {
            if (!ControlFlowUtils.openBlockMayCompleteNormally(catchClause.getBody())) continue;
            return true;
        }
        return false;
    }

    private static boolean ifStatementMayReturnNormally(@NotNull GrIfStatement ifStatement) {
        GrStatement thenBranch;
        if (ifStatement == null) {
            ControlFlowUtils.$$$reportNull$$$0(4);
        }
        if (ControlFlowUtils.statementMayCompleteNormally(thenBranch = ifStatement.getThenBranch())) {
            return true;
        }
        GrStatement elseBranch = ifStatement.getElseBranch();
        return elseBranch == null || ControlFlowUtils.statementMayCompleteNormally(elseBranch);
    }

    private static boolean labeledStatementMayCompleteNormally(@NotNull GrLabeledStatement labeledStatement) {
        GrStatement statement;
        if (labeledStatement == null) {
            ControlFlowUtils.$$$reportNull$$$0(5);
        }
        return ControlFlowUtils.statementMayCompleteNormally(statement = labeledStatement.getStatement()) || ControlFlowUtils.statementIsBreakTarget(statement);
    }

    public static boolean blockMayCompleteNormally(@Nullable GrBlockStatement block) {
        GrStatement[] statements2;
        if (block == null) {
            return true;
        }
        for (GrStatement statement : statements2 = block.getBlock().getStatements()) {
            if (ControlFlowUtils.statementMayCompleteNormally(statement)) continue;
            return false;
        }
        return true;
    }

    public static boolean openBlockMayCompleteNormally(@Nullable GrOpenBlock block) {
        GrStatement[] statements2;
        if (block == null) {
            return true;
        }
        for (GrStatement statement : statements2 = block.getStatements()) {
            if (ControlFlowUtils.statementMayCompleteNormally(statement)) continue;
            return false;
        }
        return true;
    }

    private static boolean statementIsBreakTarget(@NotNull GrStatement statement) {
        if (statement == null) {
            ControlFlowUtils.$$$reportNull$$$0(6);
        }
        BreakFinder breakFinder = new BreakFinder(statement);
        statement.accept(breakFinder);
        return breakFinder.breakFound();
    }

    public static boolean statementContainsReturn(@NotNull GrStatement statement) {
        if (statement == null) {
            ControlFlowUtils.$$$reportNull$$$0(7);
        }
        ReturnFinder returnFinder = new ReturnFinder();
        statement.accept(returnFinder);
        return returnFinder.returnFound();
    }

    public static boolean statementIsContinueTarget(@NotNull GrStatement statement) {
        if (statement == null) {
            ControlFlowUtils.$$$reportNull$$$0(8);
        }
        ContinueFinder continueFinder = new ContinueFinder(statement);
        statement.accept(continueFinder);
        return continueFinder.continueFound();
    }

    public static boolean isInLoop(@NotNull GroovyPsiElement element) {
        if (element == null) {
            ControlFlowUtils.$$$reportNull$$$0(9);
        }
        return ControlFlowUtils.isInForStatementBody(element) || ControlFlowUtils.isInWhileStatementBody(element);
    }

    public static boolean isInFinallyBlock(@NotNull GroovyPsiElement element) {
        GrFinallyClause containingClause;
        if (element == null) {
            ControlFlowUtils.$$$reportNull$$$0(10);
        }
        if ((containingClause = (GrFinallyClause)PsiTreeUtil.getParentOfType((PsiElement)element, GrFinallyClause.class)) == null) {
            return false;
        }
        GrOpenBlock body = containingClause.getBody();
        return PsiTreeUtil.isAncestor((PsiElement)body, (PsiElement)element, (boolean)true);
    }

    private static boolean isInWhileStatementBody(@NotNull GroovyPsiElement element) {
        GrWhileStatement whileStatement;
        if (element == null) {
            ControlFlowUtils.$$$reportNull$$$0(11);
        }
        if ((whileStatement = (GrWhileStatement)PsiTreeUtil.getParentOfType((PsiElement)element, GrWhileStatement.class)) == null) {
            return false;
        }
        GrStatement body = whileStatement.getBody();
        return PsiTreeUtil.isAncestor((PsiElement)body, (PsiElement)element, (boolean)true);
    }

    private static boolean isInForStatementBody(@NotNull GroovyPsiElement element) {
        GrForStatement forStatement;
        if (element == null) {
            ControlFlowUtils.$$$reportNull$$$0(12);
        }
        if ((forStatement = (GrForStatement)PsiTreeUtil.getParentOfType((PsiElement)element, GrForStatement.class)) == null) {
            return false;
        }
        GrStatement body = forStatement.getBody();
        return PsiTreeUtil.isAncestor((PsiElement)body, (PsiElement)element, (boolean)true);
    }

    public static GrStatement stripBraces(@NotNull GrStatement branch) {
        if (branch == null) {
            ControlFlowUtils.$$$reportNull$$$0(13);
        }
        if (branch instanceof GrBlockStatement) {
            GrBlockStatement block = (GrBlockStatement)branch;
            GrStatement[] statements2 = block.getBlock().getStatements();
            if (statements2.length == 1) {
                return statements2[0];
            }
            return block;
        }
        return branch;
    }

    public static boolean statementCompletesWithStatement(@NotNull GrStatement containingStatement, @NotNull GrStatement statement) {
        if (containingStatement == null) {
            ControlFlowUtils.$$$reportNull$$$0(14);
        }
        if (statement == null) {
            ControlFlowUtils.$$$reportNull$$$0(15);
        }
        GrStatement statementToCheck = statement;
        while (!statementToCheck.equals(containingStatement)) {
            GrStatement container = ControlFlowUtils.getContainingStatement(statementToCheck);
            if (container == null) {
                return false;
            }
            if (container instanceof GrBlockStatement && !ControlFlowUtils.statementIsLastInBlock((GrBlockStatement)container, statementToCheck)) {
                return false;
            }
            if (ControlFlowUtils.isLoop(container)) {
                return false;
            }
            statementToCheck = container;
        }
        return true;
    }

    public static boolean blockCompletesWithStatement(@NotNull GrBlockStatement body, @NotNull GrStatement statement) {
        if (body == null) {
            ControlFlowUtils.$$$reportNull$$$0(16);
        }
        if (statement == null) {
            ControlFlowUtils.$$$reportNull$$$0(17);
        }
        GrStatement statementToCheck = statement;
        while (statementToCheck != null) {
            PsiElement container = statementToCheck.getParent();
            if (container == null) {
                return false;
            }
            if (container instanceof GrLoopStatement) {
                return false;
            }
            if (container instanceof GrCaseSection) {
                GrCaseSection caseSection = (GrCaseSection)container;
                if (!ControlFlowUtils.statementIsLastInBlock(caseSection, statementToCheck)) {
                    return false;
                }
                parent = container.getParent();
                assert (parent instanceof GrSwitchStatement);
                GrSwitchStatement switchStatement = (GrSwitchStatement)parent;
                Object[] sections = switchStatement.getCaseSections();
                if (ArrayUtil.getLastElement((Object[])sections) != caseSection) {
                    return false;
                }
            } else if (container instanceof GrOpenBlock) {
                GrBlockStatement blockStatement;
                GrOpenBlock block = (GrOpenBlock)container;
                if (!ControlFlowUtils.statementIsLastInBlock(block, statementToCheck)) {
                    return false;
                }
                parent = block.getParent();
                if (parent instanceof GrBlockStatement && (blockStatement = (GrBlockStatement)parent) == body) {
                    return true;
                }
            } else if (container instanceof GrClosableBlock) {
                return false;
            }
            statementToCheck = ControlFlowUtils.getContainingStatement(statementToCheck);
        }
        return false;
    }

    public static boolean openBlockCompletesWithStatement(@NotNull GrCodeBlock body, @NotNull GrStatement statement) {
        if (body == null) {
            ControlFlowUtils.$$$reportNull$$$0(18);
        }
        if (statement == null) {
            ControlFlowUtils.$$$reportNull$$$0(19);
        }
        GroovyPsiElement elementToCheck = statement;
        while (elementToCheck != null) {
            GrSwitchStatement switchStatement;
            GrCaseSection[] sections;
            GroovyPsiElement container = (GroovyPsiElement)PsiTreeUtil.getParentOfType((PsiElement)elementToCheck, (Class[])new Class[]{GrStatement.class, GrCodeBlock.class, GrCaseSection.class});
            if (container == null) {
                return false;
            }
            if (ControlFlowUtils.isLoop(container)) {
                return false;
            }
            if (container instanceof GrCaseSection && container == (sections = (switchStatement = (GrSwitchStatement)container.getParent()).getCaseSections())[sections.length - 1]) {
                return false;
            }
            if (container instanceof GrCodeBlock) {
                GrCodeBlock codeBlock;
                if (elementToCheck instanceof GrStatement && !ControlFlowUtils.statementIsLastInBlock(codeBlock = (GrCodeBlock)container, elementToCheck)) {
                    return false;
                }
                if (container instanceof GrOpenBlock || container instanceof GrClosableBlock) {
                    if (container.equals(body)) {
                        return true;
                    }
                    elementToCheck = (GroovyPsiElement)PsiTreeUtil.getParentOfType((PsiElement)container, GrStatement.class);
                    continue;
                }
                elementToCheck = container;
                continue;
            }
            elementToCheck = container;
        }
        return false;
    }

    public static boolean closureCompletesWithStatement(@NotNull GrClosableBlock body, @NotNull GrStatement statement) {
        if (body == null) {
            ControlFlowUtils.$$$reportNull$$$0(20);
        }
        if (statement == null) {
            ControlFlowUtils.$$$reportNull$$$0(21);
        }
        GroovyPsiElement statementToCheck = statement;
        while (statementToCheck instanceof GrExpression || statementToCheck instanceof GrReturnStatement) {
            GroovyPsiElement container = ControlFlowUtils.getContainingStatementOrBlock(statementToCheck);
            if (container == null) {
                return false;
            }
            if (ControlFlowUtils.isLoop(container)) {
                return false;
            }
            if (container instanceof GrCodeBlock) {
                if (!ControlFlowUtils.statementIsLastInBlock((GrCodeBlock)container, statementToCheck)) {
                    return false;
                }
                if (container.equals(body)) {
                    return true;
                }
                statementToCheck = (GroovyPsiElement)PsiTreeUtil.getParentOfType((PsiElement)container, GrStatement.class);
                continue;
            }
            statementToCheck = container;
        }
        return false;
    }

    private static boolean isLoop(@NotNull PsiElement element) {
        if (element == null) {
            ControlFlowUtils.$$$reportNull$$$0(22);
        }
        return element instanceof GrLoopStatement;
    }

    @Nullable
    private static GrStatement getContainingStatement(@NotNull GroovyPsiElement statement) {
        if (statement == null) {
            ControlFlowUtils.$$$reportNull$$$0(23);
        }
        return (GrStatement)PsiTreeUtil.getParentOfType((PsiElement)statement, GrStatement.class);
    }

    @Nullable
    private static GroovyPsiElement getContainingStatementOrBlock(@NotNull GroovyPsiElement statement) {
        if (statement == null) {
            ControlFlowUtils.$$$reportNull$$$0(24);
        }
        return (GroovyPsiElement)PsiTreeUtil.getParentOfType((PsiElement)statement, (Class[])new Class[]{GrStatement.class, GrCodeBlock.class});
    }

    private static boolean statementIsLastInBlock(@NotNull GrBlockStatement block, @NotNull GrStatement statement) {
        if (block == null) {
            ControlFlowUtils.$$$reportNull$$$0(25);
        }
        if (statement == null) {
            ControlFlowUtils.$$$reportNull$$$0(26);
        }
        return ControlFlowUtils.statementIsLastInBlock(block.getBlock(), statement);
    }

    private static boolean statementIsLastInBlock(@NotNull GrStatementOwner block, @NotNull GrStatement statement) {
        GrStatement lastStatement;
        if (block == null) {
            ControlFlowUtils.$$$reportNull$$$0(27);
        }
        if (statement == null) {
            ControlFlowUtils.$$$reportNull$$$0(28);
        }
        return statement == (lastStatement = (GrStatement)ArrayUtil.getLastElement((Object[])block.getStatements()));
    }

    @NotNull
    public static List<GrStatement> collectReturns(@Nullable GroovyPsiElement element) {
        return ControlFlowUtils.collectReturns(element, element instanceof GrCodeBlock || element instanceof GroovyFile || element instanceof GrLambdaBody);
    }

    @NotNull
    public static List<GrStatement> collectReturns(@Nullable GroovyPsiElement element, boolean allExitPoints) {
        if (element == null) {
            List<GrStatement> list = Collections.emptyList();
            if (list == null) {
                ControlFlowUtils.$$$reportNull$$$0(29);
            }
            return list;
        }
        GroovyControlFlow flow = element instanceof GrControlFlowOwner ? ControlFlowUtils.getGroovyControlFlow((GrControlFlowOwner)element) : ControlFlowBuilder.buildControlFlow(element);
        return ControlFlowUtils.collectReturns(flow.getFlow(), element, allExitPoints);
    }

    @NotNull
    public static List<GrStatement> collectReturns(Instruction @NotNull [] flow, @NotNull GroovyPsiElement element, boolean allExitPoints) {
        if (element == null) {
            ControlFlowUtils.$$$reportNull$$$0(30);
        }
        if (flow == null) {
            ControlFlowUtils.$$$reportNull$$$0(31);
        }
        boolean[] visited = new boolean[flow.length];
        ExitPointCollector collector = new ExitPointCollector(allExitPoints ? MaybeReturnInstruction.class : null, GrReturnStatement.class);
        ControlFlowUtils.visitAllExitPointsInner(flow[flow.length - 1], flow[0], visited, collector);
        List<GrStatement> list = collector.getCollectedStatements();
        if (list == null) {
            ControlFlowUtils.$$$reportNull$$$0(32);
        }
        return list;
    }

    @NotNull
    public static List<GrStatement> collectYields(Instruction @NotNull [] flow) {
        if (flow == null) {
            ControlFlowUtils.$$$reportNull$$$0(33);
        }
        boolean[] visited = new boolean[flow.length];
        ExitPointCollector collector = new ExitPointCollector(MaybeYieldInstruction.class, GrYieldStatement.class);
        ControlFlowUtils.visitAllExitPointsInner(flow[flow.length - 1], flow[0], visited, collector);
        List<GrStatement> list = collector.getCollectedStatements();
        if (list == null) {
            ControlFlowUtils.$$$reportNull$$$0(34);
        }
        return list;
    }

    public static Instruction @NotNull [] getCaseSectionInstructions(GrCaseSection caseSection) {
        Instruction[] instructionArray = (Instruction[])CachedValuesManager.getCachedValue((PsiElement)caseSection, () -> CachedValueProvider.Result.create((Object)ControlFlowBuilder.buildControlFlow(caseSection).getFlow(), (Object[])new Object[]{caseSection}));
        if (instructionArray == null) {
            ControlFlowUtils.$$$reportNull$$$0(35);
        }
        return instructionArray;
    }

    @Nullable
    public static GrExpression extractReturnExpression(GrStatement returnStatement) {
        if (returnStatement instanceof GrReturnStatement) {
            return ((GrReturnStatement)returnStatement).getReturnValue();
        }
        if (returnStatement instanceof GrExpression) {
            return (GrExpression)returnStatement;
        }
        return null;
    }

    public static boolean isIncOrDecOperand(GrReferenceExpression referenceExpression) {
        PsiElement parent2 = referenceExpression.getParent();
        if (parent2 instanceof GrUnaryExpression) {
            IElementType opType = ((GrUnaryExpression)parent2).getOperationTokenType();
            return opType == GroovyTokenTypes.mDEC || opType == GroovyTokenTypes.mINC;
        }
        return false;
    }

    public static String dumpControlFlow(GroovyControlFlow flow) {
        StringBuilder builder = new StringBuilder();
        for (Instruction instruction : flow.getFlow()) {
            String repr;
            if (instruction instanceof ReadWriteVariableInstruction) {
                int descriptorId = ((ReadWriteVariableInstruction)instruction).getDescriptor();
                repr = instruction.toString().replace(" " + descriptorId, " " + flow.getVarIndices()[descriptorId].getName());
            } else {
                repr = instruction.toString();
            }
            builder.append(repr).append("\n");
        }
        return builder.toString();
    }

    @Nullable
    public static ReadWriteVariableInstruction findRWInstruction(GrReferenceExpression refExpr, Instruction[] flow) {
        for (Instruction instruction : flow) {
            if (!(instruction instanceof ReadWriteVariableInstruction) || instruction.getElement() != refExpr) continue;
            return (ReadWriteVariableInstruction)instruction;
        }
        return null;
    }

    @Nullable
    public static Instruction findNearestInstruction(PsiElement place, Instruction[] flow) {
        ArrayList<Instruction> applicable = new ArrayList<Instruction>();
        for (Instruction instruction : flow) {
            PsiElement element = instruction.getElement();
            if (element == null) continue;
            if (element == place) {
                return instruction;
            }
            if (!PsiTreeUtil.isAncestor((PsiElement)element, (PsiElement)place, (boolean)true)) continue;
            applicable.add(instruction);
        }
        if (applicable.isEmpty()) {
            return null;
        }
        applicable.sort((o1, o2) -> {
            PsiElement e1 = o1.getElement();
            PsiElement e2 = o2.getElement();
            LOG.assertTrue(e1 != null);
            LOG.assertTrue(e2 != null);
            TextRange t1 = e1.getTextRange();
            TextRange t2 = e2.getTextRange();
            int s1 = t1.getStartOffset();
            int s2 = t2.getStartOffset();
            if (s1 == s2) {
                return t1.getEndOffset() - t2.getEndOffset();
            }
            return s2 - s1;
        });
        return (Instruction)applicable.get(0);
    }

    public static boolean isImplicitReturnStatement(@NotNull GrExpression expression) {
        GrControlFlowOwner flowOwner;
        if (expression == null) {
            ControlFlowUtils.$$$reportNull$$$0(36);
        }
        return (flowOwner = ControlFlowUtils.findControlFlowOwner(expression)) != null && PsiUtil.isExpressionStatement(expression) && ControlFlowUtils.isReturnValue(expression, flowOwner) && !PsiUtil.isVoidMethodCall(expression);
    }

    public static Set<GrExpression> getAllReturnValues(@NotNull GrControlFlowOwner block) {
        if (block == null) {
            ControlFlowUtils.$$$reportNull$$$0(37);
        }
        return (Set)CachedValuesManager.getCachedValue((PsiElement)block, () -> {
            final HashSet result2 = new HashSet();
            ControlFlowUtils.visitAllExitPoints(block, new ExitPointVisitor(){

                @Override
                public boolean visitExitPoint(Instruction instruction, @Nullable GrExpression returnValue) {
                    ContainerUtil.addIfNotNull((Collection)result2, (Object)returnValue);
                    return true;
                }
            });
            return CachedValueProvider.Result.create(result2, (Object[])new Object[]{block});
        });
    }

    public static boolean isReturnValue(@NotNull GrExpression expression, @NotNull GrControlFlowOwner flowOwner) {
        if (expression == null) {
            ControlFlowUtils.$$$reportNull$$$0(38);
        }
        if (flowOwner == null) {
            ControlFlowUtils.$$$reportNull$$$0(39);
        }
        return ControlFlowUtils.getAllReturnValues(flowOwner).contains(expression);
    }

    public static boolean visitAllExitPoints(@Nullable GrControlFlowOwner block, ExitPointVisitor visitor2) {
        if (block == null) {
            return true;
        }
        Instruction[] flow = block.getControlFlow();
        boolean[] visited = new boolean[flow.length];
        return ControlFlowUtils.visitAllExitPointsInner(flow[flow.length - 1], flow[0], visited, visitor2);
    }

    private static boolean visitAllExitPointsInner(Instruction last, Instruction first, boolean[] visited, ExitPointVisitor visitor2) {
        PsiElement element;
        if (first == last) {
            return true;
        }
        int shift = first.num();
        if (last instanceof AfterCallInstruction) {
            visited[last.num() - shift] = true;
            return ControlFlowUtils.visitAllExitPointsInner(((AfterCallInstruction)last).myCall, first, visited, visitor2);
        }
        if (last instanceof MaybeInterruptInstruction) {
            return visitor2.visitExitPoint(last, (GrExpression)last.getElement());
        }
        if (last instanceof IfEndInstruction) {
            visited[last.num() - shift] = true;
            for (Instruction instruction : last.allPredecessors()) {
                if (ControlFlowUtils.visitAllExitPointsInner(instruction, first, visited, visitor2)) continue;
                return false;
            }
            return true;
        }
        if (last instanceof ThrowingInstruction && !((element = last.getElement()) instanceof GrThrowStatement) && !(element instanceof GrAssertStatement)) {
            return true;
        }
        element = last.getElement();
        if (element != null) {
            GrExpression returnValue = element instanceof GrReturnStatement ? ((GrReturnStatement)element).getReturnValue() : (element instanceof GrExpression && PsiUtil.isExpressionStatement(element) ? (GrExpression)element : null);
            return visitor2.visitExitPoint(last, returnValue);
        }
        visited[last.num() - shift] = true;
        for (Instruction pred : last.allPredecessors()) {
            if (visited[pred.num() - shift] || ControlFlowUtils.visitAllExitPointsInner(pred, first, visited, visitor2)) continue;
            return false;
        }
        return true;
    }

    @Nullable
    public static GrControlFlowOwner findControlFlowOwner(PsiElement place) {
        for (place = place.getContext(); place != null; place = place.getContext()) {
            if (place instanceof GrControlFlowOwner && ((GrControlFlowOwner)place).isTopControlFlowOwner()) {
                return (GrControlFlowOwner)place;
            }
            if (place instanceof GrMethod) {
                return ((GrMethod)place).getBlock();
            }
            if (!(place instanceof GrClassInitializer)) continue;
            return ((GrClassInitializer)place).getBlock();
        }
        return null;
    }

    public static List<ReadWriteVariableInstruction> findAccess(GrVariable local, PsiElement place, boolean ahead, boolean writeAccessOnly) {
        LOG.assertTrue(!(local instanceof GrField), local.getClass());
        GrControlFlowOwner owner = ControlFlowUtils.findControlFlowOwner(place);
        assert (owner != null);
        GroovyControlFlow flow = ControlFlowUtils.getGroovyControlFlow(owner);
        Instruction cur = ControlFlowUtils.findInstruction(place, flow.getFlow());
        if (cur == null) {
            throw new IllegalArgumentException("place is not in the flow");
        }
        return ControlFlowUtils.findAccess(flow.getIndex(VariableDescriptorFactory.createDescriptor(local)), ahead, writeAccessOnly, cur);
    }

    public static List<ReadWriteVariableInstruction> findAccess(int variableIndex, boolean ahead, boolean writeAccessOnly, Instruction cur) {
        Instruction instruction;
        if (variableIndex == 0) {
            return Collections.emptyList();
        }
        ArrayList<ReadWriteVariableInstruction> result2 = new ArrayList<ReadWriteVariableInstruction>();
        HashSet<Instruction> visited = new HashSet<Instruction>();
        visited.add(cur);
        ArrayDeque<Instruction> queue = new ArrayDeque<Instruction>();
        for (Instruction i2 : ahead ? cur.allSuccessors() : cur.allPredecessors()) {
            if (!visited.add(i2)) continue;
            queue.add(i2);
        }
        while ((instruction = (Instruction)queue.poll()) != null) {
            ReadWriteVariableInstruction rw;
            if (instruction instanceof ReadWriteVariableInstruction && variableIndex == (rw = (ReadWriteVariableInstruction)instruction).getDescriptor()) {
                if (rw.isWrite()) {
                    result2.add(rw);
                    continue;
                }
                if (!writeAccessOnly) {
                    result2.add(rw);
                }
            }
            for (Instruction i3 : ahead ? instruction.allSuccessors() : instruction.allPredecessors()) {
                if (!visited.add(i3)) continue;
                queue.add(i3);
            }
        }
        return result2;
    }

    @Nullable
    public static Instruction findInstruction(PsiElement place, Instruction[] controlFlow) {
        return (Instruction)ContainerUtil.find((Object[])controlFlow, instruction -> instruction.getElement() == place);
    }

    @Contract(value="null -> null")
    @Nullable
    public static GrControlFlowOwner getTopmostOwner(@Nullable PsiElement place) {
        if (place == null) {
            return null;
        }
        GrControlFlowOwner owner = ControlFlowUtils.findControlFlowOwner(place);
        if (place instanceof GrOpenBlock && owner instanceof GroovyFile || place == owner || owner == null && place instanceof GrControlFlowOwner) {
            return (GrControlFlowOwner)place;
        }
        if (owner == null) {
            return null;
        }
        return ControlFlowUtils.getTopmostOwner(owner);
    }

    @NotNull
    public static @NotNull List<@NotNull BitSet> inferWriteAccessMap(final GroovyControlFlow groovyFlow, final GrVariable var) {
        final BitSet neutral = new BitSet(groovyFlow.getFlow().length);
        Semilattice<BitSet> sem = new Semilattice<BitSet>(){

            @Override
            @NotNull
            public BitSet join(@NotNull List<? extends BitSet> ins) {
                if (ins == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (ins.size() == 0) {
                    BitSet bitSet = neutral;
                    if (bitSet == null) {
                        2.$$$reportNull$$$0(1);
                    }
                    return bitSet;
                }
                if (ins.size() == 1) {
                    BitSet bitSet = ins.get(0);
                    if (bitSet == null) {
                        2.$$$reportNull$$$0(2);
                    }
                    return bitSet;
                }
                BitSet result2 = new BitSet(groovyFlow.getFlow().length);
                for (BitSet bitSet : ins) {
                    result2.or(bitSet);
                }
                BitSet bitSet = result2;
                if (bitSet == null) {
                    2.$$$reportNull$$$0(3);
                }
                return bitSet;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 1, 2, 3 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "ins";
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "org/jetbrains/plugins/groovy/codeInspection/utils/ControlFlowUtils$2";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "org/jetbrains/plugins/groovy/codeInspection/utils/ControlFlowUtils$2";
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "join";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "join";
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: {
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 1, 2, 3 -> new IllegalStateException(string);
                };
            }
        };
        DfaInstance<BitSet> dfa = new DfaInstance<BitSet>(){

            @Override
            public BitSet fun(@NotNull BitSet bitSet, @NotNull Instruction instruction) {
                GrReferenceExpression ref2;
                if (bitSet == null) {
                    3.$$$reportNull$$$0(0);
                }
                if (instruction == null) {
                    3.$$$reportNull$$$0(1);
                }
                if (!(instruction instanceof ReadWriteVariableInstruction)) {
                    return bitSet;
                }
                if (!((ReadWriteVariableInstruction)instruction).isWrite()) {
                    return bitSet;
                }
                PsiElement element = instruction.getElement();
                if (element instanceof GrVariable && element != var) {
                    return bitSet;
                }
                if (element instanceof GrReferenceExpression && ((ref2 = (GrReferenceExpression)element).isQualified() || ref2.resolve() != var)) {
                    return bitSet;
                }
                if (!groovyFlow.getVarIndices()[((ReadWriteVariableInstruction)instruction).getDescriptor()].equals(VariableDescriptorFactory.createDescriptor(var))) {
                    return bitSet;
                }
                BitSet newResult = new BitSet(groovyFlow.getFlow().length);
                newResult.set(instruction.num());
                return newResult;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "bitSet";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "instruction";
                        break;
                    }
                }
                objectArray[1] = "org/jetbrains/plugins/groovy/codeInspection/utils/ControlFlowUtils$3";
                objectArray[2] = "fun";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        List list = ContainerUtil.map(new DFAEngine<BitSet>(groovyFlow.getFlow(), dfa, sem).performForceDFA(), set -> set == null ? neutral : set);
        if (list == null) {
            ControlFlowUtils.$$$reportNull$$$0(40);
        }
        return list;
    }

    @NotNull
    public static GroovyControlFlow getGroovyControlFlow(@NotNull GrControlFlowOwner owner) {
        if (owner == null) {
            ControlFlowUtils.$$$reportNull$$$0(41);
        }
        if (owner instanceof GroovyFileBaseImpl) {
            GroovyControlFlow groovyControlFlow = ((GroovyFileBaseImpl)owner).getGroovyControlFlow();
            if (groovyControlFlow == null) {
                ControlFlowUtils.$$$reportNull$$$0(42);
            }
            return groovyControlFlow;
        }
        if (owner instanceof GrExpressionLambdaBody) {
            GroovyControlFlow groovyControlFlow = ControlFlowBuilder.buildControlFlow(owner);
            if (groovyControlFlow == null) {
                ControlFlowUtils.$$$reportNull$$$0(43);
            }
            return groovyControlFlow;
        }
        if (owner instanceof GrBlockImpl) {
            GroovyControlFlow groovyControlFlow = ((GrBlockImpl)owner).getGroovyControlFlow();
            if (groovyControlFlow == null) {
                ControlFlowUtils.$$$reportNull$$$0(44);
            }
            return groovyControlFlow;
        }
        LOG.error("Unrecognized control flow owner");
        throw new IllegalStateException();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 29, 32, 34, 35, 40, 42, 43, 44 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "loopStatement";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "switchStatement";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tryStatement";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ifStatement";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "labeledStatement";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 15: 
            case 17: 
            case 19: 
            case 21: 
            case 23: 
            case 24: 
            case 26: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statement";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 22: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "branch";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "containingStatement";
                break;
            }
            case 16: 
            case 18: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "body";
                break;
            }
            case 25: 
            case 27: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "block";
                break;
            }
            case 29: 
            case 32: 
            case 34: 
            case 35: 
            case 40: 
            case 42: 
            case 43: 
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/groovy/codeInspection/utils/ControlFlowUtils";
                break;
            }
            case 31: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "flow";
                break;
            }
            case 36: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "flowOwner";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "owner";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/groovy/codeInspection/utils/ControlFlowUtils";
                break;
            }
            case 29: 
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "collectReturns";
                break;
            }
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "collectYields";
                break;
            }
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "getCaseSectionInstructions";
                break;
            }
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "inferWriteAccessMap";
                break;
            }
            case 42: 
            case 43: 
            case 44: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroovyControlFlow";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "whileStatementMayReturnNormally";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "forStatementMayReturnNormally";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "switchStatementMayReturnNormally";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "tryStatementMayReturnNormally";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "ifStatementMayReturnNormally";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "labeledStatementMayCompleteNormally";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "statementIsBreakTarget";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "statementContainsReturn";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "statementIsContinueTarget";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isInLoop";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "isInFinallyBlock";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "isInWhileStatementBody";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "isInForStatementBody";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "stripBraces";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "statementCompletesWithStatement";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "blockCompletesWithStatement";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "openBlockCompletesWithStatement";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "closureCompletesWithStatement";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "isLoop";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getContainingStatement";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getContainingStatementOrBlock";
                break;
            }
            case 25: 
            case 26: 
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "statementIsLastInBlock";
                break;
            }
            case 29: 
            case 32: 
            case 34: 
            case 35: 
            case 40: 
            case 42: 
            case 43: 
            case 44: {
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "collectReturns";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "collectYields";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "isImplicitReturnStatement";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "getAllReturnValues";
                break;
            }
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "isReturnValue";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "getGroovyControlFlow";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 29, 32, 34, 35, 40, 42, 43, 44 -> new IllegalStateException(string);
        };
    }

    private static final class BreakFinder
    extends GroovyRecursiveElementVisitor {
        private boolean m_found;
        private final GrStatement m_target;

        private BreakFinder(@NotNull GrStatement target) {
            if (target == null) {
                BreakFinder.$$$reportNull$$$0(0);
            }
            this.m_found = false;
            this.m_target = target;
        }

        public boolean breakFound() {
            return this.m_found;
        }

        @Override
        public void visitBreakStatement(@NotNull GrBreakStatement breakStatement) {
            if (breakStatement == null) {
                BreakFinder.$$$reportNull$$$0(1);
            }
            if (this.m_found) {
                return;
            }
            super.visitBreakStatement(breakStatement);
            GrStatement exitedStatement = breakStatement.findTargetStatement();
            if (exitedStatement == null) {
                return;
            }
            if (PsiTreeUtil.isAncestor((PsiElement)exitedStatement, (PsiElement)this.m_target, (boolean)false)) {
                this.m_found = true;
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "target";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "breakStatement";
                    break;
                }
            }
            objectArray2[1] = "org/jetbrains/plugins/groovy/codeInspection/utils/ControlFlowUtils$BreakFinder";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitBreakStatement";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class ReturnFinder
    extends GroovyRecursiveElementVisitor {
        private boolean m_found = false;

        private ReturnFinder() {
        }

        public boolean returnFound() {
            return this.m_found;
        }

        @Override
        public void visitReturnStatement(@NotNull GrReturnStatement returnStatement) {
            if (returnStatement == null) {
                ReturnFinder.$$$reportNull$$$0(0);
            }
            if (this.m_found) {
                return;
            }
            super.visitReturnStatement(returnStatement);
            this.m_found = true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "returnStatement", "org/jetbrains/plugins/groovy/codeInspection/utils/ControlFlowUtils$ReturnFinder", "visitReturnStatement"));
        }
    }

    private static final class ContinueFinder
    extends GroovyRecursiveElementVisitor {
        private boolean m_found;
        private final GrStatement m_target;

        private ContinueFinder(@NotNull GrStatement target) {
            if (target == null) {
                ContinueFinder.$$$reportNull$$$0(0);
            }
            this.m_found = false;
            this.m_target = target;
        }

        public boolean continueFound() {
            return this.m_found;
        }

        @Override
        public void visitContinueStatement(@NotNull GrContinueStatement continueStatement) {
            if (continueStatement == null) {
                ContinueFinder.$$$reportNull$$$0(1);
            }
            if (this.m_found) {
                return;
            }
            super.visitContinueStatement(continueStatement);
            GrStatement exitedStatement = continueStatement.findTargetStatement();
            if (exitedStatement == null) {
                return;
            }
            if (PsiTreeUtil.isAncestor((PsiElement)exitedStatement, (PsiElement)this.m_target, (boolean)false)) {
                this.m_found = true;
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "target";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "continueStatement";
                    break;
                }
            }
            objectArray2[1] = "org/jetbrains/plugins/groovy/codeInspection/utils/ControlFlowUtils$ContinueFinder";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitContinueStatement";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static final class ExitPointCollector
    implements ExitPointVisitor {
        @Nullable
        private final Class<? extends Instruction> instructionFilter;
        @Nullable
        private final Class<? extends GrStatement> statementFilter;
        @NotNull
        private final List<GrStatement> collector;

        private ExitPointCollector(@Nullable Class<? extends Instruction> instructionFilter, @Nullable Class<? extends GrStatement> statementFilter) {
            this.instructionFilter = instructionFilter;
            this.statementFilter = statementFilter;
            this.collector = new ArrayList<GrStatement>();
        }

        @Override
        public boolean visitExitPoint(Instruction instruction, @Nullable GrExpression returnValue) {
            PsiElement element = instruction.getElement();
            if (this.statementFilter != null && this.statementFilter.isInstance(element) || this.instructionFilter != null && this.instructionFilter.isInstance(instruction)) {
                this.collector.add((GrStatement)element);
            }
            return true;
        }

        @NotNull
        private List<GrStatement> getCollectedStatements() {
            List<GrStatement> list = this.collector;
            if (list == null) {
                ExitPointCollector.$$$reportNull$$$0(0);
            }
            return list;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/codeInspection/utils/ControlFlowUtils$ExitPointCollector", "getCollectedStatements"));
        }
    }

    public static interface ExitPointVisitor {
        public boolean visitExitPoint(Instruction var1, @Nullable GrExpression var2);
    }
}

