/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.control;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypes;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.GroovyBundle;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspection;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspectionVisitor;
import org.jetbrains.plugins.groovy.codeInspection.GrInspectionUtil;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrConditionalExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.impl.utils.BoolUtils;
import org.jetbrains.plugins.groovy.lang.psi.util.ErrorUtil;

public final class GroovyTrivialConditionalInspection
extends BaseInspection {
    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        return new UnnecessaryConditionalExpressionVisitor();
    }

    @Override
    public String buildErrorString(Object ... args) {
        return GroovyBundle.message("inspection.message.trivial.conditional.expression", new Object[0]);
    }

    private static String calculateReplacementExpression(GrConditionalExpression exp) {
        GrExpression thenExpression = exp.getThenBranch();
        GrExpression elseExpression = exp.getElseBranch();
        GrExpression condition = exp.getCondition();
        if (GroovyTrivialConditionalInspection.isFalse(thenExpression) && GroovyTrivialConditionalInspection.isTrue(elseExpression)) {
            return BoolUtils.getNegatedExpressionText(condition);
        }
        return condition.getText();
    }

    @Override
    public LocalQuickFix buildFix(@NotNull PsiElement location) {
        if (location == null) {
            GroovyTrivialConditionalInspection.$$$reportNull$$$0(0);
        }
        return new TrivialConditionalFix();
    }

    private static boolean isFalse(GrExpression expression) {
        @NonNls String text = expression.getText();
        return "false".equals(text);
    }

    private static boolean isTrue(GrExpression expression) {
        @NonNls String text = expression.getText();
        return "true".equals(text);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "location", "org/jetbrains/plugins/groovy/codeInspection/control/GroovyTrivialConditionalInspection", "buildFix"));
    }

    private static class UnnecessaryConditionalExpressionVisitor
    extends BaseInspectionVisitor {
        private UnnecessaryConditionalExpressionVisitor() {
        }

        @Override
        public void visitConditionalExpression(@NotNull GrConditionalExpression exp) {
            if (exp == null) {
                UnnecessaryConditionalExpressionVisitor.$$$reportNull$$$0(0);
            }
            super.visitConditionalExpression(exp);
            GrExpression condition = exp.getCondition();
            PsiType type2 = condition.getType();
            if (type2 == null || !PsiTypes.booleanType().isAssignableFrom(type2)) {
                return;
            }
            if (ErrorUtil.containsError(exp)) {
                return;
            }
            GrExpression thenExpression = exp.getThenBranch();
            if (thenExpression == null) {
                return;
            }
            GrExpression elseExpression = exp.getElseBranch();
            if (elseExpression == null) {
                return;
            }
            if (GroovyTrivialConditionalInspection.isFalse(thenExpression) && GroovyTrivialConditionalInspection.isTrue(elseExpression) || GroovyTrivialConditionalInspection.isTrue(thenExpression) && GroovyTrivialConditionalInspection.isFalse(elseExpression)) {
                this.registerError(exp);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "exp", "org/jetbrains/plugins/groovy/codeInspection/control/GroovyTrivialConditionalInspection$UnnecessaryConditionalExpressionVisitor", "visitConditionalExpression"));
        }
    }

    private static class TrivialConditionalFix
    extends PsiUpdateModCommandQuickFix {
        private TrivialConditionalFix() {
        }

        @NotNull
        public String getFamilyName() {
            String string = GroovyBundle.message("intention.family.name.simplify", new Object[0]);
            if (string == null) {
                TrivialConditionalFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
            if (project == null) {
                TrivialConditionalFix.$$$reportNull$$$0(1);
            }
            if (element == null) {
                TrivialConditionalFix.$$$reportNull$$$0(2);
            }
            if (updater == null) {
                TrivialConditionalFix.$$$reportNull$$$0(3);
            }
            GrConditionalExpression expression = (GrConditionalExpression)element;
            String newExpression = GroovyTrivialConditionalInspection.calculateReplacementExpression(expression);
            GrInspectionUtil.replaceExpression(expression, newExpression);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 3 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/plugins/groovy/codeInspection/control/GroovyTrivialConditionalInspection$TrivialConditionalFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/plugins/groovy/codeInspection/control/GroovyTrivialConditionalInspection$TrivialConditionalFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2, 3 -> new IllegalArgumentException(string);
            };
        }
    }
}

