/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.util.InspectionMessage;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspection;
import org.jetbrains.plugins.groovy.lang.psi.GroovyElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrMethodCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;

public abstract class BaseInspectionVisitor
extends GroovyElementVisitor {
    private BaseInspection inspection = null;
    private ProblemsHolder problemsHolder = null;
    private boolean onTheFly = false;

    void initialize(BaseInspection inspection, ProblemsHolder problemsHolder, boolean onTheFly) {
        this.inspection = inspection;
        this.problemsHolder = problemsHolder;
        this.onTheFly = onTheFly;
    }

    protected void registerStatementError(GrStatement statement, Object ... args) {
        PsiElement statementToken = statement.getFirstChild();
        this.registerError(statementToken, args);
    }

    protected void registerError(PsiElement location) {
        if (location == null) {
            return;
        }
        LocalQuickFix[] fix = this.createFixes(location);
        String description = StringUtil.notNullize((String)this.inspection.buildErrorString(location));
        this.registerError(location, description, fix, ProblemHighlightType.GENERIC_ERROR_OR_WARNING);
    }

    protected void registerMethodError(GrMethod method, Object ... args) {
        if (method == null) {
            return;
        }
        LocalQuickFix[] fixes = this.createFixes(method);
        String description = StringUtil.notNullize((String)this.inspection.buildErrorString(args));
        this.registerError(method.getNameIdentifierGroovy(), description, fixes, ProblemHighlightType.GENERIC_ERROR_OR_WARNING);
    }

    protected void registerRangeError(@NotNull PsiElement element, @NotNull TextRange range, Object ... args) {
        if (element == null) {
            BaseInspectionVisitor.$$$reportNull$$$0(0);
        }
        if (range == null) {
            BaseInspectionVisitor.$$$reportNull$$$0(1);
        }
        String description = StringUtil.notNullize((String)this.inspection.buildErrorString(args));
        this.problemsHolder.registerProblem(element, range, description, this.createFixes(element));
    }

    protected void registerVariableError(GrVariable variable, Object ... args) {
        if (variable == null) {
            return;
        }
        LocalQuickFix[] fix = this.createFixes(variable);
        String description = StringUtil.notNullize((String)this.inspection.buildErrorString(args));
        this.registerError(variable.getNameIdentifierGroovy(), description, fix, ProblemHighlightType.GENERIC_ERROR_OR_WARNING);
    }

    protected void registerMethodCallError(GrMethodCall method, Object ... args) {
        if (method == null) {
            return;
        }
        LocalQuickFix[] fixes = this.createFixes(method);
        String description = StringUtil.notNullize((String)this.inspection.buildErrorString(args));
        GrExpression invoked = method.getInvokedExpression();
        PsiElement nameElement = ((GrReferenceExpression)invoked).getReferenceNameElement();
        assert (nameElement != null);
        this.registerError(nameElement, description, fixes, ProblemHighlightType.GENERIC_ERROR_OR_WARNING);
    }

    protected void registerError(@NotNull PsiElement location, @InspectionMessage @NotNull String description, @NotNull LocalQuickFix @Nullable [] fixes, ProblemHighlightType highlightType) {
        if (location == null) {
            BaseInspectionVisitor.$$$reportNull$$$0(2);
        }
        if (description == null) {
            BaseInspectionVisitor.$$$reportNull$$$0(3);
        }
        this.problemsHolder.registerProblem(location, description, highlightType, fixes);
    }

    protected void registerError(@NotNull PsiElement location, Object ... args) {
        if (location == null) {
            BaseInspectionVisitor.$$$reportNull$$$0(4);
        }
        this.registerError(location, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, args);
    }

    protected void registerError(@NotNull PsiElement location, ProblemHighlightType highlightType, Object ... args) {
        if (location == null) {
            BaseInspectionVisitor.$$$reportNull$$$0(5);
        }
        LocalQuickFix[] fix = this.createFixes(location);
        String description = StringUtil.notNullize((String)this.inspection.buildErrorString(args));
        this.registerError(location, description, fix, highlightType);
    }

    private @NotNull LocalQuickFix @Nullable [] createFixes(@NotNull PsiElement location) {
        if (location == null) {
            BaseInspectionVisitor.$$$reportNull$$$0(6);
        }
        if (!this.onTheFly && this.inspection.buildQuickFixesOnlyForOnTheFlyErrors()) {
            return null;
        }
        LocalQuickFix fix = this.inspection.buildFix(location);
        if (fix == null) {
            return null;
        }
        return new LocalQuickFix[]{fix};
    }

    public int getErrorCount() {
        return this.problemsHolder.getResultCount();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "location";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "description";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/groovy/codeInspection/BaseInspectionVisitor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "registerRangeError";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "registerError";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "createFixes";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

