/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.searchEverywhereMl.typos.models;

import ai.grazie.spell.lists.WordList;
import ai.grazie.spell.suggestion.ranker.SuggestionRanker;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001:\u0001\u0010B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u001c\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJ\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\n\u001a\u00020\u000bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/intellij/searchEverywhereMl/typos/models/TypoSuggestionProvider;", "", "dictionary", "Lai/grazie/spell/lists/WordList;", "ranker", "Lai/grazie/spell/suggestion/ranker/SuggestionRanker;", "(Lai/grazie/spell/lists/WordList;Lai/grazie/spell/suggestion/ranker/SuggestionRanker;)V", "getSuggestions", "", "Lcom/intellij/searchEverywhereMl/typos/models/TypoSuggestionProvider$ScoredSuggestion;", "word", "", "maxSuggestions", "", "isMisspelled", "", "ScoredSuggestion", "intellij.searchEverywhereMl.typos"})
@SourceDebugExtension(value={"SMAP\nTypoSuggestionProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TypoSuggestionProvider.kt\ncom/intellij/searchEverywhereMl/typos/models/TypoSuggestionProvider\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,26:1\n125#2:27\n152#2,3:28\n*S KotlinDebug\n*F\n+ 1 TypoSuggestionProvider.kt\ncom/intellij/searchEverywhereMl/typos/models/TypoSuggestionProvider\n*L\n14#1:27\n14#1:28,3\n*E\n"})
public final class TypoSuggestionProvider {
    @NotNull
    private final WordList dictionary;
    @NotNull
    private final SuggestionRanker ranker;

    public TypoSuggestionProvider(@NotNull WordList dictionary, @NotNull SuggestionRanker ranker) {
        Intrinsics.checkNotNullParameter((Object)dictionary, (String)"dictionary");
        Intrinsics.checkNotNullParameter((Object)ranker, (String)"ranker");
        this.dictionary = dictionary;
        this.ranker = ranker;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<ScoredSuggestion> getSuggestions(@NotNull String word, int maxSuggestions) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)word, (String)"word");
        if (!this.isMisspelled(word)) {
            return CollectionsKt.emptyList();
        }
        LinkedHashSet suggestions = this.dictionary.suggest(word);
        Map map = this.ranker.score(word, suggestions);
        boolean $i$f$map = false;
        void var6_6 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            void it;
            Map.Entry item$iv$iv;
            Map.Entry entry = item$iv$iv = iterator.next();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new ScoredSuggestion((CharSequence)it.getKey(), ((Number)it.getValue()).doubleValue()));
        }
        return CollectionsKt.take((Iterable)CollectionsKt.sortedDescending((Iterable)((List)destination$iv$iv)), (int)maxSuggestions);
    }

    public final boolean isMisspelled(@NotNull String word) {
        Intrinsics.checkNotNullParameter((Object)word, (String)"word");
        return !WordList.contains$default((WordList)this.dictionary, (String)word, (boolean)false, (int)2, null);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0000\n\u0002\u0010\r\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0011\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0000H\u0096\u0002J\t\u0010\u000e\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u0010\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u0011\u001a\u00020\u00122\b\u0010\r\u001a\u0004\u0018\u00010\u0013H\u00d6\u0003J\t\u0010\u0014\u001a\u00020\fH\u00d6\u0001J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0017"}, d2={"Lcom/intellij/searchEverywhereMl/typos/models/TypoSuggestionProvider$ScoredSuggestion;", "", "suggestion", "", "score", "", "(Ljava/lang/CharSequence;D)V", "getScore", "()D", "getSuggestion", "()Ljava/lang/CharSequence;", "compareTo", "", "other", "component1", "component2", "copy", "equals", "", "", "hashCode", "toString", "", "intellij.searchEverywhereMl.typos"})
    public static final class ScoredSuggestion
    implements Comparable<ScoredSuggestion> {
        @NotNull
        private final CharSequence suggestion;
        private final double score;

        public ScoredSuggestion(@NotNull CharSequence suggestion, double score) {
            Intrinsics.checkNotNullParameter((Object)suggestion, (String)"suggestion");
            this.suggestion = suggestion;
            this.score = score;
        }

        @NotNull
        public final CharSequence getSuggestion() {
            return this.suggestion;
        }

        public final double getScore() {
            return this.score;
        }

        @Override
        public int compareTo(@NotNull ScoredSuggestion other) {
            Intrinsics.checkNotNullParameter((Object)other, (String)"other");
            return Double.compare(this.score, other.score);
        }

        @NotNull
        public final CharSequence component1() {
            return this.suggestion;
        }

        public final double component2() {
            return this.score;
        }

        @NotNull
        public final ScoredSuggestion copy(@NotNull CharSequence suggestion, double score) {
            Intrinsics.checkNotNullParameter((Object)suggestion, (String)"suggestion");
            return new ScoredSuggestion(suggestion, score);
        }

        public static /* synthetic */ ScoredSuggestion copy$default(ScoredSuggestion scoredSuggestion, CharSequence charSequence, double d, int n, Object object) {
            if ((n & 1) != 0) {
                charSequence = scoredSuggestion.suggestion;
            }
            if ((n & 2) != 0) {
                d = scoredSuggestion.score;
            }
            return scoredSuggestion.copy(charSequence, d);
        }

        @NotNull
        public String toString() {
            return "ScoredSuggestion(suggestion=" + this.suggestion + ", score=" + this.score + ")";
        }

        public int hashCode() {
            int result = this.suggestion.hashCode();
            result = result * 31 + Double.hashCode(this.score);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ScoredSuggestion)) {
                return false;
            }
            ScoredSuggestion scoredSuggestion = (ScoredSuggestion)other;
            if (!Intrinsics.areEqual((Object)this.suggestion, (Object)scoredSuggestion.suggestion)) {
                return false;
            }
            return Double.compare(this.score, scoredSuggestion.score) == 0;
        }
    }
}

