/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.util;

import com.intellij.execution.wsl.WslPath;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.execution.ExternalSystemTaskExecutionSettings;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskId;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskNotificationListener;
import com.intellij.openapi.externalSystem.service.execution.ProgressExecutionMode;
import com.intellij.openapi.externalSystem.util.ExternalSystemUtil;
import com.intellij.openapi.externalSystem.util.task.TaskExecutionSpec;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.NioPathUtil;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.util.GradleVersion;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.gradle.service.execution.GradleInitScriptUtil;
import org.jetbrains.plugins.gradle.service.task.GradleTaskManager;
import org.jetbrains.plugins.gradle.service.task.LazyVersionSpecificInitScript;
import org.jetbrains.plugins.gradle.settings.GradleSettings;
import org.jetbrains.plugins.gradle.util.GradleConstants;
import org.jetbrains.plugins.gradle.util.GradleDependencySourceDownloader;
import org.jetbrains.plugins.gradle.util.GradleDependencySourceDownloaderErrorHandler;
import org.jetbrains.plugins.gradle.util.GradleLog;
import org.jetbrains.plugins.gradle.util.JarUtilKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J3\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u000e\u001a\u00020\u000f2\u000b\u0010\u0010\u001a\u00070\u0007\u00a2\u0006\u0002\b\u00112\u0006\u0010\u0012\u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020\u0007H\u0007J(\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0012\u001a\u00020\u00072\u0006\u0010\u0016\u001a\u00020\u00072\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0013\u001a\u00020\u0007H\u0002J\f\u0010\u0019\u001a\u00020\u0007*\u00020\u0007H\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u0013\u0010\b\u001a\u00070\t\u00a2\u0006\u0002\b\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/plugins/gradle/util/GradleDependencySourceDownloader;", "", "()V", "GRADLE_5_6", "Lorg/gradle/util/GradleVersion;", "kotlin.jvm.PlatformType", "INIT_SCRIPT_FILE_PREFIX", "", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "downloadSources", "Ljava/util/concurrent/CompletableFuture;", "Ljava/io/File;", "project", "Lcom/intellij/openapi/project/Project;", "executionName", "Lorg/jetbrains/annotations/Nls;", "sourceArtifactNotation", "externalProjectPath", "prepareUserData", "Lcom/intellij/openapi/util/UserDataHolderBase;", "taskName", "sourcesLocationFilePath", "Ljava/nio/file/Path;", "asSystemDependentGradleProjectPath", "intellij.gradle.java"})
public final class GradleDependencySourceDownloader {
    @NotNull
    public static final GradleDependencySourceDownloader INSTANCE = new GradleDependencySourceDownloader();
    @NotNull
    private static final Logger LOG;
    private static final GradleVersion GRADLE_5_6;
    @NotNull
    private static final String INIT_SCRIPT_FILE_PREFIX = "ijDownloadSources";

    private GradleDependencySourceDownloader() {
    }

    @JvmStatic
    @NotNull
    public static final CompletableFuture<File> downloadSources(@NotNull Project project, @NotNull String executionName, @NotNull String sourceArtifactNotation, @NotNull String externalProjectPath) {
        ExternalSystemTaskExecutionSettings externalSystemTaskExecutionSettings;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)executionName, (String)"executionName");
        Intrinsics.checkNotNullParameter((Object)sourceArtifactNotation, (String)"sourceArtifactNotation");
        Intrinsics.checkNotNullParameter((Object)externalProjectPath, (String)"externalProjectPath");
        File sourcesLocationFile = null;
        try {
            sourcesLocationFile = new File(FileUtil.createTempDirectory((String)"sources", (String)"loc"), "path.tmp");
            Runtime.getRuntime().addShutdownHook(new Thread(() -> GradleDependencySourceDownloader.downloadSources$lambda$0(sourcesLocationFile), "GradleAttachSourcesProvider cleanup"));
        }
        catch (IOException e) {
            LOG.warn((Throwable)e);
            CompletableFuture<File> completableFuture = CompletableFuture.failedFuture(e);
            Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"failedFuture(...)");
            return completableFuture;
        }
        String string = UUID.randomUUID().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        String string2 = string;
        int n = 0;
        int n2 = 12;
        String string3 = string2.substring(n, n2);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
        String taskName = INIT_SCRIPT_FILE_PREFIX + string3;
        ExternalSystemTaskExecutionSettings it = externalSystemTaskExecutionSettings = new ExternalSystemTaskExecutionSettings();
        boolean bl = false;
        it.setExecutionName(executionName);
        it.setExternalProjectPath(externalProjectPath);
        it.setTaskNames(CollectionsKt.listOf((Object)taskName));
        it.setVmOptions(GradleSettings.getInstance((Project)project).getGradleVmOptions());
        it.setExternalSystemIdString(GradleConstants.SYSTEM_ID.getId());
        ExternalSystemTaskExecutionSettings settings = externalSystemTaskExecutionSettings;
        Path path = sourcesLocationFile.toPath();
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"toPath(...)");
        UserDataHolderBase userData = INSTANCE.prepareUserData(sourceArtifactNotation, taskName, path, externalProjectPath);
        CompletableFuture<File> resultWrapper = new CompletableFuture<File>();
        ExternalSystemTaskNotificationListener listener2 = new ExternalSystemTaskNotificationListener(sourcesLocationFile, resultWrapper, project, externalProjectPath, sourceArtifactNotation){
            final /* synthetic */ File $sourcesLocationFile;
            final /* synthetic */ CompletableFuture<File> $resultWrapper;
            final /* synthetic */ Project $project;
            final /* synthetic */ String $externalProjectPath;
            final /* synthetic */ String $sourceArtifactNotation;
            {
                this.$sourcesLocationFile = $sourcesLocationFile;
                this.$resultWrapper = $resultWrapper;
                this.$project = $project;
                this.$externalProjectPath = $externalProjectPath;
                this.$sourceArtifactNotation = $sourceArtifactNotation;
            }

            public void onSuccess(@NotNull ExternalSystemTaskId id) {
                Intrinsics.checkNotNullParameter((Object)id, (String)"id");
                File sourceJar = null;
                try {
                    Path downloadedArtifactPath = Path.of(FileUtil.loadFile((File)this.$sourcesLocationFile), new String[0]);
                    Intrinsics.checkNotNull((Object)downloadedArtifactPath);
                    if (!JarUtilKt.isValidJar(downloadedArtifactPath)) {
                        GradleLog.LOG.warn("Incorrect file header: " + downloadedArtifactPath + ". Unable to process downloaded file as a JAR file");
                        FileUtil.delete((File)this.$sourcesLocationFile);
                        this.$resultWrapper.completeExceptionally(new IllegalStateException("Incorrect file header: " + downloadedArtifactPath + "."));
                        return;
                    }
                    File file = downloadedArtifactPath.toFile();
                    Intrinsics.checkNotNullExpressionValue((Object)file, (String)"toFile(...)");
                    sourceJar = file;
                    FileUtil.delete((File)this.$sourcesLocationFile);
                }
                catch (IOException e) {
                    GradleLog.LOG.warn((Throwable)e);
                    this.$resultWrapper.completeExceptionally(e);
                    return;
                }
                this.$resultWrapper.complete(sourceJar);
            }

            public void onFailure(@NotNull ExternalSystemTaskId id, @NotNull Exception exception) {
                Intrinsics.checkNotNullParameter((Object)id, (String)"id");
                Intrinsics.checkNotNullParameter((Object)exception, (String)"exception");
                this.$resultWrapper.completeExceptionally(new IllegalStateException("Unable to download sources."));
                GradleDependencySourceDownloaderErrorHandler.INSTANCE.handle(this.$project, this.$externalProjectPath, this.$sourceArtifactNotation, exception);
            }
        };
        ProjectSystemId projectSystemId = GradleConstants.SYSTEM_ID;
        Intrinsics.checkNotNullExpressionValue((Object)projectSystemId, (String)"SYSTEM_ID");
        TaskExecutionSpec spec = TaskExecutionSpec.Companion.create(project, projectSystemId, "Run", settings).withProgressExecutionMode(ProgressExecutionMode.IN_BACKGROUND_ASYNC).withListener(listener2).withUserData(userData).withActivateToolWindowBeforeRun(false).withActivateToolWindowOnFailure(false).build();
        ExternalSystemUtil.runTask((TaskExecutionSpec)spec);
        return resultWrapper;
    }

    private final UserDataHolderBase prepareUserData(String sourceArtifactNotation, String taskName, Path sourcesLocationFilePath, String externalProjectPath) {
        UserDataHolderBase userDataHolderBase;
        String projectPath = this.asSystemDependentGradleProjectPath(externalProjectPath);
        LazyVersionSpecificInitScript legacyInitScript2 = new LazyVersionSpecificInitScript(() -> GradleDependencySourceDownloader.prepareUserData$lambda$2(sourceArtifactNotation, taskName, sourcesLocationFilePath, projectPath), INIT_SCRIPT_FILE_PREFIX, (Function1)prepareUserData.legacyInitScript.2.INSTANCE);
        LazyVersionSpecificInitScript initScript2 = new LazyVersionSpecificInitScript(() -> GradleDependencySourceDownloader.prepareUserData$lambda$3(sourceArtifactNotation, taskName, sourcesLocationFilePath, projectPath), INIT_SCRIPT_FILE_PREFIX, (Function1)prepareUserData.initScript.2.INSTANCE);
        UserDataHolderBase $this$prepareUserData_u24lambda_u244 = userDataHolderBase = new UserDataHolderBase();
        boolean bl = false;
        Object[] objectArray = new LazyVersionSpecificInitScript[]{legacyInitScript2, initScript2};
        $this$prepareUserData_u24lambda_u244.putUserData(GradleTaskManager.VERSION_SPECIFIC_SCRIPTS_KEY, (Object)CollectionsKt.listOf((Object[])objectArray));
        return userDataHolderBase;
    }

    private final String asSystemDependentGradleProjectPath(String $this$asSystemDependentGradleProjectPath) {
        Object pathToNormalize;
        Object object;
        WslPath wslPath = WslPath.Companion.parseWindowsUncPath($this$asSystemDependentGradleProjectPath);
        Object object2 = wslPath;
        if (object2 == null || (object2 = object2.getLinuxPath()) == null) {
            object2 = $this$asSystemDependentGradleProjectPath;
        }
        if ((object = NioPathUtil.toNioPathOrNull((String)(pathToNormalize = object2))) == null || (object = NioPathUtil.toCanonicalPath((Path)object)) == null) {
            throw new IllegalStateException("Unable to convert " + $this$asSystemDependentGradleProjectPath + " to canonical path");
        }
        return object;
    }

    private static final void downloadSources$lambda$0(File $sourcesLocationFile) {
        Intrinsics.checkNotNullParameter((Object)$sourcesLocationFile, (String)"$sourcesLocationFile");
        FileUtil.delete((File)$sourcesLocationFile);
    }

    private static final String prepareUserData$lambda$2(String $sourceArtifactNotation, String $taskName, Path $sourcesLocationFilePath, String $projectPath) {
        Intrinsics.checkNotNullParameter((Object)$sourceArtifactNotation, (String)"$sourceArtifactNotation");
        Intrinsics.checkNotNullParameter((Object)$taskName, (String)"$taskName");
        Intrinsics.checkNotNullParameter((Object)$sourcesLocationFilePath, (String)"$sourcesLocationFilePath");
        Intrinsics.checkNotNullParameter((Object)$projectPath, (String)"$projectPath");
        return GradleInitScriptUtil.loadLegacyDownloadSourcesInitScript((String)$sourceArtifactNotation, (String)$taskName, (Path)$sourcesLocationFilePath, (String)$projectPath);
    }

    private static final String prepareUserData$lambda$3(String $sourceArtifactNotation, String $taskName, Path $sourcesLocationFilePath, String $projectPath) {
        Intrinsics.checkNotNullParameter((Object)$sourceArtifactNotation, (String)"$sourceArtifactNotation");
        Intrinsics.checkNotNullParameter((Object)$taskName, (String)"$taskName");
        Intrinsics.checkNotNullParameter((Object)$sourcesLocationFilePath, (String)"$sourcesLocationFilePath");
        Intrinsics.checkNotNullParameter((Object)$projectPath, (String)"$projectPath");
        return GradleInitScriptUtil.loadDownloadSourcesInitScript((String)$sourceArtifactNotation, (String)$taskName, (Path)$sourcesLocationFilePath, (String)$projectPath);
    }

    public static final /* synthetic */ GradleVersion access$getGRADLE_5_6$p() {
        return GRADLE_5_6;
    }

    static {
        Logger logger = Logger.getInstance(GradleDependencySourceDownloader.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
        GRADLE_5_6 = GradleVersion.version((String)"5.6");
    }
}

