/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.service.resolve;

import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.service.resolve.GradleVersionCatalogHandler;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u00004\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\u001a\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u0007\u001a\u0018\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0005\u001a\u001a\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u0006\u001a\u00020\u0007\"\u0014\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"EP_NAME", "Lcom/intellij/openapi/extensions/ExtensionPointName;", "Lorg/jetbrains/plugins/gradle/service/resolve/GradleVersionCatalogHandler;", "getGradleStaticallyHandledExtensions", "", "", "project", "Lcom/intellij/openapi/project/Project;", "getVersionCatalogAccessor", "Lcom/intellij/psi/PsiClass;", "context", "Lcom/intellij/psi/PsiElement;", "name", "getVersionCatalogFiles", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "intellij.gradle.java"})
public final class GradleVersionCatalogHandlerKt {
    @NotNull
    private static final ExtensionPointName<GradleVersionCatalogHandler> EP_NAME = ExtensionPointName.Companion.create("org.jetbrains.plugins.gradle.externallyHandledExtensions");

    @NotNull
    public static final Map<String, VirtualFile> getVersionCatalogFiles(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Map container = new LinkedHashMap();
        for (GradleVersionCatalogHandler extension : EP_NAME.getExtensionList()) {
            container.putAll(extension.getVersionCatalogFiles(project));
        }
        return container;
    }

    @NotNull
    public static final Set<String> getGradleStaticallyHandledExtensions(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Set container = new LinkedHashSet();
        for (GradleVersionCatalogHandler extension : EP_NAME.getExtensionList()) {
            container.addAll((Collection)extension.getExternallyHandledExtension(project));
        }
        return container;
    }

    @Nullable
    public static final PsiClass getVersionCatalogAccessor(@NotNull PsiElement context, @NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        for (GradleVersionCatalogHandler extension : EP_NAME.getExtensionList()) {
            PsiClass psiClass = extension.getAccessorClass(context, name);
            if (psiClass == null) continue;
            return psiClass;
        }
        return null;
    }
}

