/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.service.resolve;

import com.intellij.find.usages.api.PsiUsage;
import com.intellij.find.usages.api.SearchTarget;
import com.intellij.find.usages.api.Usage;
import com.intellij.find.usages.api.UsageSearchParameters;
import com.intellij.find.usages.api.UsageSearcher;
import com.intellij.model.psi.PsiSymbolReference;
import com.intellij.openapi.project.Project;
import com.intellij.util.Query;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.service.resolve.GradleProjectSymbol;
import org.jetbrains.plugins.gradle.service.resolve.ProjectReferenceSearchKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\f\u0012\u0006\b\u0001\u0012\u00020\u0005\u0018\u00010\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\b"}, d2={"Lorg/jetbrains/plugins/gradle/service/resolve/GradleProjectUsageSearcher;", "Lcom/intellij/find/usages/api/UsageSearcher;", "()V", "collectSearchRequest", "Lcom/intellij/util/Query;", "Lcom/intellij/find/usages/api/Usage;", "parameters", "Lcom/intellij/find/usages/api/UsageSearchParameters;", "intellij.gradle.java"})
public final class GradleProjectUsageSearcher
implements UsageSearcher {
    @Nullable
    public Query<? extends Usage> collectSearchRequest(@NotNull UsageSearchParameters parameters) {
        Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
        SearchTarget searchTarget = parameters.getTarget();
        GradleProjectSymbol gradleProjectSymbol = searchTarget instanceof GradleProjectSymbol ? (GradleProjectSymbol)searchTarget : null;
        if (gradleProjectSymbol == null) {
            return null;
        }
        GradleProjectSymbol projectSymbol = gradleProjectSymbol;
        Project project = parameters.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        return ProjectReferenceSearchKt.searchGradleProjectReferences(project, projectSymbol, parameters.getSearchScope()).mapping(arg_0 -> GradleProjectUsageSearcher.collectSearchRequest$lambda$0((Function1)new Function1<PsiSymbolReference, PsiUsage>((Object)PsiUsage.Companion){

            @NotNull
            public final PsiUsage invoke(@NotNull PsiSymbolReference p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return ((PsiUsage.Companion)this.receiver).textUsage(p0);
            }
        }, arg_0));
    }

    private static final PsiUsage collectSearchRequest$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (PsiUsage)$tmp0.invoke(p0);
    }
}

