/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.service.resolve;

import com.intellij.lang.jvm.JvmParameter;
import com.intellij.lang.jvm.types.JvmType;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiWildcardType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.service.resolve.GradleMethodContextContributor;
import org.jetbrains.plugins.gradle.service.resolve.GradleProjectAwareType;
import org.jetbrains.plugins.gradle.service.resolve.transformation.GradleActionToClosureMemberContributorKt;
import org.jetbrains.plugins.groovy.intentions.style.inference.InferenceProcessUtilKt;
import org.jetbrains.plugins.groovy.lang.psi.api.GrFunctionalExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyMethodResult;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyResolveResult;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;
import org.jetbrains.plugins.groovy.lang.resolve.api.Argument;
import org.jetbrains.plugins.groovy.lang.resolve.api.ArgumentMapping;
import org.jetbrains.plugins.groovy.lang.resolve.api.ExpressionArgument;
import org.jetbrains.plugins.groovy.lang.resolve.api.GroovyMethodCandidate;
import org.jetbrains.plugins.groovy.lang.resolve.delegatesTo.DelegatesToInfo;
import org.jetbrains.plugins.groovy.lang.resolve.delegatesTo.GrDelegatesToProvider;
import org.jetbrains.plugins.groovy.lang.resolve.delegatesTo.GrDelegatesToUtilKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J*\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u001a\u0010\r\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u001a\u0010\u0010\u001a\u0004\u0018\u00010\u00042\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0012\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0012\u0010\u0013\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J \u0010\u0016\u001a\u00020\u00042\u0006\u0010\u0017\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u00182\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0012\u0010\u0019\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0014\u001a\u00020\u0018H\u0002J \u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u001c\u001a\u00020\u0004H\u0002\u00a8\u0006\u001d"}, d2={"Lorg/jetbrains/plugins/gradle/service/resolve/GradleDelegatesToProvider;", "Lorg/jetbrains/plugins/groovy/lang/resolve/delegatesTo/GrDelegatesToProvider;", "()V", "getDelegateFromAction", "Lcom/intellij/psi/PsiType;", "clazz", "Lcom/intellij/psi/PsiClass;", "type", "Lcom/intellij/psi/PsiClassType;", "psiMethod", "Lcom/intellij/psi/PsiMethod;", "substitutor", "Lcom/intellij/psi/PsiSubstitutor;", "getDelegateFromClosure", "resolvedCall", "Lorg/jetbrains/plugins/groovy/lang/psi/api/GroovyMethodResult;", "getDelegateFromMethodSignature", "getDelegateIfGeneratedClosure", "Lorg/jetbrains/plugins/groovy/lang/resolve/delegatesTo/DelegatesToInfo;", "getDelegatesToInfo", "expression", "Lorg/jetbrains/plugins/groovy/lang/psi/api/GrFunctionalExpression;", "maybeWrapWithProjectAwareType", "delegate", "Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/blocks/GrClosableBlock;", "processBeforeContributors", "typeParameterIsNotResolved", "", "resolvedType", "intellij.gradle.java"})
@SourceDebugExtension(value={"SMAP\nGradleDelegatesToProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GradleDelegatesToProvider.kt\norg/jetbrains/plugins/gradle/service/resolve/GradleDelegatesToProvider\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 KtUtils.kt\ncom/intellij/util/KotlinUtils\n*L\n1#1,162:1\n11065#2:163\n11400#2,3:164\n14#3:167\n*S KotlinDebug\n*F\n+ 1 GradleDelegatesToProvider.kt\norg/jetbrains/plugins/gradle/service/resolve/GradleDelegatesToProvider\n*L\n129#1:163\n129#1:164,3\n157#1:167\n*E\n"})
public final class GradleDelegatesToProvider
implements GrDelegatesToProvider {
    @Nullable
    public DelegatesToInfo getDelegatesToInfo(@NotNull GrFunctionalExpression expression) {
        DelegatesToInfo delegatesToInfo;
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        if (!(expression instanceof GrClosableBlock)) {
            return null;
        }
        PsiFile file = ((GrClosableBlock)expression).getContainingFile();
        if (file == null || !FileUtilRt.extensionEquals((String)file.getName(), (String)"gradle")) {
            return null;
        }
        DelegatesToInfo delegatesToInfo2 = delegatesToInfo = this.processBeforeContributors((GrClosableBlock)expression);
        if (delegatesToInfo2 != null) {
            return delegatesToInfo2;
        }
        for (GradleMethodContextContributor contributor : (GradleMethodContextContributor[])GradleMethodContextContributor.EP_NAME.getExtensions()) {
            delegatesToInfo = contributor.getDelegatesToInfo((GrClosableBlock)expression);
            if (delegatesToInfo == null) continue;
            return delegatesToInfo;
        }
        return null;
    }

    private final DelegatesToInfo processBeforeContributors(GrClosableBlock expression) {
        DelegatesToInfo generatedClosureInfo;
        GrCall grCall = GrDelegatesToUtilKt.getContainingCall((GrFunctionalExpression)((GrFunctionalExpression)expression));
        if (grCall == null) {
            return null;
        }
        GrCall call = grCall;
        GroovyResolveResult groovyResolveResult = call.advancedResolve();
        GroovyMethodResult groovyMethodResult = groovyResolveResult instanceof GroovyMethodResult ? (GroovyMethodResult)groovyResolveResult : null;
        if (groovyMethodResult == null) {
            return null;
        }
        GroovyMethodResult resolvedCall = groovyMethodResult;
        DelegatesToInfo delegatesToInfo = generatedClosureInfo = this.getDelegateIfGeneratedClosure(resolvedCall);
        if (delegatesToInfo != null) {
            return delegatesToInfo;
        }
        GroovyMethodCandidate groovyMethodCandidate = resolvedCall.getCandidate();
        if (groovyMethodCandidate == null) {
            return null;
        }
        GroovyMethodCandidate candidate = groovyMethodCandidate;
        ArgumentMapping argumentMapping = candidate.getArgumentMapping();
        if (argumentMapping == null) {
            return null;
        }
        ArgumentMapping argumentMapping2 = argumentMapping;
        PsiType psiType = argumentMapping2.expectedType((Argument)new ExpressionArgument((GrExpression)expression));
        PsiClassType psiClassType = psiType instanceof PsiClassType ? (PsiClassType)psiType : null;
        if (psiClassType == null) {
            return null;
        }
        PsiClassType type = psiClassType;
        PsiClass psiClass = type.resolve();
        if (psiClass == null) {
            return null;
        }
        PsiClass clazz = psiClass;
        PsiMethod psiMethod = candidate.getMethod();
        PsiSubstitutor psiSubstitutor = resolvedCall.getSubstitutor();
        Intrinsics.checkNotNullExpressionValue((Object)psiSubstitutor, (String)"getSubstitutor(...)");
        PsiType psiType2 = this.getDelegateFromAction(clazz, type, psiMethod, psiSubstitutor);
        if (psiType2 == null && (psiType2 = this.getDelegateFromClosure(clazz, resolvedCall)) == null) {
            return null;
        }
        PsiType delegate = psiType2;
        PsiType optionallyWrapped = this.maybeWrapWithProjectAwareType(delegate, expression, resolvedCall);
        return new DelegatesToInfo(optionallyWrapped, 1);
    }

    private final PsiType maybeWrapWithProjectAwareType(PsiType delegate, GrClosableBlock expression, GroovyMethodResult resolvedCall) {
        PsiType projectAwareReceiver;
        GroovyMethodCandidate groovyMethodCandidate = resolvedCall.getCandidate();
        Object object = projectAwareReceiver = groovyMethodCandidate != null ? groovyMethodCandidate.getReceiverType() : null;
        if (!(projectAwareReceiver instanceof GradleProjectAwareType)) {
            return delegate;
        }
        String string = delegate.getCanonicalText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getCanonicalText(...)");
        String fqClassName = string;
        if (!Intrinsics.areEqual((Object)fqClassName, (Object)"org.gradle.api.artifacts.dsl.ArtifactHandler") && !Intrinsics.areEqual((Object)fqClassName, (Object)"org.gradle.api.Project")) {
            return delegate;
        }
        PsiClassType psiClassType = delegate instanceof PsiClassType ? (PsiClassType)delegate : null;
        if (psiClassType == null) {
            PsiClassType psiClassType2 = TypesUtil.createType((String)fqClassName, (PsiElement)((PsiElement)expression));
            psiClassType = psiClassType2;
            Intrinsics.checkNotNullExpressionValue((Object)psiClassType2, (String)"createType(...)");
        }
        PsiClassType psiClassType3 = psiClassType;
        GradleProjectAwareType result = ((GradleProjectAwareType)projectAwareReceiver).setType(psiClassType3);
        return (PsiType)result;
    }

    private final DelegatesToInfo getDelegateIfGeneratedClosure(GroovyMethodResult resolvedCall) {
        PsiType bridgeDelegate = (PsiType)resolvedCall.getElement().getUserData(GradleActionToClosureMemberContributorKt.getGRADLE_GENERATED_CLOSURE_OVERLOAD_DELEGATE_KEY());
        if (bridgeDelegate == null) {
            return null;
        }
        PsiType actualBridgeDelegate = resolvedCall.getSubstitutor().substitute(bridgeDelegate);
        return new DelegatesToInfo(actualBridgeDelegate, 1);
    }

    private final PsiType getDelegateFromAction(PsiClass clazz, PsiClassType type, PsiMethod psiMethod, PsiSubstitutor substitutor) {
        if (!Intrinsics.areEqual((Object)clazz.getQualifiedName(), (Object)"org.gradle.api.Action") && !clazz.hasAnnotation("org.gradle.api.HasImplicitReceiver")) {
            return null;
        }
        PsiType[] psiTypeArray = type.getParameters();
        Intrinsics.checkNotNullExpressionValue((Object)psiTypeArray, (String)"getParameters(...)");
        PsiType psiType = (PsiType)ArraysKt.singleOrNull((Object[])psiTypeArray);
        if (psiType == null) {
            return null;
        }
        PsiType genericParameter = psiType;
        PsiType specificType = genericParameter instanceof PsiWildcardType && ((PsiWildcardType)genericParameter).isSuper() ? ((PsiWildcardType)genericParameter).getBound() : genericParameter;
        PsiType substituted = substitutor.substitute(specificType);
        Intrinsics.checkNotNull((Object)substituted);
        if (this.typeParameterIsNotResolved(clazz, psiMethod, substituted)) {
            return null;
        }
        return substituted;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean typeParameterIsNotResolved(PsiClass clazz, PsiMethod psiMethod, PsiType resolvedType) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        PsiTypeParameter[] psiTypeParameterArray = clazz.getTypeParameters();
        Intrinsics.checkNotNullExpressionValue((Object)psiTypeParameterArray, (String)"getTypeParameters(...)");
        Object[] objectArray = psiTypeParameterArray;
        PsiTypeParameter[] psiTypeParameterArray2 = psiMethod.getTypeParameters();
        Intrinsics.checkNotNullExpressionValue((Object)psiTypeParameterArray2, (String)"getTypeParameters(...)");
        Object[] objectArray2 = ArraysKt.plus((Object[])objectArray, (Object[])psiTypeParameterArray2);
        boolean $i$f$map = false;
        void var7_6 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(((void)$this$map$iv).length);
        boolean $i$f$mapTo = false;
        for (void item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            PsiTypeParameter psiTypeParameter = (PsiTypeParameter)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(p0.getName());
        }
        List typeParameterNames = (List)destination$iv$iv;
        return typeParameterNames.contains(resolvedType.getCanonicalText());
    }

    private final PsiType getDelegateFromClosure(PsiClass clazz, GroovyMethodResult resolvedCall) {
        if (!Intrinsics.areEqual((Object)clazz.getQualifiedName(), (Object)"groovy.lang.Closure") || clazz.hasAnnotation("groovy.lang.DelegatesTo")) {
            return null;
        }
        Object object = resolvedCall.getCandidate();
        if (object == null || (object = object.getMethod()) == null || (object = object.getName()) == null) {
            return null;
        }
        Object methodName = object;
        GroovyMethodCandidate groovyMethodCandidate = resolvedCall.getCandidate();
        PsiClass psiClass = InferenceProcessUtilKt.resolve((PsiType)(groovyMethodCandidate != null ? groovyMethodCandidate.getReceiverType() : null));
        if (psiClass == null) {
            return null;
        }
        PsiClass classProvidingMethod = psiClass;
        List list = classProvidingMethod.findMethodsAndTheirSubstitutorsByName((String)methodName, true);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"findMethodsAndTheirSubstitutorsByName(...)");
        List methodOverloads = list;
        for (Pair method : methodOverloads) {
            PsiType delegate;
            Object object2 = method.first;
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"first");
            PsiMethod psiMethod = (PsiMethod)object2;
            Object object3 = method.second;
            Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"second");
            PsiType psiType = delegate = this.getDelegateFromMethodSignature(psiMethod, (PsiSubstitutor)object3);
            if (psiType == null) continue;
            return psiType;
        }
        return null;
    }

    private final PsiType getDelegateFromMethodSignature(PsiMethod psiMethod, PsiSubstitutor substitutor) {
        JvmParameter[] jvmParameterArray = psiMethod.getParameters();
        Intrinsics.checkNotNullExpressionValue((Object)jvmParameterArray, (String)"getParameters(...)");
        JvmParameter jvmParameter = (JvmParameter)ArraysKt.lastOrNull((Object[])jvmParameterArray);
        if (jvmParameter == null) {
            return null;
        }
        JvmParameter lastParam = jvmParameter;
        JvmType $this$asSafely$iv = lastParam.getType();
        boolean $i$f$asSafely = false;
        JvmType jvmType = $this$asSafely$iv;
        if (!(jvmType instanceof PsiClassType)) {
            jvmType = null;
        }
        PsiClassType psiClassType = (PsiClassType)jvmType;
        if (psiClassType == null) {
            return null;
        }
        PsiClassType paramType = psiClassType;
        PsiClass psiClass = paramType.resolve();
        if (psiClass == null) {
            return null;
        }
        PsiClass resolvedClass = psiClass;
        return this.getDelegateFromAction(resolvedClass, paramType, psiMethod, substitutor);
    }
}

