/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.utils.queue;

import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jitsi.utils.OrderedJsonObject;
import org.jitsi.utils.queue.PacketQueue;
import org.jitsi.utils.queue.QueueStatistics;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B\u001b\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0015\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u001aJ\u0015\u0010\u001b\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u001aJ\n\u0010\u001c\u001a\u0004\u0018\u00010\u001dH\u0016J\u0015\u0010\u001e\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u001aR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000RP\u0010\f\u001aD\u0012\f\u0012\n \u000f*\u0004\u0018\u00010\u000e0\u000e\u0012\f\u0012\n \u000f*\u0004\u0018\u00010\u00100\u0010\u0018\u0001 \u000f* \u0012\f\u0012\n \u000f*\u0004\u0018\u00010\u000e0\u000e\u0012\f\u0012\n \u000f*\u0004\u0018\u00010\u00100\u0010\u0018\u00010\u00110\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lorg/jitsi/utils/queue/QueueStatisticsObserver;", "T", "Lorg/jitsi/utils/queue/PacketQueue$Observer;", "queue", "Lorg/jitsi/utils/queue/PacketQueue;", "clock", "Ljava/time/Clock;", "(Lorg/jitsi/utils/queue/PacketQueue;Ljava/time/Clock;)V", "getClock", "()Ljava/time/Clock;", "globalStats", "Lorg/jitsi/utils/queue/QueueStatistics;", "insertionTime", "", "", "kotlin.jvm.PlatformType", "Ljava/time/Instant;", "", "localStats", "getQueue", "()Lorg/jitsi/utils/queue/PacketQueue;", "queueSize", "Ljava/util/concurrent/atomic/AtomicInteger;", "added", "", "pkt", "(Ljava/lang/Object;)V", "dropped", "getStats", "Lorg/jitsi/utils/OrderedJsonObject;", "removed", "jitsi-utils"})
public final class QueueStatisticsObserver<T>
implements PacketQueue.Observer<T> {
    @NotNull
    private final PacketQueue<T> queue;
    @NotNull
    private final Clock clock;
    @Nullable
    private final Map<Object, Instant> insertionTime;
    @Nullable
    private final QueueStatistics localStats;
    @NotNull
    private final QueueStatistics globalStats;
    @NotNull
    private final AtomicInteger queueSize;

    public QueueStatisticsObserver(@NotNull PacketQueue<T> queue, @NotNull Clock clock) {
        Intrinsics.checkNotNullParameter(queue, (String)"queue");
        Intrinsics.checkNotNullParameter((Object)clock, (String)"clock");
        this.queue = queue;
        this.clock = clock;
        this.insertionTime = QueueStatistics.TRACK_TIMES ? Collections.synchronizedMap(new IdentityHashMap()) : null;
        this.localStats = QueueStatistics.DEBUG ? new QueueStatistics(this.queue.capacity(), this.clock) : null;
        this.globalStats = QueueStatistics.Companion.globalStatsFor$jitsi_utils(this.queue, this.clock);
        this.queueSize = new AtomicInteger(0);
    }

    @NotNull
    public final PacketQueue<T> getQueue() {
        return this.queue;
    }

    @NotNull
    public final Clock getClock() {
        return this.clock;
    }

    @Override
    public void added(T pkt) {
        this.queueSize.incrementAndGet();
        Object object = this.insertionTime;
        if (object != null) {
            object.put(pkt, (Instant)this.clock.instant());
        }
        object = this.localStats;
        if (object != null) {
            ((QueueStatistics)object).added();
        }
        this.globalStats.added();
    }

    @Override
    public void removed(T pkt) {
        Duration duration;
        int queueLength = this.queueSize.decrementAndGet();
        Map<Object, Instant> map = this.insertionTime;
        if (map == null) {
            duration = null;
        } else {
            Instant instant = map.get(pkt);
            if (instant == null) {
                duration = null;
            } else {
                Instant instant2 = instant;
                boolean bl = false;
                boolean bl2 = false;
                Instant $this$removed_u24lambda_u2d0 = instant2;
                boolean bl3 = false;
                Instant now = this.getClock().instant();
                duration = Duration.between($this$removed_u24lambda_u2d0, now);
            }
        }
        Duration wait = duration;
        map = this.localStats;
        if (map != null) {
            ((QueueStatistics)((Object)map)).removed(queueLength, wait);
        }
        this.globalStats.removed(queueLength, wait);
    }

    @Override
    public void dropped(T pkt) {
        this.queueSize.decrementAndGet();
        Object object = this.insertionTime;
        if (object != null) {
            object.remove(pkt);
        }
        object = this.localStats;
        if (object != null) {
            ((QueueStatistics)object).dropped();
        }
        this.globalStats.dropped();
    }

    @Nullable
    public OrderedJsonObject getStats() {
        QueueStatistics queueStatistics = this.localStats;
        return queueStatistics == null ? null : queueStatistics.getStats();
    }
}

