/*
 * Decompiled with CFR 0.152.
 */
package io.kinference.profiler;

import io.kinference.utils.time.Duration;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.math.MathKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\u0014\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001BC\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0005\u0012\u0006\u0010\b\u001a\u00020\u0005\u0012\u0006\u0010\t\u001a\u00020\u0005\u0012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00000\u000b\u00a2\u0006\u0002\u0010\fJ\t\u0010\u0017\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0018\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0019\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u001a\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u001b\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u001c\u001a\u00020\u0005H\u00c6\u0003J\u000f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00000\u000bH\u00c6\u0003JU\u0010\u001e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00052\b\b\u0002\u0010\u0007\u001a\u00020\u00052\b\b\u0002\u0010\b\u001a\u00020\u00052\b\b\u0002\u0010\t\u001a\u00020\u00052\u000e\b\u0002\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00000\u000bH\u00c6\u0001J\u0013\u0010\u001f\u001a\u00020 2\b\u0010!\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\u0006\u0010\"\u001a\u00020\u0003J\t\u0010#\u001a\u00020$H\u00d6\u0001J\t\u0010%\u001a\u00020\u0003H\u00d6\u0001J\u001c\u0010&\u001a\u00020'2\n\u0010(\u001a\u00060)j\u0002`*2\b\b\u0002\u0010+\u001a\u00020$J\f\u0010,\u001a\u00020\u0003*\u00020-H\u0002R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0017\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00000\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u000eR\u0011\u0010\u0007\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u000eR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\b\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u000eR\u0011\u0010\t\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u000e\u00a8\u0006."}, d2={"Lio/kinference/profiler/ProfileAnalysisEntry;", "", "name", "", "avg", "Lio/kinference/utils/time/Duration;", "max", "min", "p50", "p90", "children", "", "(Ljava/lang/String;Lio/kinference/utils/time/Duration;Lio/kinference/utils/time/Duration;Lio/kinference/utils/time/Duration;Lio/kinference/utils/time/Duration;Lio/kinference/utils/time/Duration;Ljava/util/List;)V", "getAvg", "()Lio/kinference/utils/time/Duration;", "getChildren", "()Ljava/util/List;", "getMax", "getMin", "getName", "()Ljava/lang/String;", "getP50", "getP90", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "copy", "equals", "", "other", "getInfo", "hashCode", "", "toString", "writeToStringBuilder", "", "builder", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "indent", "toRoundString", "", "utils-profiling"})
@SourceDebugExtension(value={"SMAP\nProfileEntry.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProfileEntry.kt\nio/kinference/profiler/ProfileAnalysisEntry\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,83:1\n1#2:84\n*E\n"})
public final class ProfileAnalysisEntry {
    @NotNull
    private final String name;
    @NotNull
    private final Duration avg;
    @NotNull
    private final Duration max;
    @NotNull
    private final Duration min;
    @NotNull
    private final Duration p50;
    @NotNull
    private final Duration p90;
    @NotNull
    private final List<ProfileAnalysisEntry> children;

    public ProfileAnalysisEntry(@NotNull String name, @NotNull Duration avg, @NotNull Duration max2, @NotNull Duration min2, @NotNull Duration p50, @NotNull Duration p90, @NotNull List<ProfileAnalysisEntry> children) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)avg, (String)"avg");
        Intrinsics.checkNotNullParameter((Object)max2, (String)"max");
        Intrinsics.checkNotNullParameter((Object)min2, (String)"min");
        Intrinsics.checkNotNullParameter((Object)p50, (String)"p50");
        Intrinsics.checkNotNullParameter((Object)p90, (String)"p90");
        Intrinsics.checkNotNullParameter(children, (String)"children");
        this.name = name;
        this.avg = avg;
        this.max = max2;
        this.min = min2;
        this.p50 = p50;
        this.p90 = p90;
        this.children = children;
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    @NotNull
    public final Duration getAvg() {
        return this.avg;
    }

    @NotNull
    public final Duration getMax() {
        return this.max;
    }

    @NotNull
    public final Duration getMin() {
        return this.min;
    }

    @NotNull
    public final Duration getP50() {
        return this.p50;
    }

    @NotNull
    public final Duration getP90() {
        return this.p90;
    }

    @NotNull
    public final List<ProfileAnalysisEntry> getChildren() {
        return this.children;
    }

    private final String toRoundString(double $this$toRoundString) {
        int rounded = (int)$this$toRoundString;
        return StringsKt.padStart$default((String)(rounded + "." + StringsKt.padStart((String)String.valueOf(MathKt.roundToInt((double)(($this$toRoundString - (double)rounded) * 100.0))), (int)2, (char)'0')), (int)7, (char)'\u0000', (int)2, null);
    }

    public final void writeToStringBuilder(@NotNull StringBuilder builder, int indent) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        builder.append("\n" + StringsKt.padEnd$default((String)(StringsKt.repeat((CharSequence)"  ", (int)indent) + this.name), (int)40, (char)'\u0000', (int)2, null) + " AVG: " + this.avg.getMillis() + " ms | MAX: " + this.max.getMillis() + " ms | MIN: " + this.min.getMillis() + " ms | Percentile 50: " + this.p50.getMillis() + " ms | Percentile 90: " + this.p90.getMillis() + " ms");
        for (ProfileAnalysisEntry entry2 : this.children) {
            entry2.writeToStringBuilder(builder, indent + 1);
        }
    }

    public static /* synthetic */ void writeToStringBuilder$default(ProfileAnalysisEntry profileAnalysisEntry, StringBuilder stringBuilder, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = 0;
        }
        profileAnalysisEntry.writeToStringBuilder(stringBuilder, n);
    }

    @NotNull
    public final String getInfo() {
        StringBuilder stringBuilder;
        StringBuilder $this$getInfo_u24lambda_u240 = stringBuilder = new StringBuilder();
        boolean bl = false;
        ProfileAnalysisEntry.writeToStringBuilder$default(this, $this$getInfo_u24lambda_u240, 0, 2, null);
        String string2 = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"StringBuilder().apply(builderAction).toString()");
        return string2;
    }

    @NotNull
    public final String component1() {
        return this.name;
    }

    @NotNull
    public final Duration component2() {
        return this.avg;
    }

    @NotNull
    public final Duration component3() {
        return this.max;
    }

    @NotNull
    public final Duration component4() {
        return this.min;
    }

    @NotNull
    public final Duration component5() {
        return this.p50;
    }

    @NotNull
    public final Duration component6() {
        return this.p90;
    }

    @NotNull
    public final List<ProfileAnalysisEntry> component7() {
        return this.children;
    }

    @NotNull
    public final ProfileAnalysisEntry copy(@NotNull String name, @NotNull Duration avg, @NotNull Duration max2, @NotNull Duration min2, @NotNull Duration p50, @NotNull Duration p90, @NotNull List<ProfileAnalysisEntry> children) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)avg, (String)"avg");
        Intrinsics.checkNotNullParameter((Object)max2, (String)"max");
        Intrinsics.checkNotNullParameter((Object)min2, (String)"min");
        Intrinsics.checkNotNullParameter((Object)p50, (String)"p50");
        Intrinsics.checkNotNullParameter((Object)p90, (String)"p90");
        Intrinsics.checkNotNullParameter(children, (String)"children");
        return new ProfileAnalysisEntry(name, avg, max2, min2, p50, p90, children);
    }

    public static /* synthetic */ ProfileAnalysisEntry copy$default(ProfileAnalysisEntry profileAnalysisEntry, String string2, Duration duration, Duration duration2, Duration duration3, Duration duration4, Duration duration5, List list, int n, Object object) {
        if ((n & 1) != 0) {
            string2 = profileAnalysisEntry.name;
        }
        if ((n & 2) != 0) {
            duration = profileAnalysisEntry.avg;
        }
        if ((n & 4) != 0) {
            duration2 = profileAnalysisEntry.max;
        }
        if ((n & 8) != 0) {
            duration3 = profileAnalysisEntry.min;
        }
        if ((n & 0x10) != 0) {
            duration4 = profileAnalysisEntry.p50;
        }
        if ((n & 0x20) != 0) {
            duration5 = profileAnalysisEntry.p90;
        }
        if ((n & 0x40) != 0) {
            list = profileAnalysisEntry.children;
        }
        return profileAnalysisEntry.copy(string2, duration, duration2, duration3, duration4, duration5, list);
    }

    @NotNull
    public String toString() {
        return "ProfileAnalysisEntry(name=" + this.name + ", avg=" + this.avg + ", max=" + this.max + ", min=" + this.min + ", p50=" + this.p50 + ", p90=" + this.p90 + ", children=" + this.children + ")";
    }

    public int hashCode() {
        int result2 = this.name.hashCode();
        result2 = result2 * 31 + this.avg.hashCode();
        result2 = result2 * 31 + this.max.hashCode();
        result2 = result2 * 31 + this.min.hashCode();
        result2 = result2 * 31 + this.p50.hashCode();
        result2 = result2 * 31 + this.p90.hashCode();
        result2 = result2 * 31 + ((Object)this.children).hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ProfileAnalysisEntry)) {
            return false;
        }
        ProfileAnalysisEntry profileAnalysisEntry = (ProfileAnalysisEntry)other;
        if (!Intrinsics.areEqual((Object)this.name, (Object)profileAnalysisEntry.name)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.avg, (Object)profileAnalysisEntry.avg)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.max, (Object)profileAnalysisEntry.max)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.min, (Object)profileAnalysisEntry.min)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.p50, (Object)profileAnalysisEntry.p50)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.p90, (Object)profileAnalysisEntry.p90)) {
            return false;
        }
        return Intrinsics.areEqual(this.children, profileAnalysisEntry.children);
    }
}

