/*
 * Decompiled with CFR 0.152.
 */
package io.kinference.core.operators.ml.svm;

import io.kinference.core.operators.ml.svm.KernelType;
import io.kinference.core.operators.ml.svm.SvmInfo;
import io.kinference.core.operators.ml.svm.SvmMode;
import io.kinference.core.operators.ml.svm.WriteAdditionalScores;
import io.kinference.core.operators.ml.utils.PostTransform;
import io.kinference.ndarray.arrays.FloatNDArray;
import io.kinference.ndarray.extensions.all.AllFloatKt;
import io.kinference.trees.PostTransformType;
import io.kinference.utils.ArraysExtensionKt;
import io.kinference.utils.inlines.InlineInt;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.collections.ArraysKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0014\n\u0002\b\u0004\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0007\n\u0002\b\r\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0018\u0002\n\u0002\b\u0015\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0080\b\u0018\u0000 S2\u00020\u0001:\u0001SB{\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\u000b\u0012\u0006\u0010\r\u001a\u00020\u000b\u0012\u0006\u0010\u000e\u001a\u00020\u0005\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u0012\u0006\u0010\u0011\u001a\u00020\u0012\u0012\b\b\u0002\u0010\u0013\u001a\u00020\u0014\u0012\b\b\u0002\u0010\u0015\u001a\u00020\u0014\u0012\b\b\u0002\u0010\u0016\u001a\u00020\u0014\u0012\u0006\u0010\u0017\u001a\u00020\u0010\u00a2\u0006\u0002\u0010\u0018J\t\u0010?\u001a\u00020\u0003H\u00c6\u0003J\t\u0010@\u001a\u00020\u0012H\u00c6\u0003J\t\u0010A\u001a\u00020\u0014H\u00c6\u0003J\t\u0010B\u001a\u00020\u0014H\u00c6\u0003J\t\u0010C\u001a\u00020\u0014H\u00c6\u0003J\t\u0010D\u001a\u00020\u0010H\u00c6\u0003J\t\u0010E\u001a\u00020\u0005H\u00c6\u0003J\t\u0010F\u001a\u00020\u0007H\u00c6\u0003J\t\u0010G\u001a\u00020\tH\u00c6\u0003J\t\u0010H\u001a\u00020\u000bH\u00c6\u0003J\t\u0010I\u001a\u00020\u000bH\u00c6\u0003J\t\u0010J\u001a\u00020\u000bH\u00c6\u0003J\t\u0010K\u001a\u00020\u0005H\u00c6\u0003J\t\u0010L\u001a\u00020\u0010H\u00c6\u0003J\u0095\u0001\u0010M\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\u000b2\b\b\u0002\u0010\f\u001a\u00020\u000b2\b\b\u0002\u0010\r\u001a\u00020\u000b2\b\b\u0002\u0010\u000e\u001a\u00020\u00052\b\b\u0002\u0010\u000f\u001a\u00020\u00102\b\b\u0002\u0010\u0011\u001a\u00020\u00122\b\b\u0002\u0010\u0013\u001a\u00020\u00142\b\b\u0002\u0010\u0015\u001a\u00020\u00142\b\b\u0002\u0010\u0016\u001a\u00020\u00142\b\b\u0002\u0010\u0017\u001a\u00020\u0010H\u00c6\u0001J\u0013\u0010N\u001a\u00020\"2\b\u0010O\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010P\u001a\u00020\u0012H\u00d6\u0001J\t\u0010Q\u001a\u00020RH\u00d6\u0001R\u0011\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0011\u0010\u0015\u001a\u00020\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u0011\u0010\u0016\u001a\u00020\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010\u001cR\u0011\u0010\u0013\u001a\u00020\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010\u001cR\u0011\u0010!\u001a\u00020\"\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010$R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010&R\u0011\u0010'\u001a\u00020\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010\u001aR\u0011\u0010)\u001a\u00020*\u00a2\u0006\b\n\u0000\u001a\u0004\b+\u0010,R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b-\u0010.R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b/\u00100R\u0011\u0010\f\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b1\u00100R\u0011\u0010\r\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b2\u00100R\u0011\u0010\u0017\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b3\u00104R\u0011\u0010\u000e\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b5\u0010\u001eR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b6\u00107R\u0011\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b8\u00104R\u0011\u00109\u001a\u00020\"\u00a2\u0006\b\n\u0000\u001a\u0004\b:\u0010$R\u0013\u0010;\u001a\u0004\u0018\u00010<\u00a2\u0006\b\n\u0000\u001a\u0004\b=\u0010>\u00a8\u0006T"}, d2={"Lio/kinference/core/operators/ml/svm/SvmInfo;", "", "svmMode", "Lio/kinference/core/operators/ml/svm/SvmMode;", "coefficients", "Lio/kinference/ndarray/arrays/FloatNDArray;", "kernelType", "Lio/kinference/core/operators/ml/svm/KernelType;", "postTransformType", "Lio/kinference/trees/PostTransformType;", "probA", "", "probB", "rho", "supportVectors", "vectorsPerClass", "", "classCount", "", "gamma", "", "coefZero", "degree", "startingVector", "(Lio/kinference/core/operators/ml/svm/SvmMode;Lio/kinference/ndarray/arrays/FloatNDArray;Lio/kinference/core/operators/ml/svm/KernelType;Lio/kinference/trees/PostTransformType;[F[F[FLio/kinference/ndarray/arrays/FloatNDArray;[IIFFF[I)V", "getClassCount", "()I", "getCoefZero", "()F", "getCoefficients", "()Lio/kinference/ndarray/arrays/FloatNDArray;", "getDegree", "getGamma", "haveProba", "", "getHaveProba", "()Z", "getKernelType", "()Lio/kinference/core/operators/ml/svm/KernelType;", "numClassifier", "getNumClassifier", "postTransform", "Lio/kinference/core/operators/ml/utils/PostTransform;", "getPostTransform", "()Lio/kinference/core/operators/ml/utils/PostTransform;", "getPostTransformType", "()Lio/kinference/trees/PostTransformType;", "getProbA", "()[F", "getProbB", "getRho", "getStartingVector", "()[I", "getSupportVectors", "getSvmMode", "()Lio/kinference/core/operators/ml/svm/SvmMode;", "getVectorsPerClass", "weightsAreAllPositive", "getWeightsAreAllPositive", "writeAdditionalScores", "Lio/kinference/core/operators/ml/svm/WriteAdditionalScores;", "getWriteAdditionalScores", "()Lio/kinference/core/operators/ml/svm/WriteAdditionalScores;", "component1", "component10", "component11", "component12", "component13", "component14", "component2", "component3", "component4", "component5", "component6", "component7", "component8", "component9", "copy", "equals", "other", "hashCode", "toString", "", "Companion", "inference-core"})
public final class SvmInfo {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final SvmMode svmMode;
    @NotNull
    private final FloatNDArray coefficients;
    @NotNull
    private final KernelType kernelType;
    @NotNull
    private final PostTransformType postTransformType;
    @NotNull
    private final float[] probA;
    @NotNull
    private final float[] probB;
    @NotNull
    private final float[] rho;
    @NotNull
    private final FloatNDArray supportVectors;
    @NotNull
    private final int[] vectorsPerClass;
    private final int classCount;
    private final float gamma;
    private final float coefZero;
    private final float degree;
    @NotNull
    private final int[] startingVector;
    private final boolean weightsAreAllPositive;
    private final boolean haveProba;
    private final int numClassifier;
    @NotNull
    private final PostTransform postTransform;
    @Nullable
    private final WriteAdditionalScores writeAdditionalScores;
    @NotNull
    private static final String DEFAULT_POST_TRANSFORM = "NONE";
    @NotNull
    private static final String DEFAULT_KERNEL_TYPE = "LINEAR";

    public SvmInfo(@NotNull SvmMode svmMode, @NotNull FloatNDArray coefficients, @NotNull KernelType kernelType, @NotNull PostTransformType postTransformType, @NotNull float[] probA, @NotNull float[] probB, @NotNull float[] rho, @NotNull FloatNDArray supportVectors, @NotNull int[] vectorsPerClass, int classCount, float gamma, float coefZero, float degree, @NotNull int[] startingVector) {
        Intrinsics.checkNotNullParameter((Object)((Object)svmMode), (String)"svmMode");
        Intrinsics.checkNotNullParameter((Object)coefficients, (String)"coefficients");
        Intrinsics.checkNotNullParameter((Object)((Object)kernelType), (String)"kernelType");
        Intrinsics.checkNotNullParameter((Object)((Object)postTransformType), (String)"postTransformType");
        Intrinsics.checkNotNullParameter((Object)probA, (String)"probA");
        Intrinsics.checkNotNullParameter((Object)probB, (String)"probB");
        Intrinsics.checkNotNullParameter((Object)rho, (String)"rho");
        Intrinsics.checkNotNullParameter((Object)supportVectors, (String)"supportVectors");
        Intrinsics.checkNotNullParameter((Object)vectorsPerClass, (String)"vectorsPerClass");
        Intrinsics.checkNotNullParameter((Object)startingVector, (String)"startingVector");
        this.svmMode = svmMode;
        this.coefficients = coefficients;
        this.kernelType = kernelType;
        this.postTransformType = postTransformType;
        this.probA = probA;
        this.probB = probB;
        this.rho = rho;
        this.supportVectors = supportVectors;
        this.vectorsPerClass = vectorsPerClass;
        this.classCount = classCount;
        this.gamma = gamma;
        this.coefZero = coefZero;
        this.degree = degree;
        this.startingVector = startingVector;
        this.weightsAreAllPositive = AllFloatKt.all(this.coefficients, (Function1<? super Float, Boolean>)((Function1)weightsAreAllPositive.1.INSTANCE));
        this.haveProba = !(this.probA.length == 0);
        this.numClassifier = this.classCount * (this.classCount - 1) / 2;
        this.postTransform = PostTransform.Companion.get$inference_core(this.postTransformType);
        this.writeAdditionalScores = this.svmMode == SvmMode.SVC && !this.haveProba ? (this.postTransformType == PostTransformType.NONE ? WriteAdditionalScores.WITHOUT_POST_TRANSFORM : WriteAdditionalScores.WITH_POST_TRANSFORM) : null;
        if (this.writeAdditionalScores != null && this.classCount == 2 && this.postTransformType == PostTransformType.PROBIT) {
            throw new IllegalStateException("post_transform PROBIT isn't supported for binary case".toString());
        }
    }

    public /* synthetic */ SvmInfo(SvmMode svmMode, FloatNDArray floatNDArray, KernelType kernelType, PostTransformType postTransformType, float[] fArray, float[] fArray2, float[] fArray3, FloatNDArray floatNDArray2, int[] nArray, int n, float f, float f2, float f3, int[] nArray2, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 0x400) != 0) {
            f = 0.0f;
        }
        if ((n2 & 0x800) != 0) {
            f2 = 0.0f;
        }
        if ((n2 & 0x1000) != 0) {
            f3 = 0.0f;
        }
        this(svmMode, floatNDArray, kernelType, postTransformType, fArray, fArray2, fArray3, floatNDArray2, nArray, n, f, f2, f3, nArray2);
    }

    @NotNull
    public final SvmMode getSvmMode() {
        return this.svmMode;
    }

    @NotNull
    public final FloatNDArray getCoefficients() {
        return this.coefficients;
    }

    @NotNull
    public final KernelType getKernelType() {
        return this.kernelType;
    }

    @NotNull
    public final PostTransformType getPostTransformType() {
        return this.postTransformType;
    }

    @NotNull
    public final float[] getProbA() {
        return this.probA;
    }

    @NotNull
    public final float[] getProbB() {
        return this.probB;
    }

    @NotNull
    public final float[] getRho() {
        return this.rho;
    }

    @NotNull
    public final FloatNDArray getSupportVectors() {
        return this.supportVectors;
    }

    @NotNull
    public final int[] getVectorsPerClass() {
        return this.vectorsPerClass;
    }

    public final int getClassCount() {
        return this.classCount;
    }

    public final float getGamma() {
        return this.gamma;
    }

    public final float getCoefZero() {
        return this.coefZero;
    }

    public final float getDegree() {
        return this.degree;
    }

    @NotNull
    public final int[] getStartingVector() {
        return this.startingVector;
    }

    public final boolean getWeightsAreAllPositive() {
        return this.weightsAreAllPositive;
    }

    public final boolean getHaveProba() {
        return this.haveProba;
    }

    public final int getNumClassifier() {
        return this.numClassifier;
    }

    @NotNull
    public final PostTransform getPostTransform() {
        return this.postTransform;
    }

    @Nullable
    public final WriteAdditionalScores getWriteAdditionalScores() {
        return this.writeAdditionalScores;
    }

    @NotNull
    public final SvmMode component1() {
        return this.svmMode;
    }

    @NotNull
    public final FloatNDArray component2() {
        return this.coefficients;
    }

    @NotNull
    public final KernelType component3() {
        return this.kernelType;
    }

    @NotNull
    public final PostTransformType component4() {
        return this.postTransformType;
    }

    @NotNull
    public final float[] component5() {
        return this.probA;
    }

    @NotNull
    public final float[] component6() {
        return this.probB;
    }

    @NotNull
    public final float[] component7() {
        return this.rho;
    }

    @NotNull
    public final FloatNDArray component8() {
        return this.supportVectors;
    }

    @NotNull
    public final int[] component9() {
        return this.vectorsPerClass;
    }

    public final int component10() {
        return this.classCount;
    }

    public final float component11() {
        return this.gamma;
    }

    public final float component12() {
        return this.coefZero;
    }

    public final float component13() {
        return this.degree;
    }

    @NotNull
    public final int[] component14() {
        return this.startingVector;
    }

    @NotNull
    public final SvmInfo copy(@NotNull SvmMode svmMode, @NotNull FloatNDArray coefficients, @NotNull KernelType kernelType, @NotNull PostTransformType postTransformType, @NotNull float[] probA, @NotNull float[] probB, @NotNull float[] rho, @NotNull FloatNDArray supportVectors, @NotNull int[] vectorsPerClass, int classCount, float gamma, float coefZero, float degree, @NotNull int[] startingVector) {
        Intrinsics.checkNotNullParameter((Object)((Object)svmMode), (String)"svmMode");
        Intrinsics.checkNotNullParameter((Object)coefficients, (String)"coefficients");
        Intrinsics.checkNotNullParameter((Object)((Object)kernelType), (String)"kernelType");
        Intrinsics.checkNotNullParameter((Object)((Object)postTransformType), (String)"postTransformType");
        Intrinsics.checkNotNullParameter((Object)probA, (String)"probA");
        Intrinsics.checkNotNullParameter((Object)probB, (String)"probB");
        Intrinsics.checkNotNullParameter((Object)rho, (String)"rho");
        Intrinsics.checkNotNullParameter((Object)supportVectors, (String)"supportVectors");
        Intrinsics.checkNotNullParameter((Object)vectorsPerClass, (String)"vectorsPerClass");
        Intrinsics.checkNotNullParameter((Object)startingVector, (String)"startingVector");
        return new SvmInfo(svmMode, coefficients, kernelType, postTransformType, probA, probB, rho, supportVectors, vectorsPerClass, classCount, gamma, coefZero, degree, startingVector);
    }

    public static /* synthetic */ SvmInfo copy$default(SvmInfo svmInfo, SvmMode svmMode, FloatNDArray floatNDArray, KernelType kernelType, PostTransformType postTransformType, float[] fArray, float[] fArray2, float[] fArray3, FloatNDArray floatNDArray2, int[] nArray, int n, float f, float f2, float f3, int[] nArray2, int n2, Object object) {
        if ((n2 & 1) != 0) {
            svmMode = svmInfo.svmMode;
        }
        if ((n2 & 2) != 0) {
            floatNDArray = svmInfo.coefficients;
        }
        if ((n2 & 4) != 0) {
            kernelType = svmInfo.kernelType;
        }
        if ((n2 & 8) != 0) {
            postTransformType = svmInfo.postTransformType;
        }
        if ((n2 & 0x10) != 0) {
            fArray = svmInfo.probA;
        }
        if ((n2 & 0x20) != 0) {
            fArray2 = svmInfo.probB;
        }
        if ((n2 & 0x40) != 0) {
            fArray3 = svmInfo.rho;
        }
        if ((n2 & 0x80) != 0) {
            floatNDArray2 = svmInfo.supportVectors;
        }
        if ((n2 & 0x100) != 0) {
            nArray = svmInfo.vectorsPerClass;
        }
        if ((n2 & 0x200) != 0) {
            n = svmInfo.classCount;
        }
        if ((n2 & 0x400) != 0) {
            f = svmInfo.gamma;
        }
        if ((n2 & 0x800) != 0) {
            f2 = svmInfo.coefZero;
        }
        if ((n2 & 0x1000) != 0) {
            f3 = svmInfo.degree;
        }
        if ((n2 & 0x2000) != 0) {
            nArray2 = svmInfo.startingVector;
        }
        return svmInfo.copy(svmMode, floatNDArray, kernelType, postTransformType, fArray, fArray2, fArray3, floatNDArray2, nArray, n, f, f2, f3, nArray2);
    }

    @NotNull
    public String toString() {
        return "SvmInfo(svmMode=" + this.svmMode + ", coefficients=" + this.coefficients + ", kernelType=" + this.kernelType + ", postTransformType=" + this.postTransformType + ", probA=" + Arrays.toString(this.probA) + ", probB=" + Arrays.toString(this.probB) + ", rho=" + Arrays.toString(this.rho) + ", supportVectors=" + this.supportVectors + ", vectorsPerClass=" + Arrays.toString(this.vectorsPerClass) + ", classCount=" + this.classCount + ", gamma=" + this.gamma + ", coefZero=" + this.coefZero + ", degree=" + this.degree + ", startingVector=" + Arrays.toString(this.startingVector) + ")";
    }

    public int hashCode() {
        int result2 = this.svmMode.hashCode();
        result2 = result2 * 31 + this.coefficients.hashCode();
        result2 = result2 * 31 + this.kernelType.hashCode();
        result2 = result2 * 31 + this.postTransformType.hashCode();
        result2 = result2 * 31 + Arrays.hashCode(this.probA);
        result2 = result2 * 31 + Arrays.hashCode(this.probB);
        result2 = result2 * 31 + Arrays.hashCode(this.rho);
        result2 = result2 * 31 + this.supportVectors.hashCode();
        result2 = result2 * 31 + Arrays.hashCode(this.vectorsPerClass);
        result2 = result2 * 31 + Integer.hashCode(this.classCount);
        result2 = result2 * 31 + Float.hashCode(this.gamma);
        result2 = result2 * 31 + Float.hashCode(this.coefZero);
        result2 = result2 * 31 + Float.hashCode(this.degree);
        result2 = result2 * 31 + Arrays.hashCode(this.startingVector);
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof SvmInfo)) {
            return false;
        }
        SvmInfo svmInfo = (SvmInfo)other;
        if (this.svmMode != svmInfo.svmMode) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.coefficients, (Object)svmInfo.coefficients)) {
            return false;
        }
        if (this.kernelType != svmInfo.kernelType) {
            return false;
        }
        if (this.postTransformType != svmInfo.postTransformType) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.probA, (Object)svmInfo.probA)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.probB, (Object)svmInfo.probB)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.rho, (Object)svmInfo.rho)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.supportVectors, (Object)svmInfo.supportVectors)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.vectorsPerClass, (Object)svmInfo.vectorsPerClass)) {
            return false;
        }
        if (this.classCount != svmInfo.classCount) {
            return false;
        }
        if (Float.compare(this.gamma, svmInfo.gamma) != 0) {
            return false;
        }
        if (Float.compare(this.coefZero, svmInfo.coefZero) != 0) {
            return false;
        }
        if (Float.compare(this.degree, svmInfo.degree) != 0) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.startingVector, (Object)svmInfo.startingVector);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0014\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0016\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001:\u0001 B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J)\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0082@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u000eJ9\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0082@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0013Ji\u0010\u0014\u001a\u00020\u00152\u0006\u0010\b\u001a\u00020\t2\b\u0010\u0016\u001a\u0004\u0018\u00010\t2\b\u0010\u0017\u001a\u0004\u0018\u00010\u00042\b\u0010\u0018\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0019\u001a\u00020\t2\u0006\u0010\u001a\u001a\u00020\t2\u0006\u0010\u001b\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\t2\u0006\u0010\u001c\u001a\u00020\u001d2\b\b\u0002\u0010\u001e\u001a\u00020\u000bH\u0086B\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u001fR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006!"}, d2={"Lio/kinference/core/operators/ml/svm/SvmInfo$Companion;", "", "()V", "DEFAULT_KERNEL_TYPE", "", "DEFAULT_POST_TRANSFORM", "configureLinearInfo", "Lio/kinference/ndarray/arrays/FloatNDArray;", "coefficients", "", "numClasses", "", "kernelType", "Lio/kinference/core/operators/ml/svm/KernelType;", "([FILio/kinference/core/operators/ml/svm/KernelType;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "configureSvcInfo", "Lio/kinference/core/operators/ml/svm/SvmInfo$Companion$SupportVectorsAndCoefficients;", "supportVectors", "vectorCount", "([F[FIILio/kinference/core/operators/ml/svm/KernelType;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "invoke", "Lio/kinference/core/operators/ml/svm/SvmInfo;", "kernelParams", "kernelTypeStr", "postTransformStr", "probA", "probB", "rho", "vectorsPerClass", "", "classCount", "([F[FLjava/lang/String;Ljava/lang/String;[F[F[F[F[JILkotlin/coroutines/Continuation;)Ljava/lang/Object;", "SupportVectorsAndCoefficients", "inference-core"})
    @SourceDebugExtension(value={"SMAP\nSvmInfo.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SvmInfo.kt\nio/kinference/core/operators/ml/svm/SvmInfo$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,156:1\n1#2:157\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * Unable to fully structure code
         */
        @Nullable
        public final Object invoke(@NotNull float[] var1_1, @Nullable float[] var2_2, @Nullable String var3_3, @Nullable String var4_4, @NotNull float[] var5_5, @NotNull float[] var6_6, @NotNull float[] var7_7, @NotNull float[] var8_8, @NotNull long[] var9_9, int var10_10, @NotNull Continuation<? super SvmInfo> var11_11) {
            if (!(var11_11 instanceof invoke.1)) ** GOTO lbl-1000
            var33_12 = var11_11;
            if ((var33_12.label & -2147483648) != 0) {
                var33_12.label -= -2147483648;
            } else lbl-1000:
            // 2 sources

            {
                $continuation = new ContinuationImpl(this, var11_11){
                    Object L$0;
                    Object L$1;
                    Object L$2;
                    Object L$3;
                    Object L$4;
                    Object L$5;
                    Object L$6;
                    Object L$7;
                    int I$0;
                    float F$0;
                    float F$1;
                    float F$2;
                    /* synthetic */ Object result;
                    final /* synthetic */ Companion this$0;
                    int label;
                    {
                        this.this$0 = this$0;
                        super($completion);
                    }

                    @Nullable
                    public final Object invokeSuspend(@NotNull Object $result) {
                        this.result = $result;
                        this.label |= Integer.MIN_VALUE;
                        return this.this$0.invoke(null, null, null, null, null, null, null, null, null, 0, (Continuation<? super SvmInfo>)((Continuation)this));
                    }
                };
            }
            $result = $continuation.result;
            var48_14 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
            switch ($continuation.label) {
                case 0: {
                    ResultKt.throwOnFailure((Object)$result);
                    if (!(classCount > 0)) {
                        $i$a$-require-SvmInfo$Companion$invoke$2 = false;
                        $i$a$-require-SvmInfo$Companion$invoke$2 = "Attribute either 'classlabels_ints' or 'classlabels_strings' must have at least one element";
                        throw new IllegalArgumentException($i$a$-require-SvmInfo$Companion$invoke$2.toString());
                    }
                    v0 = postTransformStr;
                    if (v0 == null) {
                        v0 = "NONE";
                    }
                    postTransform = PostTransformType.valueOf(v0);
                    v1 = kernelTypeStr;
                    if (v1 == null) {
                        v1 = "LINEAR";
                    }
                    kernelType = KernelType.valueOf(v1);
                    if (!(probA.length == probB.length)) {
                        $i$a$-require-SvmInfo$Companion$invoke$3 = false;
                        $i$a$-require-SvmInfo$Companion$invoke$3 = "Attributes prob_a and prob_b must have the same size";
                        throw new IllegalArgumentException($i$a$-require-SvmInfo$Companion$invoke$3.toString());
                    }
                    v2 = kernelParams;
                    gamma = v2 != null && (v2 = ArraysKt.getOrNull((float[])v2, (int)0)) != null ? v2.floatValue() : 0.0f;
                    v3 = kernelParams;
                    coefZero = v3 != null && (v3 = ArraysKt.getOrNull((float[])v3, (int)1)) != null ? v3.floatValue() : 0.0f;
                    v4 = kernelParams;
                    degree = v4 != null && (v4 = ArraysKt.getOrNull((float[])v4, (int)2)) != null ? v4.floatValue() : 0.0f;
                    vectorCount = 0;
                    startingVector = new int[vectorsPerClass.length];
                    var20_29 = vectorsPerClass.length;
                    for (var19_26 = 0; var19_26 < var20_29; ++var19_26) {
                        idx = var19_26;
                        vectorsSize = vectorsPerClass[var19_26];
                        startingVector[idx] = vectorCount;
                        vectorCount += (int)vectorsSize;
                    }
                    if (vectorCount <= 0) break;
                    if (!(classCount > 1)) {
                        $i$a$-require-SvmInfo$Companion$invoke$4 = false;
                        $i$a$-require-SvmInfo$Companion$invoke$4 = "Attribute either 'classlabels_ints' or 'classlabels_strings' must have at least two elements for SVC";
                        throw new IllegalArgumentException($i$a$-require-SvmInfo$Companion$invoke$4.toString());
                    }
                    $continuation.L$0 = probA;
                    $continuation.L$1 = probB;
                    $continuation.L$2 = rho;
                    $continuation.L$3 = vectorsPerClass;
                    $continuation.L$4 = postTransform;
                    $continuation.L$5 = kernelType;
                    $continuation.L$6 = startingVector;
                    $continuation.I$0 = classCount;
                    $continuation.F$0 = gamma;
                    $continuation.F$1 = coefZero;
                    $continuation.F$2 = degree;
                    $continuation.label = 1;
                    v5 = this.configureSvcInfo((float[])supportVectors, (float[])coefficients, vectorCount, classCount, kernelType, (Continuation<? super SupportVectorsAndCoefficients>)$continuation);
                    if (v5 == var48_14) {
                        return var48_14;
                    }
                    ** GOTO lbl78
                }
                case 1: {
                    degree = $continuation.F$2;
                    coefZero = $continuation.F$1;
                    gamma = $continuation.F$0;
                    classCount = $continuation.I$0;
                    startingVector = (int[])$continuation.L$6;
                    kernelType = (KernelType)$continuation.L$5;
                    postTransform = (PostTransformType)$continuation.L$4;
                    vectorsPerClass = (long[])$continuation.L$3;
                    rho = (float[])$continuation.L$2;
                    probB = (float[])$continuation.L$1;
                    probA = (float[])$continuation.L$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v5 = $result;
lbl78:
                    // 2 sources

                    var19_27 = (SupportVectorsAndCoefficients)v5;
                    supportVectorsTensor = var19_27.component1();
                    coefficientsTensor = var19_27.component2();
                    v6 = new SvmInfo(SvmMode.SVC, coefficientsTensor, kernelType, postTransform, probA, probB, rho, supportVectorsTensor, ArraysExtensionKt.toIntArray(vectorsPerClass), classCount, gamma, coefZero, degree, startingVector);
                    ** GOTO lbl165
                }
            }
            $continuation.L$0 = probA;
            $continuation.L$1 = probB;
            $continuation.L$2 = rho;
            $continuation.L$3 = vectorsPerClass;
            $continuation.L$4 = postTransform;
            $continuation.I$0 = classCount;
            $continuation.F$0 = gamma;
            $continuation.F$1 = coefZero;
            $continuation.F$2 = degree;
            $continuation.label = 2;
            v7 = this.configureLinearInfo((float[])coefficients, classCount, kernelType, (Continuation<? super FloatNDArray>)$continuation);
            if (v7 == var48_14) {
                return var48_14;
            }
            ** GOTO lbl109
            {
                case 2: {
                    degree = $continuation.F$2;
                    coefZero = $continuation.F$1;
                    gamma = $continuation.F$0;
                    classCount = $continuation.I$0;
                    postTransform = (PostTransformType)$continuation.L$4;
                    vectorsPerClass = (long[])$continuation.L$3;
                    rho = (float[])$continuation.L$2;
                    probB = (float[])$continuation.L$1;
                    probA = (float[])$continuation.L$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v7 = $result;
lbl109:
                    // 2 sources

                    coefficientsTensor = (FloatNDArray)v7;
                    var30_35 = rho;
                    var29_36 = probB;
                    var28_37 = probA;
                    var27_38 = postTransform;
                    var26_39 = KernelType.LINEAR;
                    var25_40 = coefficientsTensor;
                    var24_41 = SvmMode.LINEAR;
                    $continuation.L$0 = vectorsPerClass;
                    $continuation.L$1 = var24_41;
                    $continuation.L$2 = var25_40;
                    $continuation.L$3 = var26_39;
                    $continuation.L$4 = var27_38;
                    $continuation.L$5 = var28_37;
                    $continuation.L$6 = var29_36;
                    $continuation.L$7 = var30_35;
                    $continuation.I$0 = classCount;
                    $continuation.F$0 = gamma;
                    $continuation.F$1 = coefZero;
                    $continuation.F$2 = degree;
                    $continuation.label = 3;
                    v8 = FloatNDArray.Companion.invokeShapeVarArg(new int[0], (Continuation<? super FloatNDArray>)$continuation);
                    if (v8 == var48_14) {
                        return var48_14;
                    }
                    ** GOTO lbl149
                }
                case 3: {
                    degree = $continuation.F$2;
                    coefZero = $continuation.F$1;
                    gamma = $continuation.F$0;
                    classCount = $continuation.I$0;
                    var30_35 = (float[])$continuation.L$7;
                    var29_36 = (float[])$continuation.L$6;
                    var28_37 = (float[])$continuation.L$5;
                    var27_38 = (PostTransformType)$continuation.L$4;
                    var26_39 = (KernelType)$continuation.L$3;
                    var25_40 = (FloatNDArray)$continuation.L$2;
                    var24_41 = (SvmMode)$continuation.L$1;
                    vectorsPerClass = (long[])$continuation.L$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v8 = $result;
lbl149:
                    // 2 sources

                    var31_42 = v8;
                    var34_43 = new int[]{};
                    var35_44 = degree;
                    var36_45 = coefZero;
                    var37_46 = gamma;
                    var38_47 = classCount;
                    var39_48 = ArraysExtensionKt.toIntArray(vectorsPerClass);
                    var40_49 = (FloatNDArray)var31_42;
                    var41_50 = var30_35;
                    var42_51 = var29_36;
                    var43_52 = var28_37;
                    var44_53 = var27_38;
                    var45_54 = var26_39;
                    var46_55 = var25_40;
                    var47_56 = var24_41;
                    v6 = new SvmInfo(var47_56, var46_55, var45_54, var44_53, var43_52, var42_51, var41_50, var40_49, var39_48, var38_47, var37_46, var36_45, var35_44, var34_43);
lbl165:
                    // 2 sources

                    return v6;
                }
            }
            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
        }

        public static /* synthetic */ Object invoke$default(Companion companion, float[] fArray, float[] fArray2, String string2, String string3, float[] fArray3, float[] fArray4, float[] fArray5, float[] fArray6, long[] lArray, int n, Continuation continuation, int n2, Object object) {
            if ((n2 & 0x200) != 0) {
                n = 1;
            }
            return companion.invoke(fArray, fArray2, string2, string3, fArray3, fArray4, fArray5, fArray6, lArray, n, (Continuation<? super SvmInfo>)continuation);
        }

        /*
         * Unable to fully structure code
         */
        private final Object configureSvcInfo(float[] var1_1, float[] var2_2, int var3_3, int var4_4, KernelType var5_5, Continuation<? super SupportVectorsAndCoefficients> var6_6) {
            if (!(var6_6 instanceof configureSvcInfo.1)) ** GOTO lbl-1000
            var12_7 = var6_6;
            if ((var12_7.label & -2147483648) != 0) {
                var12_7.label -= -2147483648;
            } else lbl-1000:
            // 2 sources

            {
                $continuation = new ContinuationImpl(this, var6_6){
                    Object L$0;
                    int I$0;
                    int I$1;
                    /* synthetic */ Object result;
                    final /* synthetic */ Companion this$0;
                    int label;
                    {
                        this.this$0 = this$0;
                        super($completion);
                    }

                    @Nullable
                    public final Object invokeSuspend(@NotNull Object $result) {
                        this.result = $result;
                        this.label |= Integer.MIN_VALUE;
                        return io.kinference.core.operators.ml.svm.SvmInfo$Companion.access$configureSvcInfo(this.this$0, null, null, 0, 0, null, (Continuation)this);
                    }
                };
            }
            $result = $continuation.result;
            var13_9 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
            switch ($continuation.label) {
                case 0: {
                    ResultKt.throwOnFailure((Object)$result);
                    featuresCount = ((void)supportVectors).length / vectorCount;
                    if (kernelType != KernelType.RBF) break;
                    var9_11 = new int[]{vectorCount, featuresCount};
                    $continuation.L$0 = coefficients;
                    $continuation.I$0 = vectorCount;
                    $continuation.I$1 = numClasses;
                    $continuation.label = 1;
                    v0 = FloatNDArray.Companion.invokeShapeVarArgInlineInt(var9_11, (Function1<? super InlineInt, Float>)((Function1)new Function1<InlineInt, Float>((float[])supportVectors){
                        final /* synthetic */ float[] $supportVectors;
                        {
                            this.$supportVectors = $supportVectors;
                            super(1);
                        }

                        @NotNull
                        public final Float invoke-CWX8tlc(int idx) {
                            return Float.valueOf(this.$supportVectors[idx]);
                        }
                    }), (Continuation<? super FloatNDArray>)$continuation);
                    if (v0 == var13_9) {
                        return var13_9;
                    }
                    ** GOTO lbl29
                }
                case 1: {
                    numClasses = $continuation.I$1;
                    vectorCount = $continuation.I$0;
                    coefficients = (float[])$continuation.L$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v0 = $result;
lbl29:
                    // 2 sources

                    v1 = (FloatNDArray)v0;
                    ** GOTO lbl47
                }
            }
            var9_11 = new int[]{featuresCount, vectorCount};
            $continuation.L$0 = coefficients;
            $continuation.I$0 = vectorCount;
            $continuation.I$1 = numClasses;
            $continuation.label = 2;
            v2 = FloatNDArray.Companion.invokeShapeVarArgIntArray(var9_11, (Function1<? super int[], Float>)((Function1)new Function1<int[], Float>((float[])supportVectors, featuresCount){
                final /* synthetic */ float[] $supportVectors;
                final /* synthetic */ int $featuresCount;
                {
                    this.$supportVectors = $supportVectors;
                    this.$featuresCount = $featuresCount;
                    super(1);
                }

                @NotNull
                public final Float invoke(@NotNull int[] nArray) {
                    Intrinsics.checkNotNullParameter((Object)nArray, (String)"<name for destructuring parameter 0>");
                    int i = nArray[0];
                    int j = nArray[1];
                    return Float.valueOf(this.$supportVectors[j * this.$featuresCount + i]);
                }
            }), (Continuation<? super FloatNDArray>)$continuation);
            if (v2 == var13_9) {
                return var13_9;
            }
            ** GOTO lbl46
            {
                case 2: {
                    numClasses = $continuation.I$1;
                    vectorCount = $continuation.I$0;
                    coefficients = (float[])$continuation.L$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v2 = $result;
lbl46:
                    // 2 sources

                    v1 = (FloatNDArray)v2;
lbl47:
                    // 2 sources

                    supportVectorsTensor = v1;
                    var10_13 = new int[]{numClasses - 1, vectorCount};
                    $continuation.L$0 = supportVectorsTensor;
                    $continuation.label = 3;
                    v3 = FloatNDArray.Companion.invokeShapeVarArgInlineInt(var10_13, (Function1<? super InlineInt, Float>)((Function1)new Function1<InlineInt, Float>(coefficients){
                        final /* synthetic */ float[] $coefficients;
                        {
                            this.$coefficients = $coefficients;
                            super(1);
                        }

                        @NotNull
                        public final Float invoke-CWX8tlc(int idx) {
                            return Float.valueOf(this.$coefficients[idx]);
                        }
                    }), (Continuation<? super FloatNDArray>)$continuation);
                    if (v3 == var13_9) {
                        return var13_9;
                    }
                    ** GOTO lbl59
                }
                case 3: {
                    supportVectorsTensor = (FloatNDArray)$continuation.L$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v3 = $result;
lbl59:
                    // 2 sources

                    coefficientsTensor = (FloatNDArray)v3;
                    return new SupportVectorsAndCoefficients(supportVectorsTensor, coefficientsTensor);
                }
            }
            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
        }

        private final Object configureLinearInfo(float[] coefficients, int numClasses, KernelType kernelType, Continuation<? super FloatNDArray> $completion) {
            int featuresCount = coefficients.length / numClasses;
            if (kernelType == KernelType.RBF) {
                int[] nArray = new int[]{numClasses, featuresCount};
                return FloatNDArray.Companion.invokeShapeVarArgInlineInt(nArray, (Function1<? super InlineInt, Float>)((Function1)new Function1<InlineInt, Float>(coefficients){
                    final /* synthetic */ float[] $coefficients;
                    {
                        this.$coefficients = $coefficients;
                        super(1);
                    }

                    @NotNull
                    public final Float invoke-CWX8tlc(int idx) {
                        return Float.valueOf(this.$coefficients[idx]);
                    }
                }), $completion);
            }
            int[] nArray = new int[]{featuresCount, numClasses};
            return FloatNDArray.Companion.invokeShapeVarArgIntArray(nArray, (Function1<? super int[], Float>)((Function1)new Function1<int[], Float>(coefficients, featuresCount){
                final /* synthetic */ float[] $coefficients;
                final /* synthetic */ int $featuresCount;
                {
                    this.$coefficients = $coefficients;
                    this.$featuresCount = $featuresCount;
                    super(1);
                }

                @NotNull
                public final Float invoke(@NotNull int[] nArray) {
                    Intrinsics.checkNotNullParameter((Object)nArray, (String)"<name for destructuring parameter 0>");
                    int i = nArray[0];
                    int j = nArray[1];
                    return Float.valueOf(this.$coefficients[j * this.$featuresCount + i]);
                }
            }), $completion);
        }

        public static final /* synthetic */ Object access$configureSvcInfo(Companion $this, float[] supportVectors, float[] coefficients, int vectorCount, int numClasses, KernelType kernelType, Continuation $completion) {
            return $this.configureSvcInfo(supportVectors, coefficients, vectorCount, numClasses, kernelType, (Continuation<? super SupportVectorsAndCoefficients>)$completion);
        }

        public static final /* synthetic */ Object access$configureLinearInfo(Companion $this, float[] coefficients, int numClasses, KernelType kernelType, Continuation $completion) {
            return $this.configureLinearInfo(coefficients, numClasses, kernelType, (Continuation<? super FloatNDArray>)$completion);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\t\u0010\t\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\u000b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\u0013"}, d2={"Lio/kinference/core/operators/ml/svm/SvmInfo$Companion$SupportVectorsAndCoefficients;", "", "supportVectors", "Lio/kinference/ndarray/arrays/FloatNDArray;", "coefficients", "(Lio/kinference/ndarray/arrays/FloatNDArray;Lio/kinference/ndarray/arrays/FloatNDArray;)V", "getCoefficients", "()Lio/kinference/ndarray/arrays/FloatNDArray;", "getSupportVectors", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "inference-core"})
        private static final class SupportVectorsAndCoefficients {
            @NotNull
            private final FloatNDArray supportVectors;
            @NotNull
            private final FloatNDArray coefficients;

            public SupportVectorsAndCoefficients(@NotNull FloatNDArray supportVectors, @NotNull FloatNDArray coefficients) {
                Intrinsics.checkNotNullParameter((Object)supportVectors, (String)"supportVectors");
                Intrinsics.checkNotNullParameter((Object)coefficients, (String)"coefficients");
                this.supportVectors = supportVectors;
                this.coefficients = coefficients;
            }

            @NotNull
            public final FloatNDArray getSupportVectors() {
                return this.supportVectors;
            }

            @NotNull
            public final FloatNDArray getCoefficients() {
                return this.coefficients;
            }

            @NotNull
            public final FloatNDArray component1() {
                return this.supportVectors;
            }

            @NotNull
            public final FloatNDArray component2() {
                return this.coefficients;
            }

            @NotNull
            public final SupportVectorsAndCoefficients copy(@NotNull FloatNDArray supportVectors, @NotNull FloatNDArray coefficients) {
                Intrinsics.checkNotNullParameter((Object)supportVectors, (String)"supportVectors");
                Intrinsics.checkNotNullParameter((Object)coefficients, (String)"coefficients");
                return new SupportVectorsAndCoefficients(supportVectors, coefficients);
            }

            public static /* synthetic */ SupportVectorsAndCoefficients copy$default(SupportVectorsAndCoefficients supportVectorsAndCoefficients, FloatNDArray floatNDArray, FloatNDArray floatNDArray2, int n, Object object) {
                if ((n & 1) != 0) {
                    floatNDArray = supportVectorsAndCoefficients.supportVectors;
                }
                if ((n & 2) != 0) {
                    floatNDArray2 = supportVectorsAndCoefficients.coefficients;
                }
                return supportVectorsAndCoefficients.copy(floatNDArray, floatNDArray2);
            }

            @NotNull
            public String toString() {
                return "SupportVectorsAndCoefficients(supportVectors=" + this.supportVectors + ", coefficients=" + this.coefficients + ")";
            }

            public int hashCode() {
                int result2 = this.supportVectors.hashCode();
                result2 = result2 * 31 + this.coefficients.hashCode();
                return result2;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof SupportVectorsAndCoefficients)) {
                    return false;
                }
                SupportVectorsAndCoefficients supportVectorsAndCoefficients = (SupportVectorsAndCoefficients)other;
                if (!Intrinsics.areEqual((Object)this.supportVectors, (Object)supportVectorsAndCoefficients.supportVectors)) {
                    return false;
                }
                return Intrinsics.areEqual((Object)this.coefficients, (Object)supportVectorsAndCoefficients.coefficients);
            }
        }
    }
}

