/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.wire.internal;

import com.squareup.wire.internal.JsonFormatter;
import java.time.Duration;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\f\u0012\b\u0012\u00060\u0002j\u0002`\u00030\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J\u0014\u0010\u0005\u001a\u00060\u0002j\u0002`\u00032\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0014\u0010\b\u001a\u00020\u00072\n\u0010\u0006\u001a\u00060\u0002j\u0002`\u0003H\u0016\u00a8\u0006\t"}, d2={"Lcom/squareup/wire/internal/DurationJsonFormatter;", "Lcom/squareup/wire/internal/JsonFormatter;", "Ljava/time/Duration;", "Lcom/squareup/wire/Duration;", "()V", "fromString", "value", "", "toStringOrNumber", "wire-runtime"})
public final class DurationJsonFormatter
implements JsonFormatter<Duration> {
    @NotNull
    public static final DurationJsonFormatter INSTANCE = new DurationJsonFormatter();

    private DurationJsonFormatter() {
    }

    @NotNull
    public String toStringOrNumber(@NotNull Duration value) {
        String string2;
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        long seconds = value.getSeconds();
        int nanos = value.getNano();
        String prefix = "";
        if (seconds < 0L) {
            if (seconds == Long.MIN_VALUE) {
                prefix = "-922337203685477580";
                seconds = 8L;
            } else {
                prefix = "-";
                seconds = -seconds;
            }
            if (nanos != 0) {
                --seconds;
                nanos = 1000000000 - nanos;
            }
        }
        if (nanos == 0) {
            String string3 = "%s%ds";
            Object[] objectArray = new Object[]{prefix, seconds};
            String string4 = String.format(string3, Arrays.copyOf(objectArray, objectArray.length));
            string2 = string4;
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"format(this, *args)");
        } else if (nanos % 1000000 == 0) {
            String string5 = "%s%d.%03ds";
            Object[] objectArray = new Object[]{prefix, seconds, (long)nanos / 1000000L};
            String string6 = String.format(string5, Arrays.copyOf(objectArray, objectArray.length));
            string2 = string6;
            Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"format(this, *args)");
        } else if (nanos % 1000 == 0) {
            String string7 = "%s%d.%06ds";
            Object[] objectArray = new Object[]{prefix, seconds, (long)nanos / 1000L};
            String string8 = String.format(string7, Arrays.copyOf(objectArray, objectArray.length));
            string2 = string8;
            Intrinsics.checkNotNullExpressionValue((Object)string8, (String)"format(this, *args)");
        } else {
            String string9 = "%s%d.%09ds";
            Object[] objectArray = new Object[]{prefix, seconds, (long)nanos / 1L};
            String string10 = String.format(string9, Arrays.copyOf(objectArray, objectArray.length));
            string2 = string10;
            Intrinsics.checkNotNullExpressionValue((Object)string10, (String)"format(this, *args)");
        }
        return string2;
    }

    @Override
    @NotNull
    public Duration fromString(@NotNull String value) {
        int nanosDigits;
        int i;
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        int sIndex = StringsKt.indexOf$default((CharSequence)value, (char)'s', (int)0, (boolean)false, (int)6, null);
        if (sIndex != value.length() - 1) {
            throw new NumberFormatException();
        }
        int dotIndex = StringsKt.indexOf$default((CharSequence)value, (char)'.', (int)0, (boolean)false, (int)6, null);
        if (dotIndex == -1) {
            String string2 = value.substring(0, sIndex);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
            long seconds = Long.parseLong(string2);
            Duration duration = Duration.ofSeconds(seconds);
            Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"ofSeconds(seconds)");
            return duration;
        }
        String string3 = value.substring(0, dotIndex);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
        long seconds = Long.parseLong(string3);
        String string4 = value.substring(dotIndex + 1, sIndex);
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
        long nanos = Long.parseLong(string4);
        if (StringsKt.startsWith$default((String)value, (String)"-", (boolean)false, (int)2, null)) {
            nanos = -nanos;
        }
        for (i = nanosDigits = sIndex - (dotIndex + 1); i < 9; ++i) {
            nanos *= (long)10;
        }
        for (i = 9; i < nanosDigits; ++i) {
            nanos /= (long)10;
        }
        Duration duration = Duration.ofSeconds(seconds, nanos);
        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"ofSeconds(seconds, nanos)");
        return duration;
    }
}

